/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;

public class HRBUExtServiceHelper {
    private static final String FIELD_ORG_ID = "org.id";
    private static final String PAGE_BOS_ORG_STRUCTURE = "bos_org_structure";
    private static final String PAGE_HR_ADMINORG_STRUCT = "haos_adminorgstruct";
    private static final String ORG_STRUCTURE_FIELD_VIEW = "view";
    private static final Long BU_VIEW_ID = 11L;
    private static final String ORG_STRUCTURE_FIELD_ORG = "org";
    private static final String FIELD_VIEW_NUMBER = "view.number";

    public static DynamicObject[] getHROrgByIdList(List<Object> idList) {
        HRBaseServiceHelper editEntityHelper = new HRBaseServiceHelper(PAGE_BOS_ORG_STRUCTURE);
        QFilter idFilter = new QFilter(FIELD_ORG_ID, "in", idList);
        QFilter viewFilter = new QFilter(ORG_STRUCTURE_FIELD_VIEW, "=", (Object)BU_VIEW_ID);
        DynamicObject[] orgStructureDys = editEntityHelper.query(ORG_STRUCTURE_FIELD_ORG, new QFilter[]{viewFilter, idFilter});
        ArrayList orgDyList = Lists.newArrayListWithExpectedSize((int)orgStructureDys.length);
        Arrays.stream(orgStructureDys).forEach(orgStructureDy -> {
            DynamicObject orgDy = orgStructureDy.getDynamicObject(ORG_STRUCTURE_FIELD_ORG);
            orgDyList.add(orgDy);
        });
        return orgDyList.toArray(new DynamicObject[0]);
    }

    public static Map<Long, List<Long>> getHROrgByIds(List<Object> idList) {
        QFilter idFilter;
        Set<Long> viewIds = HRBUExtServiceHelper.getVersionView(false);
        QFilter viewFilter = new QFilter("view.id", "in", viewIds);
        DynamicObject[] orgStructureDys = new HRBaseServiceHelper(PAGE_BOS_ORG_STRUCTURE).query("view.id,org.id", new QFilter[]{viewFilter, idFilter = new QFilter(FIELD_ORG_ID, "in", idList)});
        if (orgStructureDys == null || orgStructureDys.length == 0) {
            return new HashMap<Long, List<Long>>();
        }
        QFilter filter = new QFilter("controlfuntype.id", "in", viewIds);
        DynamicObject[] businessFields = new HRBaseServiceHelper("hbss_bussinessfield").query("id,controlfuntype.id", new QFilter[]{filter});
        Map<Long, Long> businessTypeMap = Arrays.stream(businessFields).collect(Collectors.toMap(dy -> dy.getLong("controlfuntype.id"), dy2 -> dy2.getLong("id"), (x1, x2) -> x1));
        return Arrays.stream(orgStructureDys).collect(Collectors.groupingBy(dy2 -> (Long)businessTypeMap.get(dy2.getLong("view.id")), Collectors.mapping(dy2 -> dy2.getLong(FIELD_ORG_ID), Collectors.toList())));
    }

    public static Set<Long> getVersionView(boolean isIncludeHRBUView) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject vs = helper.queryOne((Object)618L);
        if (Objects.isNull(vs)) {
            return Sets.newHashSet();
        }
        String number = vs.getString("number");
        String[] split = number.split(",");
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        for (String view : split) {
            if ("11".equals(view) && !isIncludeHRBUView) continue;
            Long viewId = Long.parseLong(view);
            set.add(viewId);
        }
        return set;
    }

    public static DynamicObject getOrgStructByOrgId(String bosViewNumber, Object bosOrgId) {
        HRBaseServiceHelper bosOrgStructureHelper = new HRBaseServiceHelper(PAGE_BOS_ORG_STRUCTURE);
        QFilter bosOrgIdFilter = new QFilter(FIELD_ORG_ID, "=", bosOrgId);
        QFilter viewFilter = new QFilter(FIELD_VIEW_NUMBER, "=", (Object)bosViewNumber);
        bosOrgIdFilter.and(viewFilter);
        return bosOrgStructureHelper.queryOne(new QFilter[]{bosOrgIdFilter});
    }

    public static DynamicObject getRootHROrg() {
        HRBaseServiceHelper adminorgQueryHelper = new HRBaseServiceHelper(PAGE_HR_ADMINORG_STRUCT);
        QFilter qFilter = new QFilter("isroot", "=", (Object)"1");
        qFilter.and("iscurrentversion", "=", (Object)"1");
        qFilter.and("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        return adminorgQueryHelper.queryOriginalOne("adminorg.id  as id", qFilter);
    }
}

