/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.TaskServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;

@ExcludeFromJacocoGeneratedReport
public class MsgWarningServiceHelper {
    private static final Log logger = LogFactory.getLog(MsgWarningServiceHelper.class);
    private static final HRBaseServiceHelper ADMIN_USER_HELPER = new HRBaseServiceHelper("hrcs_msgadminsetting");
    private static final String WARNGING_ENTITYNUMBER = "hrcs_msgcenter";
    private static final String WARNGING_TEMPLATENUMBER = "hrcs_msgcenter_warning";

    public static void sendMsgWarning(DynamicObject dy, String warningType, String msgsubno) {
        if (null == dy || StringUtils.isBlank((String)warningType) || StringUtils.isBlank((String)msgsubno)) {
            return;
        }
        try {
            DynamicObject dynamicObject = (DynamicObject)OrmUtils.clone((IDataEntityBase)dy, (boolean)false, (boolean)false);
            dynamicObject.getDynamicObjectCollection("entryentity").removeIf(it -> !msgsubno.equalsIgnoreCase(it.getString("msgsubno")));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_warningset");
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)"hrcs_msg_warningset")};
            String selectProperties = "recmsgtemp,recmsgchannel,recadminuser,recpuber,recsuber,consumemsgtemp,consumemsgchannel,consumeadminuser,consumepuber,consumesuber";
            DynamicObject result = serviceHelper.queryOne(selectProperties, qFilters);
            if (null == result) {
                logger.warn("\u672a\u914d\u7f6e\u6d88\u606f\u9884\u8b66\uff0c\u4e0d\u53d1\u9001\u9884\u8b66\u6d88\u606f;msgno={},warningType={}", dynamicObject.get("number"), (Object)warningType);
                return;
            }
            String title = ResManager.loadKDString((String)"\u6d88\u606f\u534f\u540c\u9884\u8b66", (String)"MsgWarningServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            HashSet userIds = Sets.newHashSetWithExpectedSize((int)16);
            if ("rec".equalsIgnoreCase(warningType)) {
                MsgWarningServiceHelper.buildUserId(dynamicObject, userIds, result.getBoolean("recadminuser"), result.getBoolean("recpuber"), result.getBoolean("recsuber"));
            } else if ("consume".equalsIgnoreCase(warningType)) {
                MsgWarningServiceHelper.buildUserId(dynamicObject, userIds, result.getBoolean("consumeadminuser"), result.getBoolean("consumepuber"), result.getBoolean("consumesuber"));
            }
            long messageId = MsgWarningServiceHelper.sendMessage(dynamicObject.getLong("id"), title, new ArrayList<Long>(userIds));
            logger.info("\u6d88\u606f\u901a\u77e5\u5b8c\u6210;msgsubno={},messageId={},userIds={}", new Object[]{msgsubno, messageId, userIds});
        }
        catch (Exception exception) {
            logger.error("\u6d88\u606f\u9884\u8b66\u5f02\u5e38;msgno={},msgsubno={},notifyType={}", new Object[]{dy.get("number"), msgsubno, warningType, exception});
        }
    }

    public static long sendMessage(Long bizDataId, String title, List<Long> userIds) {
        if (StringUtils.isBlank((String)title) || CollectionUtils.isEmpty(userIds)) {
            logger.error("MsgWarningServiceHelper_sendMessage_null;");
            return Long.MIN_VALUE;
        }
        MessageInfo message = new MessageInfo();
        message.setTitle(title);
        message.setBizDataId(bizDataId);
        message.setEntityNumber(WARNGING_ENTITYNUMBER);
        message.setTemplateNumber(WARNGING_TEMPLATENUMBER);
        message.setType("message");
        message.setUserIds(userIds);
        message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        message.setSendTime(new Date(System.currentTimeMillis()));
        message.setTag(title);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    private static void buildUserId(DynamicObject dy, Set<Long> userIds, Boolean adminuserFlag, Boolean puberFlag, Boolean suberFlag) {
        if (Objects.nonNull(adminuserFlag) && adminuserFlag.booleanValue()) {
            QFilter[] userFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
            DynamicObject[] resultUsers = BusinessDataServiceHelper.load((String)"hrcs_msgadminsetting", (String)"adminuserid", (QFilter[])userFilters);
            Set userId = Arrays.stream(resultUsers).filter(user -> user.getDynamicObject("adminuserid") != null).map(user -> user.getDynamicObject("adminuserid").getLong("id")).collect(Collectors.toSet());
            userIds.addAll(userId);
        }
        if (Objects.nonNull(puberFlag) && puberFlag.booleanValue() && Objects.nonNull(dy.getDynamicObject("puber"))) {
            userIds.add(dy.getDynamicObject("puber").getLong("id"));
        }
        if (Objects.nonNull(suberFlag) && suberFlag.booleanValue() && Objects.nonNull(dy.getDynamicObjectCollection("entryentity"))) {
            Set userId = dy.getDynamicObjectCollection("entryentity").stream().filter(it -> it.getDynamicObject("consumer") != null).map(it -> it.getDynamicObject("consumer").getLong("id")).collect(Collectors.toSet());
            userIds.addAll(userId);
        }
    }

    public static String transformMsgWarningContext(DynamicObject dy, String msgWarningContext) {
        if (null == dy || HRStringUtils.isEmpty((String)msgWarningContext)) {
            return "";
        }
        BusinessModelVariableScope scope = new BusinessModelVariableScope(dy);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        TaskServiceImpl taskService = new TaskServiceImpl(configuration);
        ((ServiceImpl)taskService).setCommandExecutor(configuration.getCommandExecutor());
        return taskService.contentParser(msgWarningContext, dy, (VariableScope)scope, false);
    }

    public static boolean checkIsMonitorAdmin(long userId) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter userIdFilter = new QFilter("adminuserid", "=", (Object)userId);
        return ADMIN_USER_HELPER.isExists(new QFilter[]{enableFilter, statusFilter, userIdFilter});
    }
}

