/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PermFilesServiceHelper {
    private static final String USER = "user";

    public static DynamicObject[] getPermAdminorgEntrysByUserId(Long userId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permorgentry");
        QFilter userFilter = new QFilter(USER, "=", (Object)userId);
        QFilter statusEnabel = new QFilter("status", "=", (Object)"1");
        return serviceHelper.query("adminorg, user, status, containssub, id, permfile", new QFilter[]{userFilter, statusEnabel});
    }

    public static DynamicObject[] getPermAdminorgEntrysByPermfileId(Long permfileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permorgentry");
        QFilter userFilter = new QFilter(USER, "=", (Object)permfileId);
        QFilter statusEnabel = new QFilter("status", "=", (Object)"1");
        return serviceHelper.query("adminorg, user, status, containssub, id, permfile", new QFilter[]{userFilter, statusEnabel});
    }

    public static DynamicObject getPermFileByUserId(Long userId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permfiles");
        QFilter userFilter = new QFilter(USER, "=", (Object)userId);
        return serviceHelper.queryOne("user, enable, org", new QFilter[]{userFilter});
    }

    public static DynamicObject getPermFileByUserAndOrgId(Long userId, Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permfiles");
        QFilter userFilter = new QFilter(USER, "=", (Object)userId);
        return serviceHelper.queryOne("user, enable, org", new QFilter[]{userFilter});
    }

    public static List<Long> getOrgListFromPermFiles(Long userId, Boolean isEnabled) {
        DynamicObject[] orgEntrys;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<Long> containsSubOrgIds = new ArrayList<Long>();
        DynamicObject permFiles = PermFilesServiceHelper.getPermFileByUserId(userId);
        if (permFiles == null || !HRStringUtils.equals((String)"1", (String)permFiles.getString("enable"))) {
            return orgIds;
        }
        for (DynamicObject orgEntry : orgEntrys = PermFilesServiceHelper.getPermAdminorgEntrysByUserId(userId)) {
            boolean containsSub = orgEntry.getBoolean("containssub");
            Long orgId = orgEntry.getLong("adminorg.id");
            if (containsSub) {
                containsSubOrgIds.add(orgId);
                continue;
            }
            orgIds.add(orgId);
        }
        List<Long> containsOrgIds = PermFilesServiceHelper.getSubAdminOrgList(containsSubOrgIds, isEnabled);
        orgIds.addAll(containsOrgIds);
        return orgIds;
    }

    private static List<Long> getSubAdminOrgList(List<Long> orgIds, Boolean isEnabled) {
        QFilter[] filters;
        QFilter orgIdFilter = new QFilter("adminorg.id", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] focusNodeDys = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").query("longnumber", orgIdFilter.and(currentFilter));
        if (focusNodeDys == null) {
            return new ArrayList<Long>();
        }
        DynamicObject[] var4 = focusNodeDys;
        int var5 = focusNodeDys.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            DynamicObject focusNodeDy = var4[var6];
            String longNumber = (String)focusNodeDy.get("longnumber");
            QFilter filter = new QFilter("longnumber", "like", (Object)(longNumber + "!%"));
            orgIdFilter.or(filter);
        }
        if (isEnabled.booleanValue()) {
            QFilter enableFilter = new QFilter("adminorg.enable", "=", (Object)"1");
            filters = new QFilter[]{orgIdFilter, enableFilter, currentFilter};
        } else {
            filters = new QFilter[]{orgIdFilter};
        }
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl("adminorg.id adminorg", filters, (String)null);
        ArrayList<Long> ids = new ArrayList<Long>(dyColl.size());
        int size = dyColl.size();
        for (int index = 0; index < size; ++index) {
            ids.add(((DynamicObject)dyColl.get(index)).getLong("adminorg"));
        }
        return ids;
    }

    public static Long getUserIdByPermFile(Long permFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        QFilter qFilter = new QFilter("id", "=", (Object)permFileId);
        DynamicObject dyno = helper.queryOriginalOne("user.id", qFilter);
        if (dyno != null) {
            return dyno.getLong("user.id");
        }
        return null;
    }

    public static List<Long> getUserIdListByPermFile(List<Long> permFileIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        QFilter qFilter = new QFilter("id", "in", permFileIds);
        DynamicObject[] dynoArr = helper.queryOriginalArray("user.id", new QFilter[]{qFilter});
        return Arrays.stream(dynoArr).map(dyno -> dyno.getLong("user.id")).collect(Collectors.toList());
    }

    public static Map<Long, Long> getPermFileUserMapByPermFile(List<Long> permFileIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        QFilter qFilter = new QFilter("id", "in", permFileIds);
        DynamicObject[] dynaArr = helper.queryOriginalArray("id,user.id", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)permFileIds.size());
        for (DynamicObject dyna : dynaArr) {
            result.put(dyna.getLong("id"), dyna.getLong("user.id"));
        }
        return result;
    }
}

