/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.HRMsgBaseConstants;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.bussiness.util.MsgUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class PublisherConsumerServiceHelper
implements HRMsgBaseConstants {
    private static final Log logger = LogFactory.getLog(MsgCenterServiceHelper.class);
    private static final Map<String, Class> CLASS_CHECK_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final HRBaseServiceHelper SUB_HELPER = new HRBaseServiceHelper("hrcs_msgsubscriber");
    private static final HRBaseServiceHelper PUB_HELPER = new HRBaseServiceHelper("hrcs_msgpublisher");

    public static String saveMsgPublisher(Map<String, Object> publisherMap, boolean isModify) {
        logger.info("saveMsgPublisher_start_publisherMap={}", (Object)publisherMap.toString());
        MsgUtils.validateIsNull(publisherMap, "name", "actionCloud", "actionApp", "publishBd", "actionType", "action", "description", "apiEntryEntity");
        MsgUtils.validateValueType(CLASS_CHECK_MAP, publisherMap);
        QFilter filter = new QFilter("name", "=", publisherMap.get("name"));
        if (!Objects.isNull(publisherMap.get("msgpubno"))) {
            filter.or(new QFilter("msgpubno", "=", publisherMap.get("msgpubno")));
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hrcs_msgpublisher");
        DynamicObject dy = PUB_HELPER.queryOne(PublisherConsumerServiceHelper.buildSelectProperties(type), new QFilter[]{filter});
        if (isModify && null == dy) {
            logger.error("saveMsgPublisher_query_modify_msgpubno_is_null;msgpubno={}", publisherMap.get("msgpubno"));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636emsgpubno\u6216name\u67e5\u8be2\u53d1\u5e03\u4e2d\u5fc3\u7ed3\u679c\u4e3a\u7a7a", (String)"PublisherConsumerServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (!isModify && null != dy) {
            logger.error("saveMsgPublisher_query_create_msgpubno_isExsit;msgpubno={}", publisherMap.get("msgpubno"));
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636emsgpubno\u6216name\u67e5\u8be2\u53d1\u5e03\u4e2d\u5fc3\u7ed3\u679c\u5df2\u5b58\u5728", (String)"PublisherConsumerServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (!isModify && null == dy) {
            dy = PUB_HELPER.generateEmptyDynamicObject();
        }
        List apiEntryList = (List)publisherMap.get("apiEntryEntity");
        for (Map apiEntry : apiEntryList) {
            MsgUtils.validateIsNull(apiEntry, "apiNumber");
            MsgUtils.validateValueType(CLASS_CHECK_MAP, apiEntry);
        }
        MsgUtils.validateValueDuplicate(apiEntryList, "apiNumber");
        DynamicObject finalDy = PublisherConsumerServiceHelper.setPublishDyValue(publisherMap, dy, apiEntryList);
        return ((DynamicObject)PUB_HELPER.saveOne(finalDy)).getString("msgpubno");
    }

    private static DynamicObject setPublishDyValue(Map<String, Object> publisherMap, DynamicObject dy, List<Map<String, Object>> apiEntryList) {
        dy.set("name", publisherMap.get("name"));
        if (StringUtils.isEmpty((CharSequence)dy.getString("number"))) {
            dy.set("number", (Object)MsgUtils.generateNumber("hrcs_msgpublisher"));
        }
        dy.set("actioncloud", publisherMap.get("actionCloud"));
        dy.set("actionapp", publisherMap.get("actionApp"));
        dy.set("publishbd", publisherMap.get("publishBd"));
        dy.set("actiontype", publisherMap.get("actionType"));
        dy.set("action", publisherMap.get("action"));
        dy.set("msgtag", publisherMap.get("msgTag"));
        dy.set("msgprobo", publisherMap.get("msgProBo"));
        dy.set("puber", publisherMap.get("pubEr"));
        dy.set("pubstatus", publisherMap.getOrDefault("pubStatus", "N"));
        if ("P".equals(publisherMap.get("pubStatus"))) {
            if (Objects.isNull(publisherMap.get("publishDate"))) {
                dy.set("publishdate", (Object)new Date());
            } else {
                dy.set("publishdate", publisherMap.get("publishDate"));
            }
        }
        PublisherConsumerServiceHelper.getMultiBaseDataCollection(dy, "subbusfield", publisherMap.get("subBusField")).ifPresent(col -> dy.set("subbusfield", col));
        dy.set("issubscribe", publisherMap.getOrDefault("isSubscribe", "2"));
        dy.set("description", publisherMap.getOrDefault("description", " "));
        dy.set("msgpubno", dy.get("number"));
        dy.set("substatus", (Object)"0");
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        dy.set("issyspreset", (Object)"0");
        HRBaseUtils.setSysField((DynamicObject)dy);
        DynamicObjectCollection apiEntryCollection = dy.getDynamicObjectCollection("apientryentity");
        apiEntryCollection.clear();
        MainEntityType mainType = (MainEntityType)dy.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get("apientryentity");
        if (CollectionUtils.isEmpty(apiEntryList)) {
            return dy;
        }
        ArrayList apiNumberList = Lists.newArrayListWithExpectedSize((int)apiEntryList.size());
        for (Map<String, Object> apiEntry : apiEntryList) {
            apiNumberList.add(apiEntry.get("apiNumber").toString());
        }
        DynamicObject[] apiList = MsgCenterServiceHelper.queryAPIsByNumber(apiNumberList);
        if (apiList.length < apiEntryList.size()) {
            logger.error("saveMsgPublisher_validateApiList_is_lessthan;msgpubno={}", publisherMap.get("msgpubno"));
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u7981\u7528\u7684API\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"PublisherConsumerServiceHelper_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        for (DynamicObject apiDy : apiList) {
            for (Map<String, Object> apiEntry : apiEntryList) {
                if (!apiDy.getString("number").equalsIgnoreCase(apiEntry.get("apiNumber").toString())) continue;
                DynamicObject apiEntryDy = (DynamicObject)type.createInstance();
                PublisherConsumerServiceHelper.buildEntryAPI(apiDy, apiEntry, apiEntryDy);
                apiEntryCollection.add((Object)apiEntryDy);
            }
        }
        return dy;
    }

    private static void buildEntryAPI(DynamicObject apiDy, Map<String, Object> apiEntry, DynamicObject dynamicObject) {
        dynamicObject.set("apisource", apiDy.getPkValue());
        dynamicObject.set("apipubstatus", apiEntry.getOrDefault("apiPubStatus", "N"));
        dynamicObject.set("apitype", apiDy.get("type"));
        dynamicObject.set("issysset", (Object)"0");
        dynamicObject.set("apinumber", apiDy.get("number"));
        dynamicObject.set("apiname", apiDy.get("name"));
        dynamicObject.set("apiservice", apiDy.get("service"));
        dynamicObject.set("apimethod", apiDy.get("method"));
        dynamicObject.set("apidescription", apiDy.get("description"));
        dynamicObject.set("apienable", (Object)("1".equalsIgnoreCase(apiDy.getString("enable")) ? "A" : "B"));
        dynamicObject.set("apipubcloud", apiDy.get("bizcloud.id"));
        dynamicObject.set("apipubapp", apiDy.get("bizapp.id"));
        if ("2".equals(apiDy.getString("type"))) {
            dynamicObject.set("inputparam", (Object)apiDy.getString("inputparam"));
            dynamicObject.set("outputtype", (Object)apiDy.getString("outputtype"));
            dynamicObject.set("outputparam", (Object)apiDy.getString("outputparam"));
        } else {
            dynamicObject.set("params", apiDy.get("param"));
        }
    }

    private static Optional<DynamicObjectCollection> getMultiBaseDataCollection(DynamicObject mainDy, String multiBaseDataKey, Object dataIds) {
        MainEntityType mainType = (MainEntityType)mainDy.getDynamicObjectType();
        IDataEntityProperty property = (IDataEntityProperty)mainType.getAllFields().get(multiBaseDataKey);
        if (property instanceof MulBasedataProp) {
            MulBasedataProp multiProp = (MulBasedataProp)property;
            DynamicObjectCollection multiCollection = mainDy.getDynamicObjectCollection((IDataEntityProperty)multiProp);
            multiCollection.clear();
            if (dataIds instanceof Long[] || dataIds instanceof String[] || dataIds instanceof Object[] || dataIds instanceof Collection) {
                ArrayList idList = Lists.newArrayList();
                if (dataIds instanceof Long[]) {
                    idList.addAll(Arrays.asList((Long[])dataIds));
                } else if (dataIds instanceof String[]) {
                    idList.addAll(Arrays.asList((String[])dataIds));
                } else if (dataIds instanceof Object[]) {
                    idList.addAll(Arrays.asList((Object[])dataIds));
                } else {
                    idList.addAll((Collection)dataIds);
                }
                if (idList.isEmpty()) {
                    return Optional.empty();
                }
                DynamicObjectType multiDyObjType = multiCollection.getDynamicObjectType();
                for (Object id : idList) {
                    DynamicObject multiDy = new DynamicObject(multiDyObjType);
                    DynamicObject instance = (DynamicObject)multiProp.getComplexType().createInstance();
                    instance.set("id", id);
                    multiDy.set("fbasedataid", (Object)instance);
                    multiCollection.add((Object)multiDy);
                }
                mainDy.set("subbusfields", (Object)SerializationUtils.toJsonString((Object)dataIds));
                return Optional.of(multiCollection);
            }
        }
        return Optional.empty();
    }

    public static List<Long> saveMsgSubscriberList(List<Map<String, Object>> subscriberMapList) {
        logger.info("saveMsgSubscriberList_start={}", (Object)subscriberMapList.toString());
        ArrayList dyList = Lists.newArrayListWithCapacity((int)subscriberMapList.size());
        ArrayList dyUpdateList = Lists.newArrayListWithCapacity((int)subscriberMapList.size());
        ArrayList msgSubList = Lists.newArrayListWithCapacity((int)subscriberMapList.size());
        ArrayList msgPubNoList = Lists.newArrayListWithCapacity((int)subscriberMapList.size());
        HashMap msgPubSubMap = Maps.newHashMapWithExpectedSize((int)subscriberMapList.size());
        PublisherConsumerServiceHelper.validateIsNull(subscriberMapList, msgPubNoList, msgPubSubMap);
        QFilter filter = new QFilter("number", "in", (Object)msgPubNoList);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hrcs_msgpublisher");
        DynamicObject[] pubDyArr = PUB_HELPER.query(PublisherConsumerServiceHelper.buildSelectProperties(type), new QFilter[]{filter});
        if (null == pubDyArr || pubDyArr.length <= 0) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e1a\u52a1\u4e8b\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u8ba2\u3002", (String)"PublisherConsumerServiceHelper_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), msgPubNoList));
        }
        HashMap pubNoMap = Maps.newHashMapWithExpectedSize((int)pubDyArr.length);
        PublisherConsumerServiceHelper.validateSubScribe(subscriberMapList, msgSubList, msgPubSubMap, pubDyArr, pubNoMap);
        PublisherConsumerServiceHelper.validateDuplicate(subscriberMapList, msgSubList, pubNoMap);
        for (DynamicObject pubDy : pubDyArr) {
            for (Map<String, Object> subscriberMap : subscriberMapList) {
                if (!pubDy.getString("number").equalsIgnoreCase(subscriberMap.get("msgPublisherNo").toString())) continue;
                QFilter subFilter = new QFilter("msgsubno", "=", subscriberMap.get("msgSubNo"));
                MainEntityType subType = EntityMetadataCache.getDataEntityType((String)"hrcs_msgsubscriber");
                DynamicObject dy2 = SUB_HELPER.queryOne(PublisherConsumerServiceHelper.buildSelectProperties(subType), new QFilter[]{subFilter});
                if (null == dy2) {
                    dy2 = SUB_HELPER.generateEmptyDynamicObject();
                    dyList.add(dy2);
                } else {
                    dyUpdateList.add(dy2);
                }
                PublisherConsumerServiceHelper.setSubscriberDyValue(subscriberMap, dy2, pubDy);
            }
        }
        Object[] dys = SUB_HELPER.save(dyList.toArray(new DynamicObject[dyList.size()]));
        Object[] dyUpdates = SUB_HELPER.save(dyUpdateList.toArray(new DynamicObject[dyUpdateList.size()]));
        ArrayList dyIds = Lists.newArrayListWithCapacity((int)subscriberMapList.size());
        if (null != dys && dys.length > 0) {
            dyIds.addAll(Arrays.stream(dys).map(dy -> ((DynamicObject)dy).getLong("id")).collect(Collectors.toList()));
        }
        if (null != dyUpdates && dyUpdates.length > 0) {
            dyIds.addAll(Arrays.stream(dyUpdates).map(dy -> ((DynamicObject)dy).getLong("id")).collect(Collectors.toList()));
        }
        return dyIds;
    }

    private static String buildSelectProperties(MainEntityType type) {
        String props = type.getProperties().stream().filter(o -> o.getName().indexOf("_id") < 0).map(IMetadata::getName).collect(Collectors.joining(","));
        String apiEntryProps = ((EntityType)type.getAllEntities().get("apientryentity")).getProperties().stream().filter(o -> o.getName().indexOf("_id") < 0).map(IMetadata::getName).collect(Collectors.joining(",apientryentity."));
        return String.join((CharSequence)",", props, apiEntryProps);
    }

    private static void validateIsNull(List<Map<String, Object>> subscriberMapList, List<String> msgPubNoList, Map<String, String> msgPubSubMap) {
        for (Map<String, Object> subscriberMap : subscriberMapList) {
            MsgUtils.validateIsNull(subscriberMap, "msgSubNo", "consumerCloudId", "consumerAppId", "consumerService", "consumerMethod", "msgPublisherNo", "subStatus");
            msgPubNoList.add(subscriberMap.get("msgPublisherNo").toString());
            msgPubSubMap.put(subscriberMap.get("msgPublisherNo").toString(), subscriberMap.get("subscribeDdId").toString());
        }
    }

    private static void validateDuplicate(List<Map<String, Object>> subscriberMapList, List<String> msgSubList, Map<String, String> pubNoMap) {
        for (Map<String, Object> subscriberMap : subscriberMapList) {
            StringBuilder whereSql = new StringBuilder();
            whereSql.append("(fmsgpublisherid ='");
            whereSql.append(pubNoMap.get(subscriberMap.get("msgPublisherNo")));
            whereSql.append("' and fnumber <>'");
            whereSql.append(subscriberMap.get("msgSubNo"));
            whereSql.append("' and fsubstatus ='");
            whereSql.append("1");
            whereSql.append("' and fconsumercloud ='");
            whereSql.append(subscriberMap.get("consumerCloudId"));
            whereSql.append("'and fconsumerapp ='");
            whereSql.append(subscriberMap.get("consumerAppId"));
            whereSql.append("'and fconsumerservice ='");
            whereSql.append(subscriberMap.get("consumerService"));
            whereSql.append("'and fconsumermethod ='");
            whereSql.append(subscriberMap.get("consumerMethod"));
            whereSql.append("')");
            if (msgSubList.contains(whereSql.toString())) {
                logger.error("saveMsgSubscriberList_validateDuplicate;subscriber={}", (Object)whereSql.toString());
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u8ba2\u9605\u91cd\u590d\uff0c\u8bf7\u4fee\u8ba2\u3002", (String)"PublisherConsumerServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), whereSql.toString()));
            }
            msgSubList.add(whereSql.toString());
        }
        String querySql = "select 1 from t_hrcs_msgsubscriber where " + String.join((CharSequence)" or ", msgSubList);
        Boolean existFlags = (Boolean)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)querySql, null, rs -> {
            if (rs.next()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        if (existFlags.booleanValue()) {
            logger.error("saveMsgSubscriberList_validateDuplicate;subscriber={}", (Object)msgSubList.toString());
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u8ba2\u9605\u91cd\u590d\uff0c\u8bf7\u4fee\u8ba2\u3002", (String)"PublisherConsumerServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), msgSubList.toString()));
        }
    }

    private static void validateSubScribe(List<Map<String, Object>> subscriberMapList, List<String> msgSubList, Map<String, String> msgPubSubMap, DynamicObject[] pubDyArr, Map<String, String> pubNoMap) {
        ArrayList msgPubSubList = Lists.newArrayListWithCapacity((int)subscriberMapList.size());
        for (DynamicObject pubDy : pubDyArr) {
            if (!msgPubSubMap.containsKey(pubDy.getString("number"))) continue;
            msgPubSubList.add(" (fid =" + pubDy.getLong("id") + " and fbasedataid =" + msgPubSubMap.get(pubDy.get("number")) + ") ");
            msgPubSubMap.put(pubDy.getString("id"), msgPubSubMap.get(pubDy.getString("number")));
            msgPubSubMap.remove(pubDy.getString("number"));
            pubNoMap.put(pubDy.getString("number"), pubDy.getString("id"));
        }
        if (msgPubSubList.size() == 0) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e1a\u52a1\u4e8b\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u8ba2\u3002", (String)"PublisherConsumerServiceHelper_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), msgPubSubMap));
        }
        String selectSql = "select fid,fbasedataid from t_hrcs_subbsifield  where " + String.join((CharSequence)" or ", msgPubSubList);
        Map ids = (Map)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)selectSql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap ids = Maps.newHashMapWithExpectedSize((int)16);
                while (rs.next()) {
                    ids.put(rs.getString("fid"), rs.getString("fbasedataid"));
                }
                return ids;
            }
        });
        for (Map.Entry<String, String> msgPubSub : msgPubSubMap.entrySet()) {
            if (!ids.containsKey(msgPubSub.getKey()) || msgPubSub.getValue().equalsIgnoreCase((String)ids.get(msgPubSub.getKey()))) continue;
            logger.error("saveMsgSubscriberList_validateSubScribe;subscriber={}", (Object)msgSubList.toString());
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e1a\u52a1\u7c7b\u578b\u4e0d\u53ef\u8ba2\u9605\uff0c\u8bf7\u4fee\u8ba2\u3002", (String)"PublisherConsumerServiceHelper_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]), msgSubList.toString()));
        }
    }

    private static DynamicObject setSubscriberDyValue(Map<String, Object> subscriberMap, DynamicObject dy, DynamicObject pubDy) {
        Map apiEntryIDMap = (Map)subscriberMap.get("apiEntryEntity");
        if (StringUtils.isEmpty((CharSequence)dy.getString("number")) && !Objects.isNull(subscriberMap.get("msgSubNo"))) {
            dy.set("number", subscriberMap.get("msgSubNo"));
        }
        dy.set("msgsubno", subscriberMap.get("msgSubNo"));
        dy.set("consumercloud", subscriberMap.get("consumerCloudId"));
        dy.set("consumerapp", subscriberMap.get("consumerAppId"));
        dy.set("subscribebd", subscriberMap.get("subscribeDdId"));
        dy.set("consumerservice", subscriberMap.get("consumerService"));
        dy.set("consumermethod", subscriberMap.get("consumerMethod"));
        dy.set("suber", subscriberMap.get("suberId"));
        dy.set("description", subscriberMap.getOrDefault("description", " "));
        dy.set("subtime", (Object)new Date());
        dy.set("substatus", subscriberMap.getOrDefault("subStatus", "0"));
        dy.set("isnonoriginal", subscriberMap.getOrDefault("isNonoriginal", "0"));
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        dy.set("issyspreset", (Object)"0");
        HRBaseUtils.setSysField((DynamicObject)dy);
        DynamicObjectCollection apiEntryCollection = dy.getDynamicObjectCollection("apientryentity");
        apiEntryCollection.clear();
        MainEntityType mainType = (MainEntityType)dy.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get("apientryentity");
        dy.set("msgpublisher", pubDy.getPkValue());
        dy.set("name", pubDy.get("name"));
        dy.set("action", pubDy.get("action"));
        dy.set("msgactiontype", pubDy.get("actiontype"));
        if (MapUtils.isEmpty((Map)apiEntryIDMap)) {
            return dy;
        }
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)pubDy.get("apientryentity");
        for (DynamicObject pubAPIDy : dynamicObjectCollection) {
            if (!StringUtils.equals((CharSequence)pubAPIDy.getString("apipubstatus"), (CharSequence)"P")) continue;
            apiEntryCollection.add((Object)PublisherConsumerServiceHelper.buildApiEntryDy(type, pubAPIDy, apiEntryIDMap, pubDy.getDate("publishdate")));
        }
        return dy;
    }

    private static DynamicObject buildApiEntryDy(EntityType type, DynamicObject apiEntityDy, Map<String, String> apiSubEntryIDMap, Date publishDate) {
        DynamicObject apiEntryDy = (DynamicObject)type.createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)apiEntityDy, (DynamicObject)apiEntryDy);
        apiEntryDy.set("apipuberdate", (Object)publishDate);
        if (apiSubEntryIDMap.containsKey(apiEntityDy.getString("apisource.number")) && "1".equalsIgnoreCase(apiSubEntryIDMap.get(apiEntityDy.getString("apisource.number")))) {
            apiEntryDy.set("apisubstatus", (Object)"1");
        } else {
            apiEntryDy.set("apisubstatus", (Object)"0");
        }
        return apiEntryDy;
    }

    static {
        CLASS_CHECK_MAP.put("id", Long.class);
        CLASS_CHECK_MAP.put("name", String.class);
        CLASS_CHECK_MAP.put("actionCloud", String.class);
        CLASS_CHECK_MAP.put("actionApp", String.class);
        CLASS_CHECK_MAP.put("publishBd", Long.class);
        CLASS_CHECK_MAP.put("actionType", Long.class);
        CLASS_CHECK_MAP.put("action", Long.class);
        CLASS_CHECK_MAP.put("msgTag", String.class);
        CLASS_CHECK_MAP.put("msgProBo", Long.class);
        CLASS_CHECK_MAP.put("pubEr", Long.class);
        CLASS_CHECK_MAP.put("pubStatus", String.class);
        CLASS_CHECK_MAP.put("publishDate", Date.class);
        CLASS_CHECK_MAP.put("isSubscribe", String.class);
        CLASS_CHECK_MAP.put("description", String.class);
        CLASS_CHECK_MAP.put("apiEntryEntity", List.class);
        CLASS_CHECK_MAP.put("apiNumber", String.class);
        CLASS_CHECK_MAP.put("apiPubStatus", String.class);
    }
}

