/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityInsServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityNodeLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.ActivityCommonUtil;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.ActivityRecConstructHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.WorkflowEventEnum;
import kd.hr.hrcs.common.constants.activity.ActivityConstants;

public class ActivityInsBatchOperateHelper {
    private static final Log LOGGER = LogFactory.getLog(ActivityInsBatchOperateHelper.class);
    private static final String ENTITYNAME_REC = "hrcs_actassignrec";
    private static final String ENTITYNAME_INS = "hrcs_activityins";
    private static final String HRCS_BUSINESS = "hrmp-hrcs-business";

    public static OperationResult batchConsentTask(List<Long> taskIdList, Long userId, String auditMessage) {
        String failTipStr = ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5904\u7406\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsBatchOperateHelper_7", (String)HRCS_BUSINESS, (Object[])new Object[0]);
        return ActivityInsBatchOperateHelper.doThing4Task("CONSENT", taskIdList, userId, new String[]{"20", "10"}, "40", "40", failTipStr, auditMessage, Boolean.TRUE, WorkflowEventEnum.CONSENT);
    }

    public static OperationResult batchRejectTask(List<Long> taskIdList, Long userId, String auditMessage) {
        String failTipStr = ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u9a73\u56de\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsBatchOperateHelper_6", (String)HRCS_BUSINESS, (Object[])new Object[0]);
        return ActivityInsBatchOperateHelper.doThing4Task("REJECT", taskIdList, userId, new String[]{"20"}, "30", "30", failTipStr, auditMessage, Boolean.TRUE, WorkflowEventEnum.REJECT);
    }

    public static OperationResult batchTerminateTask(List<Long> taskIdList, Long userId, String auditMessage) {
        String failTipStr = ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u7ec8\u6b62\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"ActivityInsBatchOperateHelper_5", (String)HRCS_BUSINESS, (Object[])new Object[0]);
        return ActivityInsBatchOperateHelper.doThing4Task("TERMINATE", taskIdList, userId, new String[]{"20", "10"}, "50", "50", failTipStr, auditMessage, Boolean.FALSE, WorkflowEventEnum.TERMINATE);
    }

    private static OperationResult doThing4Task(String opStr, List<Long> taskIdList, Long userId, String[] checkStatusStr, String statusWithFlowByHandle, String statusFlowByAct, String tipStr, String auditMessage, boolean checkHandler, WorkflowEventEnum workflowEventEnum) {
        long end;
        long start;
        LOGGER.info("Got params with opStr:[{}], taskIdList:[{}].", (Object)opStr, taskIdList);
        OperationResult result = new OperationResult();
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(taskIdList.size());
        ArrayList<Object> actAndRecInfoList = new ArrayList<Object>(taskIdList.size());
        ArrayList nodeLogs = Lists.newArrayListWithCapacity((int)16);
        HashMap<Long, Object> toDoWorkFlowInsMap = new HashMap<Long, Object>(taskIdList.size());
        for (Long l : taskIdList) {
            start = System.currentTimeMillis();
            DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById("actscheme,activity,handlers,taskstatus,handletime,bindbizbillid,bizbillid,wfprocessinsid,wfnode", l);
            end = System.currentTimeMillis();
            LOGGER.info("GetActivityInsById task: {} coast: {}.", (Object)l, (Object)(end - start));
            if (!ActivityInsBatchOperateHelper.checkNull(errorInfoList, taskInsInfo, l)) {
                LOGGER.info("Check null false with activity ins id: {}.", (Object)l);
                continue;
            }
            if (HRStringUtils.equals((String)opStr, (String)"CONSENT")) {
                DynamicObject dynamicObject = taskInsInfo.getDynamicObject("actscheme");
                DynamicObject tempActivityScheme = ActivitySchemeServiceHelper.getByNumberAndVersionAndActivityId("actschemeentry.checkhandler", dynamicObject.getString("number"), dynamicObject.getString("version"), taskInsInfo.getLong("activity.id"));
                checkHandler = HRStringUtils.equals((String)"1", (String)((DynamicObject)((DynamicObject)tempActivityScheme.getDynamicObjectCollection("actschemeentry").get(0)).getDynamicObjectCollection("actinfo").get(0)).getString("checkhandler"));
            }
            if (!ActivityInsBatchOperateHelper.basicCheck(checkHandler, errorInfoList, taskInsInfo, l)) {
                LOGGER.info("Check basic false with activity ins id: {}.", (Object)l);
                continue;
            }
            start = System.currentTimeMillis();
            Integer n = ActivityInsServiceHelper.getFlowParam(taskInsInfo.getLong("actscheme.id"), taskInsInfo.getLong("activity.id"));
            end = System.currentTimeMillis();
            LOGGER.info("GetFlowParam: {} task: {} coast: {}.", new Object[]{n, l, end - start});
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
            if (ActivityConstants.FLOW_BY_HANDLE.compareTo(n) == 0) {
                boolean statusCheckFlagSuccess = false;
                for (String checkStatus : checkStatusStr) {
                    if (!checkStatus.equals(taskInsInfo.get("taskstatus"))) continue;
                    statusCheckFlagSuccess = true;
                    break;
                }
                if (!statusCheckFlagSuccess) {
                    errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(tipStr, taskInsInfo, l));
                    LOGGER.info("Got failed message: {}.", errorInfoList);
                    continue;
                }
                ActivityNodeLogServiceHelper.constructNodeLog(nodeLogs, serviceHelper, taskInsInfo, statusWithFlowByHandle, workflowEventEnum, userId == null ? Long.valueOf(RequestContext.get().getCurrUserId()) : userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                ActivityInsBatchOperateHelper.constructTaskInfo(taskInsInfo, statusWithFlowByHandle);
                toDoWorkFlowInsMap.put(l, taskInsInfo);
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(l, ActivityInsBatchOperateHelper.convertStatus(opStr), userId, auditMessage, null);
                actAndRecInfoList.add(taskInsInfo);
                actAndRecInfoList.add(recInfo);
                continue;
            }
            if (ActivityConstants.FLOW_BY_ACTIVATE.compareTo(n) == 0) {
                ActivityNodeLogServiceHelper.constructNodeLog(nodeLogs, serviceHelper, taskInsInfo, statusFlowByAct, workflowEventEnum, userId == null ? Long.valueOf(RequestContext.get().getCurrUserId()) : userId, taskInsInfo.getLong("wfprocessinsid"), taskInsInfo.getString("wfnode"));
                ActivityInsBatchOperateHelper.constructTaskInfo(taskInsInfo, statusFlowByAct);
                toDoWorkFlowInsMap.put(l, taskInsInfo);
                DynamicObject recInfo = ActivityRecConstructHelper.genRecInfoWithOutHandlers(l, ActivityInsBatchOperateHelper.convertStatus(opStr), userId, auditMessage, null);
                actAndRecInfoList.add(taskInsInfo);
                actAndRecInfoList.add(recInfo);
                continue;
            }
            errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u6d41\u8f6c\u53c2\u6570\u89e3\u6790\u9519\u8bef\uff0c\u65e0\u6cd5\u5904\u7406\u4efb\u52a1 \uff0c\u6d41\u8f6c\u53c2\u6570\uff1a%s\u3002", (String)"ActivityErrorCode_1", (String)HRCS_BUSINESS, (Object[])new Object[0]), n), taskInsInfo, l));
        }
        LOGGER.info("Got last error info list: {}.", errorInfoList);
        LOGGER.info("Got actAndRecInfoList: {}, toDoWorkFlowInsMap: {}.", (Object)actAndRecInfoList.size(), toDoWorkFlowInsMap);
        if (actAndRecInfoList.size() > 0) {
            start = System.currentTimeMillis();
            Throwable throwable = null;
            try (TXHandle txHandle = TX.required();){
                for (Object e : taskIdList) {
                    Long successInsID = (Long)e;
                    DynamicObject dyn = (DynamicObject)toDoWorkFlowInsMap.get(e);
                    if (dyn == null) {
                        LOGGER.info("Ignore activity instance with id: {}.", e);
                        continue;
                    }
                    Integer flowParam = ActivityInsServiceHelper.getFlowParam(dyn.getLong("actscheme.id"), dyn.getLong("activity.id"));
                    LOGGER.info("Got process activity ins id: {}, flowParam: {} with activity id: {} and activity scheme id: {}.", new Object[]{successInsID, flowParam, dyn.getLong("activity.id"), dyn.getLong("actscheme.id")});
                    TXHandle globalTaskTXHandle = TX.notSupported();
                    Throwable throwable2 = null;
                    try {
                        if ("TERMINATE".equals(opStr)) {
                            start = System.currentTimeMillis();
                            ActivityInsServiceHelper.terminateWorkFlowTask(txHandle, successInsID, userId, auditMessage);
                            end = System.currentTimeMillis();
                            LOGGER.info("TerminateWorkFlowTask task coast: {}.", (Object)(end - start));
                            continue;
                        }
                        if ("REJECT".equals(opStr)) {
                            ActivityInsServiceHelper.rejectWorkFlowTask(txHandle, successInsID, userId, auditMessage, false);
                            continue;
                        }
                        if (!"CONSENT".equals(opStr)) continue;
                        ActivityInsServiceHelper.consentWorkFlowTask(txHandle, successInsID, userId, auditMessage);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (globalTaskTXHandle == null) continue;
                        if (throwable2 != null) {
                            try {
                                globalTaskTXHandle.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        globalTaskTXHandle.close();
                    }
                }
                try {
                    result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])actAndRecInfoList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    ActivityNodeLogServiceHelper.batchSave(nodeLogs.toArray(new DynamicObject[0]));
                }
                catch (Exception exception) {
                    throw new KDException((Throwable)exception, new ErrorCode("5", ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"ActivityInsServiceHelper_14", (String)HRCS_BUSINESS, (Object[])new Object[0])), new Object[0]);
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
            end = System.currentTimeMillis();
            LOGGER.info("SaveActivityIns task coast: {}.", (Object)(end - start));
        }
        for (OperateErrorInfo operateErrorInfo : errorInfoList) {
            result.addErrorInfo(operateErrorInfo);
        }
        return result;
    }

    private static String convertStatus(String opStr) {
        if (StringUtils.isNotEmpty((String)opStr)) {
            return opStr;
        }
        return "ASSIGN";
    }

    private static boolean basicCheck(boolean checkHandler, List<OperateErrorInfo> errorInfoList, DynamicObject taskInsInfo, Long activityInsId) {
        if (!ActivityInsBatchOperateHelper.checkNull(errorInfoList, taskInsInfo, activityInsId)) {
            return false;
        }
        if (checkHandler && !ActivityInsServiceHelper.validateCanHandleByCurUser(taskInsInfo)) {
            errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u6d3b\u52a8\u5904\u7406\u4eba\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u9879\u64cd\u4f5c\u3002", (String)"ActivityInsBatchOperateHelper_2", (String)HRCS_BUSINESS, (Object[])new Object[0]), taskInsInfo, activityInsId));
            return false;
        }
        return true;
    }

    private static boolean checkNull(List<OperateErrorInfo> errorInfoList, DynamicObject taskInsInfo, Long activityInsId) {
        if (taskInsInfo == null) {
            errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsBatchOperateHelper_1", (String)HRCS_BUSINESS, (Object[])new Object[0]), null, activityInsId));
            return false;
        }
        return true;
    }

    private static void constructHandler(DynamicObjectCollection handlerColl) {
        DynamicObjectType dynamicObjectType = handlerColl == null ? new DynamicObjectType("handlers") : handlerColl.getDynamicObjectType();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        Objects.requireNonNull(handlerColl).clear();
        DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
        DynamicObject handlerUsers = hrBaseServiceHelper.generateEmptyDynamicObject("bos_user");
        handlerUsers.set("id", (Object)RequestContext.get().getCurrUserId());
        mulBasedataDy.set("fbasedataid", (Object)handlerUsers);
        handlerColl.add((Object)mulBasedataDy);
    }

    private static void constructTaskInfo(DynamicObject taskInsInfo, String taskStatus) {
        taskInsInfo.set("taskstatus", (Object)taskStatus);
        taskInsInfo.set("handletime", (Object)TimeServiceHelper.now());
        DynamicObjectCollection handlerColl = taskInsInfo.getDynamicObjectCollection("handlers");
        ActivityInsBatchOperateHelper.constructHandler(handlerColl);
    }

    public static OperationResult batchAssignTask(List<Long> taskIdList, List<Long> destHandlerIdList, String auditMessage) {
        OperationResult result = new OperationResult();
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(taskIdList.size());
        ArrayList<DynamicObject> actAndRecInfoList = new ArrayList<DynamicObject>(taskIdList.size());
        HashMap<Long, DynamicObject> toDoWorkFlowInsMap = new HashMap<Long, DynamicObject>(taskIdList.size());
        ArrayList nodeLogs = Lists.newArrayListWithCapacity((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
        for (Long l : taskIdList) {
            DynamicObject actInsInfo = ActivityInsServiceHelper.getActivityInsById("", l);
            if (actInsInfo == null) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsServiceHelper_4", (String)HRCS_BUSINESS, (Object[])new Object[0]), null, l));
                continue;
            }
            if (destHandlerIdList == null || destHandlerIdList.size() == 0) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u5f85\u5206\u914d\u7684\u5904\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ActivityInsServiceHelper_8", (String)HRCS_BUSINESS, (Object[])new Object[0]), actInsInfo, l));
                continue;
            }
            if (!ActivityCommonUtil.canAssignOrTransferStatus(actInsInfo)) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u975e\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u8fdb\u884c\u5206\u914d\u64cd\u4f5c\u3002", (String)"ActivityInsServiceHelper_9", (String)HRCS_BUSINESS, (Object[])new Object[0]), actInsInfo, l));
                continue;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
            DynamicObjectCollection dyColl = actInsInfo.getDynamicObjectCollection("handlers");
            dyColl.clear();
            for (Long handlerId : destHandlerIdList) {
                DynamicObject mulBasedataDy = new DynamicObject(dyColl.getDynamicObjectType());
                DynamicObject handlerUsers = hrBaseServiceHelper.generateEmptyDynamicObject("bos_user");
                handlerUsers.set("id", (Object)handlerId);
                mulBasedataDy.set("fbasedataid", (Object)handlerUsers);
                dyColl.add((Object)mulBasedataDy);
            }
            if (!"20".equals(actInsInfo.getString("taskstatus"))) {
                ActivityNodeLogServiceHelper.constructNodeLog(nodeLogs, serviceHelper, actInsInfo, "20", WorkflowEventEnum.ASSIGN, RequestContext.get().getCurrUserId(), actInsInfo.getLong("wfprocessinsid"), actInsInfo.getString("wfnode"));
            }
            actInsInfo.set("taskstatus", (Object)"20");
            DynamicObject assignRec = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNAME_REC);
            assignRec.set("assigntype", (Object)"ASSIGN");
            assignRec.set("creator", (Object)RequestContext.get().getCurrUserId());
            assignRec.set("createtime", (Object)TimeServiceHelper.now());
            assignRec.set("activityins", (Object)l);
            assignRec.set("auditmessage", (Object)auditMessage);
            actAndRecInfoList.add(actInsInfo);
            actAndRecInfoList.add(assignRec);
            toDoWorkFlowInsMap.put(l, actInsInfo);
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            if (actAndRecInfoList.size() > 0) {
                result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])actAndRecInfoList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            ActivityNodeLogServiceHelper.batchSave(nodeLogs.toArray(new DynamicObject[0]));
            for (Object successId : result.getSuccessPkIds()) {
                Long sId = (Long)successId;
                DynamicObject sDyn = (DynamicObject)toDoWorkFlowInsMap.get(sId);
                long activitySchemeId = sDyn.getLong("actscheme.id");
                long activityId = sDyn.getLong("activity.id");
                Integer flowParam = ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
                if (ActivityConstants.FLOW_BY_HANDLE.compareTo(flowParam) != 0) continue;
                long wfTaskId = sDyn.getLong("wfcurtaskid");
                String taskSwitch = sDyn.getString("taskswitch");
                LOGGER.info("Task[{}] activitySchemeId:{}, activityId:{}, wfTaskId:{}, taskSwitch:{}.", new Object[]{sId, activitySchemeId, activityId, wfTaskId, taskSwitch});
                try {
                    TXHandle globalTaskTXHandle = TX.notSupported();
                    Throwable throwable2 = null;
                    try {
                        if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
                            long globalTaskId = sDyn.getLong("globaltaskid");
                            LOGGER.info("Task[{}] globalTaskId:{}.", (Object)sId, (Object)globalTaskId);
                            UpdateParticipantParam updateParticipantParam = new UpdateParticipantParam();
                            updateParticipantParam.setTaskIds((List)Lists.newArrayList((Object[])new Long[]{globalTaskId}));
                            updateParticipantParam.setParticipantIds(destHandlerIdList);
                            updateParticipantParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                            BatchOperateResult operateResult = MessageCenterServiceHelper.updateParticipant((UpdateParticipantParam)updateParticipantParam);
                            if (operateResult.isSuccess()) continue;
                            String resultMessage = operateResult.getOperateResults().stream().map(OperateResult::getOperateMsg).reduce((acc, it) -> acc + "\n" + it).orElse("-");
                            LOGGER.info("Got error message: {} when drive task center with transfer task.", (Object)resultMessage);
                            result.setSuccess(false);
                            result.addErrorInfo(new OperateErrorInfo(resultMessage, ErrorLevel.Error, sDyn.getPkValue()));
                            txHandle.markRollback();
                            continue;
                        }
                        if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
                            long sscTaskId = sDyn.getLong("ssctaskid");
                            LOGGER.info("Task[{}] sscTaskId:{}.", (Object)sId, (Object)sscTaskId);
                            continue;
                        }
                        LOGGER.info("Batch assign task [{}] with handlers [{}].", (Object)wfTaskId, destHandlerIdList);
                        if (wfTaskId == 0L) continue;
                        WorkflowServiceHelper.updateTaskInfoAndParticipant((TaskInfo)WorkflowServiceHelper.findTaskById((Long)wfTaskId), destHandlerIdList);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (globalTaskTXHandle == null) continue;
                        if (throwable2 != null) {
                            try {
                                globalTaskTXHandle.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        globalTaskTXHandle.close();
                    }
                }
                catch (KDException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                    errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ex.getMessage(), sDyn, sId));
                }
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        for (OperateErrorInfo operateErrorInfo : errorInfoList) {
            result.addErrorInfo(operateErrorInfo);
        }
        return result;
    }

    private static OperateErrorInfo getErrorInfo(String errorCode, DynamicObject actInsInfo, Long actInsId) {
        OperateErrorInfo opErrorInfo;
        LOGGER.info("ActivityInsBatchOperateHelper : errorCode {} ,actInsId is {}", (Object)errorCode, (Object)actInsId);
        HashMap<String, String> cusMap = new HashMap<String, String>();
        if (actInsInfo != null) {
            cusMap.put("bizbillid", actInsInfo.getString("bizbillid"));
            cusMap.put("bindbizbillid", actInsInfo.getString("bindbizbillid"));
            cusMap.put("id", String.valueOf(actInsId));
            opErrorInfo = new OperateErrorInfo(errorCode, ErrorLevel.Error, actInsInfo.getPkValue());
        } else {
            cusMap.put("bizbillid", "");
            cusMap.put("bindbizbillid", "");
            cusMap.put("id", String.valueOf(actInsId));
            opErrorInfo = new OperateErrorInfo(errorCode, ErrorLevel.Error, (Object)actInsId);
        }
        opErrorInfo.setErrorCustInfos(cusMap);
        return opErrorInfo;
    }

    public static OperationResult batchTransferTask(List<Long> taskIdList, Long destHandlerId, String auditMessage) {
        LOGGER.info("Batch transfer task.");
        OperationResult result = new OperationResult();
        Long curUserId = RequestContext.get().getCurrUserId();
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(taskIdList.size());
        ArrayList<DynamicObject> actAndRecInfoList = new ArrayList<DynamicObject>(taskIdList.size());
        HashMap<Long, DynamicObject> toDoWorkFlowInsMap = new HashMap<Long, DynamicObject>(taskIdList.size());
        Map<Long, DynamicObject> actInsInfoMap = Arrays.stream(ActivityInsServiceHelper.getActivityInsByIds("", new HashSet<Long>(taskIdList))).collect(Collectors.toMap(it -> it.getLong("id"), it -> it, (oldValue, newValue) -> oldValue));
        for (Long l : taskIdList) {
            DynamicObject actInsInfo = actInsInfoMap.get(l);
            if (actInsInfo == null) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsBatchOperateHelper_1", (String)HRCS_BUSINESS, (Object[])new Object[0]), null, l));
                continue;
            }
            if (!ActivityCommonUtil.canAssignOrTransferStatus(actInsInfo)) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u975e\u201c\u5f85\u5904\u7406\u201d\u6216\u201c\u8fdb\u884c\u4e2d\u201d\u7684\u6d3b\u52a8\u4e0d\u5141\u8bb8\u8fdb\u884c\u8f6c\u4ea4\u3002", (String)"ActivityInsBatchOperateHelper_3", (String)HRCS_BUSINESS, (Object[])new Object[0]), actInsInfo, l));
                continue;
            }
            DynamicObjectCollection handlerColl = actInsInfo.getDynamicObjectCollection("handlers");
            boolean isCurrentHandler = false;
            boolean isDupHandler = false;
            HashSet<Long> oriHandlerIds = new HashSet<Long>(handlerColl.size());
            DynamicObject transRecInfo = null;
            for (int idx = 0; idx < handlerColl.size(); ++idx) {
                DynamicObject temp = (DynamicObject)handlerColl.get(idx);
                if (temp.get("fbasedataid") == null || ((DynamicObject)temp.get("fbasedataid")).getPkValue() == null) {
                    errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u6d3b\u52a8\u5904\u7406\u4eba\u4e0d\u5b58\u5728\u3002", (String)"ActivityInsBatchOperateHelper_9", (String)HRCS_BUSINESS, (Object[])new Object[0]), actInsInfo, l));
                    continue;
                }
                Long oriHandlerId = (Long)((DynamicObject)temp.get("fbasedataid")).getPkValue();
                if (oriHandlerIds.contains(oriHandlerId)) {
                    isDupHandler = true;
                }
                if (oriHandlerId.compareTo(destHandlerId) == 0) {
                    isDupHandler = true;
                }
                oriHandlerIds.add(oriHandlerId);
                if (oriHandlerId.compareTo(curUserId) != 0) continue;
                isCurrentHandler = true;
                temp.set("fbasedataid", (Object)destHandlerId);
                handlerColl.set(idx, (Object)temp);
                transRecInfo = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNAME_REC);
                transRecInfo.set("assigntype", (Object)"TRANSFER");
                transRecInfo.set("creator", (Object)curUserId);
                transRecInfo.set("createtime", (Object)TimeServiceHelper.now());
                transRecInfo.set("activityins", (Object)l);
                transRecInfo.set("auditmessage", (Object)auditMessage);
                DynamicObjectCollection curHandlerColl = transRecInfo.getDynamicObjectCollection("mulhandler");
                DynamicObjectType curDyType = curHandlerColl.getDynamicObjectType();
                DynamicObject curMulBasedataDy = new DynamicObject(curDyType);
                curMulBasedataDy.set("fbasedataid", (Object)destHandlerId);
                curHandlerColl.add((Object)curMulBasedataDy);
            }
            if (!isCurrentHandler) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u6d3b\u52a8\u5904\u7406\u4eba\u4e0d\u5141\u8bb8\u8fdb\u884c\u8f6c\u4ea4\u3002", (String)"ActivityInsBatchOperateHelper_4", (String)HRCS_BUSINESS, (Object[])new Object[0]), actInsInfo, l));
                continue;
            }
            if (isDupHandler) {
                errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u5904\u7406\u4eba\u5df2\u4e3a\u8be5\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u8f6c\u4ea4\u3002", (String)"ActivityInsBatchOperateHelper_8", (String)HRCS_BUSINESS, (Object[])new Object[0]), actInsInfo, l));
                continue;
            }
            actAndRecInfoList.add(actInsInfo);
            actAndRecInfoList.add(transRecInfo);
            toDoWorkFlowInsMap.put(l, actInsInfo);
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            LOGGER.info("Begin batch save instance.");
            if (actAndRecInfoList.size() > 0) {
                result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNAME_INS, (DynamicObject[])actAndRecInfoList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            LOGGER.info("End batch save instance.");
            LOGGER.info("Got result: {}.", (Object)result);
            for (Object successId : result.getSuccessPkIds()) {
                Long sId = (Long)successId;
                DynamicObject sDyn = (DynamicObject)toDoWorkFlowInsMap.get(sId);
                long activitySchemeId = sDyn.getLong("actscheme.id");
                long activityId = sDyn.getLong("activity.id");
                Integer flowParam = ActivityInsServiceHelper.getFlowParam(activitySchemeId, activityId);
                Long wfTaskId = sDyn.getLong("wfcurtaskid");
                String taskSwitch = sDyn.getString("taskswitch");
                LOGGER.info("Task[{}] activitySchemeId:{}, activityId:{}, wfTaskId:{}, taskSwitch:{}.", new Object[]{sId, activitySchemeId, activityId, wfTaskId, taskSwitch});
                LocaleString transferOpinion = new LocaleString(auditMessage);
                try {
                    TXHandle globalTaskTXHandle = TX.notSupported();
                    Throwable throwable2 = null;
                    try {
                        if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
                            long globalTaskId = sDyn.getLong("globaltaskid");
                            LOGGER.info("Task[{}] globalTaskId:{}.", (Object)sId, (Object)globalTaskId);
                            TransferOperationParam transferOperationParam = new TransferOperationParam();
                            transferOperationParam.setTaskIds((List)Lists.newArrayList((Object[])new Long[]{globalTaskId}));
                            transferOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
                            transferOperationParam.setTransfererId(destHandlerId);
                            transferOperationParam.setTransferOpinion((ILocaleString)transferOpinion);
                            transferOperationParam.setTransferSubscribe(Boolean.TRUE.booleanValue());
                            BatchOperateResult operateResult = MessageCenterServiceHelper.transferBizTask((TransferOperationParam)transferOperationParam);
                            if (operateResult.isSuccess()) continue;
                            String resultMessage = operateResult.getOperateResults().stream().map(OperateResult::getOperateMsg).reduce((acc, it) -> acc + "\n" + it).orElse("-");
                            LOGGER.info("Got error message: {} when drive task center with transfer task.", (Object)resultMessage);
                            result.setSuccess(false);
                            result.addErrorInfo(new OperateErrorInfo(resultMessage, ErrorLevel.Error, (Object)sId));
                            txHandle.markRollback();
                            continue;
                        }
                        if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
                            long sscTaskId = sDyn.getLong("ssctaskid");
                            LOGGER.info("Task[{}] sscTaskId:{}.", (Object)sId, (Object)sscTaskId);
                            continue;
                        }
                        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
                        LOGGER.info("Got taskInfo: {} with wfTaskId:{} and activityInsId: {}.", new Object[]{taskInfo, wfTaskId, sId});
                        if (null == taskInfo) continue;
                        WorkflowServiceHelper.taskTransfer((Long)wfTaskId, (Long)destHandlerId, (ILocaleString)transferOpinion, (Boolean)Boolean.TRUE);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (globalTaskTXHandle == null) continue;
                        if (throwable2 != null) {
                            try {
                                globalTaskTXHandle.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        globalTaskTXHandle.close();
                    }
                }
                catch (KDException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                    errorInfoList.add(ActivityInsBatchOperateHelper.getErrorInfo(ex.getMessage(), sDyn, sId));
                }
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        LOGGER.info("End batch transfer workflow.");
        for (OperateErrorInfo operateErrorInfo : errorInfoList) {
            result.addErrorInfo(operateErrorInfo);
        }
        return result;
    }
}

