/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;

public class ActivityTreeServiceHelper {
    private final TreeView treeView;

    public ActivityTreeServiceHelper(TreeView treeView) {
        this.treeView = treeView;
    }

    public void reBuildWholeTree() {
        this.treeView.deleteAllNodes();
        TreeNode rootNode = ActivityTreeServiceHelper.buildRootNode();
        this.addCloudNode(rootNode);
        this.treeView.addNode(rootNode);
        this.treeView.focusNode(rootNode);
        this.treeView.treeNodeClick("", rootNode.getId());
    }

    public static TreeNode buildRootNode() {
        String rootName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"HREntityTreeListPlugin_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "1010", rootName, true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private void addCloudNode(TreeNode rootNode) {
        List<Map<String, String>> bizCloudNodeList = ActivitySchemeServiceHelper.getBizCloud();
        String parentId = rootNode.getId();
        for (Map<String, String> bizCloudNode : bizCloudNodeList) {
            String id = bizCloudNode.get("id");
            String name = bizCloudNode.get("name");
            TreeNode cloudNode = new TreeNode(parentId, id, name, true);
            rootNode.addChild(cloudNode);
        }
    }

    public void handleExpandNodeClick(String parentId) {
        String nodeIdPrefix = parentId.split("_split_")[0];
        String parentTrueId = this.isRootNode(parentId) ? parentId : parentId.split("_split_")[1];
        String localeId = RequestContext.get().getLang().name();
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            DynamicObject[] load = this.getAppInfo(parentTrueId);
            this.setCloudTreeNode(parentId, localeId, load);
        }
    }

    private void setCloudTreeNode(String parentId, String localeid, DynamicObject[] load) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)load.length);
        for (DynamicObject obj : load) {
            String id = "2_split_" + obj.getString("id");
            String name = ((OrmLocaleValue)obj.get("name")).getLocaleValue();
            TreeNode appNode = new TreeNode(parentId, id, name, false);
            resultList.add(appNode);
        }
        this.treeView.addNodes((List)resultList);
    }

    private DynamicObject[] getAppInfo(String cloudId) {
        List<String> ids = ActivitySchemeServiceHelper.getAppByHbssCloudId(cloudId);
        QFilter[] qFilters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"id");
        return BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name,masterid,sequence", (QFilter[])qFilters, (String)"sequence");
    }

    private boolean isRootNode(String nodeId) {
        return HRStringUtils.equals((String)nodeId, (String)"1010");
    }
}

