/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityInsServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class ActivityWorkflowServiceHelper {
    private static final Log log = LogFactory.getLog(ActivityWorkflowServiceHelper.class);

    public static OperationResult notify(String nodeId, String bizBillId, String bizEntityNumber, String bizBillNumber, Long creatorId, Long activityId, String schemeVer, String schemeNum, String bindBizKey, String bindLayoutId, List<Long> approverList, Long wfProDefId, Long wfCurTaskId, Long wfProInsId) {
        log.info("ActivityWorkflowServiceHelper : generateActivityTask begin");
        OperationResult operationResult = ActivityInsServiceHelper.generateActivityTask(nodeId, creatorId, bizBillId, bizBillNumber, bizEntityNumber, "", "", bindBizKey, bindLayoutId, wfProDefId, wfProInsId, wfCurTaskId, schemeNum, schemeVer, activityId, approverList.toArray(new Long[approverList.size()]));
        log.info("ActivityWorkflowServiceHelper : generateActivityTask end");
        return operationResult;
    }

    public static void rejectWorkFlowTask(Long actInsId, Long userId, String auditMessage) {
        String decOptionNumber = "reject";
        ActivityWorkflowServiceHelper.completeWorkFlowTask(actInsId, userId, decOptionNumber, auditMessage);
    }

    public static void consentWorkFlowTask(Long actInsId, Long userId, String auditMessage) {
        String decOptionNumber = "consent";
        ActivityWorkflowServiceHelper.completeWorkFlowTask(actInsId, userId, decOptionNumber, auditMessage);
    }

    public static void terminateWorkFlowTask(Long actInsId, Long userId, String auditMessage) {
        String decOptionNumber = "terminal";
        ActivityWorkflowServiceHelper.completeWorkFlowTask(actInsId, userId, decOptionNumber, auditMessage);
    }

    private static void completeWorkFlowTask(Long actInsId, Long userId, String decOptionNumber, String auditMessage) {
        DynamicObject actInsInfo;
        if (userId == null || userId.compareTo(0L) == 0) {
            userId = RequestContext.get().getCurrUserId();
        }
        if (null != (actInsInfo = ActivityInsServiceHelper.getActivityInsById("wfcurtaskid", actInsId))) {
            Long taskId = actInsInfo.getLong("wfcurtaskid");
            try {
                TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
                log.info("ActivityWorkflowServiceHelper : find taskInfo ? {} ,actInsId is {},taskId is {}", new Object[]{taskInfo, actInsId, taskId});
                if (taskInfo != null) {
                    WorkflowServiceHelper.completeTask((Long)taskId, (Long)userId, (String)decOptionNumber, (String)auditMessage);
                }
            }
            catch (KDException ex) {
                log.info(String.format("ActivityWorkflowServiceHelper : taskId : %d actInsId: %d", taskId, actInsId), (Object)ex);
                throw ex;
            }
        }
    }

    public static DynamicObject invokePlugin(String bizBillId, Long activityId, String schemeVer, String schemeNum, String pluginTime, DynamicObject afterSetValue) {
        DynamicObject actScheme = ActivitySchemeServiceHelper.getByNumberAndVersion("bizobj,actschemeentry.tasktheme,actschemeentry.activity,actschemeentry.actbizobj,actschemeentry.plugintype,actschemeentry.bizapp,actschemeentry.service,actschemeentry.method", schemeNum, schemeVer);
        DynamicObjectCollection dynamicObjectCollection = actScheme.getDynamicObjectCollection("actschemeentry");
        DynamicObject actBizObjDy = null;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject activity = dynamicObject.getDynamicObject("activity");
            if (activity.getLong("id") != activityId.longValue()) continue;
            DynamicObjectCollection actinfoColl = dynamicObject.getDynamicObjectCollection("actinfo");
            String actBizObjNUm = "";
            for (DynamicObject actinfo : actinfoColl) {
                actBizObjNUm = actinfo.getDynamicObject("actbizobj").getString("number");
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(actBizObjNUm);
                actBizObjDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            }
            DynamicObjectCollection pluginColl = dynamicObject.getDynamicObjectCollection("pluginentry");
            for (DynamicObject plugin : pluginColl) {
                DynamicObject resultDynamicObject;
                String pluginType = plugin.getString("plugintype");
                String bizApp = plugin.getDynamicObject("bizapp").getString("number");
                String bizCloud = plugin.getDynamicObject("bizapp").getString("bizcloud.number");
                String service = plugin.getString("service");
                String method = plugin.getString("method");
                if ("0".equals(pluginType) && "0".equals(pluginTime)) {
                    afterSetValue = resultDynamicObject = ActivityWorkflowServiceHelper.invokePlugin(bizCloud.toLowerCase(Locale.ROOT), bizApp, service, method, actBizObjDy);
                    continue;
                }
                if (!"1".equals(pluginType) || !"1".equals(pluginTime)) continue;
                afterSetValue = resultDynamicObject = ActivityWorkflowServiceHelper.invokePlugin(bizCloud.toLowerCase(Locale.ROOT), bizApp, service, method, afterSetValue);
            }
        }
        return afterSetValue;
    }

    public static DynamicObject invokePlugin(String bizCloud, String bizApp, String service, String method, DynamicObject actBizObjDy) {
        try {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("businessObject", actBizObjDy);
            DynamicObject resultDynamicObject = (DynamicObject)DispatchServiceHelper.invokeBizService((String)bizCloud, (String)bizApp, (String)service, (String)method, (Object[])new Object[]{paramMap});
            log.info("invokePlugin operationResult:{}", (Object)resultDynamicObject);
            return resultDynamicObject;
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            return null;
        }
    }

    public static DynamicObject generateMappingDynaminObject(Long activityId, String schemeVer, String schemeNum, String bizBillId, DynamicObject afterDy) {
        DynamicObject result = afterDy;
        String actBizObjNum = "";
        DynamicObject actScheme = ActivitySchemeServiceHelper.getByNumberAndVersion("bizobj,actschemeentry.tasktheme,actschemeentry.activity,actschemeentry.subentryentity,actschemeentry.actbizobj,actschemeentry.plugin,actschemeentry.plugintype,actschemeentry.sourcefield,actschemeentry.targetfieldnumber,actschemeentry.fieldactivityid", schemeNum, schemeVer);
        DynamicObject mainBizObj = actScheme.getDynamicObject("bizobj");
        DynamicObjectCollection dynamicObjectCollection = actScheme.getDynamicObjectCollection("actschemeentry");
        DynamicObjectCollection fieldMappingEntry = new DynamicObjectCollection();
        HashMap actBizObjMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject activity = dynamicObject.getDynamicObject("activity");
            if (activity == null) {
                return result;
            }
            DynamicObjectCollection actinfoColl = dynamicObject.getDynamicObjectCollection("actinfo");
            for (DynamicObject actinfo : actinfoColl) {
                actBizObjNum = actinfo.getDynamicObject("actbizobj").getString("number");
                if (activity.getLong("id") != activityId.longValue()) continue;
                String targetFieldNum = actBizObjNum;
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(targetFieldNum);
                if (afterDy == null) {
                    result = hrBaseServiceHelper.generateEmptyDynamicObject();
                }
                fieldMappingEntry = dynamicObject.getDynamicObjectCollection("subentryentity");
            }
            actBizObjMap.put(activity.getLong("id"), actBizObjNum);
        }
        DynamicObject[] activityInsByBizId = ActivityInsServiceHelper.getActivityInsByBizId("", bizBillId);
        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject fieldDy : fieldMappingEntry) {
            String sourceField = fieldDy.getString("sourcefield");
            String targetField = fieldDy.getString("targetfieldnumber");
            String fieldActivityId = fieldDy.getString("fieldactivityid");
            if (HRStringUtils.isEmpty((String)fieldActivityId) && mainBizObj != null) {
                String mainNumber = mainBizObj.getString("number");
                HRBaseServiceHelper mainServiceHelp = new HRBaseServiceHelper(mainNumber);
                DynamicObject cachEntityObject = (DynamicObject)objectObjectHashMap.get("mainEntity");
                if (cachEntityObject == null) {
                    cachEntityObject = mainServiceHelp.loadSingle((Object)bizBillId);
                    objectObjectHashMap.put("mainEntity", cachEntityObject);
                }
                ActivityWorkflowServiceHelper.setFieldValue(targetField, result, sourceField, cachEntityObject);
                continue;
            }
            for (DynamicObject activityIns : activityInsByBizId) {
                Long insActivityId = activityIns.getDynamicObject("activity").getLong("id");
                if (!Long.valueOf(fieldActivityId).equals(insActivityId)) continue;
                Long bindbizbillid = activityIns.getLong("bindbizbillid");
                if (bindbizbillid == 0L) {
                    ActivityWorkflowServiceHelper.setFieldValue(targetField, result, sourceField, null);
                    return result;
                }
                DynamicObject cachEntityObject = (DynamicObject)objectObjectHashMap.get(fieldActivityId);
                if (cachEntityObject == null) {
                    String sourceFieldNum = (String)actBizObjMap.get(insActivityId);
                    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(sourceFieldNum);
                    cachEntityObject = hrBaseServiceHelper.loadSingle((Object)bindbizbillid);
                    objectObjectHashMap.put(fieldActivityId, cachEntityObject);
                }
                ActivityWorkflowServiceHelper.setFieldValue(targetField, result, sourceField, cachEntityObject);
            }
        }
        return result;
    }

    private static void setFieldValue(String targetField, DynamicObject result, String sourceField, DynamicObject cachEntityObject) {
        String[] split = targetField.split("\\.");
        if (split.length == 1) {
            if (cachEntityObject == null) {
                result.set(targetField, null);
            } else {
                result.set(targetField, cachEntityObject.get(sourceField));
            }
        } else if (split.length == 2) {
            String fieldName = targetField.substring(0, targetField.indexOf("."));
            if (cachEntityObject == null) {
                result.set(fieldName, null);
            } else {
                result.set(fieldName, cachEntityObject.get(sourceField));
            }
        }
    }
}

