/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.activity.util;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.activity.ActivityWfRecord;
import kd.hr.hrcs.common.model.activity.WFGroupDecisionTypeEnum;

public class ActivityCommonUtil {
    private static final Log log = LogFactory.getLog(ActivityCommonUtil.class);

    public static boolean canAssignOrTransferStatus(DynamicObject actInsInfo) {
        log.info("ActivityCommonUtil : canAssignOrTransferStatus {}", actInsInfo.get("taskstatus"));
        return ActivityCommonUtil.canChange(actInsInfo);
    }

    public static boolean canConsentOrTerminateStatus(DynamicObject taskInsInfo) {
        log.info("ActivityCommonUtil : canConsentOrTerminateStatus {}", taskInsInfo.get("taskstatus"));
        return ActivityCommonUtil.canChange(taskInsInfo);
    }

    public static boolean canRejectStatus(DynamicObject taskInsInfo) {
        log.info("ActivityCommonUtil : canRejectStatus {}", taskInsInfo.get("taskstatus"));
        return "20".equals(taskInsInfo.get("taskstatus"));
    }

    private static boolean canChange(DynamicObject taskInsInfo) {
        return "20".equals(taskInsInfo.get("taskstatus")) || "10".equals(taskInsInfo.get("taskstatus"));
    }

    public static boolean activityRecordContainWfId(List<ActivityWfRecord> activityWfRecords, String wfId) {
        ActivityWfRecord activityRecordByWfId = ActivityCommonUtil.getActivityRecordByWfId(activityWfRecords, wfId);
        return null != activityRecordByWfId;
    }

    public static ActivityWfRecord getActivityRecordByWfId(List<ActivityWfRecord> activityWfRecords, String wfId) {
        for (ActivityWfRecord activityWfRecord : activityWfRecords) {
            String activityId = activityWfRecord.getActivityId();
            if (!HRStringUtils.equals((String)activityId, (String)wfId)) continue;
            return activityWfRecord;
        }
        return null;
    }

    public static boolean isWaitSubmit(Map<String, List<ActivityWfRecord>> auditIdData) {
        List<ActivityWfRecord> waitTypeIds = auditIdData.get(WFGroupDecisionTypeEnum.WAIT.getType());
        List<ActivityWfRecord> approveTypeIds = auditIdData.get(WFGroupDecisionTypeEnum.APPROVE.getType());
        return HRCollUtil.isEmpty(waitTypeIds) && HRCollUtil.isEmpty(approveTypeIds);
    }
}

