/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.datarule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.datarule.HRDataRuleServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.datarule.HRDataRuleTreeSearchServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;

public class HRDataRuleTreeServiceHelper {
    private TreeView treeView;
    private static final Log LOGGER = LogFactory.getLog(HRDataRuleTreeServiceHelper.class);

    public HRDataRuleTreeServiceHelper(TreeView treeView) {
        this.treeView = treeView;
    }

    public void reBuildWholeTree() {
        this.treeView.deleteAllNodes();
        TreeNode rootNode = HRDataRuleTreeSearchServiceHelper.buildRootNode();
        this.addCloudNode(rootNode);
        this.treeView.addNode(rootNode);
        this.treeView.focusNode(rootNode);
        this.treeView.treeNodeClick("", rootNode.getId());
    }

    private void addCloudNode(TreeNode rootNode) {
        List<Map<String, String>> bizCloudNodeList = HRDataRuleServiceHelper.getBizCloud();
        String parentId = rootNode.getId();
        this.sortCloudNodes(bizCloudNodeList);
        for (Map<String, String> bizCloudNode : bizCloudNodeList) {
            String id = bizCloudNode.get("id");
            String name = bizCloudNode.get("name");
            TreeNode cloudNode = new TreeNode(parentId, id, name, true);
            rootNode.addChild(cloudNode);
        }
    }

    private void sortCloudNodes(List<Map<String, String>> bizCloudNodeList) {
        final List<String> orderedCloudIds = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        Collections.sort(bizCloudNodeList, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String cloudId1 = o1.get("id").split("_split_")[1];
                String cloudId2 = o2.get("id").split("_split_")[1];
                int index1 = orderedCloudIds.indexOf(cloudId1);
                int index2 = orderedCloudIds.indexOf(cloudId2);
                index1 = index1 == -1 ? Integer.MAX_VALUE : index1;
                index2 = index2 == -1 ? Integer.MAX_VALUE : index2;
                return index1 - index2;
            }
        });
    }

    public void handleExpandNodeClick(String parentId) {
        String nodeIdPrefix = parentId.split("_split_")[0];
        String parentTrueId = this.isRootNode(parentId) ? parentId : parentId.split("_split_")[1];
        QFilter[] qfArr = new QFilter[1];
        DynamicObject[] load = null;
        String localeId = RequestContext.get().getLang().name();
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            load = this.filterLeftCloud(parentTrueId, qfArr);
            this.setCloudTreeNode(parentId, localeId, load);
        } else if (HRStringUtils.equals((String)"2", (String)nodeIdPrefix)) {
            load = this.filterLeftApp(parentTrueId, qfArr);
            this.setAppTreeNode(parentId, load);
        }
    }

    private void setCloudTreeNode(String parentId, String localeid, DynamicObject[] load) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)load.length);
        for (DynamicObject obj : load) {
            String id = "2_split_" + obj.getString("id");
            String name = (String)AppMetadataCache.getAppInfo((String)obj.getString("id")).getName().get((Object)localeid);
            TreeNode appNode = new TreeNode(parentId, id, name, true);
            resultList.add(appNode);
        }
        this.treeView.addNodes((List)resultList);
    }

    private void setAppTreeNode(String parentId, DynamicObject[] load) {
        if (ArrayUtils.isEmpty((Object[])load)) {
            return;
        }
        ArrayList formIdList = Lists.newArrayListWithExpectedSize((int)load.length);
        for (DynamicObject obj : load) {
            String formId = obj.getString("form");
            formIdList.add(formId);
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)load.length);
        Map<String, String> bizObjectMap = HRDataRuleServiceHelper.getBizObjectName(formIdList);
        for (Map.Entry<String, String> bizObjectEntry : bizObjectMap.entrySet()) {
            DynamicObject treeRootDyo = new DynamicObject();
            String id = "3_split_" + bizObjectEntry.getKey();
            String name = bizObjectEntry.getValue();
            TreeNode entityNode = new TreeNode(parentId, id, name, false);
            resultList.add(entityNode);
        }
        LOGGER.info("before sort resultList = {}", (Object)resultList);
        this.sortEntitySeq(parentId.split("_split_")[1], resultList);
        LOGGER.info("after sort resultList = {}", (Object)resultList);
        this.treeView.addNodes((List)resultList);
    }

    private void sortEntitySeq(String appId, List<TreeNode> nodeList) {
        Map<String, Integer> permTreeSeq = EntityCtrlServiceHelper.getPermTreeSeq(appId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter qFilter = new QFilter("bizappid", "=", (Object)appId).and("istemplate", "=", (Object)false);
        DynamicObject[] entityInfos = serviceHelper.query("number,dentityid", new QFilter[]{qFilter});
        Map<String, String> entityMap = Arrays.stream(entityInfos).collect(Collectors.toMap(it -> it.getString("dentityid"), it -> it.getString("number")));
        LOGGER.info("permTreeSeq is {}", permTreeSeq);
        LOGGER.info("entityMap is {}" + entityMap);
        if (permTreeSeq != null) {
            nodeList.sort((o1, o2) -> {
                String id1 = o1.getId();
                String id2 = o2.getId();
                Integer index1 = (Integer)permTreeSeq.get(entityMap.get(id1.split("_split_")[1]));
                Integer index2 = (Integer)permTreeSeq.get(entityMap.get(id2.split("_split_")[1]));
                if (null == index1) {
                    index1 = Integer.MAX_VALUE;
                }
                if (null == index2) {
                    index2 = Integer.MAX_VALUE;
                }
                return index1.compareTo(index2);
            });
        } else {
            Collator cltr = Collator.getInstance(RequestContext.get().getLang().getLocale());
            nodeList.sort((o1, o2) -> cltr.compare(o1.getText(), o2.getText()));
        }
    }

    private DynamicObject[] filterLeftCloud(String parentTrueId, QFilter[] qfArr) {
        List<String> ids = HRDataRuleServiceHelper.findBizappExistsEntity(parentTrueId);
        qfArr[0] = new QFilter("id", "in", ids);
        qfArr = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])qfArr, (String)"id");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"", (QFilter[])qfArr, (String)"sequence");
        return load;
    }

    private DynamicObject[] filterLeftApp(String parentTrueId, QFilter[] qfArr) {
        List<String> allExtAppId = HRDataRuleServiceHelper.getAllExtAppId(parentTrueId);
        allExtAppId.add(parentTrueId);
        qfArr[0] = new QFilter("bizapp", "in", allExtAppId);
        qfArr = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])qfArr, (String)"form");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])qfArr);
        int loadSize = load.length;
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)loadSize);
        for (DynamicObject dynamicObject : load) {
            idSet.add(dynamicObject.get("form"));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("dentityid", "in", (Object)idSet)};
        DynamicObject[] entityArr = BusinessDataServiceHelper.load((String)"bos_entityinfo", (String)"id,modeltype,dentityid", (QFilter[])qFilters);
        int entitysSize = entityArr.length;
        idSet = Sets.newHashSetWithExpectedSize((int)entitysSize);
        for (DynamicObject dynamicObject : entityArr) {
            idSet.add(dynamicObject.get("dentityid"));
        }
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)loadSize);
        for (DynamicObject dynamicObject : load) {
            if (!idSet.contains(dynamicObject.get("form"))) continue;
            arrayList.add(dynamicObject);
        }
        load = new DynamicObject[arrayList.size()];
        int index = 0;
        for (DynamicObject dynamicObject : arrayList) {
            load[index++] = dynamicObject;
        }
        return load;
    }

    private boolean isRootNode(String nodeId) {
        return HRStringUtils.equals((String)nodeId, (String)"1010");
    }
}

