/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.label;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hrcs.common.constants.label.LabelManageConstants;
import org.apache.commons.lang.time.DateFormatUtils;

@ExcludeFromJacocoGeneratedReport
public class LabelPolicyServiceHelper
implements LabelManageConstants {
    private static final String POLICY_TASK_ENTRY = "hrcs_labelpolicytask";
    private static final String POLICY_ENTRY = "hrcs_lblstrategy";
    private static final String LABEL_POLICY_RULE = "hrcs_labelpolicyrule";
    private static final String PARAM_ENTRY = "hrcs_labelparam";
    private static final String LABEL_JOIN_ENTITY = "hrcs_lbljoinentity";
    private static final String ENTITY_RELATION_ENTITY = "hrcs_lblentityrelation";
    private final long currUserId = RequestContext.get().getCurrUserId();
    private static final HRBaseServiceHelper policyTaskServiceHelper = new HRBaseServiceHelper("hrcs_labelpolicytask");
    private static final HRBaseServiceHelper policyServiceHelper = new HRBaseServiceHelper("hrcs_lblstrategy");
    private static final HRBaseServiceHelper policyRuleServiceHelper = new HRBaseServiceHelper("hrcs_labelpolicyrule");
    private static final HRBaseServiceHelper paramServiceHelper = new HRBaseServiceHelper("hrcs_labelparam");
    private static final HRBaseServiceHelper labelJoinServiceHelper = new HRBaseServiceHelper("hrcs_lbljoinentity");
    private static final HRBaseServiceHelper entityRelationServiceHelper = new HRBaseServiceHelper("hrcs_lblentityrelation");

    public static String getViewTaskNumber(Long policyId) {
        List<String> statusList = Arrays.asList("1", "2", "3");
        QFilter statusFilter = new QFilter("taskstatus", "in", statusList);
        QFilter policyFilter = new QFilter("labelpolicy", "=", (Object)policyId);
        DynamicObject dynamicObject = policyTaskServiceHelper.queryOne("number", new QFilter[]{statusFilter, policyFilter}, "modifytime desc");
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("number");
    }

    @ExcludeFromJacocoGeneratedReport
    public void savePolicyTask(DynamicObjectCollection dynamicObjectCollection) {
        policyTaskServiceHelper.save(dynamicObjectCollection);
    }

    public String savePolicyTask(long policyId, int priority) {
        QFilter statusFilter;
        QFilter policyIdFilter = new QFilter("labelpolicy", "=", (Object)policyId);
        DynamicObject[] existPolicyTaskArr = policyTaskServiceHelper.query("modifier,modifytime,taskstatus", new QFilter[]{policyIdFilter, statusFilter = new QFilter("taskstatus", "=", (Object)"0")});
        if (existPolicyTaskArr != null && existPolicyTaskArr.length > 0) {
            for (DynamicObject task : existPolicyTaskArr) {
                task.set("taskstatus", (Object)"4");
                task.set("modifier", (Object)this.currUserId);
                task.set("modifytime", (Object)new Date());
            }
            policyTaskServiceHelper.save(existPolicyTaskArr);
        }
        DynamicObject dynamicObject = this.geneEmptyPolicyTaskDy();
        String taskNumber = LabelPolicyServiceHelper.geneTaskNumber();
        dynamicObject.set("number", (Object)taskNumber);
        dynamicObject.set("labelpolicy", (Object)policyId);
        dynamicObject.set("creator", (Object)this.currUserId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifier", (Object)this.currUserId);
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("priority", (Object)priority);
        dynamicObject.set("taskstatus", (Object)"0");
        policyTaskServiceHelper.saveOne(dynamicObject);
        return taskNumber;
    }

    public static void updatePolicyTask(long policyId, String taskNumber, String status, String desc) {
        QFilter qFilter = new QFilter("labelpolicy", "=", (Object)policyId);
        QFilter taskNumberFilter = new QFilter("number", "=", (Object)taskNumber);
        DynamicObject dynamicObject = policyTaskServiceHelper.queryOne("labelpolicy,creator,createtime,modifier,modifytime,taskstatus,taskmessage", new QFilter[]{qFilter, taskNumberFilter});
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set("labelpolicy", (Object)policyId);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("taskstatus", (Object)status);
        dynamicObject.set("taskmessage", (Object)desc);
        policyTaskServiceHelper.saveOne(dynamicObject);
    }

    public static void addPolicyTaskQuantity(long policyId, String taskNumber, int processedDelta, int matchedDelta) {
        QFilter qFilter = new QFilter("labelpolicy", "=", (Object)policyId);
        QFilter taskNumberFilter = new QFilter("number", "=", (Object)taskNumber);
        DynamicObject dynamicObject = policyTaskServiceHelper.queryOne("id,labelpolicy,taskstatus,modifier,modifytime,processedquantity,matchedquantity", new QFilter[]{qFilter, taskNumberFilter});
        if (dynamicObject == null) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
        Object[] params = new Object[]{processedDelta, matchedDelta, RequestContext.get().getCurrUserId(), new Date(), dynamicObject.get("id")};
        paramList.add(params);
        String updateSql = "update t_hrcs_labelpolicytask set fprocessedquantity = fprocessedquantity + ? , fmatchedquantity = fmatchedquantity + ?, fmodifierid = ?, fmodifytime = ? where fid = ?";
        HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hmp"), (String)updateSql, paramList);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void updatePolicyTaskTotalQuantity(long policyId, String taskNumber, int totalQuantity) {
        QFilter qFilter = new QFilter("labelpolicy", "=", (Object)policyId);
        QFilter taskNumberFilter = new QFilter("number", "=", (Object)taskNumber);
        DynamicObject dynamicObject = policyTaskServiceHelper.queryOne("id,labelpolicy,modifier,modifytime,taskstatus,totalquantity", new QFilter[]{qFilter, taskNumberFilter});
        if (dynamicObject == null) {
            return;
        }
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("totalquantity", (Object)totalQuantity);
        policyTaskServiceHelper.updateOne(dynamicObject);
    }

    public static String geneTaskNumber() {
        SecureRandom random = new SecureRandom();
        Date nowDate = new Date();
        String dateNumber = DateFormatUtils.format((Date)nowDate, (String)"yyyyMMddHHmmssmmm");
        StringBuilder randomStr = new StringBuilder();
        randomStr.append(dateNumber);
        for (int i = 0; i < 4; ++i) {
            int num = random.nextInt(9);
            randomStr.append(num);
        }
        return randomStr.toString();
    }

    public DynamicObject[] listPolicy(QFilter[] qFilters) {
        return policyServiceHelper.loadDynamicObjectArray(qFilters);
    }

    public void updatePolicy(DynamicObject[] policyArr) {
        policyServiceHelper.save(policyArr);
    }

    public DynamicObject getPolicy(long policyId) {
        return policyServiceHelper.loadSingle((Object)policyId);
    }

    public DynamicObject geneEmptyPolicyTaskDy() {
        return policyTaskServiceHelper.generateEmptyDynamicObject();
    }

    public DynamicObject[] listUndoPolicyTaskByPolicyId(long policyId) {
        QFilter statusFilter = new QFilter("taskstatus", "=", (Object)"0");
        QFilter policyIdFilter = new QFilter("labelpolicy", "=", (Object)policyId);
        QFilter[] filters = new QFilter[]{statusFilter, policyIdFilter};
        return policyTaskServiceHelper.query("labelpolicy.id,labelpolicy.labelobject,labelpolicy.filter", filters);
    }

    public DynamicObject[] listPolicyTask() {
        QFilter qFilter = new QFilter("taskstatus", "=", (Object)"0");
        QFilter[] filters = new QFilter[]{qFilter};
        return policyTaskServiceHelper.query("number,labelpolicy.id,labelpolicy.labelobject,labelpolicy.filter", filters, "priority desc,createtime asc");
    }

    public static DynamicObject[] listNeedClearEsPolicyTask(QFilter[] filters) {
        return policyTaskServiceHelper.query("id,number,esstatus", filters);
    }

    public static void updateEsStatusPolicyTask(DynamicObject dynamicObject) {
        dynamicObject.set("esstatus", (Object)1);
        policyTaskServiceHelper.saveOne(dynamicObject);
    }

    public static DynamicObject getPolicyDy(Long policyId) {
        return policyServiceHelper.loadDynamicObject(new QFilter("id", "=", (Object)policyId));
    }

    public static String getPolicyFilter(Long policyId) {
        DynamicObject policyRule = policyRuleServiceHelper.queryOne("conditions", new QFilter("labelpolicy", "=", (Object)policyId));
        if (policyRule == null) {
            return "";
        }
        return policyRule.getString("conditions");
    }

    public static DynamicObject getPolicyDyByObjectId(Long objectId) {
        return policyServiceHelper.loadDynamicObject(new QFilter("labelobject", "=", (Object)objectId));
    }

    public static DynamicObject[] listParamByPolicyId(long policyId) {
        DynamicObject policy = policyServiceHelper.loadSingle((Object)policyId);
        if (policy == null) {
            return new DynamicObject[0];
        }
        QFilter labelFilter = new QFilter("label", "=", (Object)policy.getLong("label.id"));
        QFilter objectFilter = new QFilter("labelobject", "=", (Object)policy.getLong("labelobject.id"));
        return paramServiceHelper.query("param.fieldpath,param.fieldalias,param.valuetype", new QFilter[]{labelFilter, objectFilter});
    }

    public static DynamicObject getEntryByObjectId(Long objectId) {
        QFilter objectFilter = new QFilter("labelobject", "=", (Object)objectId);
        QFilter typeFilter = new QFilter("type", "=", (Object)"main");
        return labelJoinServiceHelper.queryOriginalOne("entitynumber,entityalias", new QFilter[]{objectFilter, typeFilter});
    }

    public static DynamicObject[] getEntityRelation(Long objectId) {
        return entityRelationServiceHelper.query("id,entityid,entityid.entitynumber,entityid.entityalias,jointype,joinentityid,joinentityid,joinentityid.entitynumber,joinentityid.entityalias,joinentityid.type,joinconditions,joinconditions.leftprop,joinconditions.comparetype,joinconditions.rightprop,joinconditions.rightproptype,joinconditions.rightpropval,joinconditions.logictype", new QFilter[]{new QFilter("labelobject.id", "=", (Object)objectId)});
    }

    @ExcludeFromJacocoGeneratedReport
    public long getObjectIdByPolicyId(long policyId) {
        DynamicObject dynamicObject = policyServiceHelper.loadSingle((Object)policyId);
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("labelobject.id");
    }

    @ExcludeFromJacocoGeneratedReport
    public Long getLabelByPolicyId(long policyId) {
        DynamicObject dynamicObject = policyServiceHelper.loadSingle((Object)policyId);
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("label.id");
    }

    public static DynamicObject getParentByObjectId(Long objectId) {
        QFilter objectFilter = new QFilter("labelobject", "=", (Object)objectId);
        QFilter typeFilter = new QFilter("type", "=", (Object)"main");
        QFilter isMainFilter = new QFilter("ismainbo", "=", (Object)"1");
        return labelJoinServiceHelper.queryOriginalOne("id,entitynumber,entityalias", new QFilter[]{objectFilter, typeFilter, isMainFilter});
    }

    public static DynamicObject[] getPolicyDyns(Long labelObjectId, Long labelId) {
        LabelPolicyServiceHelper labelPolicyServiceHelper = new LabelPolicyServiceHelper();
        QFilter labelObject = new QFilter("labelobject.id", "=", (Object)labelObjectId);
        QFilter label = new QFilter("label.id", "=", (Object)labelId);
        QFilter[] qFilters = new QFilter[]{labelObject, label};
        return labelPolicyServiceHelper.listPolicy(qFilters);
    }

    public static DynamicObject[] getMainEntityRelation(Long objectId, String mainEntity) {
        return entityRelationServiceHelper.query("id,entityid,entityid.entitynumber,entityid.entityalias,jointype,joinentityid,joinentityid,joinentityid.entitynumber,joinentityid.entityalias,joinconditions,joinconditions.leftprop,joinconditions.comparetype,joinconditions.rightprop,joinconditions.rightproptype,joinconditions.rightpropval,joinconditions.logictype", new QFilter[]{new QFilter("labelobject.id", "=", (Object)objectId), new QFilter("entityid.entitynumber", "=", (Object)mainEntity)});
    }

    public static void deleteTaskByPolicyId(List<Long> strategyIdList) {
        policyTaskServiceHelper.deleteByFilter(new QFilter[]{new QFilter("labelpolicy", "in", strategyIdList)});
    }
}

