/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleEntryModel;

@ExcludeFromJacocoGeneratedReport
public class HRPermDataRuleServiceHelper {
    private static final Log LOG = LogFactory.getLog(HRPermDataRuleServiceHelper.class);
    public static final String CHECKALL = "checkall";

    public static List<Map<String, String>> buildControlItem(IFormView view, String entitytype, String selectAppId) {
        List<Map<String, String>> permItemList = HRPermDataRuleServiceHelper.getPermItemMapInfoList(view, entitytype, selectAppId, Boolean.TRUE);
        LinkedHashMap tempMap = Maps.newLinkedHashMap();
        tempMap.put("id", CHECKALL);
        tempMap.put("key", CHECKALL);
        tempMap.put("name", ResManager.loadKDString((String)"\u5168\u9009", (String)"HRDataRuleBatchSetting_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        permItemList.add(0, tempMap);
        return permItemList;
    }

    public static List<Map<String, String>> getPermItemMapInfoList(IFormView formView, String entitytype, String selectAppId, Boolean allFlag) {
        ArrayList permItems = Lists.newArrayListWithCapacity((int)16);
        String mainPageId = (String)formView.getFormShowParameter().getCustomParam("mainPageId");
        IFormView view = formView.getView(mainPageId);
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(view, false);
        List<String> permItemList = HRPermDataRuleServiceHelper.getPermItemList(entitytype, permPageCacheUtil, formView, selectAppId, allFlag);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_permitem");
        DynamicObjectCollection id = helper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("id", "in", permItemList)});
        id.forEach(permItem -> {
            HashMap permItemMap = Maps.newHashMapWithExpectedSize((int)16);
            permItemMap.put("id", permItem.getString("id"));
            permItemMap.put("key", permItem.getString("id").toLowerCase(Locale.ROOT));
            permItemMap.put("name", permItem.getString("name"));
            permItems.add(permItemMap);
        });
        return permItems;
    }

    public static List<String> getPermItemList(String entityNum, PermPageCacheUtil permPageCacheUtil, IFormView formView, String selectAppId, Boolean allFlag) {
        List<Map<String, String>> funcPermDataList = permPageCacheUtil.getFuncPermDataList();
        String currentHRbuFunc = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        Map<String, RoleDataPermModel> permDataMap = permPageCacheUtil.getDataPermMap();
        RoleDataPermModel roleDataPermModel = permDataMap.get(currentHRbuFunc);
        ArrayList businessDataRule = Lists.newArrayListWithExpectedSize((int)16);
        Map peritemCollect = funcPermDataList.stream().collect(Collectors.groupingBy(funcPermData -> (String)funcPermData.get("appId") + "#" + (String)funcPermData.get("entityNumber"), Collectors.mapping(dy -> (String)dy.get("permItemId"), Collectors.toList())));
        List<String> allocatedPeritem = peritemCollect.get(selectAppId + "#" + entityNum);
        if (CollectionUtils.isEmpty(allocatedPeritem)) {
            return allocatedPeritem;
        }
        funcPermDataList.forEach(funcPermData -> {
            String entityNumber = (String)funcPermData.get("entityNumber");
            String appId = (String)funcPermData.get("appId");
            roleDataPermModel.getAppEntity2DataRules().forEach((roleDataRuleKey, roleDataRuleValue) -> roleDataRuleValue.getDataRuleMap().forEach((roleDataRuleEntryKey, roleDataRuleEntryModel) -> {
                if (HRPermDataRuleServiceHelper.isSelected(entityNum, selectAppId, entityNumber, appId, roleDataRuleKey, roleDataRuleEntryModel)) {
                    businessDataRule.addAll(roleDataRuleEntryModel.getPermItem());
                }
            }));
        });
        if (!allFlag.booleanValue()) {
            allocatedPeritem.removeAll(businessDataRule);
        }
        allocatedPeritem.remove("4730fc9f000003ae");
        allocatedPeritem.remove("4730fc9f000004ae");
        return allocatedPeritem;
    }

    public static boolean isSelected(String entityNum, String selectAppId, String entityNumber, String appId, String roleDataRuleEntryKey, RoleDataRuleEntryModel roleDataRuleEntryModel) {
        String[] split = roleDataRuleEntryKey.split("#");
        return HRStringUtils.equals((String)entityNum, (String)roleDataRuleEntryModel.getBusinessObject()) && HRStringUtils.equals((String)appId, (String)selectAppId) && HRStringUtils.equals((String)entityNum, (String)entityNumber) && HRStringUtils.equals((String)appId, (String)split[0]);
    }
}

