/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;

public class HrbuCaControlHelper {
    public static final String HBSS_APPBUSINESSTYPE = "hbss_appbusinesstype";
    private static final Log LOGGER = LogFactory.getLog(HrbuCaControlHelper.class);

    public static void getBusinessFunction(String roleId, IFormView view, boolean loadFromDb) {
        Set<String> appIds = HrbuCaControlHelper.getAppId(roleId);
        List<Map<String, String>> businessList = HrbuCaControlHelper.getHRBuCaFuncList(appIds);
        if (CollectionUtils.isEmpty(businessList)) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        if (HRStringUtils.isNotEmpty((String)roleId) && loadFromDb) {
            HashMap assignedBuMap = Maps.newHashMapWithExpectedSize((int)16);
            HRBaseServiceHelper hrRoleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
            HrbuCaControlHelper.queryBuAssignedForRole(roleId, hrRoleBuHelper, assignedBuMap);
            HashMap pageBuCacheMap = Maps.newHashMapWithExpectedSize((int)16);
            assignedBuMap.forEach((key, value) -> pageBuCacheMap.put(key, SerializationUtils.toJsonString((Object)value)));
            if (!CollectionUtils.isEmpty((Map)pageBuCacheMap)) {
                pageCache.put((Map)pageBuCacheMap);
            }
        }
        LOGGER.info("createBusinessFunction businessList {}", businessList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryBuAssignedForRole(Object roleId, HRBaseServiceHelper hrRoleBuHelper, Map<String, List<Map<String, Object>>> buMutiMap) {
        DataSet hrbus = null;
        QFilter[] filters = new QFilter[]{new QFilter("role", "=", roleId)};
        try {
            hrbus = hrRoleBuHelper.queryDataSet("hr.hbss.createBusinessFunction.rolebu", "id,org,containssub,hrbucafunc", filters);
            while (hrbus.hasNext()) {
                Row row = hrbus.next();
                String buKey = row.getString("hrbucafunc") + "@" + row.getString("hrbucafunc");
                HashMap<String, Object> buMap = new HashMap<String, Object>(3);
                buMap.put("org", row.getString("org"));
                buMap.put("containssub", row.get("containssub"));
                buMap.put("hrbuca", buKey);
                buMutiMap.computeIfAbsent(buKey, key -> new ArrayList(16)).add(buMap);
            }
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{hrbus});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{hrbus});
    }

    public static Set<String> getAppId(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_roleperm");
        QFilter[] filters = new QFilter[]{new QFilter("roleid", "=", (Object)roleId)};
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObject rolePerm = helper.queryOne("roleperm.bizapp", filters);
        if (rolePerm == null) {
            return Sets.newHashSet();
        }
        DynamicObjectCollection rolePermDetailColl = rolePerm.getDynamicObjectCollection("roleperm");
        for (DynamicObject detail : rolePermDetailColl) {
            String appId = detail.getString("bizapp.id");
            appIdSet.add(appId);
        }
        return appIdSet;
    }

    public static List<Map<String, String>> getHRBuCaFuncList(Set<String> appIds) {
        Map<String, Map<String, Object>> hrBuCaFunc = HrbuCaControlHelper.getHRBuCaFuncByAppId(appIds);
        ArrayList<Map<String, String>> businessList = new ArrayList<Map<String, String>>(16);
        hrBuCaFunc.entrySet().forEach(appBusinessType -> {
            Map value = (Map)appBusinessType.getValue();
            HashMap businessMap = Maps.newHashMapWithExpectedSize((int)3);
            businessMap.put("buCaFuncId", (String)value.get("buCaFuncId"));
            businessMap.put("name", (String)value.get("name"));
            Set appSet = (Set)value.get("appId");
            if (!CollectionUtils.isEmpty((Collection)appSet)) {
                String appId = (String)appSet.stream().findFirst().get();
                if (HRStringUtils.isEmpty((String)appId)) {
                    return;
                }
                businessMap.put("appId", appId);
            }
            businessList.add(businessMap);
        });
        return businessList;
    }

    public static Map<String, Map<String, Object>> getHRBuCaFuncByAppId(Set<String> appIds) {
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)3);
        filterList.add(new QFilter("enable", "=", (Object)"1"));
        filterList.add(new QFilter("status", "=", (Object)"C"));
        if (!CollectionUtils.isEmpty(appIds)) {
            filterList.add(new QFilter("app", "in", appIds));
        }
        HRBaseServiceHelper buFuncHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(HBSS_APPBUSINESSTYPE);
        HashMap<String, Map<String, Object>> hrBuCaFuncMap = new HashMap<String, Map<String, Object>>(16);
        try (DataSet allHrBuFuncs = buFuncHelper.queryDataSet("algoKey_hbss_hrbucafunc", "id hrBuCaFuncId,name,description", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("id", "!=", (Object)618)});
             DataSet HrBuFuncsWithApp = helper.queryDataSet("algoKey_hbss_appbusinesstype", "app.id appId,businesstype.controlfuntype.id controlfuntypeId", filterList.toArray(new QFilter[0]));){
            DataSet finalDataSet = allHrBuFuncs.leftJoin(HrBuFuncsWithApp).on("hrBuCaFuncId", "controlfuntypeId").select(new String[]{"hrBuCaFuncId", "name", "description"}, new String[]{"appId"}).finish();
            while (finalDataSet.hasNext()) {
                String appId;
                Row row = finalDataSet.next();
                String buCaFuncId = row.getString("hrBuCaFuncId");
                Set<String> appSet = Sets.newHashSetWithExpectedSize((int)16);
                Map businessMap = (Map)hrBuCaFuncMap.get(buCaFuncId);
                if (businessMap == null) {
                    businessMap = Maps.newHashMapWithExpectedSize((int)3);
                    businessMap.put("buCaFuncId", buCaFuncId);
                    businessMap.put("name", row.getString("name"));
                    businessMap.put("description", row.getString("description"));
                    businessMap.put("appId", appSet);
                    hrBuCaFuncMap.put(buCaFuncId, businessMap);
                } else {
                    appSet = (Set)businessMap.get("appId");
                }
                if (HRStringUtils.isEmpty((String)(appId = row.getString("appId")))) continue;
                appSet.add(row.getString("appId"));
            }
        }
        return hrBuCaFuncMap;
    }

    public static Map<String, Map<String, Object>> getHRBuCaFuncMapByAppId(Set<String> appIds) {
        return HrbuCaControlHelper.getHRBuCaFuncByAppId(appIds);
    }

    public static Map<String, Map<String, Object>> getAllHRBuCaFuncMap() {
        Map<String, Map<String, Object>> hrBuCaFuncMapWithApp = HrbuCaControlHelper.getHRBuCaFuncMapByAppId(null);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject deployBus = helper.queryOriginalOne("number", (Object)618L);
        String[] deployBuIdArr = deployBus.getString("number").split(",");
        DynamicObject[] buFuncArr = helper.query("id,name,description", new QFilter[]{new QFilter("number", "in", (Object)deployBuIdArr)});
        HashMap<String, Map<String, Object>> allHRBuCaFuncMap = new HashMap<String, Map<String, Object>>();
        for (DynamicObject buFunc : buFuncArr) {
            String buCaFuncId = buFunc.getString("id");
            Map<String, Object> buCaFunc = hrBuCaFuncMapWithApp.get(buCaFuncId);
            if (buCaFunc == null) {
                HashMap<String, String> temp = new HashMap<String, String>(1);
                temp.put("name", buFunc.getString("name"));
                temp.put("description", buFunc.getString("description"));
                allHRBuCaFuncMap.put(buCaFuncId, temp);
                continue;
            }
            allHRBuCaFuncMap.put(buCaFuncId, buCaFunc);
        }
        return allHRBuCaFuncMap;
    }

    public static Map<String, Map<String, Object>> getAllHRBuCaFuncMapForPerm() {
        return HrbuCaControlHelper.getHRBuCaFuncMapByAppId(null);
    }

    public static Map<String, HashSet<String>> querySpecEntityApp(Set<String> entitySet) {
        DynamicObject[] objects;
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter filter = new QFilter("id", "in", entitySet);
        Map<String, HashSet<String>> entityApp = entityHelper.queryOriginalCollection("id,bizappid", new QFilter[]{filter}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Sets.newHashSet((Object[])new String[]{it.getString("bizappid")})));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_bizobjapp");
        for (DynamicObject object : objects = serviceHelper.query("bizobj,bizapp", new QFilter[]{new QFilter("bizobj", "in", entitySet)})) {
            String bizApp = object.getString("bizapp.id");
            String entityId = object.getString("bizobj.id");
            if (!HRStringUtils.isNotEmpty((String)bizApp) || !HRStringUtils.isNotEmpty((String)entityId)) continue;
            Set apps = entityApp.computeIfAbsent(entityId, k -> new HashSet(16));
            apps.add(bizApp);
        }
        return entityApp;
    }

    public static Map<String, List<Long>> queryAppSelfBuCa() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(HBSS_APPBUSINESSTYPE);
        DynamicObjectCollection coll = helper.queryOriginalCollection("app,businesstype.controlfuntype", new QFilter[0]);
        Set<String> hrApps = EntityCtrlServiceHelper.getHRApps(false);
        Map<String, List<Long>> appSelfBuMap = coll.stream().collect(Collectors.toMap(it -> it.getString("app"), it -> Lists.newArrayList((Object[])new Long[]{it.getLong("businesstype.controlfuntype")}), (newVal, oldVal) -> newVal));
        for (String app : hrApps) {
            appSelfBuMap.computeIfAbsent(app, key -> Lists.newArrayList((Object[])new Long[]{11L}));
        }
        return appSelfBuMap;
    }
}

