/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class PermCommonTreeSupplier {
    private static final Log LOG = LogFactory.getLog(PermCommonTreeSupplier.class);

    private PermCommonTreeSupplier() {
    }

    public static PermCommonTreeSupplier getInstance() {
        return PermCommonTreeSupplierHandler.INSTANCE;
    }

    private Map<String, String> getNodeValue4BosOrg(DynamicObject dynamicObject) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)8);
        result.put("id", dynamicObject.getString("org.id"));
        result.put("name", dynamicObject.getString("org.name"));
        result.put("number", dynamicObject.getString("org.number"));
        result.put("parent", dynamicObject.getString("parent.id"));
        result.put("structlongnumber", dynamicObject.getString("structlongnumber"));
        result.put("disable", null == dynamicObject.getDynamicObjectType().getProperties().get((Object)"disabled") ? "0" : dynamicObject.getString("disabled"));
        return result;
    }

    private Map<String, String> getNodeValue4OrgTeam(DynamicObject dynamicObject) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)8);
        result.put("id", dynamicObject.getString("orgteam.id"));
        result.put("number", dynamicObject.getString("orgteam.number"));
        result.put("name", dynamicObject.getString("orgteam.name"));
        result.put("parent", dynamicObject.getString("parentorgteam.id"));
        result.put("structlongnumber", dynamicObject.getString("structlongnumber"));
        return result;
    }

    public Map<String, String> getNodeValue4Common(DynamicObject dynamicObject) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)8);
        result.put("id", dynamicObject.getString("id"));
        result.put("name", dynamicObject.getString("name"));
        result.put("number", dynamicObject.getString("number"));
        result.put("parent", dynamicObject.getString("parent.id"));
        result.put("structlongnumber", dynamicObject.getString("structlongnumber"));
        return result;
    }

    private void getFilter4BosOrg(List<QFilter> baseFilter, IFormView formView) {
        QFilter paramFilter = (QFilter)formView.getFormShowParameter().getCustomParam("filter");
        if (Objects.nonNull(paramFilter)) {
            baseFilter.add(paramFilter);
            LOG.info("getFilter4BosOrg() paramFilter:{}", (Object)paramFilter);
        }
        String hrBuCaFuncId = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter viewFilter = new QFilter("view.id", "=", (Object)Long.valueOf(hrBuCaFuncId));
        QFilter viewDefaultFilter = new QFilter("view.isdefault", "=", (Object)"1");
        baseFilter.addAll(Arrays.asList(statusFilter, viewFilter, viewDefaultFilter));
    }

    private void getFilter4OrgTeam(List<QFilter> baseFilter, IFormView formView) {
        QFilter paramFilter = (QFilter)formView.getFormShowParameter().getCustomParam("filter");
        if (Objects.nonNull(paramFilter)) {
            baseFilter.add(paramFilter);
            LOG.info("getFilter4OrgTeam() paramFilter:{}", (Object)paramFilter);
        }
        QFilter orgTeamEnableFilter = new QFilter("orgteam.enable", "=", (Object)"1");
        QFilter orgTeamStatusFilter = new QFilter("orgteam.status", "=", (Object)"C");
        baseFilter.add(orgTeamEnableFilter);
        baseFilter.add(orgTeamStatusFilter);
        this.addHisFilter("haos_adminorgstructure", baseFilter);
    }

    public void getFilter4Common(List<QFilter> baseFilter, IFormView formView) {
        QFilter paramFilter = (QFilter)formView.getFormShowParameter().getCustomParam("filter");
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        if (Objects.nonNull(paramFilter)) {
            baseFilter.add(paramFilter);
            LOG.info("getFilter4Common() paramFilter:{}", (Object)paramFilter);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        baseFilter.addAll(Arrays.asList(enableFilter, statusFilter));
        this.addHisFilter(entityNumber, baseFilter);
    }

    public void addHisFilter(String entityNumber, List<QFilter> baseFilter) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = entityType.getAllFields();
        if (allFields.containsKey("iscurrentversion")) {
            baseFilter.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
    }

    private DynamicObject[] getBosOrgs(IFormView formView, String searchText) {
        long level;
        List<QFilter> baseFilter = this.getFilter(formView);
        LOG.info("permF7_getBosOrgs() baseFilter:{}", (Object)baseFilter.toString());
        if (!HRStringUtils.isEmpty((String)searchText)) {
            baseFilter.add(new QFilter("org.name", "like", (Object)("%" + searchText + "%")));
        }
        QFilter paramFilter = (QFilter)formView.getFormShowParameter().getCustomParam("filter");
        boolean skipPermissionControl = HRStringUtils.equals((String)"1", (String)((String)formView.getFormShowParameter().getCustomParam("skipPermissionControl")));
        if (!(null != paramFilter || skipPermissionControl || -1L != (level = HRPermServiceHelper.getUserGroupMinLevel()) && level <= 2L)) {
            long currentHRbuCaFunc = Long.parseLong((String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc"));
            List<Long> orgIds = HRPermServiceHelper.getAdminGroupFunc(currentHRbuCaFunc);
            if (orgIds.isEmpty()) {
                return new DynamicObject[0];
            }
            baseFilter.add(new QFilter("org.id", "in", orgIds));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
        Object[] orgs = helper.queryOriginalArray("id,org.id,org.number,org.name,parent.id,longnumber structlongnumber", HRPermCommonUtil.listToQFilters(baseFilter));
        LOG.info("permF7_getBosOrgs() selfInfos length:{}", (Object)orgs.length);
        if (ObjectUtils.isEmpty((Object[])orgs)) {
            return orgs;
        }
        Set<String> longNumbers = Arrays.stream(orgs).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
        Set<String> parentNumbers = PermCommonTreeSupplier.getParentNumbers(longNumbers);
        LOG.info("permF7_getBosOrgs() longNumbers:{},parentNumbers:{}", longNumbers, parentNumbers);
        String hrBuCaFuncId = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        QFilter viewFilter = new QFilter("view.id", "=", (Object)Long.valueOf(hrBuCaFuncId));
        QFilter[] parentQFilters = new QFilter[]{viewFilter, new QFilter("org.number", "in", parentNumbers)};
        DynamicObject[] parents = helper.queryOriginalArray("id,org.id,org.number,org.name,parent.id,longnumber structlongnumber, '1' AS disabled", parentQFilters);
        LOG.info("permF7_getBosOrgs() parentInfo length:{}", (Object)parents.length);
        return this.mergeAndDistinct((DynamicObject[])orgs, parents, "structlongnumber");
    }

    public DynamicObject[] getDataInfoCommon(IFormView formView, String searchText) {
        List<QFilter> baseFilter = this.getFilter(formView);
        LOG.info("permF7_getDataInfoCommon() baseFilter:{}", (Object)baseFilter.toString());
        if (!HRStringUtils.isEmpty((String)searchText)) {
            baseFilter.add(new QFilter("name", "like", (Object)("%" + searchText + "%")));
        }
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        Object[] infos = helper.queryOriginalArray("id,number,name,parent.id,longnumber structlongnumber", HRPermCommonUtil.listToQFilters(baseFilter));
        LOG.info("permF7_getDataInfoCommon() selfInfos length:{}", (Object)infos.length);
        if (ObjectUtils.isEmpty((Object[])infos) || HRStringUtils.isEmpty((String)searchText)) {
            return infos;
        }
        baseFilter.removeIf(filter -> "name".equals(filter.getProperty()));
        Set<String> longNumbers = Arrays.stream(infos).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
        Set<String> parentNumbers = PermCommonTreeSupplier.getParentNumbers(longNumbers, "\\.");
        LOG.info("permF7_getDataInfoCommon() longNumbers:{},parentNumbers:{}", longNumbers, parentNumbers);
        baseFilter.add(new QFilter("number", "in", parentNumbers));
        DynamicObject[] parents = helper.queryOriginalArray("id,number,name,parent.id,longnumber structlongnumber", HRPermCommonUtil.listToQFilters(baseFilter));
        LOG.info("permF7_getDataInfoCommon() parentInfo length:{}", (Object)parents.length);
        return this.mergeAndDistinct((DynamicObject[])infos, parents, "structlongnumber");
    }

    private DynamicObject[] getOrgTeams(IFormView formView, String searchText) {
        List<QFilter> baseFilter = this.getFilter(formView);
        LOG.info("permF7_getOrgTeams() baseFilter:{}", (Object)baseFilter.toString());
        if (!HRStringUtils.isEmpty((String)searchText)) {
            baseFilter.add(new QFilter("orgteam.name", "like", (Object)("%" + searchText + "%")));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgstructure");
        Object[] infos = helper.queryOriginalArray("orgteam.id,orgteam.number,orgteam.name,parent.id,structlongnumber", HRPermCommonUtil.listToQFilters(baseFilter));
        LOG.info("permF7_getOrgTeams() selfInfos length:{}", (Object)infos.length);
        if (ObjectUtils.isEmpty((Object[])infos) || HRStringUtils.isEmpty((String)searchText)) {
            return infos;
        }
        baseFilter.removeIf(filter -> "orgteam.name".equals(filter.getProperty()));
        Set<String> longNumbers = Arrays.stream(infos).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
        Set<String> parentNumbers = PermCommonTreeSupplier.getParentNumbers(longNumbers);
        LOG.info("permF7_getOrgTeams() structlongnumbers:{},parentNumbers:{}", longNumbers, parentNumbers);
        baseFilter.add(new QFilter("orgteam.structnumber", "in", parentNumbers));
        DynamicObject[] parents = helper.queryOriginalArray("orgteam.id,orgteam.number,orgteam.name,parent.id,structlongnumber", HRPermCommonUtil.listToQFilters(baseFilter));
        LOG.info("permF7_getOrgTeams() parentInfo length:{}", (Object)parents.length);
        return this.mergeAndDistinct((DynamicObject[])infos, parents, "structlongnumber");
    }

    public List<QFilter> getFilter(IFormView formView) {
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        ArrayList baseFilter = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, Consumer<PermCommonTreeSupplier>> treeFilterAction = PermCommonTreeSupplier.getInstance().getTreeFilterAction(baseFilter, formView);
        Consumer<PermCommonTreeSupplier> filterConsumer = treeFilterAction.get(entityNumber);
        if (Objects.isNull(filterConsumer)) {
            PermCommonTreeSupplier.getInstance().getFilter4Common(baseFilter, formView);
        } else {
            filterConsumer.accept(PermCommonTreeSupplier.getInstance());
        }
        LOG.info("PermCommonTreeSupplier_getFilter() baseFilter:{},entityNumber:{}", (Object)baseFilter, (Object)entityNumber);
        return baseFilter;
    }

    private DynamicObject[] mergeAndDistinct(DynamicObject[] infos, DynamicObject[] parents, String field) {
        List noRepeatInfos = Arrays.stream(infos).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(t -> t.getString(field)))), ArrayList::new));
        Set longNumberSet = Arrays.stream(infos).map(info -> info.getString(field)).collect(Collectors.toSet());
        List noRepeatParents = Arrays.stream(parents).filter(parent -> !longNumberSet.contains(parent.getString(field))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(t -> t.getString(field)))), ArrayList::new));
        noRepeatInfos.addAll(noRepeatParents);
        return noRepeatInfos.toArray(new DynamicObject[0]);
    }

    private static Set<String> getParentNumbers(Set<String> longNumbers) {
        return PermCommonTreeSupplier.getParentNumbers(longNumbers, "!");
    }

    private static Set<String> getParentNumbers(Set<String> longNumbers, String splitStr) {
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)16);
        longNumbers.forEach(longNumber -> {
            String[] split = longNumber.split(splitStr);
            for (int index = 0; index < split.length; ++index) {
                if (index == split.length - 1) continue;
                numbers.add(split[index]);
            }
        });
        return numbers;
    }

    Map<String, Supplier<DynamicObject[]>> getDataInfoAction(IFormView formView, String text) {
        HashMap consumerMap = Maps.newHashMapWithExpectedSize((int)4);
        consumerMap.put("bos_org", () -> PermCommonTreeSupplier.getInstance().getBosOrgs(formView, text));
        consumerMap.put("haos_adminorgteam", () -> PermCommonTreeSupplier.getInstance().getOrgTeams(formView, text));
        return consumerMap;
    }

    Map<String, Supplier<Map<String, String>>> getTreeNodeValueAction(DynamicObject info) {
        HashMap consumerMap = Maps.newHashMapWithExpectedSize((int)4);
        consumerMap.put("bos_org", () -> PermCommonTreeSupplier.getInstance().getNodeValue4BosOrg(info));
        consumerMap.put("haos_adminorgteam", () -> PermCommonTreeSupplier.getInstance().getNodeValue4OrgTeam(info));
        return consumerMap;
    }

    Map<String, Consumer<PermCommonTreeSupplier>> getTreeFilterAction(List<QFilter> baseFilter, IFormView formView) {
        HashMap consumerMap = Maps.newHashMapWithExpectedSize((int)4);
        consumerMap.put("bos_org", consumer -> consumer.getFilter4BosOrg(baseFilter, formView));
        consumerMap.put("haos_adminorgteam", consumer -> consumer.getFilter4OrgTeam(baseFilter, formView));
        return consumerMap;
    }

    private static class PermCommonTreeSupplierHandler {
        private static final PermCommonTreeSupplier INSTANCE = new PermCommonTreeSupplier();

        private PermCommonTreeSupplierHandler() {
        }
    }
}

