/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermOTLazyTreeCommonHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.constants.perm.RoleBdDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleEntryModel;
import kd.hr.hrcs.common.constants.perm.RoleDataRuleMainModel;

@ExcludeFromJacocoGeneratedReport
public class RoleDataPermHelper {
    private static final Log LOGGER = LogFactory.getLog(RoleDataPermHelper.class);

    public static void loadPermData(IFormView formView, PermPageCacheUtil permPageCacheUtil) {
        HashMap<String, RoleDataPermModel> roleDataPermModelMap = new HashMap<String, RoleDataPermModel>(16);
        Map<String, Map<String, String>> assignedAppBuCaMap = permPageCacheUtil.getAssignedAppHrBuCaMap();
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        String roleId = formView.getFormShowParameter().getCustomParam("roleId").toString();
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_roledatarule");
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        HRBaseServiceHelper dimensionHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dataRules = dataRuleHelper.query("app,entitytype,roledataruleentry.permitem,roledataruleentry.datarule,hrcs_rolebdruleentry.propkey,hrcs_rolebdruleentry.bddatarule,hrcs_rolebdruleentry.propentnum", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        DynamicObject[] hrBus = roleBuHelper.query("org,containssub,hrbucafunc", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        Arrays.stream(hrBus).forEach(hrBu -> {
            Map hrBuMap;
            String hrBuCaFuncId = hrBu.getString("hrbucafunc");
            RoleDataPermModel roleDataPermModel = (RoleDataPermModel)roleDataPermModelMap.get(hrBuCaFuncId);
            if (roleDataPermModel == null) {
                roleDataPermModel = new RoleDataPermModel();
                hrBuMap = Maps.newHashMapWithExpectedSize((int)16);
                roleDataPermModelMap.put(hrBuCaFuncId, roleDataPermModel);
            } else {
                hrBuMap = roleDataPermModel.getOrgMap();
                if (hrBuMap == null) {
                    hrBuMap = Maps.newHashMapWithExpectedSize((int)16);
                }
            }
            roleDataPermModel.setOrgMap(hrBuMap);
            String hrBuId = hrBu.getString("org.id");
            if (HRStringUtils.isEmpty((String)hrBuId)) {
                return;
            }
            HashMap hrBuInfo = Maps.newHashMapWithExpectedSize((int)16);
            hrBuInfo.put("id", hrBuId);
            hrBuInfo.put("name", hrBu.getString("org.name"));
            hrBuInfo.put("number", hrBu.getString("org.number"));
            hrBuInfo.put("includeSub", hrBu.get("containssub"));
            hrBuMap.put(hrBuId, hrBuInfo);
            roleDataPermModel.setOrgMap(hrBuMap);
        });
        List dimensionIds = assignedHrBuCaDim.values().stream().flatMap(it -> it.keySet().stream().map(Long::parseLong)).collect(Collectors.toList());
        Map<String, DynamicObject> dimensionMap = Arrays.stream(dimensionHelper.query("id,number,name,entitytype,showtype", new QFilter[]{new QFilter("id", "in", dimensionIds)})).collect(Collectors.toMap(it -> String.valueOf(it.getLong("id")), it -> it, (oldValue, newValue) -> oldValue));
        LOGGER.info("Got assignedAppBuCaMap:\u3010{}\u3011 from loadPermData.", assignedAppBuCaMap);
        Arrays.stream(dataRules).forEach(mainDataRule -> {
            Map appEntity2DataRules;
            RoleDataRuleMainModel roleDataRuleMainModel;
            String appId = mainDataRule.getString("app");
            String entityType = mainDataRule.getString("entitytype");
            String key = appId + "#" + entityType;
            String buCaFuncId = HRBuCaServiceHelper.getBuCaFuncFromSpec(entityType, appId);
            RoleDataPermModel roleDataPermModel = (RoleDataPermModel)roleDataPermModelMap.get(buCaFuncId);
            if (roleDataPermModel == null) {
                roleDataPermModel = new RoleDataPermModel();
                roleDataRuleMainModel = new RoleDataRuleMainModel();
                appEntity2DataRules = Maps.newHashMapWithExpectedSize((int)16);
                appEntity2DataRules.put(key, roleDataRuleMainModel);
                roleDataPermModel.setAppEntity2DataRules(appEntity2DataRules);
                roleDataPermModelMap.put(buCaFuncId, roleDataPermModel);
            } else {
                appEntity2DataRules = roleDataPermModel.getAppEntity2DataRules();
                if (CollectionUtils.isEmpty((Map)appEntity2DataRules)) {
                    appEntity2DataRules = Maps.newHashMapWithExpectedSize((int)16);
                    roleDataRuleMainModel = new RoleDataRuleMainModel();
                    appEntity2DataRules.put(key, roleDataRuleMainModel);
                    roleDataPermModel.setAppEntity2DataRules(appEntity2DataRules);
                } else {
                    roleDataRuleMainModel = (RoleDataRuleMainModel)appEntity2DataRules.get(key);
                    if (Objects.isNull(roleDataRuleMainModel)) {
                        roleDataRuleMainModel = new RoleDataRuleMainModel();
                        appEntity2DataRules.put(key, roleDataRuleMainModel);
                    }
                }
            }
            DynamicObjectCollection dataRuleEntry = mainDataRule.getDynamicObjectCollection("roledataruleentry");
            HashMap<String, RoleDataRuleEntryModel> dataRuleMap = new HashMap<String, RoleDataRuleEntryModel>(16);
            if (!CollectionUtils.isEmpty((Collection)dataRuleEntry)) {
                for (DynamicObject dataRuleDyna : dataRuleEntry) {
                    String dataRuleId = dataRuleDyna.getString("datarule.id");
                    RoleDataRuleEntryModel dataRuleEntryModel = (RoleDataRuleEntryModel)dataRuleMap.get(dataRuleId);
                    String permItemId = dataRuleDyna.getString("permitem.id");
                    if (Objects.isNull(dataRuleEntryModel)) {
                        ArrayList permItemList = Lists.newArrayList((Object[])new String[]{permItemId});
                        dataRuleEntryModel = new RoleDataRuleEntryModel(entityType, (List)permItemList, dataRuleId);
                        dataRuleMap.put(dataRuleId, dataRuleEntryModel);
                        continue;
                    }
                    dataRuleEntryModel.getPermItem().add(permItemId);
                }
            } else {
                dataRuleMap.put("emptyFlag", new RoleDataRuleEntryModel());
            }
            roleDataRuleMainModel.setDataRuleMap(dataRuleMap);
            DynamicObjectCollection bdDataRuleEntry = mainDataRule.getDynamicObjectCollection("hrcs_rolebdruleentry");
            HashMap<String, RoleBdDataRuleEntryModel> bdDataRuleMap = new HashMap<String, RoleBdDataRuleEntryModel>(16);
            if (!CollectionUtils.isEmpty((Collection)bdDataRuleEntry)) {
                bdDataRuleEntry.forEach(bdDataRule -> {
                    String propKey = bdDataRule.getString("propkey");
                    if (HRStringUtils.isEmpty((String)propKey)) {
                        return;
                    }
                    String propEntNum = bdDataRule.getString("propentnum");
                    String dataRuleId = bdDataRule.getString("bddatarule.id");
                    bdDataRuleMap.put(propKey, new RoleBdDataRuleEntryModel(entityType, dataRuleId, propKey, propEntNum));
                });
            } else {
                bdDataRuleMap.put("emptyFlag", new RoleBdDataRuleEntryModel());
            }
            roleDataRuleMainModel.setBdDataRuleMap(bdDataRuleMap);
        });
        RoleDataPermHelper.doLoadDimData(roleId, roleDataPermModelMap, assignedHrBuCaDim, dimensionMap);
        HRBaseServiceHelper roleDimRelatHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObjectCollection roleDimRelatColl = roleDimRelatHelper.queryOriginalCollection("dimension,bucafunc,entry,entry.app,entry.entitytype,entry.propkey", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter("entry.enable", "=", (Object)"0")});
        roleDimRelatColl.forEach(item -> {
            String dimId = item.getString("dimension");
            String buCaFuncId = item.getString("bucafunc");
            String appId = item.getString("entry.app");
            String entityType = item.getString("entry.entitytype");
            String propKey = item.getString("entry.propkey");
            RoleDataPermModel roleDataPermModel = roleDataPermModelMap.computeIfAbsent(buCaFuncId, k -> new RoleDataPermModel());
            Map roleDimRelatDisableMap = roleDataPermModel.getRoleDimRelatDisableMap();
            if (CollectionUtils.isEmpty((Map)roleDimRelatDisableMap)) {
                roleDataPermModel.setRoleDimRelatDisableMap(roleDimRelatDisableMap);
            }
            Set orDefault = roleDimRelatDisableMap.computeIfAbsent(dimId, k -> new HashSet(16));
            orDefault.add(appId + entityType + propKey);
        });
        LOGGER.info("roleDataPermModelMap---" + ((Object)roleDataPermModelMap).toString());
        permPageCacheUtil.setDataPerm(roleDataPermModelMap);
        permPageCacheUtil.setOriginalDataPerm(roleDataPermModelMap);
        permPageCacheUtil.setOriginalHrBuCaDim(permPageCacheUtil.getAssignedHrBuCaDim());
    }

    private static void doLoadDimData(String roleId, Map<String, RoleDataPermModel> roleDataPermModelMap, Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim, Map<String, DynamicObject> dimensionMap) {
        HRBaseServiceHelper dimGrpHelper = new HRBaseServiceHelper("hrcs_roledimgrp");
        DynamicObject[] dimGrps = dimGrpHelper.query("bucafunc,index,entry,entry.dimension,entry.isall,entry.otclassify,entry.admincontainssub,entry.containssub,entry.dimval,entry.structproject,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        Arrays.stream(dimGrps).forEach(item -> {
            String groupId;
            DimGrpModel dimGrpModel;
            String buCaFuncId = item.getString("bucafunc.id");
            RoleDataPermModel roleDataPermModel = roleDataPermModelMap.computeIfAbsent(buCaFuncId, key -> new RoleDataPermModel(){
                private static final long serialVersionUID = -4940543470002094388L;
                {
                    this.setDimGroupMap(Maps.newHashMapWithExpectedSize((int)16));
                }
            });
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            if (CollectionUtils.isEmpty((Map)dimGroupMap)) {
                dimGroupMap = Maps.newHashMapWithExpectedSize((int)16);
                roleDataPermModel.setDimGroupMap(dimGroupMap);
            }
            if (Objects.isNull(dimGrpModel = (DimGrpModel)dimGroupMap.get(groupId = item.getString("id")))) {
                dimGrpModel = new DimGrpModel();
                dimGrpModel.setSeq(item.getInt("index"));
                dimGroupMap.put(groupId, dimGrpModel);
            }
            DynamicObjectCollection entry = item.getDynamicObjectCollection("entry");
            LinkedListMultimap dimMultimap = LinkedListMultimap.create();
            entry.forEach(dimValObj -> {
                String showType = dimValObj.getString("dimension.showtype");
                String dimId = dimValObj.getString("dimension.id");
                dimMultimap.put((Object)(showType + "#" + dimId), dimValObj);
            });
            Map map = (Map)assignedHrBuCaDim.get(buCaFuncId);
            if (null != map) {
                map.values().forEach(dimItem -> {
                    String showType = (String)dimItem.get("showType");
                    String dimId = (String)dimItem.get("dimId");
                    String dimKey = showType + "#" + dimId;
                    if (!dimMultimap.containsKey((Object)dimKey)) {
                        DynamicObject dimension = (DynamicObject)dimensionMap.get(dimId);
                        DynamicObject entryDynamicObject = dimGrpHelper.generateEmptyEntryDynamicObject("entry");
                        entryDynamicObject.set("dimension", (Object)dimension);
                        entryDynamicObject.set("dimval", (Object)"");
                        entryDynamicObject.set("isall", (Object)"0");
                        entryDynamicObject.set("containssub", (Object)"1");
                        entryDynamicObject.set("admincontainssub", (Object)"1");
                        dimMultimap.put((Object)dimKey, (Object)entryDynamicObject);
                    }
                });
            }
            HashMap dimInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            String notLimit = "0";
            Map tempMultimap = dimMultimap.asMap();
            for (Map.Entry dimMulItem : tempMultimap.entrySet()) {
                Map dimVals;
                List valList = (List)dimMulItem.getValue();
                String key2 = (String)dimMulItem.getKey();
                String[] keySplit = key2.split("#");
                String dimId = keySplit[1];
                DynamicObject firstObj = (DynamicObject)valList.get(0);
                String dimNumber = firstObj.getString("dimension.number");
                String showType = firstObj.getString("dimension.showtype");
                notLimit = firstObj.getBoolean("isall") ? "1" : "0";
                Map dimInfo = (Map)dimInfoMap.get(dimNumber);
                if (CollectionUtils.isEmpty((Map)dimInfo)) {
                    dimInfo = Maps.newHashMapWithExpectedSize((int)16);
                    dimInfo.put("dimId", dimId);
                    dimInfoMap.put(dimNumber, dimInfo);
                }
                if (CollectionUtils.isEmpty((Map)(dimVals = (Map)dimInfo.get("dimVal")))) {
                    dimVals = Maps.newHashMapWithExpectedSize((int)16);
                    dimInfo.put("dimVal", dimVals);
                }
                if (HRStringUtils.equals((String)notLimit, (String)"0")) {
                    for (DynamicObject dim : valList) {
                        String dimVal = dim.getString("dimval");
                        if (HRStringUtils.isEmpty((String)dimVal)) continue;
                        DynamicObject structProject = dim.getDynamicObject("structproject");
                        DynamicObject originalStructProject = null;
                        if (HRStringUtils.equals((String)"teamblock", (String)showType)) {
                            originalStructProject = RoleDataPermHelper.getStructProject(dim);
                        }
                        HashMap valueDetailMap = Maps.newHashMapWithExpectedSize((int)16);
                        valueDetailMap.put("id", dimVal);
                        valueDetailMap.put("name", dimVal);
                        RoleDataPermHelper.getDimensionValName(dim, valueDetailMap, dimVal);
                        valueDetailMap.put("includeSub", dim.getBoolean("containssub"));
                        valueDetailMap.put("includeSubAdminOrg", dim.getBoolean("admincontainssub"));
                        valueDetailMap.put("valueType", dim.getString("valtype"));
                        valueDetailMap.put("dynamicCondition", dim.getString("dynacond.id"));
                        if (null != structProject && null != originalStructProject) {
                            valueDetailMap.put("structProject", structProject);
                            valueDetailMap.put("currentstructproject", originalStructProject);
                            dimVals.put(dimVal + "#" + structProject.getPkValue(), valueDetailMap);
                            continue;
                        }
                        dimVals.put(dimVal, valueDetailMap);
                    }
                }
                dimInfo.put("notLimit", notLimit);
            }
            TreeMap dimMap = dimGrpModel.getDimMap();
            if (CollectionUtils.isEmpty((Map)dimMap)) {
                dimMap = Maps.newTreeMap();
                dimGrpModel.setDimMap(dimMap);
            }
            for (Map.Entry dimInfoEntry : dimInfoMap.entrySet()) {
                Map dimInfo = (Map)dimInfoEntry.getValue();
                String dimNumber = (String)dimInfoEntry.getKey();
                if (null == dimNumber) continue;
                DimModel dimModel = new DimModel();
                dimModel.setDimNumber(dimNumber);
                dimModel.setDimId((String)dimInfo.get("dimId"));
                Map dimVals = (Map)dimInfo.get("dimVal");
                dimModel.setDimValues(dimVals);
                dimModel.setLimit((String)dimInfo.get("notLimit"));
                dimMap.put(dimNumber, dimModel);
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    public static Map<String, RoleDataPermModel> loadDimData(IFormView formView, PermPageCacheUtil permPageCacheUtil) {
        String roleId = formView.getFormShowParameter().getCustomParam("roleId").toString();
        HashMap<String, RoleDataPermModel> roleDataPermModelMap = new HashMap<String, RoleDataPermModel>(16);
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        HRBaseServiceHelper dimensionHelper = new HRBaseServiceHelper("hrcs_dimension");
        List dimensionIds = assignedHrBuCaDim.values().stream().flatMap(it -> it.keySet().stream().map(Long::parseLong)).collect(Collectors.toList());
        Map<String, DynamicObject> dimensionMap = Arrays.stream(dimensionHelper.query("id,number,name,entitytype,showtype", new QFilter[]{new QFilter("id", "in", dimensionIds)})).collect(Collectors.toMap(it -> String.valueOf(it.getLong("id")), it -> it, (oldValue, newValue) -> oldValue));
        RoleDataPermHelper.doLoadDimData(roleId, roleDataPermModelMap, assignedHrBuCaDim, dimensionMap);
        return roleDataPermModelMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public static DynamicObject getStructProject(DynamicObject dimValue) {
        long dimVal = dimValue.getLong("dimval");
        DynamicObject structProject = dimValue.getDynamicObject("structproject");
        if (null == structProject) {
            return null;
        }
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("orgteam.id", "=", (Object)dimVal));
        baseQFilterList.add(new QFilter("structproject.id", "=", (Object)structProject.getLong("id")));
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        if (dimHelper.isExists(HRPermCommonUtil.listToQFilters(baseQFilterList))) {
            return structProject;
        }
        return new HRBaseServiceHelper("haos_structproject").queryOne("relyonstructproject", new QFilter("id", "=", (Object)structProject.getLong("id")));
    }

    @ExcludeFromJacocoGeneratedReport
    public static void getDimensionValName(DynamicObject dimModelVal, Map dimValMap, String dimval) {
        block11: {
            if (HRStringUtils.isEmpty((String)dimval)) {
                dimValMap.put("name", "");
                return;
            }
            DynamicObject entityType = dimModelVal.getDynamicObject("dimension.entitytype");
            if (entityType != null && HRStringUtils.isNotEmpty((String)dimval)) {
                String entityNumber = entityType.getString("number");
                HRBaseServiceHelper dimHelper = new HRBaseServiceHelper(entityNumber);
                try {
                    Long val = Long.parseLong(dimval);
                    DynamicObject[] dimValDataArr = dimHelper.query(new QFilter[]{new QFilter("id", "in", (Object)val)});
                    if (dimValDataArr != null && dimValDataArr.length > 0 && dimValDataArr[0].containsProperty("name")) {
                        String name = dimValDataArr[0].getString("name");
                        dimValMap.put("name", name);
                        break block11;
                    }
                    dimValMap.put("name", "");
                }
                catch (Exception ex) {
                    LOGGER.error("Got exception [" + entityNumber + "] with id[" + dimval + "]", (Throwable)ex);
                    try {
                        DynamicObject[] dimValDataArr = dimHelper.query(new QFilter[]{new QFilter("id", "in", (Object)dimval)});
                        if (dimValDataArr != null && dimValDataArr.length > 0 && dimValDataArr[0].containsProperty("name")) {
                            String name = dimValDataArr[0].getString("name");
                            dimValMap.put("name", name);
                        } else {
                            dimValMap.put("name", "");
                        }
                    }
                    catch (Exception otherException) {
                        LOGGER.error("Got other exception [" + entityNumber + "] with id[" + dimval + "]", (Throwable)ex);
                    }
                }
            } else if (HRStringUtils.equals((String)"enum", (String)dimModelVal.getString("dimension.datasource")) && HRStringUtils.isNotEmpty((String)dimval)) {
                long dimensionId = dimModelVal.getLong("dimension.id");
                HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
                DynamicObject item = dimHelper.queryOne("entry.displayvalue,entry.value", (Object)dimensionId);
                String name = item.getDynamicObjectCollection("entry").stream().filter(it -> HRStringUtils.equals((String)dimval, (String)it.getString("value"))).map(it -> it.getString("displayvalue")).findAny().orElse("");
                dimValMap.put("name", name);
            }
        }
    }
}

