/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.DataPermissionCache;
import kd.bos.permission.cache.FieldPermissionCache;
import kd.bos.permission.cache.OperationRuleObjCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRListFieldPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HrbuCaControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DimensionHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.PermTreeUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;

@ExcludeFromJacocoGeneratedReport
public class RoleServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(RoleServiceHelper.class);
    private static final String KEY_EDIT_STATUS = "editStatus";
    private static final String HRMP_HRCS_BUSINESS = "hrmp-hrcs-business";
    private static final String ENTITY_PERM_ROLE = "perm_role";
    public static final String CLOUD_ENTRYENTITY = "cloudentryentity";

    public static Map<String, Map<String, String>> getAppBuCaFuncMap(Set<String> appIds) {
        Map<String, Map<String, Object>> hrBuCaFuncMap = HrbuCaControlHelper.getHRBuCaFuncByAppId(appIds);
        HashMap buCaFuncMap = Maps.newHashMapWithExpectedSize((int)hrBuCaFuncMap.size());
        HashSet alreadySet = new HashSet(16);
        for (Map.Entry<String, Map<String, Object>> appBusinessType : hrBuCaFuncMap.entrySet()) {
            Map<String, Object> value = appBusinessType.getValue();
            HashMap businessMap = new HashMap(3);
            String buCaFuncId = (String)value.get("buCaFuncId");
            Set appIdSet = (Set)value.get("appId");
            if (CollectionUtils.isEmpty((Collection)appIdSet)) continue;
            appIdSet.forEach(appId -> {
                if (alreadySet.contains(appId)) {
                    return;
                }
                businessMap.put("buCaFuncId", buCaFuncId);
                businessMap.put("name", (String)value.get("name"));
                businessMap.put("appId", appId);
                buCaFuncMap.put(appId, businessMap);
                alreadySet.add(appId);
            });
        }
        return buCaFuncMap;
    }

    public static Map<String, String> getPageCache(IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        return pageCache.getAll();
    }

    public static void setEditStatus(IPageCache cache) {
        String editStatus = cache.get(KEY_EDIT_STATUS);
        if (HRStringUtils.isEmpty((String)editStatus)) {
            cache.put(KEY_EDIT_STATUS, "1");
        }
    }

    public static void removeEditStatus(IPageCache cache) {
        cache.remove(KEY_EDIT_STATUS);
    }

    public static Map<String, Map<String, Object>> getRoleMembers(List<String> roleIds) {
        QFilter[] roleFilters = new QFilter[]{new QFilter("id", "in", roleIds)};
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        DynamicObjectCollection roleColl = roleHelper.queryOriginalCollection("id,number,enable,issystem", roleFilters);
        HashMap roleMap = Maps.newHashMapWithExpectedSize((int)roleColl.size());
        for (DynamicObject role : roleColl) {
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            tempMap.put("enable", role.getString("enable"));
            tempMap.put("number", role.getString("number"));
            tempMap.put("issyspreset", role.getBoolean("issystem"));
            tempMap.put("memberCount", 0);
            roleMap.put(role.getString("id"), tempMap);
        }
        String idStr = String.join((CharSequence)"','", roleIds);
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("select froleid id ,count(fid) count ").append("from t_perm_userrole ").append("where froleid in ('").append(idStr).append("') ").append("group by froleid");
        String sql = sbSql.toString();
        DB.query((DBRoute)DBRoute.permission, (String)sql, null, rs -> {
            while (rs.next()) {
                String id = rs.getString("id");
                Integer count = rs.getInt("count");
                Map tempMap = (Map)roleMap.get(id);
                if (!Objects.nonNull(tempMap)) continue;
                tempMap.put("memberCount", count);
                roleMap.put(id, tempMap);
            }
            return null;
        });
        return roleMap;
    }

    public static void removePermCache() {
        FieldPermissionCache.removeAllCache();
        DataPermissionCache.removeAllCache();
        RoleServiceHelper.removeOperationRuleCache();
    }

    public static void clearUserRolePermCache() {
        CacheMrg.clearCache((String)CacheMrg.getType4DataPerm());
        CacheMrg.clearCache((String)CacheMrg.getType4DataPermObj());
        CacheMrg.clearCache((String)CacheMrg.getType4DataRule());
        CacheMrg.clearCache((String)CacheMrg.getType4DataRuleObj());
        CacheMrg.clearCache((String)CacheMrg.getType4UserApp());
        CacheMrg.clearCache((String)CacheMrg.getType4UserMenu());
        CacheMrg.clearCache((String)CacheMrg.getType4User());
        CacheMrg.clearCache((String)CacheMrg.getType4UserRole());
        CacheMrg.clearCache((String)CacheMrg.getHasPermDimObjs());
    }

    public static void removeOperationRuleCache() {
        OperationRuleObjCache.removeAllCache();
    }

    public static boolean checkNameExist(String roleId, String name) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)name)};
        DynamicObjectCollection dyColl = helper.queryOriginalCollection("id,name", filters);
        return !RoleServiceHelper.checkDuplicateResult(roleId, dyColl);
    }

    public static void disablePermfile(List<Object> permfileIds) {
        RoleServiceHelper.deletePerm(permfileIds);
    }

    private static void deletePerm(List<Object> permfileIds) {
        DynamicObject[] permfiles;
        for (DynamicObject permfile : permfiles = RoleServiceHelper.getUserByPermfile(permfileIds)) {
            RoleServiceHelper.deletePerm(permfile);
        }
    }

    private static DynamicObject[] getUserByPermfile(List<Object> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        QFilter qFilter = new QFilter("id", "in", idList);
        return serviceHelper.queryOriginalArray("id,user.id,org.id", new QFilter[]{qFilter});
    }

    private static void deletePerm(DynamicObject permfile) {
        Long permfileId = permfile.getLong("id");
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObjectCollection userRoleRelateCol = userRoleRelateHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("permfile", "=", (Object)permfileId)});
        Set<Long> userRoleRelateIdSet = userRoleRelateCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                RoleServiceHelper.deleteBosRolePerm(userRoleRelateIdSet);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                throw new KDException(BosErrorCode.render, new Object[]{ResManager.loadKDString((String)"\u5220\u9664\u6743\u9650\u5f02\u5e38\u3002%s", (String)"RoleServiceHelper_4", (String)HRMP_HRCS_BUSINESS, (Object[])new Object[]{ex.getMessage()})});
            }
        }
        RoleServiceHelper.deleteHrRolePerm(permfileId, userRoleRelateIdSet);
    }

    private static void deleteBosRolePerm(Set<Long> userRoleRelateIdSet) {
        HRBaseServiceHelper hrUserRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        DynamicObjectCollection userRoleCol = hrUserRoleHelper.queryOriginalCollection("userrolepf", new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIdSet)});
        Set userRolePfIdSet = userRoleCol.stream().map(dy -> dy.getString("userrolepf")).collect(Collectors.toSet());
        HRBaseServiceHelper bosUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
        QFilter[] bosfilters = new QFilter[]{new QFilter("id", "in", userRolePfIdSet)};
        bosUserRoleHelper.deleteByFilter(bosfilters);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void deleteHrRolePerm(Long permfileId, Set<Long> userRoleRelateIdSet) {
        QFilter[] userRoleRelateQFilter = new QFilter[]{new QFilter("id", "in", userRoleRelateIdSet)};
        QFilter[] dataRuleQFilter = new QFilter[]{new QFilter("userrolerelate", "in", userRoleRelateIdSet)};
        QFilter[] fieldPermQFilter = new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIdSet)};
        QFilter[] permFileQFilter = new QFilter[]{new QFilter("permfile", "=", (Object)permfileId)};
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        HRBaseServiceHelper hrbuHelper = new HRBaseServiceHelper("hrcs_userrole");
        HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper userFieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                userRoleRelateHelper.deleteByFilter(userRoleRelateQFilter);
                userDataRuleHelper.deleteByFilter(dataRuleQFilter);
                userFieldHelper.deleteByFilter(fieldPermQFilter);
                hrbuHelper.deleteByFilter(fieldPermQFilter);
            }
            catch (RuntimeException ex) {
                txHandle.markRollback();
                throw new KDException(BosErrorCode.render, new Object[]{ResManager.loadKDString((String)"\u5220\u9664\u6743\u9650\u5f02\u5e38\u3002%s", (String)"RoleServiceHelper_4", (String)HRMP_HRCS_BUSINESS, (Object[])new Object[]{ex.getMessage()})});
            }
        }
    }

    public static boolean checkNumberExist(String roleId, String number) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_PERM_ROLE);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObjectCollection dyoColl = helper.queryOriginalCollection("id,number", filters);
        return RoleServiceHelper.checkDuplicateResult(roleId, dyoColl);
    }

    private static boolean checkDuplicateResult(String roleId, DynamicObjectCollection dyoColl) {
        if (CollectionUtils.isEmpty((Collection)dyoColl)) {
            return false;
        }
        if (dyoColl.size() == 1) {
            String roleIdInDy = ((DynamicObject)dyoColl.get(0)).getString("id");
            return !HRStringUtils.equals((String)roleId, (String)roleIdInDy);
        }
        return true;
    }

    public static boolean handleRoleModifyLock(String pkId, String entityName, IFormView view) {
        return RoleServiceHelper.handleLock(pkId, entityName, view, "modify");
    }

    public static boolean releaseLock(IFormView formView) {
        return MutexHelper.release((IFormView)formView);
    }

    private static boolean handleLock(String pkId, String entityName, IFormView view, String operationKey) {
        StringBuilder errMsg = new StringBuilder();
        boolean result = MutexHelper.require((IFormView)view, (String)entityName, (Object)pkId, (String)operationKey, (boolean)true, (StringBuilder)errMsg);
        if (!result) {
            view.showTipNotification(errMsg.toString());
        }
        return result;
    }

    public static synchronized boolean handleRoleAssignLock(String pkId, String entityName, IFormView view) {
        return RoleServiceHelper.handleLock(pkId, entityName, view, "assign");
    }

    public static String getFixNumberWords(String words) {
        String result = words;
        if (HRStringUtils.isEmpty((String)words)) {
            return result;
        }
        if (words.length() > 12) {
            result = words.substring(0, 12) + "...";
        }
        return result;
    }

    public static boolean checkRoleMemberExist(Object permFileId, String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userrolerelat");
        QFilter[] filters = new QFilter[]{new QFilter("permfile", "=", permFileId), new QFilter("role", "=", (Object)roleId)};
        DynamicObject roleMember = helper.queryOne(filters);
        return !Objects.isNull(roleMember);
    }

    @ExcludeFromJacocoGeneratedReport
    public static void addNodeToDataTree(TreeView dataPermTreeView, List<TreeNode> addNodeList, boolean ifListLikeTree, Set<String> hasDoneTreeViewEvents) {
        HashSet<String> needExpandNodeIds = new HashSet<String>(16);
        ArrayList<TreeNode> newAddNodeList = new ArrayList<TreeNode>(16);
        for (TreeNode addNode : addNodeList) {
            TreeNode newAddNode = PermTreeUtil.copyNewTreeNode((TreeNode)addNode);
            String addNodeId = newAddNode.getId();
            if (addNodeId.contains("#permItem")) continue;
            if (addNodeId.contains("#entity")) {
                newAddNode.setChildren(null);
            }
            newAddNodeList.add(newAddNode);
            needExpandNodeIds.add(newAddNode.getParentid());
        }
        String addNodesStr = dataPermTreeView.getKey() + "_addNodes_" + newAddNodeList;
        if (!hasDoneTreeViewEvents.contains(addNodesStr)) {
            RoleServiceHelper.addDataRuleTreeNode(dataPermTreeView, ifListLikeTree, hasDoneTreeViewEvents, newAddNodeList, addNodesStr);
        }
        ArrayList needExpandNodeIdList = new ArrayList(needExpandNodeIds);
        needExpandNodeIdList.sort((s1, s2) -> {
            int l1 = PermTreeUtil.getTreeNodeLevel((String)s1);
            int l2 = PermTreeUtil.getTreeNodeLevel((String)s2);
            return l1 - l2;
        });
        String expandEvtStr = dataPermTreeView.getKey() + "_expand_" + needExpandNodeIdList;
        if (!hasDoneTreeViewEvents.contains(expandEvtStr)) {
            for (String nodeId : needExpandNodeIdList) {
                dataPermTreeView.expand(nodeId);
            }
            hasDoneTreeViewEvents.add(expandEvtStr);
        }
    }

    private static void addDataRuleTreeNode(TreeView dataPermTreeView, boolean ifListLikeTree, Set<String> hasDoneTreeViewEvents, List<TreeNode> newAddNodeList, String addNodesStr) {
        int newAddNodeListCount = newAddNodeList.size();
        if (newAddNodeListCount > 0) {
            if (ifListLikeTree) {
                RoleServiceHelper.handleListLikeTree(newAddNodeListCount, newAddNodeList, dataPermTreeView);
            } else {
                dataPermTreeView.addNodes(newAddNodeList);
            }
        }
        hasDoneTreeViewEvents.add(addNodesStr);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void handleListLikeTree(int newAddNodeListCount, List<TreeNode> newAddNodeList, TreeView dataPermTreeView) {
        for (int i = 0; i < newAddNodeListCount; ++i) {
            TreeNode newAddNode = newAddNodeList.get(i);
            String nodeId = newAddNode.getId();
            if (i == newAddNodeListCount - 1) {
                dataPermTreeView.deleteNode(nodeId);
                dataPermTreeView.addNode(newAddNode);
                continue;
            }
            dataPermTreeView.addNode(newAddNode);
        }
    }

    public static void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, FormShowParameter fsp, IFormView view) {
        Map originalCustParams = view.getFormShowParameter().getCustomParams();
        if (params != null) {
            params.putAll(originalCustParams);
            fsp.setCustomParams(params);
            String roleName = (String)params.get("roleName");
            if (roleName != null) {
                fsp.setCaption(roleName);
            }
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(showType);
        view.showForm(fsp);
    }

    public static void showF7Form(IFormView view, IFormPlugin plugin, QFilter qFilter, String entityName, boolean isMultiSelect, Long[] selectRows, String businessTypeId) {
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)true, (int)0, (boolean)true);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setMultiSelect(isMultiSelect);
        if (Objects.nonNull(selectRows) && selectRows.length > 0) {
            fsp.setSelectedRows((Object[])selectRows);
        }
        fsp.getListFilterParameter().setFilter(qFilter);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        fsp.setCustomParam("orgFuncId", (Object)businessTypeId);
        fsp.setCustomParam("orgViewSchemeNumber", (Object)businessTypeId);
        fsp.setCloseCallBack(new CloseCallBack(plugin, entityName));
        view.showForm((FormShowParameter)fsp);
    }

    public static String getRoleId(IFormView view) {
        return (String)view.getFormShowParameter().getCustomParam("roleId");
    }

    public static void markFunctionChanged(IFormView view) {
        view.getPageCache().put("functionChanged", "1");
    }

    public static void revertFunctionChanged(IFormView view) {
        view.getPageCache().put("functionChanged", "0");
    }

    public static String getFunctionChangeStatus(IFormView view) {
        return view.getPageCache().get("functionChanged");
    }

    public static void reloadDataPermContainer(IFormView formView) {
        RoleServiceHelper.reloadDataPermContainer(formView, false);
    }

    public static void reloadDataPermContainer(IFormView formView, boolean showLoading) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        permPageCacheUtil.setControlMap(new HashMap<String, Map<String, Object>>());
        LOGGER.info("Clear control map.");
        Map<String, Map<String, Object>> allHrBuCaFuncMap = permPageCacheUtil.getAllHrBuCaMap();
        Tab tab = (Tab)formView.getControl("dimgrptab");
        HRPageCache pageCache = new HRPageCache(formView);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)allHrBuCaFuncMap.size());
        StringBuilder tabPageIdsBuilder = new StringBuilder();
        String mainPageId = formView.getPageId();
        Set controlHrBuFuncSet = (Set)pageCache.get("controlHRbufuncMap", Set.class);
        if (CollectionUtils.isEmpty((Collection)controlHrBuFuncSet)) {
            controlHrBuFuncSet = Sets.newHashSetWithExpectedSize((int)allHrBuCaFuncMap.size());
        }
        Set<String> hrBuCaFuncSet = permPageCacheUtil.getAssignedHrBuCaSet();
        String activeTab = formView.getPageCache().get("currentHRbuCaFunc");
        if (CollectionUtils.isEmpty(hrBuCaFuncSet)) {
            LOGGER.info("there is no available hrBuCaFuncTion.");
            RoleServiceHelper.handleDataPermTab(formView, tab, items, tabPageIdsBuilder, activeTab);
            return;
        }
        if (HRStringUtils.isNotEmpty((String)activeTab) && !hrBuCaFuncSet.contains(activeTab)) {
            activeTab = null;
        }
        String viewStatus = formView.getPageCache().get("viewStatus");
        HashMap param2 = Maps.newHashMapWithExpectedSize((int)1);
        param2.put("formId", "hrcs_fieldperm");
        FormShowParameter showParameter2 = FormShowParameter.createFormShowParameter((Map)param2);
        showParameter2.getOpenStyle().setShowType(ShowType.Modal);
        showParameter2.setAppId(formView.getFormShowParameter().getAppId());
        showParameter2.setCustomParam("mainPageId", (Object)mainPageId);
        showParameter2.setCustomParam("viewStatus", (Object)viewStatus);
        showParameter2.setCustomParam("userRoleRelateId", formView.getFormShowParameter().getCustomParam("userRoleRelateId"));
        showParameter2.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter2.getOpenStyle().setTargetKey("fieldrangetab");
        formView.showForm(showParameter2);
        HashMap<String, RoleDataPermModel> roleDataPermMap = new HashMap<String, RoleDataPermModel>(16);
        TabPageAp tabPageAp = new TabPageAp();
        for (String buCaFuncId : hrBuCaFuncSet) {
            Map<String, Object> buCaFunc = allHrBuCaFuncMap.get(buCaFuncId);
            if (Objects.isNull(buCaFunc)) continue;
            RoleDataPermModel roleDataPermModel = new RoleDataPermModel(Long.parseLong(buCaFuncId));
            if (HRStringUtils.isEmpty((String)activeTab)) {
                activeTab = buCaFuncId;
            }
            String name = (String)buCaFunc.get("name");
            String description = (String)buCaFunc.get("description");
            tabPageAp.setKey(buCaFuncId);
            tabPageAp.setName(new LocaleString(name));
            items.add(tabPageAp.createControl());
            HashMap param = Maps.newHashMapWithExpectedSize((int)1);
            param.put("formId", "hrcs_datapermcontainer");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("currentHRbuCaFunc", (Object)buCaFuncId);
            showParameter.setCustomParam("funcDesc", (Object)description);
            showParameter.setCustomParam("funcName", (Object)name);
            showParameter.setAppId(formView.getFormShowParameter().getAppId());
            showParameter.setCustomParam("mainPageId", (Object)mainPageId);
            showParameter.setCustomParam("viewStatus", (Object)viewStatus);
            showParameter.setCustomParam("roleId", (Object)RoleServiceHelper.getRoleId(formView));
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(buCaFuncId);
            formView.showForm(showParameter);
            if (showLoading) {
                formView.showLoading(null);
            }
            controlHrBuFuncSet.add(buCaFuncId);
            tabPageIdsBuilder.append(buCaFuncId).append(',');
            roleDataPermMap.put(buCaFuncId, roleDataPermModel);
        }
        DimensionHelper.initDataPerm(formView, roleDataPermMap);
        pageCache.put("controlHRbufuncMap", (Object)controlHrBuFuncSet);
        RoleServiceHelper.handleDataPermTab(formView, tab, items, tabPageIdsBuilder, activeTab);
    }

    private static void handleDataPermTab(IFormView formView, Tab tab, List<Map<String, Object>> items, StringBuilder tabPageIdsBuilder, String activeTab) {
        String tabPageIds = formView.getPageCache().get("tabPageIds");
        if (HRStringUtils.isNotEmpty((String)tabPageIds)) {
            tab.deleteControls(tabPageIds.split(","));
        }
        if (HRStringUtils.isNotEmpty((String)tabPageIdsBuilder.toString())) {
            formView.getPageCache().put("tabPageIds", tabPageIdsBuilder.substring(0, tabPageIdsBuilder.toString().length() - 1));
        } else {
            formView.getPageCache().put("tabPageIds", "");
        }
        tab.addControls(items);
        if (!HRStringUtils.isEmpty((String)activeTab)) {
            tab.activeTab(activeTab);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean checkPermDataComplete(IFormView formView, String roleProperty, boolean showTips, StringBuilder processInfo, IFormPlugin confirmCallBackPlugin) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView, false);
        Map<String, RoleDataPermModel> permDataMap = permPageCacheUtil.getDataPermMap();
        Map<String, Map<String, Object>> allHrBuCaMap = permPageCacheUtil.getAllHrBuCaMap();
        Map<String, Map<String, Object>> controlMap = permPageCacheUtil.getControlMap();
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        String roleId = (String)formView.getFormShowParameter().getCustomParam("roleId");
        boolean isCopy = HRStringUtils.equals((String)"1", (String)formView.getPageCache().get("copy"));
        if (isCopy) {
            roleId = null;
        }
        HashSet buCaFuncTipsSet = Sets.newHashSetWithExpectedSize((int)16);
        Map<String, Set<String>> dimIdResults = DimensionHelper.getDimIdResults(permPageCacheUtil, roleId);
        boolean allowDataCustom = HRStringUtils.equals((String)"1", (String)roleProperty);
        boolean mustInput = false;
        if (allowDataCustom && HRStringUtils.isNotEmpty((String)roleId)) {
            DynamicObject[] dynaSchemes;
            long dynaSchemeRoleCount;
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userrolerelat");
            DynamicObject[] roleMemberRelats = helper.query(new QFilter[]{new QFilter("customenable", "=", (Object)"0"), new QFilter("role", "=", (Object)roleId)});
            if (roleMemberRelats != null && roleMemberRelats.length > 0) {
                mustInput = true;
            }
            if (!mustInput && (dynaSchemeRoleCount = Arrays.stream(dynaSchemes = (helper = new HRBaseServiceHelper("hrcs_dynascheme")).query("roleentry.role", new QFilter[]{new QFilter("roleentry.customenable", "=", (Object)"0"), new QFilter("roleentry.role.id", "=", (Object)roleId)})).mapToLong(it -> it.getDynamicObjectCollection("roleentry").size()).sum()) > 0L) {
                mustInput = true;
            }
        }
        boolean result = true;
        int checkResult = 0;
        LOGGER.info("Pre check allHrBuCaMap:\u3010{}\u3011, assignedHrBuCaDim:\u3010{}\u3011, allowDataCustom\uff1a\u3010{}\u3011, mustInput: \u3010{}\u3011", new Object[]{allHrBuCaMap, assignedHrBuCaDim, allowDataCustom, mustInput});
        HashSet<String> legalDimGroup = new HashSet();
        if (null != controlMap) {
            legalDimGroup = controlMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("label")).map(entry -> ((Map)entry.getValue()).get("dimensionGroup").toString()).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
        }
        LOGGER.info("Legal dim group: {}.", legalDimGroup);
        for (Map.Entry<String, RoleDataPermModel> entry2 : permDataMap.entrySet()) {
            String hrBuCaFuncId = entry2.getKey();
            RoleDataPermModel roleDataPermModel = entry2.getValue();
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            Map<String, Map<String, Object>> assignDimMap = assignedHrBuCaDim.get(hrBuCaFuncId);
            Set dimIds = dimIdResults.getOrDefault(hrBuCaFuncId, new HashSet());
            boolean assignDimEmpty = CollectionUtils.isEmpty(assignDimMap);
            Map orgMap = roleDataPermModel.getOrgMap();
            boolean orgEmpty = CollectionUtils.isEmpty((Map)orgMap);
            boolean dimEmpty = RoleServiceHelper.checkDimHasNull(allHrBuCaMap, buCaFuncTipsSet, hrBuCaFuncId, dimGroupMap, assignDimMap, allowDataCustom, dimIds, legalDimGroup);
            LOGGER.info("Start check hrBuCaFuncId\u3010{}\u3011, roleDataPermModel\u3010{}\u3011, buCaFuncTipsSet\u3010{}\u3011, dimEmpty \u3010{}\u3011, assignDimMap \u3010{}\u3011, orgMap \u3010{}\u3011.", new Object[]{hrBuCaFuncId, roleDataPermModel, buCaFuncTipsSet, dimEmpty, assignDimMap, orgMap});
            if (!allowDataCustom || mustInput) {
                if (!assignDimEmpty && dimEmpty || orgEmpty) {
                    if (checkResult != 2) {
                        checkResult = 2;
                        result = false;
                    }
                    buCaFuncTipsSet.add((String)allHrBuCaMap.get(hrBuCaFuncId).get("name"));
                    continue;
                }
                if (checkResult == 2) continue;
                checkResult = 3;
                continue;
            }
            boolean dimAllEmpty = assignDimEmpty || RoleServiceHelper.checkDimAllEmpty(dimGroupMap);
            LOGGER.info("Current dim empty: {}", (Object)dimAllEmpty);
            int tempResult = 0;
            if (assignDimEmpty && orgEmpty || dimAllEmpty && orgEmpty) {
                if (checkResult == 0) {
                    checkResult = 1;
                } else if (checkResult == 2 || checkResult == 3) {
                    checkResult = 2;
                }
                tempResult = 1;
            } else if (!dimAllEmpty && !dimEmpty && !orgEmpty || assignDimEmpty && !orgEmpty) {
                if (checkResult == 0) {
                    checkResult = 3;
                } else if (checkResult == 2 || checkResult == 1) {
                    checkResult = 2;
                }
                tempResult = 3;
            } else {
                if (checkResult != 2) {
                    checkResult = 2;
                }
                tempResult = 2;
            }
            if (tempResult != 2 && tempResult != 1) continue;
            buCaFuncTipsSet.add((String)allHrBuCaMap.get(hrBuCaFuncId).get("name"));
        }
        if (!CollectionUtils.isEmpty((Collection)buCaFuncTipsSet) && showTips) {
            if (!allowDataCustom && (checkResult == 2 || checkResult == 1) || allowDataCustom && checkResult == 2) {
                String message = Joiner.on((String)"\uff0c").skipNulls().join((Iterable)buCaFuncTipsSet);
                processInfo.append(message).append(ResManager.loadKDString((String)"\u4e0b\u7684\u6570\u636e\u8303\u56f4\uff08\u5305\u542b\u7ec4\u7ec7\u8303\u56f4\u3001\u4e1a\u52a1\u6570\u636e\u8303\u56f4\uff09\u5f55\u5165\u4e0d\u5b8c\u6574", (String)"RoleServiceHelper_9", (String)HRMP_HRCS_BUSINESS, (Object[])new Object[0]));
                result = false;
            }
            if (confirmCallBackPlugin != null && processInfo.length() > 0) {
                if (!allowDataCustom || mustInput && allowDataCustom) {
                    formView.showErrorNotification(processInfo.toString());
                } else {
                    formView.showMessage(processInfo.append(ResManager.loadKDString((String)"\uff1b\u8bf7\u8865\u5145\u5b8c\u6574\uff0c\u6216\u8005\u6e05\u7a7a\u5df2\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"SaveRoleServiceHelper_0", (String)HRMP_HRCS_BUSINESS, (Object[])new Object[0])).toString());
                    return true;
                }
            }
        }
        return !result;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean checkDimAllEmpty(Map<String, DimGrpModel> dimGroupMap) {
        for (Map.Entry<String, DimGrpModel> dimGrpEntry : dimGroupMap.entrySet()) {
            DimGrpModel dimGrpModel = dimGrpEntry.getValue();
            TreeMap dimMap = dimGrpModel.getDimMap();
            for (Map.Entry dimEntry : dimMap.entrySet()) {
                DimModel dimModel = (DimModel)dimEntry.getValue();
                Map dimValues = dimModel.getDimValues();
                String limit = dimModel.getLimit();
                String dimNumber = dimModel.getDimNumber();
                if (HRStringUtils.equals((String)dimNumber, (String)"adminorg") && !CollectionUtils.isEmpty((Map)dimValues)) {
                    return false;
                }
                if (CollectionUtils.isEmpty((Map)dimValues) && !HRStringUtils.equals((String)"1", (String)limit)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkDimHasNull(Map<String, Map<String, Object>> allHrBuCaMap, Set<String> buCaFuncTipsSet, String hrBuCaFuncId, Map<String, DimGrpModel> dimGroupMap, Map<String, Map<String, Object>> assignDimMap, boolean allowDataCustom, Set<String> dimIds, Set<String> legalDimGroup) {
        boolean result = RoleServiceHelper.checkDim(dimGroupMap, assignDimMap, allowDataCustom, dimIds, legalDimGroup);
        if (result) {
            buCaFuncTipsSet.add((String)allHrBuCaMap.get(hrBuCaFuncId).get("name"));
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    private static boolean checkDim(Map<String, DimGrpModel> dimGroupMap, Map<String, Map<String, Object>> assignDimMap, boolean allowDataCustom, Set<String> dimIds, Set<String> legalDimGroup) {
        LOGGER.info("Check dim start. allowDataCustom: {}, dimGroupMap: {}, assignDimMap: {}", new Object[]{allowDataCustom, dimGroupMap, assignDimMap});
        if (!allowDataCustom && CollectionUtils.isEmpty(dimGroupMap) && !CollectionUtils.isEmpty(assignDimMap)) {
            return true;
        }
        for (Map.Entry<String, DimGrpModel> dimGrpEntry : dimGroupMap.entrySet()) {
            LOGGER.info("Check dim: {}.", dimGrpEntry);
            DimGrpModel dimGrpModel = dimGrpEntry.getValue();
            String dimGroup = dimGrpEntry.getKey();
            if (null != legalDimGroup && !legalDimGroup.isEmpty() && HRStringUtils.isNotEmpty((String)dimGroup) && !legalDimGroup.contains(dimGroup)) continue;
            TreeMap dimMap = dimGrpModel.getDimMap();
            if (CollectionUtils.isEmpty((Map)dimMap)) {
                return true;
            }
            for (Map.Entry dimEntry : dimMap.entrySet()) {
                DimModel dimModel = (DimModel)dimEntry.getValue();
                String dimId = dimModel.getDimId();
                if (HRStringUtils.isNotEmpty((String)dimId) && null != assignDimMap && !assignDimMap.containsKey(dimId)) {
                    LOGGER.info("Ignore dimension[{}] for mismatch between db and page.", (Object)dimId);
                    continue;
                }
                if (!dimIds.isEmpty() && !dimIds.contains(dimId)) continue;
                Map dimValues = dimModel.getDimValues();
                String limit = dimModel.getLimit();
                String dimNumber = dimModel.getDimNumber();
                if (HRStringUtils.equals((String)dimNumber, (String)"adminorg") && CollectionUtils.isEmpty((Map)dimValues)) {
                    return true;
                }
                if (!CollectionUtils.isEmpty((Map)dimValues) || HRStringUtils.equals((String)"1", (String)limit)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setAssignedAppEntity(Set<String> appIds, Map<String, Map<String, String>> nodeMap, PermPageCacheUtil permPageCacheUtil) {
        HashMap appEntityMap = Maps.newHashMapWithExpectedSize((int)appIds.size());
        appIds.forEach(appId -> {
            String appKey = appId + "#app";
            Map entityMap = (Map)nodeMap.get(appKey);
            if (CollectionUtils.isEmpty((Map)entityMap)) {
                return;
            }
            List entityList = entityMap.keySet().stream().map(key -> key.substring(key.indexOf(124) + 1, key.indexOf(64))).collect(Collectors.toList());
            appEntityMap.put(appId, entityList);
        });
        permPageCacheUtil.setAssignedAppEntity(appEntityMap);
    }

    public static void showMember(IFormView formView) {
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(formView.getPageCache());
        IDataModel model = formView.getModel();
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)3);
        Object roleId = formView.getFormShowParameter().getCustomParam("roleId");
        String viewStus = formView.getPageCache().get("viewStatus");
        customParams.put("viewStatus", viewStus);
        customParams.put("roleId", roleId);
        customParams.put("roleProperty", model.getValue("roleproperty"));
        customParams.put("isIntersection", model.getValue("rolecbisintersection"));
        customParams.put("assignedEntityBuCaFuncMap", permPageCacheUtil.getAssignedEntityBuCaFuncMap());
        DimensionHelper.showFormInContainer(formView, "hrcs_rolememassign", "memberpanel", customParams);
    }

    public static void fillCloudEntryCard(IFormView formView, Map<String, Set<String>> cloudBuCaFunc, PermPageCacheUtil permPageCacheUtil, Map<String, Map<String, String>> parentNodeMap) {
        List<String> cloudSeq = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        Map<String, Map<String, Object>> allHrBuCaMap = permPageCacheUtil.getAllHrBuCaMap();
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<div class=\"maincontainer\">");
        for (String cloudId : cloudSeq) {
            Set<String> infos = cloudBuCaFunc.get(cloudId);
            if (infos == null) continue;
            ArrayList buCaFuncNames = new ArrayList(16);
            infos.forEach(buCaFuncId -> {
                Map buCaFuncInfo = (Map)allHrBuCaMap.get(buCaFuncId);
                buCaFuncNames.add((String)buCaFuncInfo.get("name"));
            });
            Map<String, String> nodeInfo = parentNodeMap.get(cloudId + "#cloud");
            htmlBuilder.append("<h2 class=\"cloudname\">").append(nodeInfo.get("name")).append("</h2>");
            htmlBuilder.append("<p class=\"hrbucatips\"  style=\"padding-bottom:16px\">").append(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u901a\u7684\u4e1a\u52a1\u8303\u56f4\u4e2d\u5305\u542b\uff0c\u9700\u5728\u3010\u6570\u636e\u6388\u6743\u8303\u56f4\u3011\u914d\u7f6e\u4ee5\u4e0b\u804c\u80fd\u7c7b\u578b\u7684\u7ec4\u7ec7\u6570\u636e\u8303\u56f4\uff0c\u5305\u62ec\uff1a", (String)"RoleServiceHelper_10", (String)HRMP_HRCS_BUSINESS, (Object[])new Object[0])).append(String.join((CharSequence)",", buCaFuncNames)).append("</p>");
        }
        htmlBuilder.append("</div>");
        Html cloudContainer = (Html)formView.getControl("cloudcontainer");
        cloudContainer.setConent(htmlBuilder.toString());
    }

    public static FieldTip showValidatTip(IFormView formView, boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
            formView.showTipNotification(msg);
        }
        return fieldTip;
    }

    public static void loadRoleFieldPerm(IFormView formView, String roleId) {
        String currentCacheJson = formView.getPageCache().get("originFieldCache");
        if (HRStringUtils.isNotEmpty((String)currentCacheJson)) {
            return;
        }
        Map<String, UserRoleFieldPermInfo> roleFieldPermInfoFromData = HRListFieldPermServiceHelper.getRoleFieldPermInfoFromDatabase(null, null, roleId);
        formView.getPageCache().put("originFieldCache", SerializationUtils.toJsonString(roleFieldPermInfoFromData));
        formView.getPageCache().put("fieldPermCache", SerializationUtils.toJsonString(roleFieldPermInfoFromData));
    }

    public static Map<String, String> getEntityFieldMap(String entityNum) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        ChoiceFieldPageCustomQueryService choiceFieldPageCustomQueryService = new ChoiceFieldPageCustomQueryService();
        List<Map<String, String>> propertyList = choiceFieldPageCustomQueryService.parseProperty((IDataEntityType)mainEntityType);
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)propertyList.size());
        propertyList.forEach(tempMap -> {
            String cfr_ignored_0 = (String)fieldMap.put(tempMap.get("field_id"), tempMap.get("field_name"));
        });
        return fieldMap;
    }

    public static void initRoleTypeMulCombo(IFormView formView) {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)"bos_usertype", (String)"id,name", (QFilter[])filters, (String)"ispreset desc,number");
        if (typeList == null || typeList.size() == 0) {
            return;
        }
        ComboEdit userTypeField = (ComboEdit)formView.getControl("roletype");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(typeList.size());
        for (DynamicObject typeDyo : typeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(typeDyo.getString("id"));
            comboItem.setValue(typeDyo.getString("id"));
            comboItem.setCaption(new LocaleString(typeDyo.getString("name")));
            propertyItems.add(comboItem);
        }
        userTypeField.setComboItems(propertyItems);
    }

    public static String getComboValue(String ctrlId, IFormView formView) {
        Object value = formView.getModel().getValue(ctrlId);
        String keyName = "";
        if (Objects.isNull(value) || HRStringUtils.isEmpty((String)((String)value))) {
            return keyName;
        }
        ComboEdit comboEdit = (ComboEdit)formView.getControl(ctrlId);
        ComboProp prop = (ComboProp)comboEdit.getProperty();
        List comboItems = prop.getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            if (!HRStringUtils.equals((String)comboItem.getValue(), (String)((String)value))) continue;
            keyName = comboItem.getName().toString();
            break;
        }
        return keyName;
    }

    public static boolean handleLock(String pkId, String entityName, IFormView view, String operationKey, String msg) {
        StringBuilder errMsg = new StringBuilder();
        boolean result = MutexHelper.require((IFormView)view, (String)entityName, (Object)pkId, (String)operationKey, (boolean)true, (StringBuilder)errMsg);
        if (!result) {
            view.showTipNotification(msg);
        }
        return result;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getUserName() {
        DataMutex dataMutex = DataMutex.create();
        Map lockInfo = dataMutex.getLockInfo();
        String userIdStr = (String)lockInfo.get("userid");
        long userId = Long.parseLong(userIdStr);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
        Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
        DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
        return userObj.getString("name");
    }

    public static DynamicObject getAppName(String bizAppId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)"bos_devportal_bizapp", (String)"id,number,name");
        return obj;
    }

    public static DynamicObjectCollection getAllBusinessName(Set<String> numbers) {
        HRBaseServiceHelper formmeta = new HRBaseServiceHelper("bos_formmeta");
        return formmeta.queryOriginalCollection("id,number,name", new QFilter[]{new QFilter("number", "in", numbers)});
    }

    public static DynamicObject[] getUserDataRule(String relatid, String entityType) {
        HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        DynamicObject[] query = userDataRuleHelper.query("id,dataruleentry,dataruleentry.permitem,permitem.datarule", new QFilter[]{new QFilter("userrolerelate", "=", (Object)Long.parseLong(relatid)), new QFilter("entitytype", "=", (Object)entityType)});
        return query;
    }

    public static DynamicObject[] getRoleDataRule(String roleId, String entityType) {
        HRBaseServiceHelper roleDataRuleHelper = new HRBaseServiceHelper("hrcs_roledatarule");
        DynamicObject[] query = roleDataRuleHelper.query("id,roledataruleentry,hrcs_rolebdruleentry,roledataruleentry.permitem,roledataruleentry.datarule,hrcs_rolebdruleentry.propkey,hrcs_rolebdruleentry.bddatarule,hrcs_rolebdruleentry.propentnum", new QFilter[]{new QFilter("role", "=", (Object)roleId), new QFilter("entitytype", "=", (Object)entityType)});
        return query;
    }

    public static void setInitCheckBoxView(IFormView view) {
        String viewStatus = (String)view.getFormShowParameter().getCustomParam("viewStatus");
        if (viewStatus == null || viewStatus.equals("0")) {
            return;
        }
        view.getModel().setValue("alerdysetcheckbox", (Object)true);
        view.getModel().setValue("showrelate", (Object)true);
        view.setEnable(Boolean.valueOf(false), new String[]{"alerdysetcheckbox", "showrelate"});
    }
}

