/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.common.model.PermImportModel;
import kd.hr.hrcs.common.model.SyncAssignLicenseModel;

public class SyncAssignLicenseHelper {
    public static List<SyncAssignLicenseModel> getSyncModel(List<PermImportModel> data) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        HashMap role2UserIds = Maps.newHashMapWithExpectedSize((int)16);
        HashMap role2AppEntities = Maps.newHashMapWithExpectedSize((int)16);
        data.forEach(da -> {
            String roleId = da.getRoleId();
            Set userIds = role2UserIds.getOrDefault(roleId, Sets.newHashSetWithExpectedSize((int)16));
            userIds.add(da.getUserId());
            role2UserIds.put(roleId, userIds);
            Map app2EntityIds = role2AppEntities.getOrDefault(roleId, Maps.newHashMapWithExpectedSize((int)16));
            List entityIds = app2EntityIds.getOrDefault(da.getAppId(), Lists.newArrayListWithExpectedSize((int)16));
            if (!entityIds.contains(da.getEntityNumber())) {
                entityIds.add(da.getEntityNumber());
            }
            app2EntityIds.put(da.getAppId(), entityIds);
            role2AppEntities.put(da.getRoleId(), app2EntityIds);
        });
        ArrayList models = Lists.newArrayListWithCapacity((int)role2UserIds.size());
        role2AppEntities.forEach((roleId, app2Entities) -> {
            SyncAssignLicenseModel model = new SyncAssignLicenseModel();
            model.setRoleId(roleId).setUserIds(new ArrayList((Collection)role2UserIds.get(roleId))).setAppEntity(app2Entities);
            models.add(model);
        });
        return models;
    }

    public static Map<String, List<Long>> getRoleUserMap(List<String> roleIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_userrole");
        DynamicObjectCollection userRoleCol = helper.queryOriginalCollection("role.id, user.id", new QFilter[]{new QFilter("role", "in", roleIdList)});
        return userRoleCol.stream().collect(Collectors.groupingBy(dy -> dy.getString("role.id"), Collectors.mapping(dy -> dy.getLong("user.id"), Collectors.toList())));
    }
}

