/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dyna;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.extpoint.permission.role.ISchemeParamRuleCustomFilterPlugin;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.role.HRRolePermHelper;
import kd.hr.hrcs.common.model.perm.EnumInfo;
import kd.hr.hrcs.common.model.perm.PermConditionInfo;
import kd.hr.hrcs.common.model.perm.PermRuleConditionInfo;

@ExcludeFromJacocoGeneratedReport
public class DynaAuthSchemeServiceHelper
implements ISchemeParamRuleCustomFilterPlugin {
    private static final Log LOGGER = LogFactory.getLog(DynaAuthSchemeServiceHelper.class);

    public static void showAdminRangeDetail(Object schemeId, IFormView formView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("hrcs_dynashemeassign");
        long schemeBoid = DynaAuthSchemeServiceHelper.querySchemeBoid(schemeId);
        showParameter.setCustomParam("authSchemeId", (Object)schemeBoid);
        formView.showForm(showParameter);
    }

    public static long querySchemeBoid(Object schemeId) {
        HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        DynamicObject schemeBoid = schemeHelper.queryOne("boid", schemeId);
        return schemeBoid.getLong("boid");
    }

    public static Set<Long> queryViewableSchemes() {
        Map<Long, String> userAdminGroupInfos = HRRolePermHelper.queryUserAdminGroupInfos(RequestContext.get().getCurrUserId());
        Set<Long> affSchemeIds = DynaAuthSchemeServiceHelper.queryOperationalSchemes(userAdminGroupInfos);
        DynaAuthSchemeServiceHelper.queryAssignSchemes(affSchemeIds, Sets.newHashSet(userAdminGroupInfos.values()));
        return affSchemeIds;
    }

    public static Set<Long> queryOperationalSchemes() {
        Map<Long, String> userAdminGroupInfos = HRRolePermHelper.queryUserAdminGroupInfos(RequestContext.get().getCurrUserId());
        return DynaAuthSchemeServiceHelper.queryOperationalSchemes(userAdminGroupInfos);
    }

    public static Set<Long> queryOperationalSchemes(Map<Long, String> userAdminGroupInfos) {
        HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        QFilter affiliationFilter = new QFilter("admingroup", "in", userAdminGroupInfos.keySet());
        List topAdminGroups = userAdminGroupInfos.values().stream().filter(it -> it.split("\\.").length <= 2).collect(Collectors.toList());
        QFilter topAdminGrpFilter = null;
        for (String topAdminGroup : topAdminGroups) {
            if (null == topAdminGrpFilter) {
                topAdminGrpFilter = new QFilter("admingroup.longnumber", "like", (Object)(topAdminGroup + "%"));
                continue;
            }
            topAdminGrpFilter = topAdminGrpFilter.or(new QFilter("admingroup.longnumber", "like", (Object)(topAdminGroup + "%")));
        }
        QFilter filter = null == topAdminGrpFilter ? affiliationFilter : affiliationFilter.or(topAdminGrpFilter);
        DynamicObjectCollection collection = schemeHelper.queryOriginalCollection("boid", new QFilter[]{filter});
        return collection.stream().map(it -> it.getLong("boid")).collect(Collectors.toSet());
    }

    public static void queryAssignSchemes(Set<Long> affSchemeIds, Set<String> groupNums) {
        DynamicObject[] schemeRangeArr;
        HRBaseServiceHelper schemeRangeHelper = new HRBaseServiceHelper("hrcs_dynaschemerange");
        QFilter affSchemeFilter = new QFilter("scheme", "not in", affSchemeIds);
        for (DynamicObject schemeRange : schemeRangeArr = schemeRangeHelper.queryOriginalArray("scheme,admingroup.longnumber,includesub", new QFilter[]{affSchemeFilter})) {
            long schemeId = schemeRange.getLong("scheme");
            if (affSchemeIds.contains(schemeId)) continue;
            boolean includeSub = schemeRange.getBoolean("includesub");
            String adminGroupLongNum = schemeRange.getString("admingroup.longnumber");
            boolean hasRight = includeSub ? groupNums.stream().anyMatch(it -> it.startsWith(adminGroupLongNum)) : groupNums.stream().anyMatch(it -> it.equals(adminGroupLongNum));
            if (!hasRight) continue;
            affSchemeIds.add(schemeId);
        }
    }

    public static List<PermConditionInfo> computeSceneIntersection(IFormView formView) {
        boolean initSourceIntersection;
        DynamicObject dataEntity = formView.getModel().getDataEntity(true);
        String authAction = dataEntity.getString("authaction");
        Set assignSceneIds = dataEntity.getDynamicObjectCollection("assignsceneentry").stream().map(it -> it.getLong("assignscene.id")).collect(Collectors.toSet());
        Set<Object> allSceneIds = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.equals((String)"1", (String)authAction)) {
            allSceneIds = assignSceneIds;
            initSourceIntersection = false;
        } else if (HRStringUtils.equals((String)"2", (String)authAction)) {
            initSourceIntersection = true;
        } else {
            allSceneIds = assignSceneIds;
            initSourceIntersection = true;
        }
        return DynaAuthSchemeServiceHelper.queryDyanRuleParams(allSceneIds, initSourceIntersection);
    }

    private static List<PermConditionInfo> queryDyanRuleParams(Set<Long> sceneIds, boolean initSourceIntersection) {
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        QFilter filter = new QFilter("id", "in", sceneIds);
        List<Long> msgPublisherIds = sceneHelper.queryOriginalCollection("msgpublisher.id", new QFilter[]{filter}).stream().map(it -> it.getLong("msgpublisher.id")).collect(Collectors.toList());
        LOGGER.info("DynaAuthSchemeServiceHelper#queryDyanRuleParams sceneIds: {}, msgPublisherIds: {}, initSourceIntersection: {}.", new Object[]{sceneIds, msgPublisherIds, initSourceIntersection});
        return DynaAuthSchemeServiceHelper.queryDyanRuleParams(msgPublisherIds, initSourceIntersection);
    }

    private static List<PermConditionInfo> queryDyanRuleParams(List<Long> msgPublisherIds, boolean containsCancel) {
        DynamicObject[] personParamArr;
        HRBaseServiceHelper dsHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        QFilter dsFilter = new QFilter("msgpublisher", "in", msgPublisherIds).and("enable", "=", (Object)"1");
        if (containsCancel) {
            dsFilter = dsFilter.or(new QFilter("iscancelds", "=", (Object)Boolean.TRUE).and("enable", "=", (Object)"1"));
        }
        if ((personParamArr = dsHelper.query("paramentry.ruleparam", new QFilter[]{dsFilter})).length <= 0) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        List commonRuleParamList = personParamArr[0].getDynamicObjectCollection("paramentry").stream().map(it -> it.getLong("ruleparam.id")).collect(Collectors.toList());
        for (int index = 1; index < personParamArr.length; ++index) {
            List finalCommonRuleParamList = commonRuleParamList;
            commonRuleParamList = personParamArr[index].getDynamicObjectCollection("paramentry").stream().map(it -> it.getLong("ruleparam.id")).filter(finalCommonRuleParamList::contains).collect(Collectors.toList());
        }
        LOGGER.info("DynaAuthSchemeServiceHelper#queryDyanRuleParams personParamArr size: {}, commonRuleParamList: {}.", (Object)personParamArr.length, commonRuleParamList);
        HRBaseServiceHelper paramHelper = new HRBaseServiceHelper("hrcs_dynaruleparam");
        QFilter unrelatedParamFilter = new QFilter("id", "in", commonRuleParamList);
        QFilter relateParamFilter = new QFilter("isrelatparam", "=", (Object)Boolean.TRUE).and("relatruleparam.id", "in", commonRuleParamList);
        DynamicObject[] ruleParams = paramHelper.query("id,number,name,datatype,entitytype.id,entryentity.value,entryentity.displayvalue", new QFilter[]{unrelatedParamFilter.or(relateParamFilter)}, "number asc");
        ArrayList permConditionInfoList = Lists.newArrayListWithExpectedSize((int)ruleParams.length);
        for (DynamicObject ruleParam : ruleParams) {
            String datatype = ruleParam.getString("datatype");
            String number = ruleParam.getString("number");
            PermConditionInfo permConditionInfo = new PermConditionInfo(ruleParam.getLong("id"), ruleParam.getString("name"), ruleParam.getString("number"), datatype);
            if (HRStringUtils.equals((String)"bd", (String)datatype) || HRStringUtils.equals((String)"org", (String)datatype)) {
                permConditionInfo.setBaseDataNumber(ruleParam.getString("entitytype.id"));
                HRPluginProxy proxy = new HRPluginProxy((Object)new DynaAuthSchemeServiceHelper(), ISchemeParamRuleCustomFilterPlugin.class, "kd.hr.hbp.business.extpoint.permission.role.ISchemeParamRuleCustomFilterPlugin", null);
                List list = proxy.callReplace(p -> p.addParamRuleF7ValueCustomFilters());
                ArrayList qFilterList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Map stringQFilterMap = (Map)iterator.next();
                        if (stringQFilterMap == null || !stringQFilterMap.containsKey(number) || stringQFilterMap.get(number) == null) continue;
                        qFilterList.add(stringQFilterMap.get(number));
                    }
                }
                permConditionInfo.setFilters(SerializationUtils.toJsonString(qFilterList));
            } else if (HRStringUtils.equals((String)"enum", (String)datatype)) {
                ArrayList enumList = Lists.newArrayListWithCapacity((int)10);
                for (DynamicObject dy : ruleParam.getDynamicObjectCollection("entryentity")) {
                    String comboTitle = dy.getString("displayvalue");
                    String comboValue = dy.getString("value");
                    EnumInfo info = new EnumInfo(comboTitle, comboValue);
                    enumList.add(info);
                }
                HRPluginProxy proxy = new HRPluginProxy((Object)new DynaAuthSchemeServiceHelper(), ISchemeParamRuleCustomFilterPlugin.class, "kd.hr.hbp.business.extpoint.permission.role.ISchemeParamRuleCustomFilterPlugin", null);
                List mulEnumMap = proxy.callAfter(p -> p.addParamRuleEnumValueCustomFilters());
                Set set = enumList.stream().map(enumInfo -> enumInfo.getValue()).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty((Collection)mulEnumMap)) {
                    for (Map stringListMap : mulEnumMap) {
                        if (stringListMap == null || !stringListMap.containsKey(number)) continue;
                        List list = (List)stringListMap.get(number);
                        set.retainAll(list);
                    }
                }
                ArrayList faEnumList = Lists.newArrayListWithCapacity((int)set.size());
                for (EnumInfo enumInfo2 : enumList) {
                    if (!set.contains(enumInfo2.getValue())) continue;
                    faEnumList.add(enumInfo2);
                }
                permConditionInfo.setEnumInfos((List)faEnumList);
            } else if (HRStringUtils.equals((String)"org", (String)datatype)) {
                permConditionInfo.setBaseDataNumber("haos_adminorghr");
            }
            permConditionInfoList.add(permConditionInfo);
        }
        return permConditionInfoList;
    }

    public static void resolveRuleConfigToSearch(IFormView formView) {
        String allRuleConfigStr = formView.getPageCache().get("allruleconfig");
        PermRuleConditionInfo permRuleConditionInfo = (PermRuleConditionInfo)JSONArray.parseObject((String)allRuleConfigStr, PermRuleConditionInfo.class);
        List allRuleConfig = permRuleConditionInfo.getConditionList();
        HashSet paramIds = Sets.newHashSetWithExpectedSize((int)allRuleConfig.size());
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet labTypeIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet stdPosIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet jobIds = Sets.newHashSetWithExpectedSize((int)16);
        for (PermConditionInfo permConditionInfo : allRuleConfig) {
            List ids;
            paramIds.add(Long.parseLong(permConditionInfo.getParam()));
            String paramType = DynaAuthSchemeServiceHelper.getParamType(permConditionInfo);
            String valueStr = permConditionInfo.getValue();
            if (HRStringUtils.isEmpty((String)valueStr)) continue;
            String[] values = valueStr.split(",");
            if (HRStringUtils.equals((String)"org", (String)paramType)) {
                ids = Arrays.stream(values).map(Long::parseLong).collect(Collectors.toList());
                adminOrgIds.addAll(ids);
                continue;
            }
            if (!HRStringUtils.equals((String)"bd", (String)paramType)) continue;
            ids = Arrays.stream(values).map(Long::parseLong).collect(Collectors.toList());
            String baseDataNumber = permConditionInfo.getBaseDataNumber();
            if (HRStringUtils.equals((String)"hbpm_positionhr", (String)baseDataNumber)) {
                positionIds.addAll(ids);
                continue;
            }
            if (HRStringUtils.equals((String)"hbss_laborreltype", (String)baseDataNumber)) {
                labTypeIds.addAll(ids);
                continue;
            }
            if (HRStringUtils.equals((String)"hbpm_stposition", (String)baseDataNumber)) {
                stdPosIds.addAll(ids);
                continue;
            }
            if (!HRStringUtils.equals((String)"hbjm_jobhr", (String)baseDataNumber)) continue;
            jobIds.addAll(ids);
        }
        IDataModel model = formView.getModel();
        model.setValue("search_param", (Object)paramIds.toArray(new Object[0]));
        model.setValue("search_adminorg", (Object)adminOrgIds.toArray(new Object[0]));
        model.setValue("search_pos", (Object)positionIds.toArray(new Object[0]));
        model.setValue("search_labtype", (Object)labTypeIds.toArray(new Object[0]));
        model.setValue("search_stdpos", (Object)stdPosIds.toArray(new Object[0]));
        model.setValue("search_job", (Object)jobIds.toArray(new Object[0]));
    }

    public static void resolveSceneToSearch(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        List<Object> assignSceneList = dataEntity.getDynamicObjectCollection("assignsceneentry").stream().map(it -> it.getLong("assignscene.id")).collect(Collectors.toList());
        List<Object> cancelSceneList = dataEntity.getDynamicObjectCollection("cancelsceneentry").stream().map(it -> it.getLong("cancelscene.id")).collect(Collectors.toList());
        String authAction = dataEntity.getString("authaction");
        if (HRStringUtils.equals((String)"1", (String)authAction)) {
            view.getModel().setValue("search_assignscene", (Object)assignSceneList.toArray(new Object[0]));
        } else if (HRStringUtils.equals((String)"2", (String)authAction)) {
            view.getModel().setValue("search_cancelscene", (Object)cancelSceneList.toArray(new Object[0]));
        } else {
            view.getModel().setValue("search_assignscene", (Object)assignSceneList.toArray(new Object[0]));
            view.getModel().setValue("search_cancelscene", (Object)cancelSceneList.toArray(new Object[0]));
        }
    }

    public Map<String, QFilter> addParamRuleF7ValueCustomFilters() {
        return null;
    }

    public Map<String, List<String>> addParamRuleEnumValueCustomFilters() {
        return null;
    }

    private static String getParamType(PermConditionInfo permConditionInfo) {
        if ("string".equals(permConditionInfo.getParamType()) && "mul_enum".equals(permConditionInfo.getValueDataType())) {
            return "enum";
        }
        if ("boolean".equals(permConditionInfo.getParamType())) {
            return "boolean";
        }
        if ("dynamicObject".equals(permConditionInfo.getParamType())) {
            if ("haos_adminorghr".equals(permConditionInfo.getBaseDataNumber())) {
                return "org";
            }
            return "bd";
        }
        return permConditionInfo.getParamType();
    }

    public static void showRoleDetails(String roleId, String roleName, IFormView formView, Boolean isView) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_modifyrole");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPageId("role-hypelink-" + roleId);
        parameter.setCustomParam("roleId", (Object)roleId);
        parameter.setCaption(roleName);
        if (isView.booleanValue()) {
            parameter.setCustomParam("notShowModifyButton", (Object)"1");
        }
        formView.showForm(parameter);
    }

    public static void showChangeTips(IFormView formView, long boid) {
        HRBaseServiceHelper userRoleRelateHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        boolean exists = userRoleRelateHelper.isExists(new QFilter[]{new QFilter("sourcetype", "=", (Object)"4"), new QFilter("scheme.boid", "=", (Object)boid)});
        if (exists) {
            formView.showConfirm(ResManager.loadKDString((String)"\u672c\u6b21\u4fee\u6539\u4e0d\u5f71\u54cd\u5df2\u5206\u914d\u7684\u8bb0\u5f55\uff0c\u5982\u9700\u66f4\u6539\u7528\u6237\u6743\u9650\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u5206\u914d\u8bb0\u5f55\u8fdb\u884c\u53d6\u6d88\u3002", (String)"DynaAuthSchemeServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), MessageBoxOptions.Toast);
        }
    }
}

