/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dyna.RuleParamApplyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.PublishEventDataSourceHelper;
import kd.hr.hrcs.common.constants.perm.HRDynaPermConst;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class DynaDataSourceServiceHelper
implements HRDynaPermConst {
    private static final Log LOGGER = LogFactory.getLog(DynaDataSourceServiceHelper.class);
    private static HRBaseServiceHelper HRCS_DYNAPUBLISHERDS = new HRBaseServiceHelper("hrcs_dynapublisherds");
    private static HRBaseServiceHelper HRCS_DYNADATASOURCE = new HRBaseServiceHelper("hrcs_dynadatasource");

    public static ArrayList<DynamicObject> getPublishEvenSourceList(Long publishEvenId) {
        DynamicObject[] dynamicObjects;
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : dynamicObjects = HRCS_DYNAPUBLISHERDS.loadDynamicObjectArray(new QFilter[0])) {
            DynamicObjectCollection publishEvents = dynamicObject.getDynamicObjectCollection("msgpublishers");
            if (CollectionUtils.isEmpty((Collection)publishEvents)) {
                objects.add(dynamicObject);
                continue;
            }
            List publishEventIds = publishEvents.stream().map(publishEventSource -> publishEventSource.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            if (!publishEventIds.contains(publishEvenId)) continue;
            objects.add(dynamicObject);
        }
        return objects;
    }

    public static List<TreeNodeItem> getTreeNodeItemList(ArrayList<DynamicObject> publishEventSourceList, boolean hasBusinessEntity) {
        List<Long> apiSourceIds;
        DynamicObject[] apiFieldByPatch;
        ArrayList nodes = Lists.newArrayListWithExpectedSize((int)16);
        if (hasBusinessEntity) {
            DynaDataSourceServiceHelper.getEntityTreeNode(publishEventSourceList, nodes);
        }
        List subMessageList = publishEventSourceList.stream().filter(publishEventSource -> {
            String sourceString = publishEventSource.getString("sourceclassify");
            DynamicObjectCollection msgPublish = publishEventSource.getDynamicObjectCollection("msgpublishers");
            return HRStringUtils.equals((String)"2", (String)sourceString) && !CollectionUtils.isEmpty((Collection)msgPublish);
        }).collect(Collectors.toList());
        List subMessageEmptyList = publishEventSourceList.stream().filter(publishEventSource -> {
            String sourceString = publishEventSource.getString("sourceclassify");
            DynamicObjectCollection msgPublish = publishEventSource.getDynamicObjectCollection("msgpublishers");
            return HRStringUtils.equals((String)"2", (String)sourceString) && CollectionUtils.isEmpty((Collection)msgPublish);
        }).collect(Collectors.toList());
        List<Long> subApiSourceIds = subMessageList.stream().map(dynamicObject -> dynamicObject.getDynamicObject("apisource") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("apisource").getPkValue()).collect(Collectors.toList());
        DynamicObject[] subaApiFieldByPatch = PublishEventDataSourceHelper.getAPIFieldByPatch(subApiSourceIds);
        if (subaApiFieldByPatch != null && subaApiFieldByPatch.length > 0) {
            Map<Long, List<DynamicObject>> subCollect = Arrays.stream(subaApiFieldByPatch).collect(Collectors.groupingBy(dynamicObject -> (Long)dynamicObject.getPkValue()));
            for (DynamicObject dynamicObject2 : subMessageList) {
                DynaDataSourceServiceHelper.getApiTreeNode(nodes, dynamicObject2, subCollect);
            }
        }
        if ((apiFieldByPatch = PublishEventDataSourceHelper.getAPIFieldByPatch(apiSourceIds = subMessageEmptyList.stream().map(dynamicObject -> dynamicObject.getDynamicObject("apisource") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("apisource").getPkValue()).collect(Collectors.toList()))) != null && apiFieldByPatch.length > 0) {
            Map<Long, List<DynamicObject>> collect = Arrays.stream(apiFieldByPatch).collect(Collectors.groupingBy(dynamicObject -> (Long)dynamicObject.getPkValue()));
            for (DynamicObject dynamicObject3 : subMessageEmptyList) {
                DynaDataSourceServiceHelper.getApiTreeNode(nodes, dynamicObject3, collect);
            }
        }
        if (hasBusinessEntity) {
            DynaDataSourceServiceHelper.getDefaultApiTreeNode(nodes, INVOKE_SOURCE_API);
        }
        return nodes;
    }

    private static void getEntityTreeNode(ArrayList<DynamicObject> publishEventSourceList, List<TreeNodeItem> nodes) {
        List businessPubList = publishEventSourceList.stream().filter(publishEventSource -> {
            String sourceString = publishEventSource.getString("sourceclassify");
            return HRStringUtils.equals((String)"1", (String)sourceString);
        }).collect(Collectors.toList());
        for (DynamicObject dynamicObject : businessPubList) {
            DynamicObject entityDy = dynamicObject.getDynamicObject("entitytype");
            String number = entityDy.getString("number");
            String name = dynamicObject.getLocaleString("name").getLocaleValue();
            String pbulishEventSourceId = dynamicObject.getPkValue().toString();
            pbulishEventSourceId = "id" + pbulishEventSourceId;
            TreeNodeItem treeNodeItem = new TreeNodeItem("businessCategory", pbulishEventSourceId, "", name);
            nodes.add(treeNodeItem);
            String entityNum = entityDy.getString("number");
            ArrayList<Map<String, String>> fieldCloumnByFormNumber = DynaDataSourceServiceHelper.getFieldCloumnByFormNumber(entityNum);
            for (Map<String, String> fieldMap : fieldCloumnByFormNumber) {
                String fieldNumber = fieldMap.get("number");
                String fieldName = fieldMap.get("name");
                String fieldType = fieldMap.get("type");
                String entityNumber = fieldMap.get("entityNumber");
                String nodeId = pbulishEventSourceId + "_" + fieldNumber;
                if ("enum".equals(fieldType)) {
                    CalItem fieldNodeItem = new CalItem("fieldCategory", nodeId, pbulishEventSourceId, fieldName, nodeId, DataTypeEnum.TEXT);
                    fieldNodeItem.setItemType(CalItemTypeEnum.ENUM);
                    fieldNodeItem.setPropertyField(fieldNumber);
                    fieldNodeItem.setEntityNumber(number);
                    nodes.add((TreeNodeItem)fieldNodeItem);
                    continue;
                }
                DataTypeEnum dataTypeEnum = DynaDataSourceServiceHelper.getDataTypeEnum(fieldType);
                if (dataTypeEnum == null) continue;
                CalItem fieldNodeItem = new CalItem("fieldCategory", nodeId, pbulishEventSourceId, fieldName, nodeId, dataTypeEnum);
                if (DataTypeEnum.BASE.equals((Object)dataTypeEnum)) {
                    fieldNodeItem.setEntityNumber(entityNumber);
                    fieldNodeItem.setItemType(CalItemTypeEnum.BASE_DATA);
                    if (DynaDataSourceServiceHelper.isContainName(entityDy)) {
                        fieldNodeItem.setPropertyField("name");
                    }
                }
                nodes.add((TreeNodeItem)fieldNodeItem);
            }
        }
    }

    private static boolean isContainName(DynamicObject entityDy) {
        DynamicObject toObj = BusinessDataServiceHelper.newDynamicObject((String)entityDy.getString("number"));
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        for (IDataEntityProperty toPro : toPros) {
            if (!HRStringUtils.equals((String)toPro.getName(), (String)"name")) continue;
            return true;
        }
        return false;
    }

    public static DataTypeEnum getDataTypeEnum(String type) {
        if (DataTypeEnum.BASE.getCode().equals(type)) {
            return DataTypeEnum.BASE;
        }
        if (DataTypeEnum.NUM.getCode().equals(type)) {
            return DataTypeEnum.NUM;
        }
        if (DataTypeEnum.TEXT.getCode().equals(type)) {
            return DataTypeEnum.TEXT;
        }
        if (DataTypeEnum.BOOLEAN.getCode().equals(type)) {
            return DataTypeEnum.BOOLEAN;
        }
        if (DataTypeEnum.INT.getCode().equals(type)) {
            return DataTypeEnum.INT;
        }
        if (DataTypeEnum.DATE.getCode().equals(type)) {
            return DataTypeEnum.DATE;
        }
        if (DataTypeEnum.DATETIME.getCode().equals(type)) {
            return DataTypeEnum.DATETIME;
        }
        return null;
    }

    private static void getApiTreeNode(List<TreeNodeItem> nodes, DynamicObject dynamicObject, Map<Long, List<DynamicObject>> collect) {
        block4: {
            String type;
            String publishEvenSourcetId;
            DynamicObject apiSource;
            block3: {
                String name = dynamicObject.getLocaleString("name").getLocaleValue();
                apiSource = dynamicObject.getDynamicObject("apisource");
                if (apiSource == null) {
                    return;
                }
                publishEvenSourcetId = dynamicObject.getPkValue().toString();
                publishEvenSourcetId = "id" + publishEvenSourcetId;
                TreeNodeItem treeNodeItem = new TreeNodeItem("apiCategory", publishEvenSourcetId, "", name);
                nodes.add(treeNodeItem);
                type = apiSource.getString("type");
                if (!HRStringUtils.equals((String)"1", (String)type)) break block3;
                List<Map<String, Object>> list = DynaDataSourceServiceHelper.getConfigApiEntryListByBatch(apiSource, true, collect);
                for (Map<String, Object> fieldMap : list) {
                    String apiFieldType = (String)fieldMap.get("apifieldtype");
                    String fieldKey = (String)fieldMap.get("apifieldkey");
                    String entity = (String)fieldMap.get("queryfieldentity");
                    String fieldKey$ = entity + "$" + fieldKey.replace(".", "$");
                    String nodeId = publishEvenSourcetId + "_" + fieldKey$;
                    DataTypeEnum dataTypeEnum = DynaDataSourceServiceHelper.fieldType2DataTypeEnum(apiFieldType);
                    CalItem fieldNodeItem = new CalItem("apiOutParamCategory", nodeId, publishEvenSourcetId, (String)fieldMap.get("apifieldname"), nodeId, dataTypeEnum);
                    nodes.add((TreeNodeItem)fieldNodeItem);
                }
                break block4;
            }
            if (!HRStringUtils.equals((String)"2", (String)type)) break block4;
            List<Map<String, Object>> customApiEntryList = DynaDataSourceServiceHelper.getCustomApiEntryListByBatch(apiSource, collect);
            for (Map<String, Object> stringObjectMap : customApiEntryList) {
                String apiFieldType = (String)stringObjectMap.get("outputfieldtype");
                DataTypeEnum dataTypeEnum = DynaDataSourceServiceHelper.fieldType2DataTypeEnum(apiFieldType);
                String fieldKey = (String)stringObjectMap.get("outputfieldkey");
                String fieldKey$ = fieldKey.replace(".", "$");
                String nodeId = publishEvenSourcetId + "_" + fieldKey$;
                CalItem fieldNodeItem = new CalItem("apiOutParamCategory", nodeId, publishEvenSourcetId, (String)stringObjectMap.get("outputfieldname"), nodeId, dataTypeEnum);
                nodes.add((TreeNodeItem)fieldNodeItem);
            }
        }
    }

    public static DataTypeEnum fieldType2DataTypeEnum(String apiFieldType) {
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"java.lang.String", "String", "string"})) {
            return DataTypeEnum.TEXT;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"java.lang.Long", "Long", "long"})) {
            return DataTypeEnum.NUM;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"java.lang.Integer", "Integer", "int"})) {
            return DataTypeEnum.INT;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"java.math.BigDecimal", "BigDecimal", "bigdecimal", "java.lang.Double", "Double", "double"})) {
            return DataTypeEnum.NUM;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"java.lang.Boolean", "Boolean", "boolean"})) {
            return DataTypeEnum.BOOLEAN;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"java.util.Date", "Date", "date"})) {
            return DataTypeEnum.DATETIME;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"DynamicObject", "dynamicObject"})) {
            return DataTypeEnum.BASE;
        }
        if (StringUtils.equalsAny((CharSequence)apiFieldType, (CharSequence[])new CharSequence[]{"kd.bos.dataentity.entity.DynamicObject", "DynamicObject", "dynamicObject"})) {
            return DataTypeEnum.BASE;
        }
        return null;
    }

    public static List<Map<String, Object>> getConfigApiEntryList(DynamicObject apiSource, boolean allFlag) {
        DynamicObject mainEntityDy = apiSource.getDynamicObject("mainentity");
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        if (mainEntityDy == null) {
            return list;
        }
        String mainEntityNumber = mainEntityDy.getString("number");
        QueryEntityType queryEntityTpe = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        String mainEntityName = queryEntityTpe.getMainEntityType().getName();
        DynamicObjectCollection fieldCols = PublishEventDataSourceHelper.getAPIFields(Long.valueOf(apiSource.getPkValue().toString()));
        List queryFieldList = queryEntityTpe.getSelectFields();
        Map<String, String> allFieldType = PublishEventDataSourceHelper.getAllFieldType(queryEntityTpe);
        List<String> joinEntityList = PublishEventDataSourceHelper.getJoinEntityList(queryEntityTpe);
        for (QuerySelectField queryField : queryFieldList) {
            DynamicObject dy;
            String queryFieldEntity;
            String alias;
            String secondAlias = alias = queryField.getAlias();
            String displayName = queryField.getDisplayName();
            String secondDisplayName = queryField.getDisplayName();
            String fieldType = allFieldType.get(alias);
            String enablefield = "1";
            String isparam = "0";
            Object pkValue = null;
            if (HRStringUtils.isEmpty((String)fieldType) && allFieldType.get(alias + ".id") != null) {
                fieldType = "kd.bos.dataentity.entity.DynamicObject";
            }
            if (HRStringUtils.isEmpty((String)(queryFieldEntity = PublishEventDataSourceHelper.getFieldEntity(alias, joinEntityList)))) {
                queryFieldEntity = mainEntityName;
            }
            if ((dy = PublishEventDataSourceHelper.queryFiledByEntity(fieldCols, alias)) == null) continue;
            boolean isParam = dy.getBoolean("isparam1");
            if (!allFlag && !isParam) continue;
            secondAlias = dy.getString("apifieldkey1");
            secondDisplayName = dy.getString("apifieldname1");
            enablefield = dy.getString("enablefield1");
            isparam = dy.getString("isparam1");
            pkValue = dy.getPkValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("queryfield", alias);
            map.put("queryfieldname", displayName);
            map.put("queryfieldentity", queryFieldEntity);
            map.put("apifieldkey", secondAlias);
            map.put("apifieldname", secondDisplayName);
            map.put("apifieldtype", fieldType);
            map.put("enablefield", enablefield);
            map.put("isparam", isparam);
            map.put("inputparamentryid", pkValue);
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> getConfigApiEntryListByBatch(DynamicObject apiSource, boolean allFlag, Map<Long, List<DynamicObject>> collect) {
        DynamicObject mainEntityDy = apiSource.getDynamicObject("mainentity");
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        if (mainEntityDy == null) {
            return list;
        }
        String mainEntityNumber = mainEntityDy.getString("number");
        QueryEntityType queryEntityTpe = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)mainEntityNumber);
        String mainEntityName = queryEntityTpe.getMainEntityType().getName();
        List<DynamicObject> dynamicObjects = collect.get(Long.valueOf(apiSource.getPkValue().toString()));
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return list;
        }
        DynamicObjectCollection fieldCols = dynamicObjects.get(0).getDynamicObjectCollection("entryfield1");
        List queryFieldList = queryEntityTpe.getSelectFields();
        Map<String, String> allFieldType = PublishEventDataSourceHelper.getAllFieldType(queryEntityTpe);
        List<String> joinEntityList = PublishEventDataSourceHelper.getJoinEntityList(queryEntityTpe);
        for (QuerySelectField queryField : queryFieldList) {
            DynamicObject dy;
            String queryFieldEntity;
            String alias;
            String secondAlias = alias = queryField.getAlias();
            String displayName = queryField.getDisplayName();
            String secondDisplayName = queryField.getDisplayName();
            String fieldType = allFieldType.get(alias);
            String enablefield = "1";
            String isparam = "0";
            Object pkValue = null;
            if (HRStringUtils.isEmpty((String)fieldType) && allFieldType.get(alias + ".id") != null) {
                fieldType = "kd.bos.dataentity.entity.DynamicObject";
            }
            if (HRStringUtils.isEmpty((String)(queryFieldEntity = PublishEventDataSourceHelper.getFieldEntity(alias, joinEntityList)))) {
                queryFieldEntity = mainEntityName;
            }
            if ((dy = PublishEventDataSourceHelper.queryFiledByEntity(fieldCols, alias)) == null) continue;
            boolean isParam = dy.getBoolean("isparam1");
            if (!allFlag && !isParam) continue;
            secondAlias = dy.getString("apifieldkey1");
            secondDisplayName = dy.getString("apifieldname1");
            enablefield = dy.getString("enablefield1");
            isparam = dy.getString("isparam1");
            pkValue = dy.getPkValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("queryfield", alias);
            map.put("queryfieldname", displayName);
            map.put("queryfieldentity", queryFieldEntity);
            map.put("apifieldkey", secondAlias);
            map.put("apifieldname", secondDisplayName);
            map.put("apifieldtype", fieldType);
            map.put("enablefield", enablefield);
            map.put("isparam", isparam);
            map.put("inputparamentryid", pkValue);
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> getCustomApiEntryList(DynamicObject apiSource) {
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        DynamicObject apiDepoly = PublishEventDataSourceHelper.getAPIDepoly(apiSource.getPkValue());
        DynamicObjectCollection outputEntryEntity = apiDepoly.getDynamicObjectCollection("outputentryentity");
        for (DynamicObject outputParamDy : outputEntryEntity) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outputfieldkey", outputParamDy.getString("outputfieldkey"));
            map.put("outputfieldname", outputParamDy.getLocaleString("outputfieldname").getLocaleValue());
            map.put("outputfieldtype", outputParamDy.getString("outputfieldtype"));
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> getCustomApiEntryListByBatch(DynamicObject apiSource, Map<Long, List<DynamicObject>> collect) {
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        List<DynamicObject> dynamicObjects = collect.get(apiSource.getPkValue());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return list;
        }
        DynamicObject apiDepoly = dynamicObjects.get(0);
        DynamicObjectCollection outputEntryEntity = apiDepoly.getDynamicObjectCollection("outputentryentity");
        for (DynamicObject outputParamDy : outputEntryEntity) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("outputfieldkey", outputParamDy.getString("outputfieldkey"));
            map.put("outputfieldname", outputParamDy.getLocaleString("outputfieldname").getLocaleValue());
            map.put("outputfieldtype", outputParamDy.getString("outputfieldtype"));
            list.add(map);
        }
        return list;
    }

    public static DynamicObject queryOne(Long pkValue) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hrcs_dynaruleparam");
        DynamicObject dynamicObject = baseServiceHelper.queryOne((Object)pkValue);
        return dynamicObject;
    }

    public static ArrayList<Object> getBusEntityByPublishEvent(Long publishEvenId) {
        ArrayList entityIds = Lists.newArrayListWithCapacity((int)16);
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        DynamicObject[] dynamicObjects = HRCS_DYNAPUBLISHERDS.loadDynamicObjectArray(new QFilter[]{new QFilter("sourceclassify", "=", (Object)"1")});
        for (DynamicObject dynamicObject : dynamicObjects) {
            List publishEventIds;
            DynamicObjectCollection publishEvents = dynamicObject.getDynamicObjectCollection("msgpublishers");
            if (CollectionUtils.isEmpty((Collection)publishEvents) || !(publishEventIds = publishEvents.stream().map(publishEventSource -> publishEventSource.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())).contains(publishEvenId)) continue;
            objects.add(dynamicObject);
        }
        for (DynamicObject dynamicObject : objects) {
            DynamicObject entityDy = dynamicObject.getDynamicObject("entitytype");
            Object pkValue = entityDy.getPkValue();
            entityIds.add(pkValue);
        }
        return entityIds;
    }

    public static ArrayList<DynamicObject> getPublishEventDataSource(Long publishEvenId, String dataSource) {
        DynamicObject[] dynamicObjects;
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : dynamicObjects = HRCS_DYNAPUBLISHERDS.loadDynamicObjectArray(new QFilter[]{new QFilter("sourceclassify", "=", (Object)dataSource), new QFilter("enable", "=", (Object)"1")})) {
            DynamicObjectCollection publishEvents = dynamicObject.getDynamicObjectCollection("msgpublishers");
            if (CollectionUtils.isEmpty((Collection)publishEvents)) {
                objects.add(dynamicObject);
                continue;
            }
            List publishEventIds = publishEvents.stream().map(publishEventSource -> publishEventSource.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            if (!publishEventIds.contains(publishEvenId)) continue;
            objects.add(dynamicObject);
        }
        return objects;
    }

    public static ArrayList<Map<String, Object>> getApiOutFieldParam(Object apiId) {
        DynamicObject apiDepoly = PublishEventDataSourceHelper.getAPIDepoly(apiId);
        String type = apiDepoly.getString("type");
        ArrayList param = Lists.newArrayListWithCapacity((int)16);
        if (HRStringUtils.equals((String)"1", (String)type)) {
            List<Map<String, Object>> configApiEntryList = DynaDataSourceServiceHelper.getConfigApiEntryList(apiDepoly, true);
            for (Map<String, Object> stringObjectMap : configApiEntryList) {
                HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
                String queryFieldEntity = (String)stringObjectMap.get("queryfieldentity");
                objectObjectHashMap.put("fieldKey", queryFieldEntity + "." + stringObjectMap.get("apifieldkey"));
                objectObjectHashMap.put("fieldName", stringObjectMap.get("apifieldname"));
                param.add(objectObjectHashMap);
            }
        } else {
            DynamicObjectCollection dynamicObjectCollection = apiDepoly.getDynamicObjectCollection("outputentryentity");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
                objectObjectHashMap.put("fieldKey", dynamicObject.getString("outputfieldkey"));
                String outputfieldname = dynamicObject.getLocaleString("outputfieldname").toString();
                objectObjectHashMap.put("fieldName", outputfieldname == null ? dynamicObject.getString("outputfieldkey") : outputfieldname);
                param.add(objectObjectHashMap);
            }
        }
        return param;
    }

    public static String getOrgRootId() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("11");
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode.getId();
    }

    public static ArrayList<DynamicObject> getAllSubMsgPublishEventDataSource() {
        DynamicObject[] dynamicObjects;
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : dynamicObjects = HRCS_DYNAPUBLISHERDS.loadDynamicObjectArray(new QFilter[]{new QFilter("sourceclassify", "=", (Object)"2"), new QFilter("enable", "=", (Object)"1")})) {
            objects.add(dynamicObject);
        }
        return objects;
    }

    public static DynamicObject queryDataSourceById(Object id) {
        DynamicObject dynamicObject = HRCS_DYNADATASOURCE.queryOne(id);
        return dynamicObject;
    }

    public static void changeCancelSourceStatus(Object id) {
        DynamicObject[] iscancelds;
        for (DynamicObject iscanceld : iscancelds = HRCS_DYNADATASOURCE.query("enable", new QFilter[]{new QFilter("iscancelds", "=", (Object)"1"), new QFilter("id", "!=", id)})) {
            iscanceld.set("enable", (Object)"0");
        }
        HRCS_DYNADATASOURCE.update(iscancelds);
    }

    public static boolean getRuleParamReference(Long pkValue, Object ruleParamId, Object publishEvenId) {
        HRBaseServiceHelper dynaScenHelper = new HRBaseServiceHelper("hrcs_dynascene");
        DynamicObject dynaScene = dynaScenHelper.queryOne(new QFilter[]{new QFilter("msgpublisher", "=", publishEvenId), new QFilter("enable", "=", (Object)"1")});
        if (dynaScene == null) {
            LOGGER.info("getRuleParamReference dynaScene is null");
            return true;
        }
        boolean assignRuleParamReference = RuleParamApplyServiceHelper.getAssignRuleParamReference((Long)ruleParamId, (Long)dynaScene.getPkValue());
        return assignRuleParamReference;
    }

    public static boolean getCancelRuleParamReference(Long pkValue, Object ruleParamId) {
        boolean assignRuleParamReference = RuleParamApplyServiceHelper.getCancelRuleParamReference((Long)ruleParamId);
        return assignRuleParamReference;
    }

    public static ArrayList<String> checkRuleParamData(IFormView view) {
        ArrayList tipStringList = Lists.newArrayListWithCapacity((int)16);
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("paramentry");
        block0: for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject ruleParam = dynamicObject.getDynamicObject("ruleparam");
            String ruleParamName = "\u3010" + ruleParam.getLocaleString("name").toString() + "\u3011";
            String fetchMode = dynamicObject.getString("fetchmode");
            String fetchSource = dynamicObject.getString("fetchsource");
            if (HRStringUtils.equals((String)"1", (String)fetchMode)) {
                if (HRStringUtils.equals((String)"2", (String)fetchSource)) {
                    Object publisherds = dynamicObject.get("publisherds");
                    String paramProkey = dynamicObject.getString("param_propkey");
                    String paramProname = dynamicObject.getLocaleString("param_propname").toString();
                    if (publisherds != null && !HRStringUtils.isEmpty((String)paramProkey) && !HRStringUtils.isEmpty((String)paramProname)) continue;
                    tipStringList.add(ruleParamName);
                    continue;
                }
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("paramentitysubentry");
                for (DynamicObject object : dynamicObjectCollection) {
                    String propKey = object.getString("paramentity_propkey");
                    String propName = object.getLocaleString("paramentity_propname").toString();
                    if (!HRStringUtils.isEmpty((String)propKey) && !HRStringUtils.isEmpty((String)propName)) continue;
                    tipStringList.add(ruleParamName);
                    continue block0;
                }
                continue;
            }
            DynamicObject dynaFomulaId = dynamicObject.getDynamicObject("dynaformula");
            if (dynaFomulaId != null) continue;
            tipStringList.add(ruleParamName);
        }
        return tipStringList;
    }

    public static ArrayList<Object> queryDataSourceDynaFormula(Object id) {
        DynamicObject dynamicObject = HRCS_DYNADATASOURCE.queryOne(id);
        ArrayList objects = Lists.newArrayListWithCapacity((int)16);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("paramentry");
        for (DynamicObject object : dynamicObjectCollection) {
            DynamicObject dynaFormula = object.getDynamicObject("dynaformula");
            String fetchMode = object.getString("fetchmode");
            if (!"2".equals(fetchMode)) continue;
            objects.add(dynaFormula.getPkValue());
        }
        return objects;
    }

    private static void getDefaultApiTreeNode(List<TreeNodeItem> nodes, Long defaultApiId) {
        block4: {
            String type;
            String publishEvenSourcetId;
            DynamicObject apiSource;
            block3: {
                apiSource = PublishEventDataSourceHelper.getAPIDepoly(defaultApiId);
                if (apiSource == null) {
                    return;
                }
                publishEvenSourcetId = apiSource.getPkValue().toString();
                publishEvenSourcetId = "id" + publishEvenSourcetId;
                TreeNodeItem treeNodeItem = new TreeNodeItem("defaultApiCategory", publishEvenSourcetId, "", apiSource.getLocaleString("name").toString());
                nodes.add(treeNodeItem);
                type = apiSource.getString("type");
                if (!HRStringUtils.equals((String)"1", (String)type)) break block3;
                List<Map<String, Object>> list = DynaDataSourceServiceHelper.getConfigApiEntryList(apiSource, true);
                for (Map<String, Object> fieldMap : list) {
                    String apiFieldType = (String)fieldMap.get("apifieldtype");
                    String fieldKey = (String)fieldMap.get("apifieldkey");
                    String entity = (String)fieldMap.get("queryfieldentity");
                    String fieldKey$ = entity + "$" + fieldKey.replace(".", "$");
                    String nodeId = publishEvenSourcetId + "_" + fieldKey$;
                    DataTypeEnum dataTypeEnum = DynaDataSourceServiceHelper.fieldType2DataTypeEnum(apiFieldType);
                    CalItem fieldNodeItem = new CalItem("defaultApiOutParamCategory", nodeId, publishEvenSourcetId, (String)fieldMap.get("apifieldname"), nodeId, dataTypeEnum);
                    nodes.add((TreeNodeItem)fieldNodeItem);
                }
                break block4;
            }
            if (!HRStringUtils.equals((String)"2", (String)type)) break block4;
            List<Map<String, Object>> customApiEntryList = DynaDataSourceServiceHelper.getCustomApiEntryList(apiSource);
            for (Map<String, Object> stringObjectMap : customApiEntryList) {
                String apiFieldType = (String)stringObjectMap.get("outputfieldtype");
                DataTypeEnum dataTypeEnum = DynaDataSourceServiceHelper.fieldType2DataTypeEnum(apiFieldType);
                String fieldKey = (String)stringObjectMap.get("outputfieldkey");
                String fieldKey$ = fieldKey.replace(".", "$");
                String nodeId = publishEvenSourcetId + "_" + fieldKey$;
                CalItem fieldNodeItem = new CalItem("defaultApiOutParamCategory", nodeId, publishEvenSourcetId, (String)stringObjectMap.get("outputfieldname"), nodeId, dataTypeEnum);
                nodes.add((TreeNodeItem)fieldNodeItem);
            }
        }
    }

    public static ArrayList<Map<String, String>> getFieldCloumnByFormNumber(String formNumber) {
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            HashMap cloumnMap = Maps.newHashMapWithExpectedSize((int)16);
            String name = property.getName();
            String dataType = DynaDataSourceServiceHelper.getDataType(property);
            if (Objects.isNull(property.getDisplayName()) || HRStringUtils.isEmpty((String)property.getAlias())) continue;
            String localName = property.getDisplayName().getLocaleValue();
            if (property instanceof MulBasedataProp || property instanceof EntryProp) continue;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                String baseEntityId = basedataProp.getBaseEntityId();
                cloumnMap.put("number", name);
                cloumnMap.put("name", localName);
                cloumnMap.put("type", dataType);
                cloumnMap.put("entityNumber", baseEntityId);
            } else {
                cloumnMap.put("number", name);
                cloumnMap.put("name", localName);
                cloumnMap.put("type", dataType);
                cloumnMap.put("entityNumber", formNumber);
            }
            result.add(cloumnMap);
        }
        return result;
    }

    private static String getDataType(IDataEntityProperty property) {
        if (property instanceof BasedataProp) {
            return DataTypeEnum.BASE.getCode();
        }
        if (property instanceof LongProp || property instanceof BigIntProp || property instanceof DecimalProp) {
            return DataTypeEnum.NUM.getCode();
        }
        if (property instanceof TextProp || property instanceof TextAreaProp || property instanceof MuliLangTextProp) {
            return DataTypeEnum.TEXT.getCode();
        }
        if (property instanceof ComboProp) {
            return "enum";
        }
        if (property instanceof BooleanProp) {
            return DataTypeEnum.BOOLEAN.getCode();
        }
        if (property instanceof IntegerProp) {
            return DataTypeEnum.INT.getCode();
        }
        if (property instanceof DateProp) {
            return DataTypeEnum.DATE.getCode();
        }
        if (property instanceof DateTimeProp) {
            return DataTypeEnum.DATETIME.getCode();
        }
        if (property instanceof EntryProp) {
            return "entry";
        }
        return "";
    }

    public static DynamicObject queryDataSourceByNumber(String number) {
        DynamicObject dynamicObject = HRCS_DYNADATASOURCE.loadDynamicObject(new QFilter("number", "=", (Object)number));
        return dynamicObject;
    }
}

