/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.perm.DepInfo;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.SceneRoleInfo;
import kd.hr.hrcs.common.model.perm.SchemeInfo;
import kd.hr.hrcs.common.model.perm.dyna.AssignRecord;
import kd.hr.hrcs.common.model.perm.dyna.BdRule;
import kd.hr.hrcs.common.model.perm.dyna.DynDim;
import kd.hr.hrcs.common.model.perm.dyna.DynPermModel;
import kd.hr.hrcs.common.model.perm.dyna.DynUserDimModel;
import kd.hr.hrcs.common.model.perm.dyna.Field;
import kd.hr.hrcs.common.model.perm.dyna.Rule;
import kd.hr.hrcs.common.model.perm.dyna.SchemeDim;
import kd.hr.hrcs.common.model.perm.dyna.SchemeField;
import kd.hr.hrcs.common.model.perm.dyna.SchemeOrg;
import kd.hr.hrcs.common.model.perm.dyna.SchemeRule;
import kd.hr.hrcs.common.model.perm.dyna.UserRoleRelat2;
import kd.hr.hrcs.common.model.perminit.OrgRangeBean;

@ExcludeFromJacocoGeneratedReport
@Deprecated
public class DynaRoleService {
    private static final Log LOGGER = LogFactory.getLog(DynaRoleService.class);
    private static final HRBaseServiceHelper USER_ROLE_RELAT_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper USER_ROLE_HELPER = new HRBaseServiceHelper("hrcs_userrole");
    private static final HRBaseServiceHelper SYS_USER_ROLE_HELPER = new HRBaseServiceHelper("perm_userrole");
    private static final HRBaseServiceHelper PERM_FILE_HELPER = new HRBaseServiceHelper("hrcs_userpermfile");
    private static final HRBaseServiceHelper USER_ROLE_DIM_HELPER = new HRBaseServiceHelper("hrcs_userroledimgrp");
    private static final HRBaseServiceHelper USER_DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_userdatarule");
    private static final HRBaseServiceHelper USER_FIELD_HELPER = new HRBaseServiceHelper("hrcs_userfield");

    public Map<String, List<OrgRangeBean>> buildRoleOrgMap(List<String> roles) {
        DynamicObject[] roleBuDynaArr;
        HashMap roleOrgRangeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String it : roles) {
            roleOrgRangeMap.put(it, Lists.newArrayListWithExpectedSize((int)16));
        }
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        for (DynamicObject dy : roleBuDynaArr = roleBuHelper.queryOriginalArray("hrbucafunc,role,org.id,containssub", new QFilter[]{new QFilter("role", "in", roles)})) {
            OrgRangeBean orgRangeBean = new OrgRangeBean(Long.valueOf(dy.getLong("hrbucafunc")), Long.valueOf(dy.getLong("org.id")), Boolean.valueOf(dy.getBoolean("containssub")));
            ((List)roleOrgRangeMap.get(dy.getString("role"))).add(orgRangeBean);
        }
        return roleOrgRangeMap;
    }

    private Map<String, Long> buildUserRoleRelatIdMap(DynPermModel dynPermModel) {
        List userDimModels = dynPermModel.getUserDimModels();
        HashMap userRoleRelatIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynUserDimModel userDimModel : userDimModels) {
            String key = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getCustomEnable(), userDimModel.getRoleId());
            userRoleRelatIdMap.put(key, 0L);
        }
        int userRoleRelatIdx = 0;
        long[] relatIds = ORM.create().genLongIds("hrcs_userrolerelat", userRoleRelatIdMap.size());
        for (Map.Entry entry : userRoleRelatIdMap.entrySet()) {
            userRoleRelatIdMap.put(entry.getKey(), relatIds[userRoleRelatIdx]);
            ++userRoleRelatIdx;
        }
        return userRoleRelatIdMap;
    }

    private static Map<String, String> buildSysUserRoleIdMap(DynPermModel dynPermModel) {
        ArrayList sysUserRoleIdMapKeys = Lists.newArrayListWithExpectedSize((int)16);
        if (Objects.isNull(dynPermModel)) {
            LOGGER.info("buildSysUserRoleIdMap dynPermModel is null,return null map.");
            return Maps.newHashMap();
        }
        for (DynUserDimModel userDimModel : dynPermModel.getUserDimModels()) {
            if (Objects.isNull(userDimModel)) {
                LOGGER.info("buildSysUserRoleIdMap userDimModel is null,continue.");
                continue;
            }
            if (HRStringUtils.equals((String)userDimModel.getCustomEnable(), (String)"1")) {
                LOGGER.info("buildSysUserRoleIdMap role {} is customEnable", (Object)userDimModel.getRoleId());
                if (CollectionUtils.isEmpty((Collection)userDimModel.getRoleBuLst())) continue;
                for (SchemeOrg schemeOrg : userDimModel.getRoleBuLst()) {
                    String key = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getRoleId(), schemeOrg.getBuCaFunc(), schemeOrg.getOrgId());
                    sysUserRoleIdMapKeys.add(key);
                }
                continue;
            }
            List orgRangeBeans = (List)dynPermModel.getRoleOrgRangeMap().get(userDimModel.getRoleId());
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                String key = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getRoleId(), orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId());
                sysUserRoleIdMapKeys.add(key);
            }
        }
        HashMap sysUserRoleIdMap = Maps.newHashMapWithExpectedSize((int)sysUserRoleIdMapKeys.size());
        String[] ids = ORM.create().genStringIds("perm_userrole", sysUserRoleIdMapKeys.size());
        for (int idx = 0; idx < sysUserRoleIdMapKeys.size(); ++idx) {
            sysUserRoleIdMap.put(sysUserRoleIdMapKeys.get(idx), ids[idx]);
        }
        return sysUserRoleIdMap;
    }

    public void assignUserRole(DynPermModel dynPermModel) {
        LOGGER.info("EventPermService-assignUserRole assignUserRole entry,dynPermModel:{}", (Object)dynPermModel);
        Map<String, String> sysUserRoleIdMap = DynaRoleService.buildSysUserRoleIdMap(dynPermModel);
        dynPermModel.setSysUserRoleIdMap(sysUserRoleIdMap);
        LOGGER.info("EventPermService-assignUserRole sysUserRoleIdMap:{}", sysUserRoleIdMap);
        Map<String, Long> userRoleRelatIdMap = this.buildUserRoleRelatIdMap(dynPermModel);
        LOGGER.info("EventPermService-assignUserRole userRoleRelatIdMap:{}", userRoleRelatIdMap);
        DynamicObjectCollection userRoleRelatColl = this.buildUserRoleRelatDynaColl(dynPermModel, userRoleRelatIdMap);
        USER_ROLE_RELAT_HELPER.save(userRoleRelatColl);
        DynamicObjectCollection userRoleDynaColl = this.buildUserRoleDynaColl(dynPermModel, userRoleRelatIdMap);
        USER_ROLE_HELPER.save(userRoleDynaColl);
        DynamicObjectCollection userDimGroupDynaColl = this.buildUserDimGroupDynaColl(dynPermModel, userRoleRelatIdMap);
        USER_ROLE_DIM_HELPER.save(userDimGroupDynaColl);
        List<DynamicObject> userDataRuleDynaColl = this.buildUserDataRuleDynaColl(dynPermModel, userRoleRelatIdMap);
        USER_DATA_RULE_HELPER.save(userDataRuleDynaColl.toArray(new DynamicObject[0]));
        List<DynamicObject> userFieldDynaColl = this.buildUserFieldDynaColl(dynPermModel, userRoleRelatIdMap);
        USER_FIELD_HELPER.save(userFieldDynaColl.toArray(new DynamicObject[0]));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DynamicObjectCollection sysUserRoleDynaColl = this.buildSysUserRoleDynaColl(dynPermModel);
                SYS_USER_ROLE_HELPER.save(sysUserRoleDynaColl);
            }
            catch (Exception ex) {
                LOGGER.error("EventPermService-cancelUserRole sysUserRole rollback");
                txHandle.markRollback();
            }
        }
    }

    private List<DynamicObject> buildUserFieldDynaColl(DynPermModel dynPermModel, Map<String, Long> userRoleRelatIdMap) {
        List userFieldModelList = dynPermModel.getUserDimModels();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (DynUserDimModel userFieldModel : userFieldModelList) {
            List roleFieldLst = userFieldModel.getRoleFieldLst();
            if (CollectionUtils.isEmpty((Collection)roleFieldLst)) continue;
            for (SchemeField schemeField : roleFieldLst) {
                DynamicObject userFieldDyna = USER_FIELD_HELPER.generateEmptyDynamicObject();
                userFieldDyna.set("id", (Object)this.getId("hrcs_userfield"));
                String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userFieldModel.getRoleEntryId(), userFieldModel.getUserId(), userFieldModel.getFileId(), userFieldModel.getCustomEnable(), userFieldModel.getRoleId());
                Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
                userFieldDyna.set("userrolerealt", (Object)relatId);
                userFieldDyna.set("app", (Object)schemeField.getApp());
                userFieldDyna.set("entitytype", (Object)schemeField.getEntityType());
                PermInitServiceHelper.setOperatorAndDate(userFieldDyna);
                DynamicObjectCollection userFieldEntryColl = userFieldDyna.getDynamicObjectCollection("entryentity");
                for (Field field : schemeField.getFieldList()) {
                    DynamicObject userFieldEntryDyna = USER_FIELD_HELPER.generateEmptyEntryDynamicObject("entryentity");
                    userFieldEntryDyna.set("fieldname", (Object)field.getFieldProp());
                    userFieldEntryDyna.set("isbanread", (Object)field.isBanRead());
                    userFieldEntryDyna.set("isbanwrite", (Object)field.isBanWrite());
                    userFieldEntryColl.add((Object)userFieldEntryDyna);
                }
                userFieldDyna.set("entryentity", (Object)userFieldEntryColl);
                result.add(userFieldDyna);
            }
        }
        return result;
    }

    private List<DynamicObject> buildUserDataRuleDynaColl(DynPermModel dynPermModel, Map<String, Long> userRoleRelatIdMap) {
        List userDataRuleModelList = dynPermModel.getUserDimModels();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (DynUserDimModel userDataRuleModel : userDataRuleModelList) {
            List roleRuleLst = userDataRuleModel.getRoleRuleLst();
            if (CollectionUtils.isEmpty((Collection)roleRuleLst)) continue;
            for (SchemeRule schemeRule : roleRuleLst) {
                DynamicObject userDataRuleDyna = USER_DATA_RULE_HELPER.generateEmptyDynamicObject();
                userDataRuleDyna.set("id", (Object)this.getId("hrcs_userdatarule"));
                String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userDataRuleModel.getRoleEntryId(), userDataRuleModel.getUserId(), userDataRuleModel.getFileId(), userDataRuleModel.getCustomEnable(), userDataRuleModel.getRoleId());
                Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
                userDataRuleDyna.set("userrolerelate", (Object)relatId);
                userDataRuleDyna.set("app", (Object)schemeRule.getAppId());
                userDataRuleDyna.set("entitytype", (Object)schemeRule.getEntityNumber());
                this.setDataRuleOperatorAndDate(userDataRuleDyna);
                DynamicObjectCollection userDataRuleEntryColl = userDataRuleDyna.getDynamicObjectCollection("dataruleentry");
                for (Rule rule : schemeRule.getRuleList()) {
                    DynamicObject userDataRuleEntryDyna = USER_DATA_RULE_HELPER.generateEmptyEntryDynamicObject("dataruleentry");
                    userDataRuleEntryDyna.set("permitem", (Object)rule.getPermItemId());
                    userDataRuleEntryDyna.set("datarule", (Object)rule.getDataRule());
                    userDataRuleEntryColl.add((Object)userDataRuleEntryDyna);
                }
                userDataRuleDyna.set("dataruleentry", (Object)userDataRuleEntryColl);
                DynamicObjectCollection userBdDataRuleEntryColl = userDataRuleDyna.getDynamicObjectCollection("bddataruleentry");
                if (schemeRule.getBdRuleList() != null) {
                    for (BdRule bdRule : schemeRule.getBdRuleList()) {
                        DynamicObject userBdDataRuleEntryDyna = USER_DATA_RULE_HELPER.generateEmptyEntryDynamicObject("bddataruleentry");
                        userBdDataRuleEntryDyna.set("propkey", (Object)bdRule.getPropKey());
                        userBdDataRuleEntryDyna.set("propentnum", (Object)bdRule.getPropNum());
                        userBdDataRuleEntryDyna.set("bddatarule", (Object)bdRule.getDataRule());
                        userBdDataRuleEntryColl.add((Object)userBdDataRuleEntryDyna);
                    }
                }
                userDataRuleDyna.set("bddataruleentry", (Object)userBdDataRuleEntryColl);
                result.add(userDataRuleDyna);
            }
        }
        return result;
    }

    private void setDataRuleOperatorAndDate(DynamicObject dyna) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        dyna.set("createrfield", (Object)userId);
        dyna.set("createdatefield", (Object)now);
        dyna.set("modifierfield", (Object)userId);
        dyna.set("modifydatefield", (Object)now);
    }

    private DynamicObjectCollection buildUserDimGroupDynaColl(DynPermModel dynPermModel, Map<String, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userDimGroupDynaColl = new DynamicObjectCollection();
        List userDimModelList = dynPermModel.getUserDimModels();
        for (DynUserDimModel userDimModel : userDimModelList) {
            List roleDimLst = userDimModel.getRoleDimLst();
            if (CollectionUtils.isEmpty((Collection)roleDimLst)) continue;
            for (SchemeDim dim : roleDimLst) {
                DynamicObject userDimGroupDyna = USER_ROLE_DIM_HELPER.generateEmptyDynamicObject();
                userDimGroupDyna.set("id", (Object)this.getId("hrcs_userroledimgrp"));
                String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getCustomEnable(), userDimModel.getRoleId());
                Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
                userDimGroupDyna.set("userrolerelat", (Object)relatId);
                userDimGroupDyna.set("bucafunc", (Object)dim.getBuCaFunc());
                PermInitServiceHelper.setOperatorAndDate(userDimGroupDyna);
                DynamicObjectCollection userDimValEntryColl = USER_ROLE_DIM_HELPER.generateEmptyEntryCollection(userDimGroupDyna, "entry");
                for (DynDim dimValueBean : dim.getDimList()) {
                    DynamicObject userDimValEntryDyna = USER_ROLE_DIM_HELPER.generateEmptyEntryDynamicObject("entry");
                    userDimValEntryDyna.set("dimension", (Object)dimValueBean.getDimId());
                    userDimValEntryDyna.set("dimval", (Object)dimValueBean.getDimVal());
                    userDimValEntryDyna.set("isall", (Object)dimValueBean.isAll());
                    userDimValEntryDyna.set("containssub", (Object)dimValueBean.isContainsSub());
                    userDimValEntryDyna.set("admincontainssub", (Object)dimValueBean.isAdminContainsSub());
                    userDimValEntryDyna.set("structproject", (Object)dimValueBean.getStructProjectId());
                    userDimValEntryDyna.set("dynacond", (Object)dimValueBean.getDynaCondId());
                    userDimValEntryDyna.set("valtype", (Object)dimValueBean.getValType());
                    userDimValEntryColl.add((Object)userDimValEntryDyna);
                }
                userDimGroupDyna.set("entry", (Object)userDimValEntryColl);
                userDimGroupDynaColl.add((Object)userDimGroupDyna);
            }
        }
        return userDimGroupDynaColl;
    }

    private long getId(String hrcs_userroledimgrp) {
        return ORM.create().genLongId(hrcs_userroledimgrp);
    }

    private DynamicObjectCollection buildSysUserRoleDynaColl(DynPermModel dynPermModel) {
        List userDimModelList = dynPermModel.getUserDimModels();
        DynamicObjectCollection userRoleDynaColl = new DynamicObjectCollection();
        Map roleOrgRangeMap = dynPermModel.getRoleOrgRangeMap();
        Map sysUserRoleIdMap = dynPermModel.getSysUserRoleIdMap();
        for (DynUserDimModel userDimModel : userDimModelList) {
            if (HRStringUtils.equals((String)userDimModel.getCustomEnable(), (String)"1")) {
                LOGGER.info("customEnable");
                for (SchemeOrg schemeOrg : userDimModel.getRoleBuLst()) {
                    DynamicObject userRoleDyna = this.genSysUserRoleDyna(userDimModel, schemeOrg.getBuCaFunc(), schemeOrg.getOrgId(), schemeOrg.isIncludeSubOrg(), sysUserRoleIdMap);
                    userRoleDynaColl.add((Object)userRoleDyna);
                }
                continue;
            }
            List orgRangeBeans = (List)roleOrgRangeMap.get(userDimModel.getRoleId());
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                DynamicObject userRoleDyna = this.genSysUserRoleDyna(userDimModel, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId(), orgRangeBean.getIncludeSub(), sysUserRoleIdMap);
                userRoleDynaColl.add((Object)userRoleDyna);
            }
        }
        return userRoleDynaColl;
    }

    private DynamicObject genSysUserRoleDyna(DynUserDimModel userDimModel, Long bucaFuncId, Long orgId, Boolean includeSub, Map<String, String> sysUserRoleIdMap) {
        DynamicObject userRoleDyna = SYS_USER_ROLE_HELPER.generateEmptyDynamicObject();
        String idMapKey = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getRoleId(), bucaFuncId, orgId);
        userRoleDyna.set("id", (Object)sysUserRoleIdMap.get(idMapKey));
        userRoleDyna.set("user", (Object)userDimModel.getUserId());
        userRoleDyna.set("role", (Object)userDimModel.getRoleId());
        userRoleDyna.set("org", (Object)orgId);
        userRoleDyna.set("includesuborg", (Object)includeSub);
        userRoleDyna.set("source", (Object)"hr");
        userRoleDyna.set("dimtype", (Object)"bos_org");
        userRoleDyna.set("starttime", (Object)userDimModel.getValidStart());
        userRoleDyna.set("endtime", (Object)userDimModel.getValidEnd());
        return userRoleDyna;
    }

    public List<DynamicObject> getUpdateValidDate(List<DynamicObject> dys, Date startDate, Date endDate, Long schemeId, DynPermModel model, SceneRoleInfo sceneRoleInfo) {
        Date now = new Date();
        for (DynamicObject dy : dys) {
            Date validEnd = dy.getDate("validend");
            if (!HRDateTimeUtils.dayBefore((Date)validEnd, (Date)endDate)) continue;
            dy.set("validstart", (Object)startDate);
            dy.set("validend", (Object)endDate);
            dy.set("scheme", (Object)schemeId);
            dy.set("createtime", (Object)now);
            model.getApplyRd().getAssignRdList().add(this.getAssignRd(dy, schemeId, sceneRoleInfo, startDate, endDate));
            model.getApplyRd().getUserSet().add(dy.getLong("user.id"));
        }
        return dys;
    }

    private AssignRecord getAssignRd(DynamicObject dy, Long schemeId, SceneRoleInfo sceneRoleInfo, Date startDate, Date endDate) {
        AssignRecord assignRecord = new AssignRecord();
        assignRecord.setPermFile(Long.valueOf(dy.getLong("permfile.id")));
        assignRecord.setSchemeId(schemeId);
        assignRecord.setRoleEntryId(sceneRoleInfo.getRoleEntryId());
        assignRecord.setValidStart(PermRoleUtil.formatStartDate(startDate));
        assignRecord.setValidEnd(PermRoleUtil.formatEndDate(endDate));
        assignRecord.setDealWay("2");
        assignRecord.setUserId(Long.valueOf(dy.getLong("user.id")));
        assignRecord.setRoleId(sceneRoleInfo.getRoleId());
        return assignRecord;
    }

    public List<DynamicObject> updateValidDate(List<DynamicObject> dys) {
        USER_ROLE_RELAT_HELPER.update(dys.toArray(new DynamicObject[0]));
        return dys;
    }

    private DynamicObjectCollection buildUserRoleDynaColl(DynPermModel dynPermModel, Map<String, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userRoleDynaColl = new DynamicObjectCollection();
        Map sysUserRoleIdMap = dynPermModel.getSysUserRoleIdMap();
        long[] hmpUserRoleIds = ORM.create().genLongIds("hrcs_userrole", sysUserRoleIdMap.size());
        HashMap hmpUserRoleIdMap = Maps.newHashMapWithExpectedSize((int)sysUserRoleIdMap.size());
        int sysUserRoleIdx = 0;
        for (Map.Entry entry : sysUserRoleIdMap.entrySet()) {
            hmpUserRoleIdMap.put(entry.getKey(), hmpUserRoleIds[sysUserRoleIdx]);
            ++sysUserRoleIdx;
        }
        List userDimModelList = dynPermModel.getUserDimModels();
        Map roleOrgRangeMap = dynPermModel.getRoleOrgRangeMap();
        for (DynUserDimModel userDimModel : userDimModelList) {
            if (HRStringUtils.equals((String)userDimModel.getCustomEnable(), (String)"1")) {
                LOGGER.info("customEnable");
                for (SchemeOrg schemeOrg : userDimModel.getRoleBuLst()) {
                    DynamicObject userRoleDyna = this.genUserRoleDyna(userDimModel, schemeOrg.getBuCaFunc(), schemeOrg.getOrgId(), schemeOrg.isIncludeSubOrg(), userRoleRelatIdMap, hmpUserRoleIdMap, sysUserRoleIdMap);
                    userRoleDynaColl.add((Object)userRoleDyna);
                }
                continue;
            }
            List orgRangeBeans = (List)roleOrgRangeMap.get(userDimModel.getRoleId());
            for (OrgRangeBean orgRangeBean : orgRangeBeans) {
                DynamicObject userRoleDyna = this.genUserRoleDyna(userDimModel, orgRangeBean.getBucaFuncId(), orgRangeBean.getOrgId(), orgRangeBean.getIncludeSub(), userRoleRelatIdMap, hmpUserRoleIdMap, sysUserRoleIdMap);
                userRoleDynaColl.add((Object)userRoleDyna);
            }
        }
        return userRoleDynaColl;
    }

    private DynamicObject genUserRoleDyna(DynUserDimModel userDimModel, Long bucaFuncId, Long orgId, Boolean includeSub, Map<String, Long> userRoleRelatIdMap, Map<String, Long> hmpUserRoleIdMap, Map<String, String> sysUserRoleIdMap) {
        DynamicObject userRoleDyna = USER_ROLE_HELPER.generateEmptyDynamicObject();
        String idMapKey = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getRoleId(), bucaFuncId, orgId);
        userRoleDyna.set("id", (Object)hmpUserRoleIdMap.get(idMapKey));
        userRoleDyna.set("org", (Object)orgId);
        userRoleDyna.set("includesuborg", (Object)includeSub);
        String userRoleRelatIdKey = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getCustomEnable(), userDimModel.getRoleId());
        Long relatId = userRoleRelatIdMap.get(userRoleRelatIdKey);
        userRoleDyna.set("userrolerealt", (Object)relatId);
        String sysUserRoleIdKey = PermInitServiceHelper.joinToKey(userDimModel.getRoleEntryId(), userDimModel.getUserId(), userDimModel.getFileId(), userDimModel.getRoleId(), bucaFuncId, orgId);
        String sysUserRoleId = sysUserRoleIdMap.get(sysUserRoleIdKey);
        userRoleDyna.set("userrolepf", (Object)sysUserRoleId);
        userRoleDyna.set("bucafunc", (Object)bucaFuncId);
        return userRoleDyna;
    }

    private DynamicObjectCollection buildUserRoleRelatDynaColl(DynPermModel dynPermModel, Map<String, Long> userRoleRelatIdMap) {
        DynamicObjectCollection userRoleRelatColl = new DynamicObjectCollection();
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)userRoleRelatIdMap.size());
        for (DynUserDimModel dynUserDimModel : dynPermModel.getUserDimModels()) {
            DynamicObject userRoleRelatDyna = USER_ROLE_RELAT_HELPER.generateEmptyDynamicObject();
            userRoleRelatColl.add((Object)userRoleRelatDyna);
            String relatIdKey = PermInitServiceHelper.joinToKey(dynUserDimModel.getRoleEntryId(), dynUserDimModel.getUserId(), dynUserDimModel.getFileId(), dynUserDimModel.getCustomEnable(), dynUserDimModel.getRoleId());
            Long id = userRoleRelatIdMap.get(relatIdKey);
            if (!idSet.add(id)) continue;
            userRoleRelatDyna.set("id", (Object)id);
            userRoleRelatDyna.set("permfile", (Object)dynUserDimModel.getFileId());
            userRoleRelatDyna.set("user", (Object)dynUserDimModel.getUserId());
            userRoleRelatDyna.set("role", (Object)dynUserDimModel.getRoleId());
            userRoleRelatDyna.set("customenable", (Object)dynUserDimModel.getCustomEnable());
            userRoleRelatDyna.set("sourcetype", (Object)"4");
            userRoleRelatDyna.set("validstart", (Object)dynUserDimModel.getValidStart());
            userRoleRelatDyna.set("validend", (Object)dynUserDimModel.getValidEnd());
            userRoleRelatDyna.set("scheme", (Object)dynUserDimModel.getSchemeId());
            PermInitServiceHelper.setOperatorAndDate(userRoleRelatDyna);
            userRoleRelatDyna.set("creator", (Object)0);
        }
        return userRoleRelatColl;
    }

    public Set<UserRoleRelat2> getPermFileForDel(Set<PersonInfo> memberSet, Boolean containManualAssign) {
        DynamicObject[] permFileDys;
        HashSet userIdSet = Sets.newHashSetWithExpectedSize((int)memberSet.size());
        HashSet buIdSet = Sets.newHashSetWithExpectedSize((int)memberSet.size());
        for (PersonInfo personInfo : memberSet) {
            userIdSet.add(personInfo.getUserId());
            if (personInfo.getDepSet() == null) continue;
            buIdSet.addAll(personInfo.getDepSet().stream().map(DepInfo::getBuId).collect(Collectors.toSet()));
        }
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("user.id", "in", (Object)userIdSet)});
        if (buIdSet.size() > 0) {
            qFilters.add(new QFilter("org.id", "in", (Object)buIdSet));
        }
        if ((permFileDys = PERM_FILE_HELPER.query("id", HRPermCommonUtil.listToQFilters((List)qFilters))) == null) {
            return Sets.newHashSet();
        }
        Set permFileIds = Arrays.stream(permFileDys).map(dyna -> dyna.getLong("id")).collect(Collectors.toSet());
        QFilter notManualQfilter = null;
        if (!containManualAssign.booleanValue()) {
            notManualQfilter = new QFilter("scheme.id", "!=", (Object)0L);
        }
        DynamicObject[] userRoleRelatDynaArr = USER_ROLE_RELAT_HELPER.queryOriginalArray("id,role.id,permfile.id,assigntype,user.id", new QFilter[]{new QFilter("permfile.id", "in", permFileIds), notManualQfilter});
        HashSet permFileSet = Sets.newHashSetWithExpectedSize((int)memberSet.size());
        for (DynamicObject relatDyna : userRoleRelatDynaArr) {
            UserRoleRelat2 userRoleRelat = new UserRoleRelat2();
            userRoleRelat.setId(Long.valueOf(relatDyna.getLong("id")));
            userRoleRelat.setRoleId(relatDyna.getString("role.id"));
            userRoleRelat.setFileId(Long.valueOf(relatDyna.getLong("permfile.id")));
            userRoleRelat.setUserId(Long.valueOf(relatDyna.getLong("user.id")));
            userRoleRelat.setAssignType(relatDyna.getString("assigntype"));
            permFileSet.add(userRoleRelat);
        }
        return permFileSet;
    }

    public void cancelUserRole(Set<Long> relatIdSet) {
        LOGGER.info("EventPermService-cancelUserRole ,relatIdSet:{}", relatIdSet);
        if (CollectionUtils.isEmpty(relatIdSet)) {
            LOGGER.info("EventPermService-cancelUserRole relatIdSet is empty,code return");
            return;
        }
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        HRBaseServiceHelper userRoleRelHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        HRBaseServiceHelper sysUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        DynamicObject[] userRoleRelDys = userRoleHelper.queryOriginalArray("id,userrolepf.id,userrolerealt", new QFilter[]{new QFilter("userrolerealt", "in", relatIdSet)});
        HashSet sysRelIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dy : userRoleRelDys) {
            sysRelIdSet.add(dy.getString("userrolepf.id"));
        }
        userRoleRelHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", relatIdSet)});
        userRoleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerealt", "in", relatIdSet)});
        ruleHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelate", "in", relatIdSet)});
        dimHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerelat", "in", relatIdSet)});
        fieldHelper.deleteByFilter(new QFilter[]{new QFilter("userrolerealt", "in", relatIdSet)});
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                sysUserRoleHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", (Object)sysRelIdSet)});
            }
            catch (Exception ex) {
                LOGGER.error("EventPermService-cancelUserRole sysUserRole rollback");
                txHandle.markRollback();
            }
        }
    }

    public void assignSchemeRoleDataRange(Set<SchemeInfo> matchAssignIdSet) {
        matchAssignIdSet.removeIf(it -> CollectionUtils.isEmpty((Collection)it.getRoleList()));
        HashSet entryIdSet = Sets.newHashSetWithExpectedSize((int)matchAssignIdSet.size());
        for (SchemeInfo sc : matchAssignIdSet) {
            for (SceneRoleInfo src : sc.getRoleList()) {
                entryIdSet.add(src.getRoleEntryId());
            }
        }
        if (entryIdSet.size() == 0) {
            return;
        }
        HRBaseServiceHelper buHelper = new HRBaseServiceHelper("hrcs_dynaschemeorg");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_dynaschemedatarule");
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dynaschemedimgrp");
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_dynaschemefield");
        DynamicObject[] buDys = buHelper.query("bucafunc,org,includesuborg,roleentryid,role,scheme", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet)});
        DynamicObject[] ruleDys = ruleHelper.query("scheme,role,app,entitytype,bucafunc,roleentryid,dataruleentry.permitem,dataruleentry.datarule,hrcs_rolebdruleentry.propkey,hrcs_rolebdruleentry.propentnum,hrcs_rolebdruleentry.bddatarule", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet)});
        DynamicObject[] dimDys = dimHelper.query("scheme,role,bucafunc,roleentryid,dimvalentry.dimension,dimvalentry.isall,dimvalentry.structproject,dimvalentry.admincontainssub,dimvalentry.containssub,dimvalentry.dimval,dimvalentry.valtype,dimvalentry.dynacond", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet)});
        DynamicObject[] fieldDys = fieldHelper.query("scheme,role,app,entitytype,roleentryid,fieldpermentry.fieldname,fieldpermentry.isbanread,fieldpermentry.isbanwrite", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("roleentryid", "in", (Object)entryIdSet)});
        List<SchemeOrg> roleBuLst = null;
        if (buDys != null && buDys.length > 0) {
            roleBuLst = this.getRoleBu(buDys);
        }
        List<SchemeRule> roleRuleLst = null;
        if (ruleDys != null && ruleDys.length > 0) {
            roleRuleLst = this.getRoleDataRule(ruleDys);
        }
        List<SchemeDim> roleDimLst = null;
        if (dimDys != null && dimDys.length > 0) {
            roleDimLst = this.getRoleDim(dimDys);
        }
        List<SchemeField> roleFieldLst = null;
        if (fieldDys != null && fieldDys.length > 0) {
            roleFieldLst = this.getRoleField(fieldDys);
        }
        for (SchemeInfo sc : matchAssignIdSet) {
            for (SceneRoleInfo scr : sc.getRoleList()) {
                this.setRoleBu(scr, roleBuLst);
                this.setRoleDr(scr, roleRuleLst);
                this.setRoleDim(scr, roleDimLst);
                this.setRoleField(scr, roleFieldLst);
            }
        }
    }

    private void setRoleField(SceneRoleInfo scr, List<SchemeField> roleFieldLst) {
        if (roleFieldLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleField = roleFieldLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleFieldLst(roleField);
    }

    private void setRoleDim(SceneRoleInfo scr, List<SchemeDim> roleDimLst) {
        if (roleDimLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleDim = roleDimLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleDimLst(roleDim);
    }

    private void setRoleDr(SceneRoleInfo scr, List<SchemeRule> roleRuleLst) {
        if (roleRuleLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleDr = roleRuleLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleRuleLst(roleDr);
    }

    private void setRoleBu(SceneRoleInfo scr, List<SchemeOrg> roleBuLst) {
        if (roleBuLst == null) {
            return;
        }
        String roleId = scr.getRoleId();
        Long roleEntryId = scr.getRoleEntryId();
        List roleBu = roleBuLst.stream().filter(it -> HRStringUtils.equals((String)roleId, (String)it.getRoleId()) && roleEntryId.equals(it.getRoleEntryId())).collect(Collectors.toList());
        scr.setRoleBuLst(roleBu);
    }

    private List<SchemeField> getRoleField(DynamicObject[] fieldDys) {
        ArrayList roleFieldLst = Lists.newArrayListWithExpectedSize((int)fieldDys.length);
        for (DynamicObject dy : fieldDys) {
            SchemeField schemeField = new SchemeField();
            Long scheme = dy.getLong("scheme.id");
            String app = dy.getString("app.id");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            String entityType = dy.getString("entitytype.id");
            schemeField.setApp(app);
            schemeField.setScheme(scheme);
            schemeField.setRoleId(role);
            schemeField.setRoleEntryId(roleEntryId);
            schemeField.setEntityType(entityType);
            DynamicObjectCollection fieldEntry = dy.getDynamicObjectCollection("fieldpermentry");
            if (!fieldEntry.isEmpty()) {
                ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)fieldEntry.size());
                for (DynamicObject fieldDy : fieldEntry) {
                    Field field = new Field();
                    String fieldName = fieldDy.getString("fieldname");
                    boolean isBanRead = fieldDy.getBoolean("isbanread");
                    boolean isBanWrite = fieldDy.getBoolean("isbanwrite");
                    field.setBanRead(isBanRead);
                    field.setBanWrite(isBanWrite);
                    field.setFieldProp(fieldName);
                    fieldList.add(field);
                }
                schemeField.setFieldList((List)fieldList);
            }
            roleFieldLst.add(schemeField);
        }
        return roleFieldLst;
    }

    private List<SchemeDim> getRoleDim(DynamicObject[] dimDys) {
        ArrayList roleDimLst = Lists.newArrayListWithExpectedSize((int)dimDys.length);
        for (DynamicObject dy : dimDys) {
            SchemeDim schemeDim = new SchemeDim();
            Long scheme = dy.getLong("scheme.id");
            Long buCaFunc = dy.getLong("bucafunc.id");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            schemeDim.setScheme(scheme);
            schemeDim.setBuCaFunc(buCaFunc);
            schemeDim.setRoleEntryId(roleEntryId);
            schemeDim.setRoleId(role);
            DynamicObjectCollection dimEntry = dy.getDynamicObjectCollection("dimvalentry");
            if (!dimEntry.isEmpty()) {
                ArrayList dimList = Lists.newArrayListWithExpectedSize((int)dimEntry.size());
                for (DynamicObject dimDy : dimEntry) {
                    DynDim dim = new DynDim();
                    Long dimension = dimDy.getLong("dimension.id");
                    boolean isAll = dimDy.getBoolean("isall");
                    Long structProject = dimDy.getLong("structproject.id");
                    boolean adminContainsSub = dimDy.getBoolean("admincontainssub");
                    boolean containsSub = dimDy.getBoolean("containssub");
                    String dimVal = dimDy.getString("dimval");
                    String valType = dimDy.getString("valtype");
                    Long dynaCond = dimDy.getLong("dynacond.id");
                    dim.setDimId(dimension);
                    dim.setAll(isAll);
                    dim.setAdminContainsSub(adminContainsSub);
                    dim.setStructProjectId(structProject);
                    dim.setContainsSub(containsSub);
                    dim.setDimVal(dimVal);
                    dim.setValType(valType);
                    dim.setDynaCondId(dynaCond);
                    dimList.add(dim);
                }
                schemeDim.setDimList((List)dimList);
            }
            roleDimLst.add(schemeDim);
        }
        return roleDimLst;
    }

    private List<SchemeRule> getRoleDataRule(DynamicObject[] ruleDys) {
        ArrayList roleRuleLst = Lists.newArrayListWithExpectedSize((int)ruleDys.length);
        for (DynamicObject dy : ruleDys) {
            DynamicObjectCollection bdRuleEntry;
            SchemeRule schemeRule = new SchemeRule();
            Long scheme = dy.getLong("scheme.id");
            Long buCaFunc = dy.getLong("bucafunc.id");
            String app = dy.getString("app");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            String entityType = dy.getString("entitytype");
            schemeRule.setScheme(scheme);
            schemeRule.setBuCaFunc(buCaFunc);
            schemeRule.setAppId(app);
            schemeRule.setRoleEntryId(roleEntryId);
            schemeRule.setRoleId(role);
            schemeRule.setEntityNumber(entityType);
            DynamicObjectCollection ruleEntry = dy.getDynamicObjectCollection("dataruleentry");
            if (!ruleEntry.isEmpty()) {
                ArrayList ruleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject ruleDy : ruleEntry) {
                    Rule rule = new Rule();
                    String permItem = ruleDy.getString("permitem.id");
                    Long dataRule = ruleDy.getLong("datarule.id");
                    rule.setDataRule(dataRule);
                    rule.setPermItemId(permItem);
                    ruleList.add(rule);
                }
                schemeRule.setRuleList((List)ruleList);
            }
            if (!(bdRuleEntry = dy.getDynamicObjectCollection("hrcs_rolebdruleentry")).isEmpty()) {
                ArrayList bdRuleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject bdDy : bdRuleEntry) {
                    BdRule bdRule = new BdRule();
                    String propKey = bdDy.getString("propkey");
                    String propentNum = bdDy.getString("propentnum");
                    Long bdDataRule = bdDy.getLong("bddatarule.id");
                    bdRule.setDataRule(bdDataRule);
                    bdRule.setPropKey(propKey);
                    bdRule.setPropNum(propentNum);
                    bdRuleList.add(bdRule);
                }
                schemeRule.setBdRuleList((List)bdRuleList);
            }
            roleRuleLst.add(schemeRule);
        }
        return roleRuleLst;
    }

    private List<SchemeOrg> getRoleBu(DynamicObject[] buDys) {
        ArrayList roleBuLst = Lists.newArrayListWithExpectedSize((int)buDys.length);
        for (DynamicObject dy : buDys) {
            SchemeOrg schemeOrg = new SchemeOrg();
            Long scheme = dy.getLong("scheme.id");
            Long buCaFunc = dy.getLong("bucafunc.id");
            Long org = dy.getLong("org.id");
            boolean includeSubOrg = dy.getBoolean("includesuborg");
            Long roleEntryId = dy.getLong("roleentryid");
            String role = dy.getString("role.id");
            schemeOrg.setBuCaFunc(buCaFunc);
            schemeOrg.setScheme(scheme);
            schemeOrg.setIncludeSubOrg(includeSubOrg);
            schemeOrg.setOrgId(org);
            schemeOrg.setRoleEntryId(roleEntryId);
            schemeOrg.setRoleId(role);
            roleBuLst.add(schemeOrg);
        }
        return roleBuLst;
    }

    public Set<UserRoleRelat2> savePFile(List<DynamicObject> pfList) {
        Object[] pFiles = PERM_FILE_HELPER.save(pfList.toArray(new DynamicObject[0]));
        HashSet set = Sets.newHashSetWithExpectedSize((int)pfList.size());
        for (Object obj : pFiles) {
            DynamicObject dy = (DynamicObject)obj;
            UserRoleRelat2 userRoleRelat = new UserRoleRelat2();
            userRoleRelat.setFileId(Long.valueOf(dy.getLong("id")));
            userRoleRelat.setUserId(this.getUserIdFromDynaObject(dy));
            set.add(userRoleRelat);
        }
        return set;
    }

    private Long getUserIdFromDynaObject(DynamicObject dyna) {
        Long userId = dyna.getLong("user.id");
        if (Objects.isNull(userId) || Objects.equals(userId, 0L)) {
            userId = dyna.getLong("user");
        }
        return userId;
    }

    public Map<Long, List<SceneRoleInfo>> getRoleDataRange(List<DynamicObject> cusRoles) {
        HashSet userrolerealtSet = Sets.newHashSetWithExpectedSize((int)cusRoles.size());
        for (DynamicObject dy : cusRoles) {
            userrolerealtSet.add(dy.getLong("id"));
        }
        HRBaseServiceHelper buHelper = new HRBaseServiceHelper("hrcs_userrole");
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_userroledimgrp");
        HRBaseServiceHelper fieldHelper = new HRBaseServiceHelper("hrcs_userfield");
        DynamicObject[] buDys = buHelper.query("userrolerealt,bucafunc,org,includesuborg,role", new QFilter[]{new QFilter("userrolerealt", "in", (Object)userrolerealtSet)});
        DynamicObject[] ruleDys = ruleHelper.query("userrolerelate,app,entitytype,bucafunc,dataruleentry.permitem,dataruleentry.datarule,bddataruleentry.propkey,bddataruleentry.propentnum,bddataruleentry.bddatarule", new QFilter[]{new QFilter("userrolerelate", "in", (Object)userrolerealtSet)});
        DynamicObject[] dimDys = dimHelper.query("userrolerelat,bucafunc,entry.dimension,entry.isall,entry.structproject,entry.admincontainssub,entry.containssub,entry.dimval,entry.valtype,entry.dynacond", new QFilter[]{new QFilter("userrolerelat", "in", (Object)userrolerealtSet)});
        DynamicObject[] fieldDys = fieldHelper.query("userrolerealt,app,entitytype,entryentity.fieldname,entryentity.isbanread,entryentity.isbanwrite", new QFilter[]{new QFilter("userrolerealt", "in", (Object)userrolerealtSet)});
        List<SchemeOrg> roleBuLst = null;
        if (buDys != null && buDys.length > 0) {
            roleBuLst = this.getDbRoleBu(buDys);
        }
        List<SchemeRule> roleRuleLst = null;
        if (ruleDys != null && ruleDys.length > 0) {
            roleRuleLst = this.getDbRoleDataRule(ruleDys);
        }
        List<SchemeDim> roleDimLst = null;
        if (dimDys != null && dimDys.length > 0) {
            roleDimLst = this.getDbRoleDim(dimDys);
        }
        List<SchemeField> roleFieldLst = null;
        if (fieldDys != null && fieldDys.length > 0) {
            roleFieldLst = this.getDbRoleField(fieldDys);
        }
        HashMap userrolerealtMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject urt : cusRoles) {
            this.setDbRoleBu(urt, roleBuLst, userrolerealtMap);
            this.setDbRoleDr(urt, roleRuleLst, userrolerealtMap);
            this.setDbRoleDim(urt, roleDimLst, userrolerealtMap);
            this.setDbRoleField(urt, roleFieldLst, userrolerealtMap);
        }
        HashMap pfMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : userrolerealtMap.entrySet()) {
            Optional<DynamicObject> pfRet = cusRoles.stream().filter(it -> ((Long)entry.getKey()).equals(it.getLong("id"))).findFirst();
            if (!pfRet.isPresent()) continue;
            Long pf = pfRet.get().getLong("permfile.id");
            pfMap.computeIfAbsent(pf, key -> new ArrayList(16)).add(entry.getValue());
        }
        return pfMap;
    }

    private void setDbRoleField(DynamicObject urt, List<SchemeField> roleFieldLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleFieldLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleFieldLst(roleFieldLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleFieldLst(roleFieldLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private void setDbRoleDim(DynamicObject urt, List<SchemeDim> roleDimLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleDimLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleDimLst(roleDimLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleDimLst(roleDimLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private void setDbRoleDr(DynamicObject urt, List<SchemeRule> roleRuleLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleRuleLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleRuleLst(roleRuleLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleRuleLst(roleRuleLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private void setDbRoleBu(DynamicObject urt, List<SchemeOrg> roleBuLst, Map<Long, SceneRoleInfo> userrolerealtMap) {
        if (CollectionUtils.isEmpty(roleBuLst)) {
            return;
        }
        Long userRoleRltId = urt.getLong("id");
        String roleId = urt.getString("role.id");
        String roleNumber = urt.getString("role.number");
        SceneRoleInfo sceneRoleInfo = userrolerealtMap.get(userRoleRltId);
        if (Objects.isNull(sceneRoleInfo)) {
            sceneRoleInfo = new SceneRoleInfo(roleNumber, "1", roleId);
            sceneRoleInfo.setUserrolerealtId(userRoleRltId);
            sceneRoleInfo.setRoleBuLst(roleBuLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
            userrolerealtMap.put(userRoleRltId, sceneRoleInfo);
        } else {
            sceneRoleInfo.setRoleBuLst(roleBuLst.stream().filter(it -> it.getUserrolerealtId().equals(userRoleRltId)).collect(Collectors.toList()));
        }
    }

    private List<SchemeField> getDbRoleField(DynamicObject[] fieldDys) {
        ArrayList roleFieldLst = Lists.newArrayListWithExpectedSize((int)fieldDys.length);
        for (DynamicObject dy : fieldDys) {
            SchemeField schemeField = new SchemeField();
            String app = dy.getString("app.id");
            String entityType = dy.getString("entitytype.id");
            Long userrolerealtId = dy.getLong("userrolerealt.id");
            schemeField.setUserrolerealtId(userrolerealtId);
            schemeField.setApp(app);
            schemeField.setEntityType(entityType);
            DynamicObjectCollection fieldEntry = dy.getDynamicObjectCollection("entryentity");
            if (!fieldEntry.isEmpty()) {
                ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)fieldEntry.size());
                for (DynamicObject fieldDy : fieldEntry) {
                    Field field = new Field();
                    String fieldName = fieldDy.getString("fieldname");
                    boolean isBanRead = fieldDy.getBoolean("isbanread");
                    boolean isBanWrite = fieldDy.getBoolean("isbanwrite");
                    field.setBanRead(isBanRead);
                    field.setBanWrite(isBanWrite);
                    field.setFieldProp(fieldName);
                    fieldList.add(field);
                }
                schemeField.setFieldList((List)fieldList);
            }
            roleFieldLst.add(schemeField);
        }
        return roleFieldLst;
    }

    private List<SchemeDim> getDbRoleDim(DynamicObject[] dimDys) {
        ArrayList roleDimLst = Lists.newArrayListWithExpectedSize((int)dimDys.length);
        for (DynamicObject dy : dimDys) {
            SchemeDim schemeDim = new SchemeDim();
            Long buCaFunc = dy.getLong("bucafunc.id");
            Long userrolerealtId = dy.getLong("userrolerelat.id");
            schemeDim.setBuCaFunc(buCaFunc);
            schemeDim.setUserrolerealtId(userrolerealtId);
            DynamicObjectCollection dimEntry = dy.getDynamicObjectCollection("entry");
            if (!dimEntry.isEmpty()) {
                ArrayList dimList = Lists.newArrayListWithExpectedSize((int)dimEntry.size());
                for (DynamicObject dimDy : dimEntry) {
                    DynDim dim = new DynDim();
                    Long dimension = dimDy.getLong("dimension.id");
                    boolean isAll = dimDy.getBoolean("isall");
                    Long structProject = dimDy.getLong("structproject.id");
                    boolean adminContainsSub = dimDy.getBoolean("admincontainssub");
                    boolean containsSub = dimDy.getBoolean("containssub");
                    String dimVal = dimDy.getString("dimval");
                    String valType = dimDy.getString("valtype");
                    Long dynaCond = dimDy.getLong("dynacond.id");
                    dim.setDimId(dimension);
                    dim.setAll(isAll);
                    dim.setAdminContainsSub(adminContainsSub);
                    dim.setStructProjectId(structProject);
                    dim.setContainsSub(containsSub);
                    dim.setDimVal(dimVal);
                    dim.setValType(valType);
                    dim.setDynaCondId(dynaCond);
                    dimList.add(dim);
                }
                schemeDim.setDimList((List)dimList);
            }
            roleDimLst.add(schemeDim);
        }
        return roleDimLst;
    }

    private List<SchemeRule> getDbRoleDataRule(DynamicObject[] ruleDys) {
        ArrayList roleRuleLst = Lists.newArrayListWithExpectedSize((int)ruleDys.length);
        for (DynamicObject dy : ruleDys) {
            SchemeRule schemeRule = new SchemeRule();
            String app = dy.getString("app.id");
            String entityType = dy.getString("entitytype.id");
            Long userrolerealtId = dy.getLong("userrolerelate.id");
            schemeRule.setEntityNumber(entityType);
            schemeRule.setAppId(app);
            schemeRule.setUserrolerealtId(userrolerealtId);
            DynamicObjectCollection bdRuleEntry = dy.getDynamicObjectCollection("bddataruleentry");
            DynamicObjectCollection ruleEntry = dy.getDynamicObjectCollection("dataruleentry");
            if (!bdRuleEntry.isEmpty()) {
                ArrayList bdRuleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject bdDy : bdRuleEntry) {
                    BdRule bdRule = new BdRule();
                    String propKey = bdDy.getString("propkey");
                    String propentNum = bdDy.getString("propentnum");
                    Long bdDataRule = bdDy.getLong("bddatarule.id");
                    bdRule.setDataRule(bdDataRule);
                    bdRule.setPropKey(propKey);
                    bdRule.setPropNum(propentNum);
                    bdRuleList.add(bdRule);
                }
                schemeRule.setBdRuleList((List)bdRuleList);
            }
            if (!ruleEntry.isEmpty()) {
                ArrayList ruleList = Lists.newArrayListWithExpectedSize((int)ruleEntry.size());
                for (DynamicObject ruleDy : ruleEntry) {
                    Rule rule = new Rule();
                    String permItem = ruleDy.getString("permitem.id");
                    Long dataRule = ruleDy.getLong("datarule.id");
                    rule.setDataRule(dataRule);
                    rule.setPermItemId(permItem);
                    ruleList.add(rule);
                }
                schemeRule.setRuleList((List)ruleList);
            }
            roleRuleLst.add(schemeRule);
        }
        return roleRuleLst;
    }

    private List<SchemeOrg> getDbRoleBu(DynamicObject[] buDys) {
        ArrayList roleBuLst = Lists.newArrayListWithExpectedSize((int)buDys.length);
        for (DynamicObject dy : buDys) {
            SchemeOrg schemeOrg = new SchemeOrg();
            Long buCaFunc = dy.getLong("bucafunc");
            Long org = dy.getLong("org.id");
            boolean includeSubOrg = dy.getBoolean("includesuborg");
            Long userrolerealtId = dy.getLong("userrolerealt.id");
            schemeOrg.setBuCaFunc(buCaFunc);
            schemeOrg.setIncludeSubOrg(includeSubOrg);
            schemeOrg.setOrgId(org);
            schemeOrg.setUserrolerealtId(userrolerealtId);
            roleBuLst.add(schemeOrg);
        }
        return roleBuLst;
    }
}

