/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dyna;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.extpoint.permission.dyna.RuleMatchBO;
import kd.hr.hbp.business.extpoint.permission.dyna.RuleMatchResponseBO;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.dyna.PermDiyDataService;
import kd.hr.hrcs.bussiness.service.perm.dyna.rulehandler.PermRuleMatchService;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermFileSyncServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleMemberAssignServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.DynaRoleService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dyna.PersonService;
import kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.perm.DepInfo;
import kd.hr.hrcs.common.model.perm.PermRuleConditionInfo;
import kd.hr.hrcs.common.model.perm.PersonInfo;
import kd.hr.hrcs.common.model.perm.SceneInfo;
import kd.hr.hrcs.common.model.perm.SceneRoleInfo;
import kd.hr.hrcs.common.model.perm.SchemeInfo;
import kd.hr.hrcs.common.model.perm.dyna.ApplyRecord;
import kd.hr.hrcs.common.model.perm.dyna.AssignRecord;
import kd.hr.hrcs.common.model.perm.dyna.CancelRecord;
import kd.hr.hrcs.common.model.perm.dyna.DynPermModel;
import kd.hr.hrcs.common.model.perm.dyna.DynUserDimModel;
import kd.hr.hrcs.common.model.perm.dyna.SchemeDim;
import kd.hr.hrcs.common.model.perm.dyna.SchemeField;
import kd.hr.hrcs.common.model.perm.dyna.SchemeOrg;
import kd.hr.hrcs.common.model.perm.dyna.SchemeRule;
import kd.hr.hrcs.common.model.perm.dyna.UserRoleRelat2;

@ExcludeFromJacocoGeneratedReport
@Deprecated
public class EventPermService {
    private static final Log LOGGER = LogFactory.getLog(EventPermService.class);
    private static final HRBaseServiceHelper PERM_FILE_HELPER = new HRBaseServiceHelper("hrcs_userpermfile");
    private static final HRBaseServiceHelper ASSIGN_APPLY_RECORD_HELPER = new HRBaseServiceHelper("hrcs_permapplybill");
    private static final HRBaseServiceHelper DYN_SCENE_HELPER = new HRBaseServiceHelper("hrcs_dynascene");
    private static final PermDiyDataService PERM_DIY_DATA_SERVICE = new PermDiyDataService();
    private static final HRBaseServiceHelper SYS_ROLE_HELPER = new HRBaseServiceHelper("perm_role");
    private static final DynaRoleService DYNA_ROLE_SERVICE = new DynaRoleService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRMServiceResult consumerDyPerm(DynamicObject tplDy) {
        String contentBase64 = tplDy.getString("msgcontent");
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)contentBase64);
        LOGGER.info("EventPermService-msgInfo:msgNumber:{},msgName:{},recordId:{}", new Object[]{tplDy.get("number"), null == tplDy.get("name") ? "" : tplDy.get("name").toString(), msgContent.get("recordId")});
        boolean successFlag = true;
        try {
            Map<String, Object> personDataMap = PermFileSyncServiceHelper.getChgInfoByRecordId(msgContent.get("recordId"));
            if (CollectionUtils.isEmpty(personDataMap)) {
                LOGGER.info("EventPermService-consumer-entryJob:req-fourData-finished-recordId={}", msgContent.get("recordId"));
                HRMServiceResult hRMServiceResult = HRMServiceResult.success();
                return hRMServiceResult;
            }
            Object billId = personDataMap.get("billId");
            String billNumber = (String)personDataMap.get("billSource");
            String billNo = (String)personDataMap.get("billNo");
            String msgSubNo = tplDy.getString("msgsubno");
            LOGGER.info("EventPermService-billInfo,billId:{},billNumber:{},billNo:{},msgSubNo:{}", new Object[]{billId, billNumber, billNo, msgSubNo});
            Long publisherId = EventPermService.getPublishId(msgSubNo);
            Long msgCenterId = EventPermService.getMsgCenterId(tplDy.getString("number"));
            Map<String, Long> personData = EventPermService.getDataMap(personDataMap);
            this.dyPermEvent(billId, billNumber, publisherId, msgCenterId, personData);
        }
        catch (Exception ex) {
            successFlag = false;
            LOGGER.error("EventPermService-consumer-entryJob-fail", (Throwable)ex);
        }
        finally {
            try {
                String successMsg = ResManager.loadKDString((String)"\u52a8\u6001\u6743\u9650\u5904\u7406\u5df2\u5b8c\u6210\u3002", (String)"EventPermService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                String failMsg = ResManager.loadKDString((String)"\u52a8\u6001\u6743\u9650\u5904\u7406\u5931\u8d25\u3002", (String)"EventPermService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
                PermFileSyncServiceHelper.rspConsumerMsg(tplDy, successFlag, successMsg, failMsg);
            }
            catch (Exception exc) {
                LOGGER.error("EventPermService-rsp-consumer-entryJob-fail.", (Throwable)exc);
            }
        }
        return null;
    }

    private static Map<String, Long> getDataMap(Map<String, Object> dataMap) {
        Map person;
        Map employee;
        HashMap data = Maps.newHashMapWithExpectedSize((int)dataMap.size());
        Map depemp = (Map)dataMap.get("hrpi_depemp");
        if (Objects.nonNull(depemp)) {
            Long depEmpId = (Long)depemp.get("boid");
            String chgMode = (String)depemp.get("chgmode");
            if (HRStringUtils.equals((String)chgMode, (String)"2")) {
                depEmpId = (Long)depemp.get("vid");
            }
            data.put("TYPE_DEPEMP", depEmpId);
            LOGGER.info("EventPermService-getDataMap,depemp:{}", (Object)depemp);
        }
        if (Objects.nonNull(employee = (Map)dataMap.get("hrpi_employee"))) {
            Long employeeId = (Long)employee.get("boid");
            data.put("TYPE_EMPLOYEE", employeeId);
            LOGGER.info("EventPermService-getDataMap,employee:{}", (Object)employee);
        }
        if (Objects.nonNull(person = (Map)dataMap.get("hrpi_person"))) {
            Long personId = (Long)person.get("boid");
            data.put("TYPE_PERSON", personId);
            Long sysUserId = (Long)PermFileSyncServiceHelper.getSysUserId(personId);
            data.put("TYPE_BOS_USER", sysUserId);
            LOGGER.info("EventPermService-getDataMap,person:{}", (Object)person);
        }
        LOGGER.info("EventPermService-getDataMap,data:{}", (Object)data);
        return data;
    }

    private static Long getMsgCenterId(String number) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgcenter");
        DynamicObject dy = helper.queryOriginalOne("id", new QFilter[]{new QFilter("number", "=", (Object)number)});
        return dy.getLong("id");
    }

    private static Long getPublishId(String msgSubNo) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        DynamicObject dy = helper.queryOriginalOne("msgpublisher.id", new QFilter("number", "=", (Object)msgSubNo));
        return dy.getLong("msgpublisher.id");
    }

    private void dyPermEvent(Object billId, String billNumber, Long publisherId, Long msgCenterId, Map<String, Long> personData) {
        HRBaseServiceHelper sceneHelper = new HRBaseServiceHelper("hrcs_dynascene");
        DynamicObject sceneDyn = sceneHelper.queryOne(new QFilter[]{new QFilter("msgpublisher", "=", (Object)publisherId), new QFilter("enable", "=", (Object)"1")});
        if (Objects.isNull(sceneDyn)) {
            LOGGER.info("EventPermService-dealWithDyPermEvent,sceneDyn is null , code return");
            return;
        }
        HRBaseServiceHelper billHelper = new HRBaseServiceHelper(billNumber);
        DynamicObject billDyn = billHelper.queryOne(billId);
        List<SchemeInfo> dynaSchemeList = this.getDynaScheme(sceneDyn, msgCenterId, publisherId);
        if (dynaSchemeList.size() == 0) {
            LOGGER.info("EventPermService no scene match scheme , code return");
            return;
        }
        LOGGER.info("EventPermService getDynaSchemes by scene ={}", dynaSchemeList);
        DynamicObject assignDataSource = EventPermService.getAssignDataSource(billNumber);
        if (assignDataSource == null) {
            LOGGER.error("EventPermService assignDataSource is null ,return ,billNumber:{}", (Object)billNumber);
            return;
        }
        DynamicObject cancelDataSource = EventPermService.getAssignDataSource("hrcs_dynadsinittag");
        HashSet matchAssignIdSet = Sets.newHashSetWithExpectedSize((int)dynaSchemeList.size());
        HashSet matchCancelIdSet = Sets.newHashSetWithExpectedSize((int)dynaSchemeList.size());
        String dataSourceName = assignDataSource.getString("entitytype.name");
        LOGGER.info("EventPermService getMemberInfo sceneName={},dataSourceName:{} ", (Object)sceneDyn.getString("name"), (Object)dataSourceName);
        DynamicObject[] arr = new DynamicObject[]{billDyn};
        List billDataMap = DynamicObjectUtil.serializeToListMap((DynamicObject[])arr);
        PersonInfo personInfo = null;
        for (SchemeInfo schemeInfo : dynaSchemeList) {
            try {
                List<Map<String, Object>> bizData;
                List<Map<String, Object>> diyData;
                LOGGER.info("EventPermService start to match SchemeInfo params :{}", (Object)schemeInfo.toString());
                if (HRStringUtils.equals((String)schemeInfo.getAuthAction(), (String)"1")) {
                    if (schemeInfo.getAssignSceneInfo() == null || HRStringUtils.isEmpty((String)schemeInfo.getAssignSceneInfo().getPersonProp())) {
                        LOGGER.info("EventPermService SchemeInfo assignSceneInfo is null ,continue,schemeInfo:{}", (Object)schemeInfo.getName());
                        continue;
                    }
                    personInfo = PersonService.getMemberInfo(assignDataSource, schemeInfo.getAssignSceneInfo().getPersonProp(), billDyn, personData);
                    if (personInfo.isEmpty()) {
                        LOGGER.info("EventPermService assignSchemeParam personInfo is null ,continue,original:{},type:{},schemeInfo:{}", new Object[]{personInfo.getOriginal(), personInfo.getType(), schemeInfo.getName()});
                        continue;
                    }
                    diyData = PERM_DIY_DATA_SERVICE.getDiyData(assignDataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                    bizData = EventPermService.getBizData(billDataMap, diyData);
                    EventPermService.assignSchemeParam(assignDataSource, matchAssignIdSet, schemeInfo, bizData, personInfo);
                    continue;
                }
                if (HRStringUtils.equals((String)schemeInfo.getAuthAction(), (String)"2")) {
                    if (schemeInfo.getCancelSceneInfo() == null || HRStringUtils.isEmpty((String)schemeInfo.getCancelSceneInfo().getPersonProp())) {
                        LOGGER.error("EventPermService SchemeInfo cancelSceneInfo is null ,continue,schemeInfo:{}", (Object)schemeInfo.getName());
                        continue;
                    }
                    personInfo = PersonService.getMemberInfo(assignDataSource, schemeInfo.getCancelSceneInfo().getPersonProp(), billDyn, personData);
                    if (personInfo.isEmpty()) {
                        LOGGER.info("EventPermService SchemeInfo personInfo is null ,continue,original:{},type:{},schemeInfo:{}", new Object[]{personInfo.getOriginal(), personInfo.getType(), schemeInfo.getName()});
                        continue;
                    }
                    diyData = PERM_DIY_DATA_SERVICE.getDiyData(cancelDataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                    EventPermService.cancelSchemeParam(cancelDataSource, matchCancelIdSet, schemeInfo, diyData, personInfo);
                    continue;
                }
                if (!HRStringUtils.equals((String)schemeInfo.getAuthAction(), (String)"3")) continue;
                diyData = null;
                if (schemeInfo.getAssignSceneInfo() != null && HRStringUtils.isNotEmpty((String)schemeInfo.getAssignSceneInfo().getPersonProp())) {
                    personInfo = PersonService.getMemberInfo(assignDataSource, schemeInfo.getAssignSceneInfo().getPersonProp(), billDyn, personData);
                    if (!personInfo.isEmpty()) {
                        diyData = PERM_DIY_DATA_SERVICE.getDiyData(assignDataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                        bizData = EventPermService.getBizData(billDataMap, diyData);
                        EventPermService.assignSchemeParam(assignDataSource, matchAssignIdSet, schemeInfo, bizData, personInfo);
                    } else {
                        LOGGER.error("EventPermService assignSchemeParam  personInfo is null ,continue,original:{},type:{},schemeInfo:{}", new Object[]{personInfo.getOriginal(), personInfo.getType(), schemeInfo.getName()});
                    }
                }
                if (schemeInfo.getCancelSceneInfo() == null || !HRStringUtils.isNotEmpty((String)schemeInfo.getCancelSceneInfo().getPersonProp())) continue;
                personInfo = PersonService.getMemberInfo(assignDataSource, schemeInfo.getCancelSceneInfo().getPersonProp(), billDyn, personData);
                if (!personInfo.isEmpty()) {
                    diyData = PERM_DIY_DATA_SERVICE.getDiyData(cancelDataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                    EventPermService.cancelSchemeParam(cancelDataSource, matchCancelIdSet, schemeInfo, diyData, personInfo);
                    continue;
                }
                LOGGER.info("EventPermService cancelSchemeParam personInfo is null ,continue,original:{},type:{},schemeInfo:{}", new Object[]{personInfo.getOriginal(), personInfo.getType(), schemeInfo.getName()});
            }
            catch (Exception exc) {
                LOGGER.error("EventPermService match error", (Throwable)exc);
            }
        }
        new DynaRoleService().assignSchemeRoleDataRange(matchAssignIdSet);
        Long schemeId = sceneDyn.getLong("id");
        DynPermModel model = new DynPermModel();
        model.setSceneId(schemeId);
        ApplyRecord applyRecord = new ApplyRecord();
        applyRecord.setSceneId(schemeId);
        applyRecord.setMessageId(msgCenterId);
        applyRecord.setMsgPublisher(publisherId);
        model.setApplyRd(applyRecord);
        EventPermService.assignScheme(matchAssignIdSet, model);
        EventPermService.cancelScheme(matchCancelIdSet, model);
        EventPermService.assignApplyRecord(model);
    }

    private static Set<Long> assignApplyRecord(DynPermModel model) {
        LOGGER.info("EventPermService assignApplyRecord entry model:{}", (Object)model);
        ApplyRecord applyRecord = model.getApplyRd();
        if (CollectionUtils.isEmpty((Collection)applyRecord.getAssignRdList()) && CollectionUtils.isEmpty((Collection)applyRecord.getCancelRdList())) {
            LOGGER.info("EventPermService assignApplyRecord AssignRdList and CancelRdList is null. Exit");
            return Sets.newHashSet();
        }
        HashMap assignRdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Object assignRecord : applyRecord.getAssignRdList()) {
            assignRdMap.computeIfAbsent(assignRecord.getUserId(), key -> new ArrayList(16)).add(assignRecord);
        }
        HashMap cancelRdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (CancelRecord cancelRecord : applyRecord.getCancelRdList()) {
            cancelRdMap.computeIfAbsent(cancelRecord.getUserId(), key -> new ArrayList(16)).add(cancelRecord);
        }
        DynamicObjectCollection addColl = new DynamicObjectCollection();
        String authAction = null;
        for (Long userId : applyRecord.getUserSet()) {
            List cancelRecords;
            DynamicObject record = ASSIGN_APPLY_RECORD_HELPER.generateEmptyDynamicObject();
            addColl.add((Object)record);
            record.set("billno", (Object)String.valueOf(System.currentTimeMillis()));
            record.set("message", (Object)applyRecord.getMessageId());
            record.set("msgpublisher", (Object)applyRecord.getMsgPublisher());
            record.set("user", (Object)userId);
            record.set("scene", (Object)applyRecord.getSceneId());
            record.set("auditstatus", (Object)"C");
            record.set("billstatus", (Object)"C");
            PermInitServiceHelper.setOperatorAndDate(record);
            DynamicObjectCollection assignEntryColl = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryCollection(record, "assignentry");
            DynamicObjectCollection cancelEntryColl = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryCollection(record, "cancelentry");
            record.set("assignentry", (Object)assignEntryColl);
            record.set("cancelentry", (Object)cancelEntryColl);
            List assignRecords = (List)assignRdMap.get(userId);
            if (!CollectionUtils.isEmpty((Collection)assignRecords)) {
                authAction = "1";
                for (AssignRecord assignRecord : assignRecords) {
                    DynamicObject entryDyna = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryDynamicObject("assignentry");
                    entryDyna.set("assign_permfile", (Object)assignRecord.getPermFile());
                    entryDyna.set("assign_role", (Object)assignRecord.getRoleId());
                    entryDyna.set("assign_scheme", (Object)assignRecord.getSchemeId());
                    entryDyna.set("assign_validstart", (Object)assignRecord.getValidStart());
                    entryDyna.set("assign_validend", (Object)assignRecord.getValidEnd());
                    entryDyna.set("assign_dealway", (Object)assignRecord.getDealWay());
                    entryDyna.set("assign_filechangetype", (Object)assignRecord.getFileChangeType());
                    assignEntryColl.add((Object)entryDyna);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(cancelRecords = (List)cancelRdMap.get(userId)))) {
                authAction = "2";
                for (CancelRecord cancelRecord : cancelRecords) {
                    DynamicObject entryDyna = ASSIGN_APPLY_RECORD_HELPER.generateEmptyEntryDynamicObject("cancelentry");
                    entryDyna.set("cancel_permfile", (Object)cancelRecord.getPermFile());
                    entryDyna.set("cancel_role", (Object)cancelRecord.getRoleId());
                    entryDyna.set("cancel_scheme", (Object)cancelRecord.getSchemeId());
                    entryDyna.set("cancel_desc", (Object)cancelRecord.getDesc());
                    entryDyna.set("cancel_reason", (Object)cancelRecord.getReason());
                    cancelEntryColl.add((Object)entryDyna);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)cancelRecords) && !CollectionUtils.isEmpty((Collection)assignRecords)) {
                authAction = "3";
            }
            record.set("authaction", (Object)authAction);
        }
        Object[] applyDy = ASSIGN_APPLY_RECORD_HELPER.save(addColl);
        if (applyDy == null || applyDy.length == 0) {
            return Sets.newHashSet();
        }
        HashSet applyIdSet = Sets.newHashSetWithExpectedSize((int)applyDy.length);
        for (Object obj : applyDy) {
            DynamicObject dy = (DynamicObject)obj;
            applyIdSet.add(dy.getLong("id"));
        }
        return applyIdSet;
    }

    private static List<Map<String, Object>> getBizData(List<Map<String, Object>> billData, List<Map<String, Object>> diyData) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(diyData)) {
            return billData;
        }
        ArrayList allData = Lists.newArrayListWithExpectedSize((int)2);
        allData.add(billData);
        allData.add(diyData);
        ArrayList personDataList = Lists.newArrayListWithExpectedSize((int)2);
        List cartesianList = Lists.cartesianProduct((List)allData);
        for (List cartesian : cartesianList) {
            if (CollectionUtils.isEmpty((Collection)cartesian)) continue;
            HashMap rowDataMap = Maps.newHashMapWithExpectedSize((int)cartesian.size());
            for (Map map : cartesian) {
                rowDataMap.putAll(map);
            }
            personDataList.add(rowDataMap);
        }
        return personDataList;
    }

    private static void cancelSchemeParam(DynamicObject cancelDataSource, Set<SchemeInfo> matchCancelIdSet, SchemeInfo schemeInfo, List<Map<String, Object>> diyData, PersonInfo personInfo) {
        LOGGER.info("EventPermService cancel Scheme={} start to match", (Object)schemeInfo.getName());
        Map<Long, Map<Long, RuleMatchResponseBO>> schemeMatchMap = EventPermService.matchRule(cancelDataSource, schemeInfo, personInfo, diyData);
        Map<Long, RuleMatchResponseBO> ruleMatchResponseBOMap = schemeMatchMap.get(schemeInfo.getId());
        RuleMatchResponseBO ruleMatchResponseBO = ruleMatchResponseBOMap.get(personInfo.getOriginal());
        if (!ruleMatchResponseBO.isMatch()) {
            matchCancelIdSet.add(schemeInfo);
            personInfo.setMatchRuleMsg(ruleMatchResponseBO.getMsg());
            schemeInfo.getCancelMember().add(personInfo);
        } else if ("2".equals(schemeInfo.getAuthAction())) {
            if (HRStringUtils.isEmpty((String)schemeInfo.getJson())) {
                matchCancelIdSet.add(schemeInfo);
                schemeInfo.getCancelMember().add(personInfo);
            } else {
                PermRuleConditionInfo ruleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)schemeInfo.getJson(), PermRuleConditionInfo.class);
                List conditionList = ruleConditionInfo.getConditionList();
                if (CollectionUtils.isEmpty((Collection)conditionList)) {
                    matchCancelIdSet.add(schemeInfo);
                    schemeInfo.getCancelMember().add(personInfo);
                }
            }
        } else {
            LOGGER.info("EventPermService cancel Scheme={}  match, no cancel", (Object)schemeInfo.getName());
        }
        LOGGER.info("EventPermService cancel Scheme={} end to match", (Object)schemeInfo.getName());
    }

    private static void assignSchemeParam(DynamicObject assignDataSource, Set<SchemeInfo> matchAssignIdSet, SchemeInfo schemeInfo, List<Map<String, Object>> bizData, PersonInfo personInfo) {
        LOGGER.info("EventPermService assign Scheme={} start to match", (Object)schemeInfo.getName());
        Map<Long, Map<Long, RuleMatchResponseBO>> schemeMatchMap = EventPermService.matchRule(assignDataSource, schemeInfo, personInfo, bizData);
        Map<Long, RuleMatchResponseBO> ruleMatchResponseBOMap = schemeMatchMap.get(schemeInfo.getId());
        RuleMatchResponseBO ruleMatchResponseBO = ruleMatchResponseBOMap.get(personInfo.getOriginal());
        if (ruleMatchResponseBO.isMatch()) {
            LOGGER.info("EventPermService assign Scheme={} match", (Object)schemeInfo.getName());
            matchAssignIdSet.add(schemeInfo);
            schemeInfo.getAssignMember().add(personInfo);
        } else {
            LOGGER.info("EventPermService assign Scheme={} no match", (Object)schemeInfo.getName());
        }
        LOGGER.info("EventPermService assign Scheme={} end to match", (Object)schemeInfo.getName());
    }

    public static void cancelScheme(Set<SchemeInfo> matchCancelIdSet, DynPermModel model) {
        if (matchCancelIdSet.size() == 0) {
            LOGGER.info("EventPermService-cancelScheme,matchScSet=0,code return");
            return;
        }
        DynaRoleService dynaRoleService = new DynaRoleService();
        for (SchemeInfo schemeInfo : matchCancelIdSet) {
            LOGGER.info("EventPermService-cancelScheme,get roles:{}", (Object)schemeInfo.getRoleList());
            if (CollectionUtils.isEmpty((Collection)schemeInfo.getRoleList())) {
                LOGGER.error("EventPermService-cancelScheme,schemeInfo:{} get roles is null", (Object)schemeInfo.getName());
                continue;
            }
            Set roleSet = schemeInfo.getRoleList().stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet());
            Set<UserRoleRelat2> userRoleRelats = dynaRoleService.getPermFileForDel(schemeInfo.getCancelMember(), schemeInfo.isContainManualAssign());
            LOGGER.info("EventPermService-cancelScheme,schemeId:{},schemeName:{},isContainManualAssign:{}, to be selected relatIdList:{}", new Object[]{schemeInfo.getId(), schemeInfo.getName(), schemeInfo.isContainManualAssign(), userRoleRelats});
            userRoleRelats.removeIf(it -> !roleSet.contains(it.getRoleId()));
            LOGGER.info("EventPermService-cancelScheme,schemeId:{},schemeName:{}, selected relatIdList:{}", new Object[]{schemeInfo.getId(), schemeInfo.getName(), userRoleRelats});
            EventPermService.setCancelRd(model, schemeInfo, userRoleRelats);
            Set userIds = schemeInfo.getCancelMember().stream().map(PersonInfo::getUserId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(userIds)) {
                model.getApplyRd().getUserSet().addAll(userIds);
            }
            Set<Long> userRoleIdSet = userRoleRelats.stream().map(UserRoleRelat2::getId).collect(Collectors.toSet());
            dynaRoleService.cancelUserRole(userRoleIdSet);
        }
    }

    private static void setCancelRd(DynPermModel model, SchemeInfo schemeInfo, Set<UserRoleRelat2> userPFSet) {
        for (UserRoleRelat2 userRoleRelat : userPFSet) {
            model.getApplyRd().getCancelRdList().add(EventPermService.getCancelRd(userRoleRelat, schemeInfo));
        }
    }

    private static CancelRecord getCancelRd(UserRoleRelat2 userRoleRelat, SchemeInfo schemeInfo) {
        Set cancelMember = schemeInfo.getCancelMember();
        Long schemeId = schemeInfo.getId();
        CancelRecord cancelRecord = new CancelRecord();
        cancelRecord.setPermFile(userRoleRelat.getFileId());
        cancelRecord.setRoleId(userRoleRelat.getRoleId());
        cancelRecord.setValidEnd(userRoleRelat.getEndDate());
        cancelRecord.setValidStart(userRoleRelat.getStartDate());
        cancelRecord.setSchemeId(schemeId);
        cancelRecord.setUserId(userRoleRelat.getUserId());
        if (HRStringUtils.equals((String)userRoleRelat.getAssignType(), (String)"1")) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u672a\u6ee1\u8db3%s\u52a8\u6001\u6388\u6743\u65b9\u6848\uff0c\u5c06\u540c\u6b65\u5220\u9664\u624b\u5de5\u5206\u914d\u7684\u76f8\u5173\u89d2\u8272\u3002", (String)"EventPermService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), schemeInfo.getName());
            cancelRecord.setReason(errMsg);
        } else {
            for (PersonInfo personInfo : cancelMember) {
                if (personInfo.getUserId().longValue() != userRoleRelat.getUserId().longValue()) continue;
                cancelRecord.setReason(personInfo.getMatchRuleMsg());
            }
        }
        DynamicObject dynamicObject = DYN_SCENE_HELPER.loadSingle((Object)schemeInfo.getCancelSceneInfo().getId());
        String name = dynamicObject != null ? dynamicObject.getString("name") : "";
        String msg = String.format(ResManager.loadKDString((String)"\u6536\u5230%s\u7684\u6d88\u606f\uff0c\u5df2\u5220\u9664\u76f8\u5173\u89d2\u8272\u3002", (String)"EventPermService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), name);
        if (HRStringUtils.isEmpty((String)schemeInfo.getJson())) {
            cancelRecord.setReason(msg);
        } else {
            PermRuleConditionInfo ruleConditionInfo = (PermRuleConditionInfo)SerializationUtils.fromJsonString((String)schemeInfo.getJson(), PermRuleConditionInfo.class);
            List conditionList = ruleConditionInfo.getConditionList();
            if (CollectionUtils.isEmpty((Collection)conditionList)) {
                cancelRecord.setReason(msg);
            }
        }
        return cancelRecord;
    }

    public static void assignScheme(Set<SchemeInfo> matchScSet, DynPermModel model) {
        if (matchScSet.size() == 0) {
            LOGGER.info("EventPermService-assignScheme,matchScSet=0 code return");
            return;
        }
        ArrayList updatePfDyLst = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList userDimModels = Lists.newArrayListWithCapacity((int)16);
        ArrayList assignRole = Lists.newArrayListWithExpectedSize((int)16);
        Date startDate = PermRoleUtil.formatStartDate(new Date());
        HashMap userRoleRltMap = Maps.newHashMapWithExpectedSize((int)16);
        for (SchemeInfo schemeInfo : matchScSet) {
            try {
                LOGGER.info("EventPermService-assignScheme,get roles:{}", (Object)schemeInfo.getRoleList());
                if (CollectionUtils.isEmpty((Collection)schemeInfo.getRoleList())) {
                    LOGGER.info("EventPermService-assignScheme,get roles is null ,schemeInfo", (Object)schemeInfo.getName());
                    continue;
                }
                Set<UserRoleRelat2> userRoleRelats = EventPermService.geneUserPermFile(schemeInfo.getAssignMember());
                LOGGER.info("EventPermService-assignScheme,schemeId:{},schemeName:{}, to be selected relatIdList:{}", new Object[]{schemeInfo.getId(), schemeInfo.getName(), userRoleRelats});
                Set<Long> userPFIdSet = userRoleRelats.stream().map(UserRoleRelat2::getFileId).collect(Collectors.toSet());
                Map<String, List<DynamicObject>> assignedRoles = EventPermService.matchRoleDRange(userPFIdSet, schemeInfo.getRoleList());
                Map<Long, List<SceneRoleInfo>> cusAssignedRoles = EventPermService.getCusRoleDRange(userPFIdSet, schemeInfo.getRoleList(), userRoleRltMap);
                Date endDate = PermRoleUtil.formatEndDate(PermRoleUtil.dateIncreaseByDay(startDate, schemeInfo.getAssignDays()));
                for (SceneRoleInfo role : schemeInfo.getRoleList()) {
                    if (HRStringUtils.equals((String)role.getCustomEnable(), (String)"0")) {
                        for (UserRoleRelat2 userRoleRelat : userRoleRelats) {
                            List<Object> fileDynaObjects = assignedRoles.getOrDefault(role.getRoleId(), Lists.newArrayList());
                            Set permFileIds = fileDynaObjects.stream().map(dyna -> dyna.getLong("permfile.id")).collect(Collectors.toSet());
                            if (permFileIds.contains(userRoleRelat.getFileId())) {
                                LOGGER.info("EventPermService-assignScheme,the same role :{},schemeInfo:{}", (Object)role.getRoleNumber(), (Object)schemeInfo.getName());
                                fileDynaObjects = fileDynaObjects.stream().filter(dyna -> Objects.equals(dyna.getLong("permfile.id"), userRoleRelat.getFileId())).collect(Collectors.toList());
                                updatePfDyLst.addAll(DYNA_ROLE_SERVICE.getUpdateValidDate(fileDynaObjects, startDate, endDate, schemeInfo.getId(), model, role));
                                continue;
                            }
                            assignRole.add(role.getRoleId());
                            DynUserDimModel dynUserDimModel = new DynUserDimModel();
                            dynUserDimModel.setRoleId(role.getRoleId());
                            dynUserDimModel.setUserId(userRoleRelat.getUserId());
                            dynUserDimModel.setValidStart(startDate);
                            dynUserDimModel.setValidEnd(endDate);
                            dynUserDimModel.setFileId(userRoleRelat.getFileId());
                            dynUserDimModel.setSchemeId(schemeInfo.getId());
                            dynUserDimModel.setCustomEnable(role.getCustomEnable());
                            dynUserDimModel.setRoleEntryId(role.getRoleEntryId());
                            userDimModels.add(dynUserDimModel);
                            model.getApplyRd().getAssignRdList().add(EventPermService.getAssignRd(dynUserDimModel));
                            model.getApplyRd().getUserSet().add(userRoleRelat.getUserId());
                        }
                        continue;
                    }
                    for (UserRoleRelat2 userRoleRelat : userRoleRelats) {
                        Set<Long> userRoleRltIdSet = EventPermService.matchRoleCusDataRange(cusAssignedRoles, userRoleRelat, role);
                        LOGGER.info("EventPermService-assignScheme custom datarange have same data,schemeName:{},roleNumber:{},userRoleRelatIdSet:{}", new Object[]{schemeInfo.getName(), role.getRoleNumber(), userRoleRltIdSet});
                        if (userRoleRltIdSet.size() > 0) {
                            updatePfDyLst.addAll(DYNA_ROLE_SERVICE.getUpdateValidDate(EventPermService.getRtDyList(userRoleRltIdSet, userRoleRltMap), startDate, endDate, schemeInfo.getId(), model, role));
                            continue;
                        }
                        DynUserDimModel dynUserDimModel = new DynUserDimModel();
                        dynUserDimModel.setRoleId(role.getRoleId());
                        dynUserDimModel.setUserId(userRoleRelat.getUserId());
                        dynUserDimModel.setValidStart(startDate);
                        dynUserDimModel.setValidEnd(endDate);
                        dynUserDimModel.setFileId(userRoleRelat.getFileId());
                        dynUserDimModel.setSchemeId(schemeInfo.getId());
                        dynUserDimModel.setCustomEnable(role.getCustomEnable());
                        dynUserDimModel.setRoleBuLst(role.getRoleBuLst());
                        dynUserDimModel.setRoleRuleLst(role.getRoleRuleLst());
                        dynUserDimModel.setRoleDimLst(role.getRoleDimLst());
                        dynUserDimModel.setRoleFieldLst(role.getRoleFieldLst());
                        dynUserDimModel.setRoleEntryId(role.getRoleEntryId());
                        userDimModels.add(dynUserDimModel);
                        model.getApplyRd().getAssignRdList().add(EventPermService.getAssignRd(dynUserDimModel));
                        model.getApplyRd().getUserSet().add(userRoleRelat.getUserId());
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("EventPermService error", (Throwable)ex);
            }
        }
        if (updatePfDyLst.size() > 0) {
            DYNA_ROLE_SERVICE.updateValidDate(updatePfDyLst);
        }
        if (userDimModels.size() > 0) {
            model.setRoleOrgRangeMap(DYNA_ROLE_SERVICE.buildRoleOrgMap(assignRole));
            model.setUserDimModels((List)userDimModels);
            DYNA_ROLE_SERVICE.assignUserRole(model);
        } else {
            LOGGER.info("EventPermService-assignScheme assignUserRole no dynPermModel data ,no dealWith");
        }
    }

    private static List<DynamicObject> getRtDyList(Set<Long> userRoleRltIdSet, Map<Long, DynamicObject> userRoleRltMap) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)16);
        for (Long id : userRoleRltIdSet) {
            dys.add(userRoleRltMap.get(id));
        }
        return dys;
    }

    private static Set<Long> matchRoleCusDataRange(Map<Long, List<SceneRoleInfo>> cusAssignedRoles, UserRoleRelat2 userRoleRelat, SceneRoleInfo role) {
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        if (cusAssignedRoles == null || cusAssignedRoles.size() == 0) {
            return Sets.newHashSet();
        }
        boolean hasPf = cusAssignedRoles.containsKey(userRoleRelat.getFileId());
        if (!hasPf) {
            return Sets.newHashSet();
        }
        for (Map.Entry<Long, List<SceneRoleInfo>> entry : cusAssignedRoles.entrySet()) {
            for (SceneRoleInfo sc : entry.getValue()) {
                Long result = EventPermService.matchOneRoleDataRg(sc, role);
                if (result <= 0L) continue;
                idSet.add(result);
            }
        }
        return idSet;
    }

    private static Long matchOneRoleDataRg(SceneRoleInfo dbRole, SceneRoleInfo dyRole) {
        List roleBuLst = dyRole.getRoleBuLst();
        List roleDimLst = dyRole.getRoleDimLst();
        List roleRuleLst = dyRole.getRoleRuleLst();
        List roleFieldLst = dyRole.getRoleFieldLst();
        List dbRoleBuLst = dbRole.getRoleBuLst();
        List dbRoleDimLst = dbRole.getRoleDimLst();
        List dbRoleRuleLst = dbRole.getRoleRuleLst();
        List dbRoleFieldLst = dbRole.getRoleFieldLst();
        boolean roleBuResult = EventPermService.compareRoleBu(roleBuLst, dbRoleBuLst);
        boolean roleDimResult = EventPermService.compareRoleDim(roleDimLst, dbRoleDimLst);
        boolean roleRuleResult = EventPermService.compareRoleRule(roleRuleLst, dbRoleRuleLst);
        boolean roleFieldResult = EventPermService.compareRoleField(roleFieldLst, dbRoleFieldLst);
        if (roleBuResult && roleDimResult && roleRuleResult && roleFieldResult) {
            return dbRole.getUserrolerealtId();
        }
        return 0L;
    }

    private static boolean compareRoleField(List<SchemeField> roleFieldLst, List<SchemeField> targetRoleFieldLst) {
        if (roleFieldLst.size() != targetRoleFieldLst.size()) {
            return false;
        }
        for (SchemeField schemeField : roleFieldLst) {
            if (!targetRoleFieldLst.stream().noneMatch(arg_0 -> ((SchemeField)schemeField).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareRoleRule(List<SchemeRule> roleRuleLst, List<SchemeRule> targetRoleRuleLst) {
        if (roleRuleLst.size() != targetRoleRuleLst.size()) {
            return false;
        }
        for (SchemeRule schemeRule : roleRuleLst) {
            if (!targetRoleRuleLst.stream().noneMatch(arg_0 -> ((SchemeRule)schemeRule).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareRoleDim(List<SchemeDim> roleDimLst, List<SchemeDim> targetRoleDimLst) {
        if (roleDimLst.size() != targetRoleDimLst.size()) {
            return false;
        }
        for (SchemeDim schemeDim : roleDimLst) {
            if (!targetRoleDimLst.stream().noneMatch(arg_0 -> ((SchemeDim)schemeDim).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareRoleBu(List<SchemeOrg> roleBuLst, List<SchemeOrg> targetRoleBuLst) {
        if (roleBuLst.size() != targetRoleBuLst.size()) {
            return false;
        }
        for (SchemeOrg schemeOrg : roleBuLst) {
            if (!targetRoleBuLst.stream().noneMatch(arg_0 -> ((SchemeOrg)schemeOrg).hasEquals(arg_0))) continue;
            return false;
        }
        return true;
    }

    private static Map<Long, List<SceneRoleInfo>> getCusRoleDRange(Set<Long> userPFIdSet, List<SceneRoleInfo> roleList, Map<Long, DynamicObject> userRoleRltMap) {
        HRBaseServiceHelper relHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        Object[] dys = relHelper.query("id,role.id,user.id,validstart,validend,scheme,createtime,customenable,permfile", new QFilter[]{new QFilter("role", "in", roleList.stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet())), new QFilter("permfile", "in", userPFIdSet), new QFilter("sourcetype", "=", (Object)"4"), new QFilter("customenable", "=", (Object)"1")});
        if (dys == null || dys.length == 0) {
            return Maps.newHashMap();
        }
        for (DynamicObject dynamicObject : dys) {
            userRoleRltMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return DYNA_ROLE_SERVICE.getRoleDataRange(Lists.newArrayList((Object[])dys));
    }

    private static AssignRecord getAssignRd(DynUserDimModel dynUserDimModel) {
        AssignRecord assignRecord = new AssignRecord();
        assignRecord.setUserId(dynUserDimModel.getUserId());
        assignRecord.setPermFile(dynUserDimModel.getFileId());
        assignRecord.setDealWay("1");
        assignRecord.setValidEnd(dynUserDimModel.getValidEnd());
        assignRecord.setValidStart(dynUserDimModel.getValidStart());
        assignRecord.setSchemeId(dynUserDimModel.getSchemeId());
        assignRecord.setRoleId(dynUserDimModel.getRoleId());
        return assignRecord;
    }

    private static Map<String, List<DynamicObject>> matchRoleDRange(Set<Long> userPFIdSet, List<SceneRoleInfo> roleIdList) {
        HashMap PFMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper relHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObject[] dys = relHelper.query("id,role.id,user.id,permfile.id,validstart,validend,scheme,createtime,customenable", new QFilter[]{new QFilter("role", "in", roleIdList.stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet())), new QFilter("permfile", "in", userPFIdSet), new QFilter("assigntype", "=", (Object)"2"), new QFilter("customenable", "=", (Object)"0")});
        if (dys == null || dys.length == 0) {
            return Maps.newHashMap();
        }
        for (DynamicObject dy : dys) {
            PFMap.computeIfAbsent(dy.getString("role.id"), key -> new ArrayList(16)).add(dy);
        }
        return PFMap;
    }

    private static Set<UserRoleRelat2> geneUserPermFile(Set<PersonInfo> personInfoSet) {
        Set userIdSet = personInfoSet.stream().map(PersonInfo::getUserId).collect(Collectors.toSet());
        HashSet permFileSet = Sets.newHashSetWithExpectedSize((int)personInfoSet.size());
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject[] userDys = userHelper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", userIdSet)});
        HashMap userMap = Maps.newHashMapWithExpectedSize((int)userDys.length);
        for (DynamicObject dy : userDys) {
            userMap.put(dy.getLong("id"), dy.getString("name"));
        }
        personInfoSet.forEach(it -> permFileSet.addAll(EventPermService.genePermFieldId(it, userMap)));
        return permFileSet;
    }

    private static Set<UserRoleRelat2> genePermFieldId(PersonInfo personInfo, Map<Long, String> userMap) {
        ArrayList addColl = Lists.newArrayListWithExpectedSize((int)16);
        QFilter[] personFilter = new QFilter[]{new QFilter("user", "=", (Object)personInfo.getUserId())};
        HashSet permFileSet = Sets.newHashSetWithExpectedSize((int)16);
        Object[] permFileDys = PERM_FILE_HELPER.query("id,user,org,permfileenable,username,description", personFilter);
        Set depSet = personInfo.getDepSet();
        if (HRArrayUtils.isEmpty((Object[])permFileDys) && CollectionUtils.isEmpty((Collection)depSet)) {
            addColl.add(EventPermService.getNewUserDy(personInfo.getUserId(), userMap.get(personInfo.getUserId())));
            LOGGER.info("EventPermService genePermFieldId not ermanfile & not permfile,add root org permfile.userId:{}", (Object)personInfo.getUserId());
            if (addColl.size() > 0) {
                permFileSet.addAll(DYNA_ROLE_SERVICE.savePFile(addColl));
            }
        } else if (CollectionUtils.isEmpty((Collection)depSet)) {
            List<DynamicObject> enablePfLst = Arrays.stream(permFileDys).filter(it -> HRStringUtils.equals((String)"1", (String)it.getString("permfileenable"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(enablePfLst)) {
                List<DynamicObject> disPfLst = Arrays.stream(permFileDys).collect(Collectors.toList());
                disPfLst.forEach(it -> it.set("permfileenable", (Object)"1"));
                permFileSet.addAll(DYNA_ROLE_SERVICE.savePFile(disPfLst));
                LOGGER.info("EventPermService genePermFieldId not ermanfile, enable existed permfiles size:{},userId:{}", (Object)disPfLst.size(), (Object)personInfo.getUserId());
            } else {
                permFileSet.addAll(DYNA_ROLE_SERVICE.savePFile(enablePfLst));
            }
        } else {
            Set<Long> buSet = depSet.stream().map(DepInfo::getBuId).collect(Collectors.toSet());
            for (Object dy : permFileDys) {
                Long org = dy.getLong("org.id");
                String status = dy.getString("permfileenable");
                if (!buSet.remove(org)) continue;
                if (!HRStringUtils.equals((String)"1", (String)status)) {
                    dy.set("permfileenable", (Object)"1");
                }
                permFileSet.addAll(DYNA_ROLE_SERVICE.savePFile(Lists.newArrayList((Object[])new DynamicObject[]{dy})));
            }
            if (buSet.size() > 0) {
                DynamicObjectCollection coll = EventPermService.getNewUserDc(personInfo.getUserId(), userMap.get(personInfo.getUserId()), buSet);
                permFileSet.addAll(DYNA_ROLE_SERVICE.savePFile(new ArrayList<DynamicObject>((Collection<DynamicObject>)coll)));
                LOGGER.info("EventPermService genePermFieldId have ermanfile ,create new permfiles size:{}.userId:{}.", (Object)coll.size(), (Object)personInfo.getUserId());
            }
        }
        return permFileSet;
    }

    private static DynamicObject getNewUserDy(Long sysUserId, String userName) {
        DynamicObject newPermFile = PERM_FILE_HELPER.generateEmptyDynamicObject();
        newPermFile.set("user", (Object)sysUserId);
        newPermFile.set("id", (Object)RoleMemberAssignServiceHelper.genLongId("hrcs_userpermfile"));
        newPermFile.set("org", (Object)OrgServiceUtil.getBuRootOrgId());
        newPermFile.set("permfileenable", (Object)"1");
        newPermFile.set("username", (Object)userName);
        newPermFile.set("description", (Object)ResManager.loadKDString((String)"\u7531\u52a8\u6001\u6388\u6743\u81ea\u52a8\u521b\u5efa", (String)"EventPermService_3", (String)"hrmp-hrcs-business", (Object[])new Object[]{userName}));
        return newPermFile;
    }

    private static DynamicObjectCollection getNewUserDc(Long sysUserId, String userName, Set<Long> buSet) {
        long[] ids = RoleMemberAssignServiceHelper.genLongIds("hrcs_userpermfile", buSet.size());
        int index = 0;
        DynamicObjectCollection addColl = new DynamicObjectCollection();
        for (Long bu : buSet) {
            DynamicObject newPermFile = PERM_FILE_HELPER.generateEmptyDynamicObject();
            newPermFile.set("user", (Object)sysUserId);
            newPermFile.set("org", (Object)bu);
            newPermFile.set("id", (Object)ids[index]);
            newPermFile.set("permfileenable", (Object)"1");
            newPermFile.set("username", (Object)userName);
            addColl.add((Object)newPermFile);
            ++index;
        }
        return addColl;
    }

    private static Map<Long, Map<Long, RuleMatchResponseBO>> matchRule(DynamicObject dataSource, SchemeInfo schemeInfo, PersonInfo personInfo, List<Map<String, Object>> dataMap) {
        RuleMatchBO ruleMatchBO = new RuleMatchBO();
        ruleMatchBO.setConditionMap(EventPermService.getSchemeParam(schemeInfo));
        ruleMatchBO.setBizDataMap(EventPermService.initBusinessData(dataMap, personInfo));
        LOGGER.info("EventPermService-matchRule params,conditionMap:{} ,dataSource is null ({})", (Object)ruleMatchBO.getConditionMap(), (Object)(dataSource == null ? 1 : 0));
        Map<Long, Map<Long, RuleMatchResponseBO>> matchRuleResultMap = new PermRuleMatchService().matchRule(ruleMatchBO);
        LOGGER.info("EventPermService-matchRule result,matchRuleResultMap:{},come from schemeInfo:{} ", matchRuleResultMap, (Object)schemeInfo.getName());
        return matchRuleResultMap;
    }

    private static Map<Long, List<Map<String, Object>>> initBusinessData(List<Map<String, Object>> dataMap, PersonInfo personInfo) {
        HashMap dataParam = Maps.newHashMapWithExpectedSize((int)2);
        dataParam.put(personInfo.getOriginal(), dataMap);
        return dataParam;
    }

    private static Map<Long, String> getSchemeParam(SchemeInfo schemeInfo) {
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)2);
        paramsMap.put(schemeInfo.getId(), schemeInfo.getJson());
        return paramsMap;
    }

    private static DynamicObject getAssignDataSource(String billNumber) {
        HRBaseServiceHelper sourceHelper = new HRBaseServiceHelper("hrcs_dynadatasource");
        return sourceHelper.loadDynamicObject(new QFilter[]{new QFilter("entitytype.number", "=", (Object)billNumber), new QFilter("enable", "=", (Object)"1")});
    }

    private static List<SchemeInfo> getSchemeLst(DynamicObject[] schemeDynArr, Long msgCenterId, Long publisherId, String sceneNumber) {
        ArrayList schemeList = Lists.newArrayListWithExpectedSize((int)16);
        boolean isAdd = false;
        for (DynamicObject dyn : schemeDynArr) {
            Object entryDyn2;
            DynamicObjectCollection assignSceneColl = dyn.getDynamicObjectCollection("assignsceneentry");
            ArrayList roleList = Lists.newArrayListWithExpectedSize((int)16);
            SchemeInfo schemeInfo = new SchemeInfo();
            schemeInfo.setId(Long.valueOf(dyn.getLong("id")));
            schemeInfo.setJson(dyn.getString("condition"));
            schemeInfo.setAuthAction(dyn.getString("authaction"));
            schemeInfo.setContainManualAssign(dyn.getBoolean("containmanualassign"));
            int assignDays = dyn.getInt("assigndays");
            if (assignDays >= 1) {
                --assignDays;
            }
            schemeInfo.setAssignDays(assignDays);
            schemeInfo.setName(dyn.getString("name"));
            schemeInfo.setPublisherId(publisherId);
            schemeInfo.setMsgCenterId(msgCenterId);
            for (Object entryDyn2 : assignSceneColl) {
                String entrySceneNumber = entryDyn2.getString("assignscene.number");
                String personProp = entryDyn2.getString("apersonprop");
                Long id = entryDyn2.getLong("assignscene.id");
                if (!HRStringUtils.isNotEmpty((String)sceneNumber) || !HRStringUtils.equals((String)sceneNumber, (String)entrySceneNumber)) continue;
                SceneInfo sceneInfo = new SceneInfo(true, personProp, entrySceneNumber, id);
                schemeInfo.setAssignSceneInfo(sceneInfo);
                isAdd = true;
            }
            DynamicObjectCollection cancelSceneColl = dyn.getDynamicObjectCollection("cancelsceneentry");
            entryDyn2 = cancelSceneColl.iterator();
            while (entryDyn2.hasNext()) {
                DynamicObject entryDyn3 = (DynamicObject)entryDyn2.next();
                String entrySceneNumber = entryDyn3.getString("cancelscene.number");
                String personProp = entryDyn3.getString("cpersonprop");
                Long id = entryDyn3.getLong("cancelscene.id");
                if (!HRStringUtils.isNotEmpty((String)sceneNumber) || !HRStringUtils.equals((String)sceneNumber, (String)entrySceneNumber)) continue;
                SceneInfo sceneInfo = new SceneInfo(false, personProp, entrySceneNumber, id);
                schemeInfo.setCancelSceneInfo(sceneInfo);
                isAdd = true;
            }
            DynamicObjectCollection roleColl = dyn.getDynamicObjectCollection("roleentry");
            for (DynamicObject entryDyn4 : roleColl) {
                String roleNum = entryDyn4.getString("role.number");
                String roleId = entryDyn4.getString("role.id");
                String customEnable = entryDyn4.getString("customenable");
                Long roleEntryId = entryDyn4.getLong("id");
                SceneRoleInfo sceneRoleInfo = new SceneRoleInfo(roleNum, customEnable, roleId);
                sceneRoleInfo.setRoleEntryId(roleEntryId);
                roleList.add(sceneRoleInfo);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)roleList)) {
                Set<String> roleIdSet = roleList.stream().map(SceneRoleInfo::getRoleId).collect(Collectors.toSet());
                Set<String> disRoleSet = EventPermService.getDisRole(roleIdSet);
                roleList.removeIf(it -> disRoleSet.contains(it.getRoleId()));
                schemeInfo.setRoleList((List)roleList);
            }
            if (isAdd) {
                schemeList.add(schemeInfo);
                isAdd = false;
            }
            if (!HRStringUtils.isEmpty((String)sceneNumber)) continue;
            schemeList.add(schemeInfo);
        }
        return schemeList;
    }

    private List<SchemeInfo> getDynaScheme(DynamicObject sceneDyn, Long msgCenterId, Long publisherId) {
        HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)2);
        String sceneNumber = sceneDyn.getString("number");
        QFilter aFilter = new QFilter("assignsceneentry.assignscene.number", "=", (Object)sceneNumber);
        QFilter bFilter = new QFilter("cancelsceneentry.cancelscene.number", "=", (Object)sceneNumber);
        QFilter version = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter filter = aFilter.or(bFilter);
        filterList.add(version);
        filterList.add(filter);
        filterList.add(enable);
        filterList.add(status);
        DynamicObjectCollection schemeVidColl = schemeHelper.queryOriginalCollection("sourcevid", HRPermCommonUtil.listToQFilters((List)filterList));
        Set schemeVidSet = schemeVidColl.stream().map(dyna -> dyna.getLong("sourcevid")).collect(Collectors.toSet());
        DynamicObject[] schemeDynArr = schemeHelper.query("id,name,assigndays,containmanualassign,authaction,condition,assignsceneentry.assignscene,assignsceneentry.apersonprop,cancelsceneentry.cancelscene,cancelsceneentry.cpersonprop,roleentry.role,roleentry.customenable", new QFilter[]{new QFilter("id", "in", schemeVidSet)});
        return EventPermService.getSchemeLst(schemeDynArr, msgCenterId, publisherId, sceneNumber);
    }

    private static Set<String> getDisRole(Set<String> roleIdSet) {
        DynamicObject[] dys = SYS_ROLE_HELPER.queryOriginalArray("id,enable", new QFilter[]{new QFilter("id", "in", roleIdSet), new QFilter("enable", "=", (Object)"0")});
        return Arrays.stream(dys).map(it -> it.getString("id")).collect(Collectors.toSet());
    }

    public static Set<Long> matchScheme(Set<Long> memberIdSet, String memberType, Set<Long> schemeSet) {
        HashSet matchAssignIdSet = Sets.newHashSetWithExpectedSize((int)schemeSet.size());
        HashSet matchCancelIdSet = Sets.newHashSetWithExpectedSize((int)schemeSet.size());
        Set<PersonInfo> personInfoSet = EventPermService.getPersonBizBu(memberIdSet, memberType);
        DynamicObject dataSource = EventPermService.getAssignDataSource("hrcs_dynadsinittag");
        List<SchemeInfo> schemeInfoList = EventPermService.initScheme(schemeSet);
        for (SchemeInfo sc : schemeInfoList) {
            try {
                LOGGER.info("EventPermService matchScheme params :{}", (Object)sc.toString());
                for (PersonInfo personInfo : personInfoSet) {
                    List<Map<String, Object>> diyData;
                    LOGGER.info("EventPermService matchScheme personInfo ", (Object)personInfo);
                    if (personInfo.isEmpty()) {
                        LOGGER.info("EventPermService matchScheme personInfo is null original:{}, continue", (Object)personInfo.getOriginal());
                        continue;
                    }
                    if (HRStringUtils.equals((String)sc.getAuthAction(), (String)"1")) {
                        diyData = PERM_DIY_DATA_SERVICE.getDiyData(dataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                        EventPermService.assignSchemeParam(dataSource, matchAssignIdSet, sc, diyData, personInfo);
                        continue;
                    }
                    if (HRStringUtils.equals((String)sc.getAuthAction(), (String)"2")) {
                        diyData = PERM_DIY_DATA_SERVICE.getDiyData(dataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                        EventPermService.cancelSchemeParam(dataSource, matchCancelIdSet, sc, diyData, personInfo);
                        continue;
                    }
                    if (!HRStringUtils.equals((String)sc.getAuthAction(), (String)"3")) continue;
                    diyData = null;
                    diyData = PERM_DIY_DATA_SERVICE.getDiyData(dataSource, personInfo.getPersonId(), personInfo.getEmployeeId());
                    EventPermService.assignSchemeParam(dataSource, matchAssignIdSet, sc, diyData, personInfo);
                    EventPermService.cancelSchemeParam(dataSource, matchCancelIdSet, sc, diyData, personInfo);
                }
            }
            catch (Exception exc) {
                LOGGER.error((Throwable)exc);
            }
        }
        new DynaRoleService().assignSchemeRoleDataRange(matchAssignIdSet);
        DynPermModel model = new DynPermModel();
        model.setApplyRd(new ApplyRecord());
        model.setSceneId(Long.valueOf(0L));
        model.getApplyRd().setMessageId(Long.valueOf(0L));
        model.getApplyRd().setMsgPublisher(Long.valueOf(0L));
        model.setSceneId(Long.valueOf(0L));
        EventPermService.assignScheme(matchAssignIdSet, model);
        EventPermService.cancelScheme(matchCancelIdSet, model);
        return EventPermService.assignApplyRecord(model);
    }

    private static List<SchemeInfo> initScheme(Set<Long> schemeSet) {
        HRBaseServiceHelper schemeHelper = new HRBaseServiceHelper("hrcs_dynascheme");
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)2);
        QFilter idQFilter = new QFilter("id", "in", schemeSet);
        QFilter version = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        filterList.add(version);
        filterList.add(idQFilter);
        filterList.add(enable);
        filterList.add(status);
        DynamicObjectCollection schemeVidColl = schemeHelper.queryOriginalCollection("sourcevid", HRPermCommonUtil.listToQFilters((List)filterList));
        Set schemeVidSet = schemeVidColl.stream().map(dyna -> dyna.getLong("sourcevid")).collect(Collectors.toSet());
        DynamicObject[] schemeDynArr = schemeHelper.query("id,name,containmanualassign,assigndays,authaction,condition,assignsceneentry.assignscene,assignsceneentry.apersonprop,cancelsceneentry.cancelscene,cancelsceneentry.cpersonprop,roleentry.role,roleentry.customenable", new QFilter[]{new QFilter("id", "in", schemeVidSet)});
        return EventPermService.getSchemeLst(schemeDynArr, 0L, 0L, null);
    }

    private static Set<PersonInfo> getPersonBizBu(Set<Long> memberIdSet, String memberType) {
        HashSet personInfoSet = Sets.newHashSetWithExpectedSize((int)memberIdSet.size());
        for (Long pId : memberIdSet) {
            personInfoSet.add(PersonService.getPersonInfo(pId, memberType));
        }
        LOGGER.info("EventPermService matchScheme getPerson result :{}", (Object)personInfoSet);
        return personInfoSet;
    }
}

