/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.common.model.perminit.RoleFuncInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PermInitServiceHelper {
    public static String DYNA_CONDE_PREFIX = "DYNA_COND";
    private static final Log LOG = LogFactory.getLog(PermInitServiceHelper.class);

    public static String joinToKey(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        if (objects.length < 1) {
            return sb.toString();
        }
        sb.append(objects[0].toString());
        for (int idx = 1; idx < objects.length; ++idx) {
            sb.append("_").append(objects[idx]);
        }
        return sb.toString();
    }

    public static void setOperatorAndDate(DynamicObject dyna) {
        Long userId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        dyna.set("creator", (Object)userId);
        dyna.set("createtime", (Object)now);
        dyna.set("modifier", (Object)userId);
        dyna.set("modifytime", (Object)now);
    }

    public static Map<Long, Map<String, Pair<String, String>>> structDimInfo(Map<Long, List<String>> allDimValList, Map<String, List<String>> allDimStructProjectMap, Map<Long, List<Triple<Long, String, Long>>> oTDimValueMap) {
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dimArr = dimHelper.query("id,datasource,hrbu.id,entitytype.id,teamtype.id,entry.displayvalue,entry.value", new QFilter[]{new QFilter("id", "in", allDimValList.keySet())});
        HashMap<Long, Map<String, Pair<String, String>>> dimInfoMap = new HashMap<Long, Map<String, Pair<String, String>>>(16);
        for (DynamicObject dim : dimArr) {
            Long dimId = dim.getLong("id");
            String datasource = dim.getString("datasource");
            if (HRStringUtils.equals((String)"basedata", (String)datasource)) {
                PermInitServiceHelper.queryBDDimValues(dimId, dim, allDimValList, dimInfoMap);
                continue;
            }
            if (HRStringUtils.equals((String)"enum", (String)datasource)) {
                Map<String, Pair> enumVal = dim.getDynamicObjectCollection("entry").stream().filter(it -> ((List)allDimValList.get(dimId)).contains(it.getString("value"))).collect(Collectors.toMap(it -> it.getString("value"), it -> Pair.of((Object)it.getString("displayvalue"), (Object)it.getString("displayvalue"))));
                dimInfoMap.put(dimId, enumVal);
                continue;
            }
            if (HRStringUtils.equals((String)"hrbu", (String)datasource)) {
                String buId = dim.getString("hrbu.id");
                if (HRStringUtils.isEmpty((String)buId)) continue;
                HRBaseServiceHelper orgStructureHelper = new HRBaseServiceHelper("bos_org");
                List list = allDimValList.get(dimId).stream().filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toList());
                Map<String, Pair> orgVal = orgStructureHelper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("id", "in", list)}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("name"), (Object)it.getString("number")), (oldVal, newVal) -> oldVal));
                dimInfoMap.put(dimId, orgVal);
                continue;
            }
            if (!HRStringUtils.equals((String)"orgteam", (String)datasource) || ObjectUtils.isEmpty(allDimStructProjectMap)) continue;
            ArrayList orgteamIds = Lists.newArrayListWithExpectedSize((int)16);
            for (Map.Entry entry : allDimStructProjectMap.entrySet()) {
                orgteamIds.addAll(((List)entry.getValue()).stream().map(it -> Long.valueOf(it)).collect(Collectors.toList()));
            }
            QFilter filter = new QFilter("orgteam.id", "in", (Object)orgteamIds);
            Long l = dim.getLong("teamtype.id");
            boolean isCustomProjectStruct = PermInitServiceHelper.isOrgTeamTypeCustom(l);
            String structEntityNumber = isCustomProjectStruct ? "haos_customotstruct" : "haos_adminorgstructure";
            HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper(structEntityNumber);
            DynamicObjectCollection collection = orgTeamHelper.queryOriginalCollection("orgteam.id,orgteam.number,structproject.id", new QFilter[]{filter, new QFilter("iscurrentversion", "=", (Object)"1")});
            for (DynamicObject row : collection) {
                Long structProject = row.getLong("structproject.id");
                String otNumber = row.getString("orgteam.number");
                Long otId = row.getLong("orgteam.id");
                List otDimList = oTDimValueMap.computeIfAbsent(dimId, key -> Lists.newArrayListWithExpectedSize((int)16));
                otDimList.add(Triple.of((Object)structProject, (Object)otNumber, (Object)otId));
            }
        }
        return dimInfoMap;
    }

    public static Map<Long, Map<String, Pair<String, String>>> structDimInfo(Map<Long, List<String>> allDimValList) {
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dimArr = dimHelper.query("id,datasource,hrbu.id,entitytype.id,teamtype.id,entry.displayvalue,entry.value", new QFilter[]{new QFilter("id", "in", allDimValList.keySet())});
        HashMap<Long, Map<String, Pair<String, String>>> dimInfoMap = new HashMap<Long, Map<String, Pair<String, String>>>(16);
        try {
            for (DynamicObject dim : dimArr) {
                String teamTypeId;
                Long dimId = dim.getLong("id");
                String datasource = dim.getString("datasource");
                if (HRStringUtils.equals((String)"basedata", (String)datasource)) {
                    PermInitServiceHelper.queryBDDimValues(dimId, dim, allDimValList, dimInfoMap);
                    continue;
                }
                if (HRStringUtils.equals((String)"enum", (String)datasource)) {
                    Map<String, Pair> enumVal = dim.getDynamicObjectCollection("entry").stream().filter(it -> ((List)allDimValList.get(dimId)).contains(it.getString("value"))).collect(Collectors.toMap(it -> it.getString("value"), it -> Pair.of((Object)it.getString("displayvalue"), (Object)it.getString("value"))));
                    dimInfoMap.put(dimId, enumVal);
                    continue;
                }
                if (HRStringUtils.equals((String)"hrbu", (String)datasource)) {
                    String buId = dim.getString("hrbu.id");
                    if (HRStringUtils.isEmpty((String)buId)) continue;
                    HRBaseServiceHelper orgStructureHelper = new HRBaseServiceHelper("bos_org");
                    List orgIds = allDimValList.get(dimId).stream().filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toList());
                    Map<String, Pair> orgVal = orgStructureHelper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("id", "in", orgIds)}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("name"), (Object)it.getString("number")), (oldVal, newVal) -> oldVal));
                    dimInfoMap.put(dimId, orgVal);
                    continue;
                }
                if (!HRStringUtils.equals((String)"orgteam", (String)datasource) || HRStringUtils.isEmpty((String)(teamTypeId = dim.getString("teamtype.id")))) continue;
                HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper("haos_adminorgteam");
                Set orgTeamIds = allDimValList.get(dimId).stream().filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toSet());
                QFilter idFiter = new QFilter("id", "in", orgTeamIds);
                QFilter curFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                Map<String, Pair> orgTeamVal = orgTeamHelper.queryOriginalCollection("id,name,number", new QFilter[]{idFiter, curFilter}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("name"), (Object)it.getString("number")), (oldVal, newVal) -> oldVal));
                HRBaseServiceHelper customOrgTeamHelper = new HRBaseServiceHelper("haos_customotstruct");
                Map<String, Pair> customOrgTeamVal = customOrgTeamHelper.queryOriginalCollection("orgteam.id,orgteam.number,orgteam.name,structproject.id", new QFilter[]{idFiter, curFilter}).stream().collect(Collectors.toMap(it -> it.getString("orgteam.id"), it -> Pair.of((Object)it.getString("orgteam.name"), (Object)it.getString("orgteam.number")), (oldVal, newVal) -> oldVal));
                orgTeamVal.putAll(customOrgTeamVal);
                dimInfoMap.put(dimId, orgTeamVal);
            }
            return dimInfoMap;
        }
        catch (Exception exception) {
            LOG.error("kd.hr.hrcs.bussiness.servicehelper.perm.init.PermInitServiceHelper#structDimInfo error", (Throwable)exception);
            return dimInfoMap;
        }
    }

    public static Map<String, Map<String, String>> structDimInfoByNumber(Map<String, List<String>> allDimValList, Map<Long, List<Triple<Long, String, Long>>> oTDimValueMap) {
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        Set<String> dimIdStrs = allDimValList.keySet();
        Set otDimIdStrs = dimIdStrs.stream().filter(it -> it.contains("#")).collect(Collectors.toSet());
        Set dimIds = dimIdStrs.stream().map(it -> Long.valueOf(it.split("#")[0])).collect(Collectors.toSet());
        DynamicObject[] dimArr = dimHelper.query("id,name,datasource,hrbu.id,entitytype.id,teamtype,entry.displayvalue,entry.value", new QFilter[]{new QFilter("id", "in", dimIds)});
        HashMap<String, Map<String, String>> dimInfoMap = new HashMap<String, Map<String, String>>(16);
        for (DynamicObject dim : dimArr) {
            Long dimId = dim.getLong("id");
            String dimIdStr = String.valueOf(dimId);
            String datasource = dim.getString("datasource");
            if (HRStringUtils.equals((String)"basedata", (String)datasource)) {
                PermInitServiceHelper.queryBDDimValuesByNumber(dimId, dim, allDimValList, dimInfoMap);
                continue;
            }
            if (HRStringUtils.equals((String)"enum", (String)datasource)) {
                Map<String, String> enumVal = dim.getDynamicObjectCollection("entry").stream().filter(it -> ((List)allDimValList.get(dimIdStr)).contains(it.getString("value"))).collect(Collectors.toMap(it -> it.getString("value"), it -> it.getString("displayvalue")));
                dimInfoMap.put(dimIdStr, enumVal);
                continue;
            }
            if (HRStringUtils.equals((String)"hrbu", (String)datasource)) {
                String buId = dim.getString("hrbu.id");
                if (HRStringUtils.isEmpty((String)buId)) continue;
                HRBaseServiceHelper orgStructureHelper = new HRBaseServiceHelper("bos_org");
                Map<String, String> orgVal = orgStructureHelper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("number", "in", allDimValList.get(dimIdStr))}).stream().collect(Collectors.toMap(it -> it.getString("number"), it -> it.getString("id"), (oldVal, newVal) -> oldVal));
                dimInfoMap.put(dimIdStr, orgVal);
                continue;
            }
            if (!HRStringUtils.equals((String)"orgteam", (String)datasource)) continue;
            Long teamTypeId = dim.getLong("teamtype.id");
            boolean isCustomProjectStruct = PermInitServiceHelper.isOrgTeamTypeCustom(teamTypeId);
            Set otDims = otDimIdStrs.stream().filter(it -> HRStringUtils.equals((String)it.split("#")[0], (String)dimIdStr)).collect(Collectors.toSet());
            HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper("haos_adminorgstructure");
            HRBaseServiceHelper cusOrgTeamHelper = new HRBaseServiceHelper("haos_customotstruct");
            QFilter orgFilter = null;
            for (String otDim : otDims) {
                List<String> numberLists = allDimValList.get(otDim);
                if (!CollectionUtils.isNotEmpty(numberLists)) continue;
                QFilter filter = new QFilter("orgteam.number", "in", numberLists);
                if (null == orgFilter) {
                    orgFilter = filter;
                    continue;
                }
                orgFilter.or(filter);
            }
            if (!Objects.nonNull(orgFilter)) continue;
            DynamicObjectCollection collection = new DynamicObjectCollection();
            collection = isCustomProjectStruct ? cusOrgTeamHelper.queryOriginalCollection("orgteam.id,orgteam.number,structproject.id", new QFilter[]{orgFilter, new QFilter("iscurrentversion", "=", (Object)"1")}) : orgTeamHelper.queryOriginalCollection("orgteam.id,orgteam.number,structproject.id", new QFilter[]{orgFilter, new QFilter("iscurrentversion", "=", (Object)"1")});
            for (DynamicObject row : collection) {
                Long structProject = row.getLong("structproject.id");
                String otNumber = row.getString("orgteam.number");
                Long otId = row.getLong("orgteam.id");
                List otDimList = oTDimValueMap.computeIfAbsent(dimId, key -> Lists.newArrayListWithExpectedSize((int)16));
                otDimList.add(Triple.of((Object)structProject, (Object)otNumber, (Object)otId));
            }
        }
        return dimInfoMap;
    }

    private static boolean isOrgTeamTypeCustom(Long teamTypeId) {
        if (Objects.isNull(teamTypeId) || Objects.equals(teamTypeId, 0L)) {
            return false;
        }
        HRBaseServiceHelper teamTypeServiceHelper = new HRBaseServiceHelper("hbss_teamtype");
        DynamicObject cusTeamType = teamTypeServiceHelper.queryOne("iscustom", new QFilter[]{new QFilter("id", "=", (Object)teamTypeId)});
        return HRStringUtils.equals((String)"1", (String)cusTeamType.getString("iscustom"));
    }

    public static Map<Long, Map<String, Pair<String, String>>> structDimInfoById(Map<Long, List<String>> allDimValList, List<Long> orgteamIds) {
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dimArr = dimHelper.query("id,datasource,hrbu.id,entitytype.id,teamtype.id,entry.displayvalue,entry.value", new QFilter[]{new QFilter("id", "in", allDimValList.keySet())});
        HashMap<Long, Map<String, Pair<String, String>>> dimInfoMap = new HashMap<Long, Map<String, Pair<String, String>>>(16);
        for (DynamicObject dim : dimArr) {
            Long dimId = dim.getLong("id");
            String datasource = dim.getString("datasource");
            if (HRStringUtils.equals((String)"basedata", (String)datasource)) {
                PermInitServiceHelper.queryBDDimValues(dimId, dim, allDimValList, dimInfoMap);
                continue;
            }
            if (HRStringUtils.equals((String)"enum", (String)datasource)) {
                Map<String, Pair> enumVal = dim.getDynamicObjectCollection("entry").stream().filter(it -> ((List)allDimValList.get(dimId)).contains(it.getString("value"))).collect(Collectors.toMap(it -> it.getString("value"), it -> Pair.of((Object)it.getString("displayvalue"), (Object)it.getString("value"))));
                dimInfoMap.put(dimId, enumVal);
                continue;
            }
            if (HRStringUtils.equals((String)"hrbu", (String)datasource)) {
                String buId = dim.getString("hrbu.id");
                if (HRStringUtils.isEmpty((String)buId)) continue;
                HRBaseServiceHelper orgStructureHelper = new HRBaseServiceHelper("bos_org");
                List orgIds = allDimValList.get(dimId).stream().filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toList());
                Map<String, Pair> orgVal = orgStructureHelper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("id", "in", orgIds)}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("name"), (Object)it.getString("number")), (oldVal, newVal) -> oldVal));
                dimInfoMap.put(dimId, orgVal);
                continue;
            }
            if (!HRStringUtils.equals((String)"orgteam", (String)datasource)) continue;
            QFilter filter = new QFilter("orgteam.id", "in", orgteamIds);
            HRBaseServiceHelper orgTeamHelper = new HRBaseServiceHelper("haos_adminorgstructure");
            Map<String, Pair> orgTeamVal = orgTeamHelper.queryOriginalCollection("orgteam.id,orgteam.number,orgteam.name,structproject.id", new QFilter[]{filter, new QFilter("iscurrentversion", "=", (Object)"1")}).stream().collect(Collectors.toMap(it -> it.getString("orgteam.id"), it -> Pair.of((Object)it.getString("orgteam.name"), (Object)it.getString("orgteam.number")), (oldVal, newVal) -> oldVal));
            HRBaseServiceHelper customOrgTeamHelper = new HRBaseServiceHelper("haos_customotstruct");
            Map<String, Pair> customOrgTeamVal = customOrgTeamHelper.queryOriginalCollection("orgteam.id,orgteam.number,orgteam.name,structproject.id", new QFilter[]{filter, new QFilter("iscurrentversion", "=", (Object)"1")}).stream().collect(Collectors.toMap(it -> it.getString("orgteam.id"), it -> Pair.of((Object)it.getString("orgteam.name"), (Object)it.getString("orgteam.number")), (oldVal, newVal) -> oldVal));
            orgTeamVal.putAll(customOrgTeamVal);
            dimInfoMap.put(dimId, orgTeamVal);
        }
        return dimInfoMap;
    }

    protected static void queryBDDimValues(long dimId, DynamicObject dim, Map<Long, List<String>> allDimValList, Map<Long, Map<String, Pair<String, String>>> dimInfoMap) {
        DynamicObjectCollection bdCol;
        String entityId = dim.getString("entitytype.id");
        if (HRStringUtils.isEmpty((String)entityId)) {
            return;
        }
        ISimpleProperty propertyType = EntityMetadataCache.getDataEntityType((String)entityId).getPrimaryKey();
        HRBaseServiceHelper bdHelper = new HRBaseServiceHelper(entityId);
        List<String> valIds = allDimValList.get(dimId);
        if (propertyType instanceof LongProp) {
            List longIds = allDimValList.get(dimId).stream().filter(StringUtils::isNumeric).map(Long::valueOf).collect(Collectors.toList());
            bdCol = bdHelper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("id", "in", longIds)});
        } else {
            bdCol = bdHelper.queryOriginalCollection("id,name,number", new QFilter[]{new QFilter("id", "in", valIds)});
        }
        Map<String, Pair> bdValMap = bdCol.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> Pair.of((Object)it.getString("name"), (Object)it.getString("number")), (oldVal, newVal) -> oldVal));
        dimInfoMap.put(dimId, bdValMap);
    }

    protected static void queryBDDimValuesByNumber(long dimId, DynamicObject dim, Map<String, List<String>> allDimValList, Map<String, Map<String, String>> dimInfoMap) {
        String entityId = dim.getString("entitytype.id");
        if (HRStringUtils.isEmpty((String)entityId)) {
            return;
        }
        HRBaseServiceHelper bdHelper = new HRBaseServiceHelper(entityId);
        try {
            String result = HisModelController.getInstance().entityInhRelation(entityId);
            String dimIdStr = String.valueOf(dimId);
            DynamicObjectCollection bdCol = !HRStringUtils.equals((String)result, (String)"0") ? bdHelper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", allDimValList.get(dimIdStr)), new QFilter("iscurrentversion", "=", (Object)"1")}) : bdHelper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", allDimValList.get(dimIdStr))});
            Map<String, String> bdValMap = bdCol.stream().collect(Collectors.toMap(it -> it.getString("number"), it -> it.getString("id"), (oldVal, newVal) -> oldVal));
            dimInfoMap.put(dimIdStr, bdValMap);
        }
        catch (Exception ex) {
            LOG.error("queryBDDimValuesByNumber error", (Throwable)ex);
        }
    }

    public static Map<String, List<RoleFuncInfo>> queryRoleFuncInfo(Set<String> roleIds) {
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_roleperm");
        DynamicObject[] dyns = roleHelper.query("roleid,roleperm.entity,roleperm.permitem,roleperm.bizapp,roleperm.droleid", new QFilter[]{new QFilter("roleid", "in", roleIds)});
        HashMap roleFuncMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy : dyns) {
            DynamicObjectCollection entry = dy.getDynamicObjectCollection("roleperm");
            String roleId = dy.getString("roleid.id");
            ArrayList funcInfos = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject entryDy : entry) {
                String appId = entryDy.getString("bizapp.id");
                String entityNum = entryDy.getString("entity.number");
                String permItemId = entryDy.getString("permitem.id");
                funcInfos.add(new RoleFuncInfo(appId, entityNum, permItemId));
            }
            roleFuncMap.put(roleId, funcInfos);
        }
        return roleFuncMap;
    }

    public static Map<Long, DynamicObject> queryDataRuleInfo(Set<Long> dataRuleIds) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_datarule");
        DynamicObject[] dataRuleDynaColl = dataRuleHelper.query("id,entitynum.number,enable", new QFilter[]{new QFilter("id", "in", dataRuleIds)});
        HashMap dataRuleMap = Maps.newHashMapWithExpectedSize((int)dataRuleDynaColl.length);
        Arrays.stream(dataRuleDynaColl).forEach(dyna -> dataRuleMap.put(dyna.getLong("id"), dyna));
        return dataRuleMap;
    }

    public static Map<String, DynamicObject> querySysRoleInfo(Set<String> roleIds) {
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_role");
        DynamicObject[] dyns = roleHelper.query("id,enable", new QFilter[]{new QFilter("id", "in", roleIds)});
        HashMap sysRoleMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject roleDyna : dyns) {
            sysRoleMap.put(roleDyna.getString("id"), roleDyna);
        }
        return sysRoleMap;
    }

    public static Map<Long, DynamicObject> querySysUserInfo(Set<Long> userIds) {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject[] dyns = userHelper.query("id,isforbidden", new QFilter[]{new QFilter("id", "in", userIds)});
        HashMap sysUserMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject userDyna : dyns) {
            sysUserMap.put(userDyna.getLong("id"), userDyna);
        }
        return sysUserMap;
    }

    public static Map<String, DynamicObject> queryPermFileInfo(Set<Long> userIds) {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObject[] dyns = userHelper.query("user.id,org.id,permfileenable", new QFilter[]{new QFilter("user.id", "in", userIds)});
        HashMap permFileMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject fileDyna : dyns) {
            permFileMap.put(PermInitServiceHelper.joinToKey(fileDyna.getLong("user.id"), fileDyna.getLong("org.id")), fileDyna);
        }
        return permFileMap;
    }

    public static Map<String, Set<Long>> queryRoleBucaFuncInfo(Set<String> roleIds) {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("hrcs_rolebucafunc");
        DynamicObject[] dyns = userHelper.query("role,hrbucafunc", new QFilter[]{new QFilter("role", "in", roleIds)});
        HashMap roleBucaFuncMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject bucaDyna : dyns) {
            String roleId = bucaDyna.getString("role");
            Set bucaList = (Set)roleBucaFuncMap.get(roleId);
            if (bucaList == null) {
                bucaList = Sets.newHashSetWithExpectedSize((int)16);
                roleBucaFuncMap.put(roleId, bucaList);
            }
            bucaList.add(bucaDyna.getLong("hrbucafunc"));
        }
        return roleBucaFuncMap;
    }

    public static Map<Long, String> queryBucaFuncInfo() {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("hbss_hrbucafunc");
        DynamicObject[] dyns = userHelper.query("id,name", null);
        HashMap bucaFuncMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject bucaDyna : dyns) {
            bucaFuncMap.put(bucaDyna.getLong("id"), bucaDyna.getString("name"));
        }
        return bucaFuncMap;
    }

    public static Map<String, DynamicObject> queryHrRoleInfo(Set<String> roleIds) {
        HRBaseServiceHelper hrRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObject[] dyns = hrRoleHelper.query("id,property", new QFilter[]{new QFilter("id", "in", roleIds)});
        HashMap hrRoleDynaMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject hrRoleDyna : dyns) {
            hrRoleDynaMap.put(hrRoleDyna.getString("id"), hrRoleDyna);
        }
        return hrRoleDynaMap;
    }

    public static Map<String, Set<Long>> queryRoleDimensionInfo(Set<String> roleIds) {
        HRBaseServiceHelper userHelper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject[] dyns = userHelper.query("role.id,bucafunc.id,dimension.id", new QFilter[]{new QFilter("role", "in", roleIds)});
        HashMap roleBucaDimMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject roleDimDyna : dyns) {
            String key = PermInitServiceHelper.joinToKey(roleDimDyna.getString("role.id"), roleDimDyna.getLong("bucafunc.id"));
            Set dimIdList = (Set)roleBucaDimMap.get(key);
            if (dimIdList == null) {
                dimIdList = Sets.newHashSetWithExpectedSize((int)16);
                roleBucaDimMap.put(key, dimIdList);
            }
            dimIdList.add(roleDimDyna.getLong("dimension.id"));
        }
        return roleBucaDimMap;
    }

    public static Map<Long, String> queryDimNameInfo() {
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] dyns = dimHelper.query("id,name", null);
        HashMap dimNameMap = Maps.newHashMapWithExpectedSize((int)dyns.length);
        for (DynamicObject dimDyna : dyns) {
            dimNameMap.put(dimDyna.getLong("id"), dimDyna.getString("name"));
        }
        return dimNameMap;
    }

    public static Map<String, List<Long>> queryRoleBus(Set<String> roleIds) {
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        DynamicObject[] roleBuDynaArr = roleBuHelper.queryOriginalArray("role,org.id", new QFilter[]{new QFilter("role", "in", roleIds)});
        HashMap roleBusMap = Maps.newHashMapWithExpectedSize((int)roleIds.size());
        roleIds.forEach(roleId -> {
            List cfr_ignored_0 = roleBusMap.put(roleId, Lists.newArrayListWithExpectedSize((int)16));
        });
        for (DynamicObject roleBuDyna : roleBuDynaArr) {
            String roleId2 = roleBuDyna.getString("role");
            ((List)roleBusMap.get(roleId2)).add(roleBuDyna.getLong("org.id"));
        }
        return roleBusMap;
    }

    public static Map<String, List<DynamicObject>> batchQueryRoleDimGrp(Set<String> roleNumbers) {
        HRBaseServiceHelper permRoleHelper = new HRBaseServiceHelper("perm_role");
        Map<String, String> roleIdNameMap = permRoleHelper.queryOriginalCollection("id,number", new QFilter[]{new QFilter("number", "in", roleNumbers)}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("number")));
        HRBaseServiceHelper roleDimGrpHelper = new HRBaseServiceHelper("hrcs_roledimgrp");
        DynamicObject[] roleDimGrpArr = roleDimGrpHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("role.id", "in", roleIdNameMap.keySet())});
        HashMap roleDimGrpMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject roleDimGrp : roleDimGrpArr) {
            String roleId = roleDimGrp.getString("role.id");
            List roleDimGrpList = roleDimGrpMap.computeIfAbsent(roleIdNameMap.get(roleId), key -> Lists.newArrayListWithExpectedSize((int)10));
            roleDimGrpList.add(roleDimGrp);
        }
        return roleDimGrpMap;
    }

    public static String getOrgInfo(DynamicObject dimRow, DynamicObjectCollection orgRange, String orgRangeContainsSub) {
        if (HRStringUtils.isEmpty((String)orgRangeContainsSub)) {
            return "";
        }
        Map orgRangeContainsSubMap = (Map)SerializationUtils.fromJsonString((String)orgRangeContainsSub, Map.class);
        return orgRange.stream().filter(it -> !ObjectUtils.isEmpty((Object)it.getDynamicObject("fbasedataid"))).map(it -> {
            String orgInfoName = it.getString("fbasedataid.name");
            if (HRStringUtils.equals((String)"1", (String)((String)orgRangeContainsSubMap.get(it.get("fbasedataid.id").toString())))) {
                return ResManager.loadKDString((String)"%s<\u5305\u542b\u4e0b\u7ea7>", (String)"PermRoleInitDrPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[]{orgInfoName});
            }
            return orgInfoName;
        }).collect(Collectors.joining(";"));
    }

    public static Map<String, Pair<String, String>> getDimTypeMap(Set<String> dimIdKeySet) {
        Set dimIdSet = dimIdKeySet.stream().filter(dimIdStr -> !dimIdStr.contains("#")).collect(Collectors.toSet());
        HashSet dimIdSetLong = Sets.newHashSetWithExpectedSize((int)16);
        for (String dimId : dimIdSet) {
            dimIdSetLong.add(Long.valueOf(dimId));
        }
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        return Arrays.stream(dimHelper.query("id,datasource,showtype", new QFilter[]{new QFilter("id", "in", (Object)dimIdSetLong)})).collect(Collectors.toMap(it -> String.valueOf(it.getLong("id")), it -> Pair.of((Object)it.getString("datasource"), (Object)it.getString("showtype")), (oldValue, newValue) -> oldValue));
    }

    public static String getContainsSubText() {
        return ResManager.loadKDString((String)"<\u5305\u542b\u4e0b\u7ea7>", (String)"PermRoleInitValidateService_48", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public static Map<String, List<String>> getDimDynaRangeMap(Set<String> dimIdKeySet) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        Set dimIdSet = dimIdKeySet.stream().filter(dimIdStr -> !dimIdStr.contains("#")).collect(Collectors.toSet());
        Set dimIdSetContainsStructId = dimIdKeySet.stream().filter(dimIdStr -> dimIdStr.contains("#")).collect(Collectors.toSet());
        HashSet dimIdSetLong = Sets.newHashSetWithExpectedSize((int)16);
        for (String dimId : dimIdSet) {
            dimIdSetLong.add(Long.valueOf(dimId));
        }
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObject[] query = dimHelper.query("id,datasource,showtype,entitytype", new QFilter[]{new QFilter("id", "in", (Object)dimIdSetLong)});
        Map<String, List<DynamicObject>> collect = Arrays.stream(query).collect(Collectors.groupingBy(data -> data.getPkValue().toString()));
        for (Map.Entry<String, List<DynamicObject>> dimTypePair : collect.entrySet()) {
            List<DynamicObject> valueList = dimTypePair.getValue();
            if (!CollectionUtils.isNotEmpty(valueList)) continue;
            DynamicObject value = valueList.get(0);
            String dataSource = value.getString("datasource");
            String entityNumber = value.getString("entitytype.number");
            String dynamicConditionIds = "";
            dynamicConditionIds = HRStringUtils.equals((String)"basedata", (String)dataSource) ? Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applybdtype.fbasedataid", "=", (Object)entityNumber).or(new QFilter("applyscope", "=", (Object)"1")), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0") : Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applyscope", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0");
            List<String> numberList = PermInitServiceHelper.getDynaCondNumbers(dynamicConditionIds);
            resultMap.put(dimTypePair.getKey(), numberList);
        }
        for (String dimIdContainsStructId : dimIdSetContainsStructId) {
            String[] split = dimIdContainsStructId.split("#");
            DynamicObject otClassify = new HRBaseServiceHelper("haos_structproject").queryOne("otclassify", new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(split[1]))});
            String dynamicConditionIds = Arrays.stream(new HRBaseServiceHelper("hrcs_dynacond").query("id", new QFilter[]{new QFilter("applyteamcls.fbasedataid", "=", (Object)otClassify.getLong("otclassify.id")).or(new QFilter("applyscope", "=", (Object)"1")), new QFilter("enable", "=", (Object)"1")})).map(it -> it.getString("id")).reduce((acc, item) -> acc + "#" + item).orElse("0");
            List<String> numberList = PermInitServiceHelper.getDynaCondNumbers(dynamicConditionIds);
            resultMap.put(dimIdContainsStructId, numberList);
        }
        return resultMap;
    }

    private static List<String> getDynaCondNumbers(String dynamicConditionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        DynamicObject[] dynaCondArr = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("id", "in", Arrays.stream(dynamicConditionIds.split("#")).map(Long::parseLong).collect(Collectors.toList())), new QFilter("enable", "=", (Object)"1")});
        return Arrays.stream(dynaCondArr).map(dynaCond -> dynaCond.getString("number")).collect(Collectors.toList());
    }

    public static List<String> getAllDynaCondNumbers() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        DynamicObject[] dynaCondArr = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (dynaCondArr != null) {
            return Arrays.stream(dynaCondArr).map(dynaCond -> dynaCond.getString("number")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static Map<String, Long> getAllDynaCondMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        DynamicObject[] dynaCondArr = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (dynaCondArr != null) {
            Map<String, Long> collect = Arrays.stream(dynaCondArr).collect(Collectors.toMap(data -> data.getString("number"), data -> data.getLong("id")));
            return collect;
        }
        return new HashMap<String, Long>();
    }

    public static Map<Long, String> getAllDynaCondNameMap() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        DynamicObject[] dynaCondArr = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (dynaCondArr != null) {
            Map<Long, String> collect = Arrays.stream(dynaCondArr).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getLocaleString("name").toString()));
            return collect;
        }
        return new HashMap<Long, String>();
    }

    public static Map<Long, String> getAllDynaCondMapIdNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynacond");
        DynamicObject[] dynaCondArr = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (dynaCondArr != null) {
            Map<Long, String> collect = Arrays.stream(dynaCondArr).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("number")));
            return collect;
        }
        return new HashMap<Long, String>();
    }

    public static boolean checkBaseDataTreeContainsSub(Pair<String, String> dimInfoWithType) {
        return !(dimInfoWithType == null || HRStringUtils.equals((String)"orgteam", (String)((String)dimInfoWithType.getKey())) || HRStringUtils.equals((String)"hrbu", (String)((String)dimInfoWithType.getKey())) && HRStringUtils.equals((String)"tree", (String)((String)dimInfoWithType.getValue())) || HRStringUtils.equals((String)"basedata", (String)((String)dimInfoWithType.getKey())) && HRStringUtils.equals((String)"tree", (String)((String)dimInfoWithType.getValue())));
    }

    public static boolean isRightContainsSub(String next) {
        return next.contains("<") || next.contains(">");
    }
}

