/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.log;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.econtract.KeywordMappingServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogBussinessHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.BDDataRuleLogRoleModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleLogModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleLogRoleAssignModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleLogRoleModel;
import kd.hr.hrcs.common.constants.perm.log.FieldModel;

@ExcludeFromJacocoGeneratedReport
public class DataRuleLogServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(DataRuleLogServiceHelper.class);
    private static HRBaseServiceHelper dataRuleServiceHelper = new HRBaseServiceHelper("hrcs_datarule");
    private static final HRBaseServiceHelper ROLE_DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_roledatarule");
    private static final HRBaseServiceHelper USER_DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_userdatarule");

    public static void dataRuleLogInit(String opType, DataRuleLogModel dataRuleLogModel) {
        try {
            if (!PermCommonUtil.isEnablePermLog()) {
                return;
            }
            HRBaseServiceHelper logHelper = new HRBaseServiceHelper("hrcs_permlog");
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            DynamicObject permLogDy = logHelper.generateEmptyDynamicObject();
            String str = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") + String.format("%03d", 0);
            permLogDy.set("number", (Object)str);
            permLogDy.set("operator", (Object)RequestContext.get().getCurrUserId());
            permLogDy.set("datarule", (Object)dataRuleLogModel.getDataRuleId());
            DynamicObject dynamicObject = dataRuleServiceHelper.queryOne((Object)dataRuleLogModel.getDataRuleId());
            DynamicObject entitynum = dynamicObject.getDynamicObject("entitynum");
            String number = entitynum.getString("number");
            permLogDy.set("datarulenumber", (Object)dynamicObject.getString("number"));
            permLogDy.set("datarulename", (Object)dynamicObject.getLocaleString("name").getLocaleValue());
            permLogDy.set("entitytype", (Object)number);
            permLogDy.set("operationtime", (Object)new Date());
            permLogDy.set("clienttype", (Object)"web");
            permLogDy.set("opentitytype", (Object)new HRBaseServiceHelper("hrcs_datarule").generateEmptyDynamicObject().getDataEntityType());
            if (HRStringUtils.equals((String)opType, (String)"modify")) {
                permLogDy.set("opbtnname", (Object)ResManager.loadKDString((String)"\u4fee\u6539", (String)"PermLogService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
                permLogDy.set("logtype", (Object)3015L);
            }
            permLogDy.set("beforeopdata", (Object)SerializationUtils.toJsonString((Object)dataRuleLogModel.getBeforeDataRuleModel()));
            permLogDy.set("afteropdata", (Object)SerializationUtils.toJsonString((Object)dataRuleLogModel));
            dynamicObjectCollection.add((Object)permLogDy);
            PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
        }
        catch (Exception exception) {
            LOGGER.error("kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogServiceHelper.roleAssignPermLog error", (Throwable)exception);
        }
    }

    public static DataRuleLogModel getDataRuleLogModel(Object pkValue, boolean flag) {
        long ruleStart = System.currentTimeMillis();
        DynamicObject dynamicObject = dataRuleServiceHelper.queryOne(pkValue);
        DynamicObject entitynum = dynamicObject.getDynamicObject("entitynum");
        String number = entitynum.getString("number");
        String entityName = entitynum.getLocaleString("name").getLocaleValue();
        String rule = (String)dynamicObject.get("rule");
        String dataRuleDisplayText = RoleAssignLogBussinessHelper.getDataRuleDisplayText(rule, number);
        DataRuleLogModel dataRuleLogModel = new DataRuleLogModel();
        dataRuleLogModel.setEntityName(entityName);
        dataRuleLogModel.setDataRuleId((Long)pkValue);
        ArrayList fieldModelList = Lists.newArrayListWithCapacity((int)16);
        dataRuleLogModel.setFieldModelList((List)fieldModelList);
        FieldModel fieldModel = new FieldModel();
        fieldModel.setPropName(ResManager.loadKDString((String)"\u6761\u4ef6\u89c4\u5219\u8bbe\u7f6e", (String)"DataRuleLogServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        fieldModel.setPropNum("ruleSet");
        fieldModel.setVal(dataRuleDisplayText);
        fieldModelList.add(fieldModel);
        long ruleEnd = System.currentTimeMillis();
        LOGGER.info("getDataRuleLogModel task cost: {}.", (Object)(ruleEnd - ruleStart));
        if (flag) {
            return dataRuleLogModel;
        }
        long start = System.currentTimeMillis();
        DataRuleLogServiceHelper.getAffectRoleDataRule((Long)pkValue, dataRuleLogModel);
        long end = System.currentTimeMillis();
        LOGGER.info("getAffectRoleDataRule task cost: {}.", (Object)(end - start));
        long assignStart = System.currentTimeMillis();
        DataRuleLogServiceHelper.getAffectRoleAssignDataRule((Long)pkValue, dataRuleLogModel);
        long assignEnd = System.currentTimeMillis();
        LOGGER.info("getAffectRoleAssignDataRule task cost: {}.", (Object)(assignEnd - assignStart));
        return dataRuleLogModel;
    }

    public static void getAffectRoleDataRule(Long pkValue, DataRuleLogModel dataRuleLogModel) {
        QFilter qFilter = new QFilter("roledataruleentry.datarule", "=", (Object)pkValue);
        qFilter.or(new QFilter("hrcs_rolebdruleentry.bddatarule", "=", (Object)pkValue));
        DynamicObject[] roleDataRuleDys = ROLE_DATA_RULE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList bdDataRuleLogRoleModels = Lists.newArrayListWithCapacity((int)16);
        ArrayList dataRuleLogRoleModels = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject roleDataRuleDy : roleDataRuleDys) {
            String appId = roleDataRuleDy.getString("app");
            String entityId = roleDataRuleDy.getString("entitytype");
            DynamicObject role = roleDataRuleDy.getDynamicObject("role");
            DynamicObject roleByDb = RoleAssignLogBussinessHelper.getRoleById(role.getPkValue().toString());
            DynamicObjectCollection entry = roleDataRuleDy.getDynamicObjectCollection("roledataruleentry");
            for (DynamicObject dynamicObject : entry) {
                String permItemId = dynamicObject.getString("permitem.id");
                Long dataRuleId = dynamicObject.getLong("datarule.id");
                if (!pkValue.equals(dataRuleId)) continue;
                DataRuleLogRoleModel dataRuleLogRoleModel = new DataRuleLogRoleModel();
                dataRuleLogRoleModel.setApp(appId);
                dataRuleLogRoleModel.setEntityType(entityId);
                dataRuleLogRoleModel.setRoleNum(role.getString("id"));
                dataRuleLogRoleModel.setRoleName(roleByDb.getLocaleString("name").getLocaleValue());
                dataRuleLogRoleModel.setRoleNumDisplay(roleByDb.getString("number"));
                dataRuleLogRoleModel.setPermItem(permItemId);
                dataRuleLogRoleModels.add(dataRuleLogRoleModel);
            }
            DynamicObjectCollection bdEntry = roleDataRuleDy.getDynamicObjectCollection("hrcs_rolebdruleentry");
            try {
                Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(entityId);
                for (DynamicObject dynamicObject : bdEntry) {
                    String propKey = dynamicObject.getString("propkey");
                    Long bdDataRuleId = dynamicObject.getLong("bddatarule.id");
                    if (!pkValue.equals(bdDataRuleId)) continue;
                    BDDataRuleLogRoleModel bdDataRuleLogRoleModel = new BDDataRuleLogRoleModel();
                    bdDataRuleLogRoleModel.setApp(appId);
                    bdDataRuleLogRoleModel.setEntityType(entityId);
                    bdDataRuleLogRoleModel.setRoleNumDisplay(roleByDb.getString("number"));
                    bdDataRuleLogRoleModel.setRoleNum(role.getString("id"));
                    bdDataRuleLogRoleModel.setRoleName(roleByDb.getLocaleString("name").getLocaleValue());
                    bdDataRuleLogRoleModel.setField(propKey);
                    bdDataRuleLogRoleModel.setFieldName(entityFieldMap.get(propKey));
                    bdDataRuleLogRoleModels.add(bdDataRuleLogRoleModel);
                }
            }
            catch (Exception exception) {
                LOGGER.error("RolePermLogServiceHelper.getEntityFieldMap error", (Throwable)exception);
            }
        }
        dataRuleLogModel.setAffectDataRuleRoleList((List)dataRuleLogRoleModels);
        dataRuleLogModel.setAffectBDDataRuleRoleList((List)bdDataRuleLogRoleModels);
    }

    public static void getAffectRoleAssignDataRule(Long pkValue, DataRuleLogModel dataRuleLogModel) {
        DynamicObject[] allUserRoleRelates;
        QFilter qFilter = new QFilter("roledataruleentry.datarule", "=", (Object)pkValue);
        qFilter.or(new QFilter("hrcs_rolebdruleentry.bddatarule", "=", (Object)pkValue));
        DynamicObject[] roleDataRuleDys = ROLE_DATA_RULE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList dataRuleLogRoleModels = Lists.newArrayListWithCapacity((int)16);
        HRBaseServiceHelper userRoleRelatehelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        QFilter userDataRuleQFilter = new QFilter("dataruleentry.datarule", "=", (Object)pkValue);
        userDataRuleQFilter.or(new QFilter("bddataruleentry.bddatarule", "=", (Object)pkValue));
        DynamicObject[] userDataRuleArr = USER_DATA_RULE_HELPER.loadDynamicObjectArray(new QFilter[]{userDataRuleQFilter});
        List userRoelRelateIds = Arrays.stream(userDataRuleArr).map(userDataRule -> userDataRule.getDynamicObject("userrolerelate") == null ? Long.valueOf(0L) : userDataRule.getDynamicObject("userrolerelate").getPkValue()).collect(Collectors.toList());
        Map<Object, List<DynamicObject>> userrolerelate = Arrays.stream(userDataRuleArr).collect(Collectors.groupingBy(userDataRule -> userDataRule.getDynamicObject("userrolerelate") == null ? Long.valueOf(0L) : userDataRule.getDynamicObject("userrolerelate").getPkValue()));
        for (DynamicObject userRoleRelate2 : allUserRoleRelates = userRoleRelatehelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", userRoelRelateIds)})) {
            List<DynamicObject> userDataRules;
            if (userRoleRelate2 == null) continue;
            String dataProperty = userRoleRelate2.getString("customenable");
            DynamicObject role = userRoleRelate2.getDynamicObject("role");
            if (role == null || !HRStringUtils.equals((String)"1", (String)dataProperty) || CollectionUtils.isEmpty(userDataRules = userrolerelate.get(userRoleRelate2.getPkValue()))) continue;
            for (DynamicObject userrRoleRelate : userDataRules) {
                Object dataRule2;
                String appId = userrRoleRelate.getString("app.id");
                String entityId = userrRoleRelate.getString("entitytype.number");
                DynamicObjectCollection dataRuleEntry = userrRoleRelate.getDynamicObjectCollection("dataruleentry");
                for (Object dataRule2 : dataRuleEntry) {
                    Long dataRuleId = dataRule2.getLong("datarule.id");
                    if (!pkValue.equals(dataRuleId)) continue;
                    String permItemId = dataRule2.getString("permitem.id");
                    DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, permItemId, userRoleRelate2, "0");
                }
                DynamicObjectCollection bdDataRuleEntry = userrRoleRelate.getDynamicObjectCollection("bddataruleentry");
                dataRule2 = bdDataRuleEntry.iterator();
                while (dataRule2.hasNext()) {
                    DynamicObject bdDataRule = (DynamicObject)dataRule2.next();
                    Long dataRuleId = bdDataRule.getLong("bddatarule.id");
                    if (!pkValue.equals(dataRuleId)) continue;
                    String propKey = bdDataRule.getString("propkey");
                    DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, propKey, userRoleRelate2, "1");
                }
            }
        }
        List collect = dataRuleLogRoleModels.stream().map(dataRuleLogRoleAssignModel -> dataRuleLogRoleAssignModel.getRelateId()).collect(Collectors.toList());
        List roleIds = Arrays.stream(roleDataRuleDys).map(roleDataRuleDy -> roleDataRuleDy.getDynamicObject("role") == null ? "0" : roleDataRuleDy.getDynamicObject("role").getString("id")).collect(Collectors.toList());
        DynamicObject[] userRoleRelateArr = userRoleRelatehelper.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "in", roleIds)});
        Map<String, List<DynamicObject>> userRoleRelateMap = Arrays.stream(userRoleRelateArr).collect(Collectors.groupingBy(userRoleRelate -> userRoleRelate.getDynamicObject("role").getString("id")));
        for (DynamicObject roleDataRuleDy2 : roleDataRuleDys) {
            String dataProperty;
            String propKey;
            Long dataRuleId;
            String permItemId;
            String appId = roleDataRuleDy2.getString("app");
            String entityId = roleDataRuleDy2.getString("entitytype");
            DynamicObject role = roleDataRuleDy2.getDynamicObject("role");
            if (role == null) continue;
            String isintersection = role.getString("isintersection");
            String property = role.getString("property");
            DynamicObjectCollection entry = roleDataRuleDy2.getDynamicObjectCollection("roledataruleentry");
            DynamicObjectCollection bdDataRuleEntry = roleDataRuleDy2.getDynamicObjectCollection("hrcs_rolebdruleentry");
            List<DynamicObject> userRoleRelates = userRoleRelateMap.get(role.getString("id"));
            if (CollectionUtils.isEmpty(userRoleRelates)) continue;
            if (HRStringUtils.equals((String)"0", (String)property)) {
                for (DynamicObject dynamicObject : entry) {
                    permItemId = dynamicObject.getString("permitem.id");
                    dataRuleId = dynamicObject.getLong("datarule.id");
                    if (!pkValue.equals(dataRuleId)) continue;
                    for (DynamicObject userRoleRelate3 : userRoleRelates) {
                        if (collect.contains(userRoleRelate3.getPkValue())) continue;
                        DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, permItemId, userRoleRelate3, "0");
                    }
                }
                for (DynamicObject dynamicObject : bdDataRuleEntry) {
                    propKey = dynamicObject.getString("propkey");
                    dataRuleId = dynamicObject.getLong("bddatarule.id");
                    if (!pkValue.equals(dataRuleId)) continue;
                    for (DynamicObject userRoleRelate3 : userRoleRelates) {
                        if (collect.contains(userRoleRelate3.getPkValue())) continue;
                        DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, propKey, userRoleRelate3, "1");
                    }
                }
                continue;
            }
            for (DynamicObject dynamicObject : entry) {
                permItemId = dynamicObject.getString("permitem.id");
                dataRuleId = dynamicObject.getLong("datarule.id");
                if (!pkValue.equals(dataRuleId)) continue;
                if (HRStringUtils.equals((String)"1", (String)isintersection) || HRStringUtils.equals((String)"2", (String)isintersection)) {
                    for (DynamicObject userRoleRelate3 : userRoleRelates) {
                        if (collect.contains(userRoleRelate3.getPkValue())) continue;
                        DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, permItemId, userRoleRelate3, "0");
                    }
                    continue;
                }
                for (DynamicObject userRoleRelate3 : userRoleRelates) {
                    if (collect.contains(userRoleRelate3.getPkValue()) || !HRStringUtils.equals((String)"0", (String)(dataProperty = userRoleRelate3.getString("customenable")))) continue;
                    DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, permItemId, userRoleRelate3, "0");
                }
            }
            for (DynamicObject dynamicObject : bdDataRuleEntry) {
                propKey = dynamicObject.getString("propkey");
                dataRuleId = dynamicObject.getLong("bddatarule.id");
                if (!pkValue.equals(dataRuleId)) continue;
                if (HRStringUtils.equals((String)"1", (String)isintersection) || HRStringUtils.equals((String)"2", (String)isintersection)) {
                    for (DynamicObject userRoleRelate3 : userRoleRelates) {
                        if (collect.contains(userRoleRelate3.getPkValue())) continue;
                        DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, propKey, userRoleRelate3, "1");
                    }
                    continue;
                }
                for (DynamicObject userRoleRelate3 : userRoleRelates) {
                    if (collect.contains(userRoleRelate3.getPkValue()) || !HRStringUtils.equals((String)"0", (String)(dataProperty = userRoleRelate3.getString("customenable")))) continue;
                    DataRuleLogServiceHelper.getRoleAssignLogModel(appId, entityId, role, dataRuleLogRoleModels, propKey, userRoleRelate3, "1");
                }
            }
        }
        dataRuleLogModel.setAffectRoleAssignList((List)dataRuleLogRoleModels);
    }

    private static void getRoleAssignLogModel(String appId, String entityId, DynamicObject role, ArrayList<DataRuleLogRoleAssignModel> dataRuleLogRoleModels, String permItemIdOrPropKey, DynamicObject userRoleRelate, String dataRuleType) {
        DynamicObject permFile = userRoleRelate.getDynamicObject("permfile");
        DynamicObject user = userRoleRelate.getDynamicObject("user");
        DynamicObject roleAssign = userRoleRelate.getDynamicObject("role");
        String dataProperty = userRoleRelate.getString("customenable");
        DataRuleLogRoleAssignModel dataRuleLogRoleAssignModel = new DataRuleLogRoleAssignModel();
        dataRuleLogRoleAssignModel.setApp(appId);
        dataRuleLogRoleAssignModel.setEntityType(entityId);
        DynamicObject roleByDb = RoleAssignLogBussinessHelper.getRoleById(role.getPkValue().toString());
        dataRuleLogRoleAssignModel.setRoleName(roleByDb.getLocaleString("name").getLocaleValue());
        dataRuleLogRoleAssignModel.setRoleNum(roleByDb.getString("number"));
        dataRuleLogRoleAssignModel.setRole(role.getString("id"));
        if (HRStringUtils.equals((String)"0", (String)dataRuleType)) {
            dataRuleLogRoleAssignModel.setPermItem(permItemIdOrPropKey);
        } else {
            dataRuleLogRoleAssignModel.setFieldKey(permItemIdOrPropKey);
            Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(entityId);
            dataRuleLogRoleAssignModel.setFieldName(entityFieldMap.get(permItemIdOrPropKey));
        }
        dataRuleLogRoleAssignModel.setCustomEnable(dataProperty);
        dataRuleLogRoleAssignModel.setPermFile(Long.valueOf(permFile.getLong("id")));
        dataRuleLogRoleAssignModel.setPermFileOrgNum(permFile.getString("org.number"));
        dataRuleLogRoleAssignModel.setPermFileOrgName(permFile.getLocaleString("org.name").toString());
        dataRuleLogRoleAssignModel.setRelateId(Long.valueOf(userRoleRelate.getLong("id")));
        DynamicObject hrcsRoleById = RoleAssignLogBussinessHelper.getHrcsRoleById(role.getPkValue().toString());
        dataRuleLogRoleAssignModel.setIntersection(hrcsRoleById.getString("isintersection"));
        dataRuleLogRoleModels.add(dataRuleLogRoleAssignModel);
    }

    public static boolean compareFilterControls(String entityNumber, String beforeFilterCondition, String nowFilterCondition) {
        QFilter newQFilter = HRStringUtils.isEmpty((String)nowFilterCondition) ? new QFilter("1", "=", (Object)"1") : KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, nowFilterCondition);
        QFilter oldQFilter = HRStringUtils.isEmpty((String)beforeFilterCondition) ? new QFilter("1", "=", (Object)"1") : KeywordMappingServiceHelper.convertJsonToQFilter(entityNumber, beforeFilterCondition);
        String newQFilterStr = newQFilter.toSerializedString();
        String oldQFilterStr = oldQFilter.toSerializedString();
        boolean equals = oldQFilterStr.equals(newQFilterStr);
        return !equals;
    }
}

