/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.log;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.model.perm.HRPermRole;
import kd.hr.hrcs.common.model.perm.HRPermRoleUser;
import org.apache.commons.lang.RandomStringUtils;

@ExcludeFromJacocoGeneratedReport
public class PermLogRoleStatusServiceHelper
implements HRCSBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(PermLogRoleStatusServiceHelper.class);
    private static final HRBaseServiceHelper PERM_ROLE_HELPER = new HRBaseServiceHelper("perm_role");
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");
    private static final HRBaseServiceHelper PERM_LOG_TYPE_HELPER = new HRBaseServiceHelper("hrcs_permlogtype");
    private static final HRBaseServiceHelper USER_ROLE_RELAT_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    public static long LOG_TYPE_ROLE_ENABLE = 1040L;
    public static long LOG_TYPE_ROLE_DISABLE = 1035L;

    public static void processPermLogMsg(DynamicObject permLog) {
        if (!(permLog.getBoolean("hashandle") || permLog.getDynamicObject("logtype") == null || LOG_TYPE_ROLE_ENABLE != permLog.getDynamicObject("logtype").getLong("id") && LOG_TYPE_ROLE_DISABLE != permLog.getDynamicObject("logtype").getLong("id"))) {
            String beforeopdata;
            if (permLog.getDynamicObject("role") != null) {
                if (LOG_TYPE_ROLE_ENABLE == permLog.getDynamicObject("logtype").getLong("id")) {
                    permLog.set("description", (Object)String.format(ResManager.loadKDString((String)"\u542f\u7528\u201c%1$s %2$s\u201d\u3002", (String)"PermLogRoleStatusServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), permLog.getDynamicObject("role").getString("number"), permLog.getDynamicObject("role").getString("name")));
                } else if (LOG_TYPE_ROLE_DISABLE == permLog.getDynamicObject("logtype").getLong("id")) {
                    permLog.set("description", (Object)String.format(ResManager.loadKDString((String)"\u7981\u7528\u201c%1$s %2$s\u201d\u3002", (String)"PermLogRoleStatusServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), permLog.getDynamicObject("role").getString("number"), permLog.getDynamicObject("role").getString("name")));
                }
            }
            if (!HRStringUtils.isEmpty((String)(beforeopdata = permLog.getString("beforeopdata")))) {
                try {
                    HRPermRole hrPermRole = (HRPermRole)HRJSONUtils.cast((String)beforeopdata, HRPermRole.class);
                    DynamicObjectCollection dynColl = permLog.getDynamicObjectCollection("influuserentry");
                    for (HRPermRoleUser roleUser : hrPermRole.getRoleUsers()) {
                        DynamicObject roleUserDyn = dynColl.addNew();
                        roleUserDyn.set("influuser_permfile", (Object)roleUser.getPermFileId());
                        roleUserDyn.set("influuser_validstart", (Object)roleUser.getValidStart());
                        roleUserDyn.set("influuser_validend", (Object)roleUser.getValidEnd());
                        roleUserDyn.set("influuser_createtime", (Object)roleUser.getCreateTime());
                        roleUserDyn.set("influuser_role", permLog.get("role"));
                        roleUserDyn.set("influuser_creator", (Object)roleUser.getCreatorId());
                        roleUserDyn.set("influuser_createtime", (Object)roleUser.getCreateTime());
                        roleUserDyn.set("influuser_dataproperty", (Object)roleUser.getCustomEnable());
                        roleUserDyn.set("influuser_fileorgnumber", (Object)roleUser.getPermFileOrgNumber());
                        roleUserDyn.set("influuser_fileorgname", (Object)roleUser.getPermFileOrgName());
                        roleUserDyn.set("influuser_intersection", (Object)roleUser.getIntersection());
                        roleUserDyn.set("influuser_isuserforbidden", (Object)roleUser.getUserIsForbidden());
                    }
                }
                catch (IOException exp) {
                    LOGGER.error("processPermLogMsg error");
                    LOGGER.error((Throwable)exp);
                    return;
                }
            }
            permLog.set("hashandle", (Object)"1");
            PERM_LOG_HELPER.saveOne(permLog);
        }
    }

    public static void addPermLog(Set<String> roleIds, long logType) {
        if (!PermCommonUtil.isEnablePermLog() || roleIds.size() == 0) {
            return;
        }
        DynamicObject logTypeDyn = PermLogRoleStatusServiceHelper.getPermLogTypeByNumber(logType);
        IDataEntityType dataEntityType = PERM_ROLE_HELPER.generateEmptyDynamicObject().getDataEntityType();
        Date now = TimeServiceHelper.now();
        String dataStr = HRDateTimeUtils.format((Date)now, (String)"yyyyMMddHHmmss");
        DynamicObjectCollection permLogList = new DynamicObjectCollection();
        Map<String, HRPermRole> roleDetailMap = PermLogRoleStatusServiceHelper.getRoleUsers(roleIds);
        DynamicObject[] roleDyns = PERM_ROLE_HELPER.query("id,name,number", new QFilter[]{new QFilter("id", "in", roleIds)});
        HashMap roleDynMap = new HashMap(16);
        if (roleDyns != null && roleDyns.length > 0) {
            Arrays.stream(roleDyns).forEach(item -> roleDynMap.put(item.getString("id"), item));
        }
        for (String roleId : roleIds) {
            DynamicObject permLogDyn = PERM_LOG_HELPER.generateEmptyDynamicObject();
            permLogDyn.set("number", (Object)(dataStr + RandomStringUtils.randomNumeric((int)3)));
            permLogDyn.set("logtype", (Object)logTypeDyn);
            permLogDyn.set("description", (Object)"");
            permLogDyn.set("operator", (Object)RequestContext.get().getCurrUserId());
            permLogDyn.set("operationtime", (Object)now);
            if (roleDetailMap.containsKey(roleId)) {
                permLogDyn.set("influusernumber", (Object)roleDetailMap.get(roleId).getRoleUsers().size());
                try {
                    permLogDyn.set("beforeopdata", (Object)HRJSONUtils.toString((Object)roleDetailMap.get(roleId)));
                }
                catch (IOException exp) {
                    LOGGER.error("hrpermrole data trans error");
                    LOGGER.error((Throwable)exp);
                }
                permLogDyn.set("afteropdata", null);
            } else {
                permLogDyn.set("influusernumber", (Object)0);
            }
            permLogDyn.set("clienttype", (Object)"web");
            permLogDyn.set("opentitytype", (Object)dataEntityType);
            if (LOG_TYPE_ROLE_ENABLE == logType) {
                permLogDyn.set("opbtnname", (Object)ResManager.loadKDString((String)"\u542f\u7528", (String)"PermLogRoleStatusServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            } else if (LOG_TYPE_ROLE_DISABLE == logType) {
                permLogDyn.set("opbtnname", (Object)ResManager.loadKDString((String)"\u7981\u7528", (String)"PermLogRoleStatusServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            permLogDyn.set("role", (Object)roleId);
            if (roleDynMap.containsKey(roleId) && roleDynMap.get(roleId) != null) {
                permLogDyn.set("rolenumber", ((DynamicObject)roleDynMap.get(roleId)).get("number"));
                permLogDyn.set("rolename", ((DynamicObject)roleDynMap.get(roleId)).get("name"));
            }
            permLogDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            permLogDyn.set("createtime", (Object)now);
            permLogList.add((Object)permLogDyn);
        }
        PermLogServiceHelper.savePermLogs(permLogList);
    }

    private static DynamicObject getPermLogTypeByNumber(long logTypeId) {
        return PERM_LOG_TYPE_HELPER.queryOne(new QFilter[]{new QFilter("id", "=", (Object)logTypeId)});
    }

    private static Map<String, HRPermRole> getRoleUsers(Set<String> roleIds) {
        QFilter filter = new QFilter("role", "in", roleIds).and("permfile.permfileenable", "!=", (Object)"0");
        HashMap<String, HRPermRole> roleDetailMap = new HashMap<String, HRPermRole>(16);
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObject[] userRoleDys = userRoleHelper.loadDynamicObjectArray(new QFilter[]{filter});
        HRBaseServiceHelper roleRoleHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection roleColl = roleRoleHelper.queryOriginalCollection("id,isintersection", new QFilter[]{new QFilter("id", "in", roleIds)});
        Map<String, String> roleMap = roleColl.stream().collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("isintersection"), (newVal, oldVal) -> newVal));
        if (userRoleDys != null && userRoleDys.length > 0) {
            for (DynamicObject userRoleRelDyn : userRoleDys) {
                HRPermRole permRole;
                String roleId = userRoleRelDyn.getString("role.id");
                if (roleDetailMap.containsKey(roleId)) {
                    permRole = (HRPermRole)roleDetailMap.get(roleId);
                } else {
                    permRole = new HRPermRole(roleId);
                    roleDetailMap.put(roleId, permRole);
                }
                HRPermRoleUser roleUser = new HRPermRoleUser();
                roleUser.setId(userRoleRelDyn.getLong("id"));
                roleUser.setPermFileId(userRoleRelDyn.getLong("permfile.id"));
                roleUser.setPermFileOrgNumber(userRoleRelDyn.getString("permfile.org.number"));
                roleUser.setPermFileOrgName(userRoleRelDyn.getString("permfile.org.name"));
                roleUser.setValidStart(userRoleRelDyn.getDate("validstart"));
                roleUser.setValidEnd(userRoleRelDyn.getDate("validend"));
                roleUser.setIntersection(roleMap.get(roleId));
                roleUser.setUserIsForbidden(userRoleRelDyn.getString("user.isforbidden"));
                roleUser.setCreateTime(userRoleRelDyn.getDate("createtime"));
                roleUser.setAssignType(userRoleRelDyn.getString("assigntype"));
                roleUser.setCustomEnable(userRoleRelDyn.getString("customenable"));
                roleUser.setCreatorId(userRoleRelDyn.getLong("creator.id"));
                permRole.addPermUser(roleUser);
            }
        }
        return roleDetailMap;
    }
}

