/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.log;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;

public class PermLogServiceHelper
implements HRCSBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(PermLogServiceHelper.class);
    private static final HRBaseServiceHelper PERM_FILE_HELPER = new HRBaseServiceHelper("hrcs_userpermfile");
    private static final HRBaseServiceHelper SYS_ROLE_HELPER = new HRBaseServiceHelper("perm_role");
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");
    private static final HRBaseServiceHelper PERM_DIMENSION_HELPER = new HRBaseServiceHelper("hrcs_dimension");
    private static final HRBaseServiceHelper ROLE_DIMENSION_HELPER = new HRBaseServiceHelper("hrcs_roledimension");
    private static final HRBaseServiceHelper ROLE_DIMENSION_GRP_HELPER = new HRBaseServiceHelper("hrcs_roledimgrp");
    private static final HRBaseServiceHelper ROLE_BU_HELPER = new HRBaseServiceHelper("hrcs_rolebu");
    private static final HRBaseServiceHelper ROLE_DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_roledatarule");
    private static final HRBaseServiceHelper ROLE_FIELD_HELPER = new HRBaseServiceHelper("hrcs_rolefield");
    private static final HRBaseServiceHelper ROLE_ASSIGN_SCOPE_HELPER = new HRBaseServiceHelper("hrcs_roleassignscope");
    private static final HRBaseServiceHelper ROLE_OPEN_SCOPE_HELPER = new HRBaseServiceHelper("hrcs_roleopenscope");
    private static final String MSG_BIZ_PERM_LOG_CONFIG = "MP20240403003009";
    private static final Long MSG_ACTION_PERM_LOG = 1920361262957491200L;

    public static void savePermLogs(DynamicObjectCollection dynamicObjects) {
        block16: {
            try {
                if (!PermCommonUtil.isEnablePermLog() || Objects.isNull(dynamicObjects) || dynamicObjects.size() <= 0) break block16;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        Object[] save = PERM_LOG_HELPER.save(dynamicObjects);
                        tx.commit();
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                    }
                }
                List<Long> permLogIds = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                PermLogServiceHelper.publishLogMsg(permLogIds);
            }
            catch (Exception ex) {
                LOGGER.error("kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper.savePermLogs-fail", (Throwable)ex);
            }
        }
    }

    public static void publishLogMsg(List<Long> permLogIds) {
        LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper.publishLogMsg.permLogId:{}", (Object)permLogIds.size());
        HashMap actionInfo = Maps.newHashMap();
        actionInfo.put("msgNumber", String.valueOf(System.currentTimeMillis()));
        actionInfo.put("msgTitle", ResManager.loadKDString((String)"\u6743\u9650\u65e5\u5fd7\u6d88\u606f", (String)"PermLogServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        actionInfo.put("msgDesc", ResManager.loadKDString((String)"\u6743\u9650\u65e5\u5fd7\u6d88\u606f", (String)"PermLogServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        actionInfo.put("actionId", MSG_ACTION_PERM_LOG);
        actionInfo.put("msgTag", "msgTag");
        actionInfo.put("senderId", RequestContext.get().getCurrUserId());
        actionInfo.put("sendTime", new Date());
        actionInfo.put("msgPubNo", MSG_BIZ_PERM_LOG_CONFIG);
        actionInfo.put("params", PermLogServiceHelper.getLogParams(permLogIds));
        HRProducerServiceHelper.publishAction((Map)actionInfo);
    }

    public static DynamicObject getPermLog(long pkId) {
        return PERM_LOG_HELPER.queryOne((Object)pkId);
    }

    private static String getLogParams(List<Long> permLogIds) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("permLogId", permLogIds);
        return SerializationUtils.serializeToBase64((Object)paramsMap);
    }
}

