/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.log;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogRoleStatusServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class PermLogTaskServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(PermLogRoleStatusServiceHelper.class);
    private static final HRBaseServiceHelper PERM_LOG_HELPER = new HRBaseServiceHelper("hrcs_permlog");
    private static final HRBaseServiceHelper PERM_LOG_TYPE_HELPER = new HRBaseServiceHelper("hrcs_permlogtype");
    private static final HRBaseServiceHelper PERM_LOG_ARCHIVE_HELPER = new HRBaseServiceHelper("hrcs_permlogarchive");
    private static final int DEFAULT_PERM_LOG_ARCHIVE_DAYS = 30;
    private static final int DEFAULT_PERM_LOG_DELETE_DAYS = 90;
    private static final int PERM_LOG_ARCHIVE_PER_SIZE = 1000;

    public static void archivePermLog() {
        DynamicObject[] permLogTypes = PermLogTaskServiceHelper.getAllPermLogType();
        if (permLogTypes == null || permLogTypes.length == 0) {
            return;
        }
        for (DynamicObject permLogType : permLogTypes) {
            PermLogTaskServiceHelper.archivePermLog(permLogType);
        }
    }

    public static void archivePermLog(DynamicObject permLogType) {
        if (permLogType == null) {
            return;
        }
        int archiveDays = permLogType.getInt("archiveperiod") > 0 ? permLogType.getInt("archiveperiod") : 30;
        int maxLoopCnt = 100;
        for (int loop = 0; loop < maxLoopCnt; ++loop) {
            DynamicObject[] logPageDataIds = PermLogTaskServiceHelper.getPermLogIds(permLogType.getLong("id"), archiveDays);
            if (logPageDataIds == null || logPageDataIds.length == 0) {
                return;
            }
            Set<Long> idSet = Arrays.stream(logPageDataIds).map(row -> row.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] permLogPageData = PermLogTaskServiceHelper.getPermLogs(idSet);
            if (permLogPageData == null || permLogPageData.length == 0) {
                return;
            }
            DynamicObject[] permLogArchives = new DynamicObject[permLogPageData.length];
            for (int idx = 0; idx < permLogPageData.length; ++idx) {
                permLogArchives[idx] = PERM_LOG_ARCHIVE_HELPER.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)permLogPageData[idx], (DynamicObject)permLogArchives[idx]);
                permLogArchives[idx].set("id", permLogPageData[idx].get("id"));
                permLogArchives[idx].set("modifytime", permLogPageData[idx].get("modifytime"));
                permLogArchives[idx].set("modifier", permLogPageData[idx].get("modifier"));
            }
            PermLogTaskServiceHelper.archive(idSet, permLogArchives);
        }
    }

    private static void archive(Set<Long> idSet, DynamicObject[] permLogArchives) {
        try (TXHandle h = TX.requiresNew((String)"hrmp_hrcs_perm_log_archive");){
            try {
                PERM_LOG_ARCHIVE_HELPER.save(permLogArchives);
                PERM_LOG_HELPER.deleteByFilter(new QFilter[]{new QFilter("id", "in", idSet)});
            }
            catch (Throwable exp) {
                h.markRollback();
                LOGGER.error("permLog data archive error");
                LOGGER.error(exp);
                throw exp;
            }
        }
    }

    public static DynamicObject[] getPermLogIds(Long permLogTypeId, int archiveDays) {
        Date createTime = HRDateTimeUtils.addDay((Date)HRDateTimeUtils.dateFormatDate((Date)TimeServiceHelper.now()), (long)(-1 * archiveDays + 1));
        QFilter[] qFilters = new QFilter[]{new QFilter("logtype.id", "=", (Object)permLogTypeId), new QFilter("createtime", "<", (Object)createTime)};
        return PERM_LOG_HELPER.query("id", qFilters, "createtime", 1000);
    }

    public static DynamicObject[] getPermLogs(Set<Long> permLogIds) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)PERM_LOG_HELPER.getEntityName());
        return BusinessDataReader.load((Object[])permLogIds.toArray(), (DynamicObjectType)mainEntityType, (Boolean)Boolean.TRUE);
    }

    public static DynamicObject[] getAllPermLogType() {
        return PERM_LOG_TYPE_HELPER.query("id,number,handlerclass,archiveperiod,archiveretaindays", new QFilter[0]);
    }

    public static void deletePermLog() {
        DynamicObject[] permLogTypes = PermLogTaskServiceHelper.getAllPermLogType();
        if (permLogTypes == null || permLogTypes.length == 0) {
            return;
        }
        for (DynamicObject permLogType : permLogTypes) {
            PermLogTaskServiceHelper.deletePermLog(permLogType);
        }
    }

    public static void deletePermLog(DynamicObject permLogType) {
        if (permLogType == null) {
            return;
        }
        int deleteDays = permLogType.getInt("archiveretaindays") > 0 ? permLogType.getInt("archiveretaindays") : 90;
        try (TXHandle h = TX.requiresNew((String)"hrmp_hrcs_perm_log_delete");){
            try {
                Date createTime = HRDateTimeUtils.addDay((Date)HRDateTimeUtils.dateFormatDate((Date)TimeServiceHelper.now()), (long)(-1 * deleteDays + 1));
                QFilter[] qFilters = new QFilter[]{new QFilter("logtype.id", "=", (Object)permLogType.getLong("id")), new QFilter("createtime", "<", (Object)createTime)};
                PERM_LOG_ARCHIVE_HELPER.deleteByFilter(qFilters);
            }
            catch (Throwable exp) {
                h.markRollback();
                LOGGER.error("permLog data archive error");
                LOGGER.error(exp);
                throw exp;
            }
        }
    }
}

