/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.log;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.log.BDDataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DataRangeLogModel;
import kd.hr.hrcs.common.constants.perm.log.DataRuleModel;
import kd.hr.hrcs.common.constants.perm.log.DimGrpLogModel;
import kd.hr.hrcs.common.constants.perm.log.DimLogModel;
import kd.hr.hrcs.common.constants.perm.log.FieldModel;
import kd.hr.hrcs.common.constants.perm.log.FieldPermLogModel;
import kd.hr.hrcs.common.constants.perm.log.FunctionItemLogModel;
import kd.hr.hrcs.common.constants.perm.log.MulValue;
import kd.hr.hrcs.common.constants.perm.log.OrgModel;
import kd.hr.hrcs.common.constants.perm.log.RoleDimLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleInfoLogModel;
import kd.hr.hrcs.common.constants.perm.log.RoleUserFileModel;
import kd.hr.hrcs.common.constants.perm.log.ScopeModel;
import org.apache.commons.lang3.ObjectUtils;

public class RolePermLogServiceHelper
implements HRCSBaseConstants {
    private static final Log LOGGER = LogFactory.getLog(RolePermLogServiceHelper.class);
    private static final HRBaseServiceHelper PERM_ROLE_HELPER = new HRBaseServiceHelper("hrcs_role");
    private static final HRBaseServiceHelper USER_TYPE_HELPER = new HRBaseServiceHelper("bos_usertype");
    private static final HRBaseServiceHelper PERM_FUNCTION_HELPER = new HRBaseServiceHelper("perm_roleperm");
    private static final HRBaseServiceHelper SYS_ROLE_HELPER = new HRBaseServiceHelper("perm_role");
    private static final HRBaseServiceHelper ROLE_DIMENSION_HELPER = new HRBaseServiceHelper("hrcs_roledimension");
    private static final HRBaseServiceHelper ROLE_DIMENSION_GRP_HELPER = new HRBaseServiceHelper("hrcs_roledimgrp");
    private static final HRBaseServiceHelper ROLE_BU_HELPER = new HRBaseServiceHelper("hrcs_rolebu");
    private static final HRBaseServiceHelper ROLE_DATA_RULE_HELPER = new HRBaseServiceHelper("hrcs_roledatarule");
    private static final HRBaseServiceHelper ROLE_FIELD_HELPER = new HRBaseServiceHelper("hrcs_rolefield");
    private static final HRBaseServiceHelper ROLE_ASSIGN_SCOPE_HELPER = new HRBaseServiceHelper("hrcs_roleassignscope");
    private static final HRBaseServiceHelper ROLE_OPEN_SCOPE_HELPER = new HRBaseServiceHelper("hrcs_roleopenscope");
    private static final HRBaseServiceHelper USER_ROLE_RE_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final HRBaseServiceHelper PERM_USER_ADMIN_HELPER = new HRBaseServiceHelper("perm_useradmingroup");

    public static void setPermLogDataByRoleId(RoleInfoLogModel roleInfoLogModel, List<Map<String, String>> funcPermDataList, String roleId) {
        try {
            if (!PermCommonUtil.isEnablePermLog()) {
                return;
            }
            RolePermLogServiceHelper.handleBaseInfo(roleInfoLogModel, roleId);
            RolePermLogServiceHelper.handleFunction(roleInfoLogModel, funcPermDataList, roleId);
            DynamicObject[] roleDimDys = ROLE_DIMENSION_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
            ArrayList roleDimLogModelList = Lists.newArrayListWithExpectedSize((int)roleDimDys.length);
            LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.setPermLogDataByRoleId.roleDimDys.length:{}", (Object)roleDimDys.length);
            for (DynamicObject roleDimDy : roleDimDys) {
                long dimensionId = roleDimDy.getLong("dimension.id");
                long buCaFunc = roleDimDy.getLong("bucafunc.id");
                long id = roleDimDy.getLong("id");
                DynamicObjectCollection entry = roleDimDy.getDynamicObjectCollection("entry");
                LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.setPermLogDataByRoleId.entry.length:{}", (Object)entry.size());
                Iterator iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)iterator.next();
                    String appId = dynamicObject.getString("app.id");
                    String entityId = dynamicObject.getString("entitytype.id");
                    String propKey = dynamicObject.getString("propkey");
                    String enable = dynamicObject.getString("enable");
                    Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(entityId);
                    String propName = entityFieldMap.get(propKey);
                    RoleDimLogModel roleDimLogModel = new RoleDimLogModel(Long.valueOf(id), Long.valueOf(buCaFunc), appId, entityId, propKey, propName, dimensionId, HRStringUtils.equals((String)enable, (String)"1"));
                    List collect = roleDimLogModelList.stream().map(model -> model.getId() + "#" + model.getAppId() + "#" + model.getEntityNum() + "#" + model.getPropKey()).collect(Collectors.toList());
                    if (collect.contains(id + "#" + appId + "#" + entityId + "#" + propKey)) continue;
                    roleDimLogModelList.add(roleDimLogModel);
                }
                LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.setPermLogDataByRoleId.roleDimLogModelList.length:{}", (Object)roleDimLogModelList.size());
            }
            LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.setPermLogDataByRoleId.roleDimLogModelList.all:{}", (Object)roleDimLogModelList.size());
            roleInfoLogModel.setRoleDimLogModelList((List)roleDimLogModelList);
            RolePermLogServiceHelper.handleDataRange(roleInfoLogModel, roleId, roleDimDys);
            DynamicObject[] fieldPermDys = ROLE_FIELD_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
            ArrayList fieldPermLogModelList = Lists.newArrayListWithExpectedSize((int)fieldPermDys.length);
            for (DynamicObject fieldPermDy : fieldPermDys) {
                String appId = fieldPermDy.getString("app");
                String entityId = fieldPermDy.getString("entitytype.id");
                DynamicObjectCollection entry = fieldPermDy.getDynamicObjectCollection("fieldpermentry");
                Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(entityId);
                for (DynamicObject dynamicObject : entry) {
                    String fieldName = dynamicObject.getString("fieldname");
                    boolean isBanRead = dynamicObject.getBoolean("isbanread");
                    boolean isBanWrite = dynamicObject.getBoolean("isbanwrite");
                    fieldPermLogModelList.add(new FieldPermLogModel(appId, entityId, fieldName, entityFieldMap.get(fieldName), isBanRead, isBanWrite));
                }
            }
            roleInfoLogModel.setFieldPermLogModelList((List)fieldPermLogModelList);
            RolePermLogServiceHelper.handleScope(roleInfoLogModel, roleId);
            DynamicObject[] userRoleReDys = USER_ROLE_RE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
            ArrayList roleUserFileModelList = Lists.newArrayListWithExpectedSize((int)userRoleReDys.length);
            for (DynamicObject userRoleReDy : userRoleReDys) {
                long permFileId = userRoleReDy.getLong("permfile.id");
                String validStart = userRoleReDy.getString("validstart");
                String validEnd = userRoleReDy.getString("validend");
                String customEnable = userRoleReDy.getString("customenable");
                String createTime = userRoleReDy.getString("createtime");
                long creatorId = userRoleReDy.getLong("creator.id");
                roleUserFileModelList.add(new RoleUserFileModel(roleId, Long.valueOf(permFileId), validStart, validEnd, customEnable, createTime, Long.valueOf(0L), "", "", Long.valueOf(creatorId)));
            }
            roleInfoLogModel.setRoleUserFileModelList((List)roleUserFileModelList);
        }
        catch (Exception ex) {
            LOGGER.error("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.setPermLogDataByRoleId", (Throwable)ex);
        }
    }

    private static void handleFunction(RoleInfoLogModel roleInfoLogModel, List<Map<String, String>> funcPermDataList, String roleId) {
        if (CollectionUtils.isNotEmpty(funcPermDataList)) {
            ArrayList functionItemLogModelList = Lists.newArrayListWithExpectedSize((int)funcPermDataList.size());
            for (Map<String, String> stringMap : funcPermDataList) {
                functionItemLogModelList.add(new FunctionItemLogModel(stringMap.get("permItemId"), stringMap.get("appId"), stringMap.get("entityNumber")));
            }
            roleInfoLogModel.setFunctionItemLogModelList((List)functionItemLogModelList);
        } else {
            DynamicObject dynamicObjects = PERM_FUNCTION_HELPER.loadDynamicObject(new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
            DynamicObjectCollection rolePerm = dynamicObjects.getDynamicObjectCollection("roleperm");
            ArrayList functionItemLogModelList = Lists.newArrayListWithExpectedSize((int)rolePerm.size());
            for (DynamicObject dynamicObject : rolePerm) {
                String permItemId = dynamicObject.getString("permitem.id");
                String entityId = dynamicObject.getString("entity.id");
                String appId = dynamicObject.getString("bizapp.id");
                functionItemLogModelList.add(new FunctionItemLogModel(permItemId, appId, entityId));
            }
            roleInfoLogModel.setFunctionItemLogModelList((List)functionItemLogModelList);
        }
    }

    private static void handleScope(RoleInfoLogModel roleInfoLogModel, String roleId) {
        if (HRStringUtils.equals((String)roleInfoLogModel.getUseScope(), (String)"1")) {
            DynamicObject[] assignScopes = ROLE_ASSIGN_SCOPE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
            RolePermLogServiceHelper.setScopeListAssign(roleInfoLogModel, assignScopes);
        } else if (HRStringUtils.equals((String)roleInfoLogModel.getUseScope(), (String)"2")) {
            DynamicObject[] openScopes = ROLE_OPEN_SCOPE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
            RolePermLogServiceHelper.setScopeList(roleInfoLogModel, openScopes);
        }
    }

    private static void setScopeListAssign(RoleInfoLogModel roleInfoLogModel, DynamicObject[] scopes) {
        List userAdminReIds = Arrays.stream(scopes).map(dynamicObject -> dynamicObject.getLong("admingroup.id")).collect(Collectors.toList());
        DynamicObject[] userAdminReDys = PERM_USER_ADMIN_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("usergroup", "in", userAdminReIds)});
        Map<Long, List<DynamicObject>> collect = Arrays.stream(userAdminReDys).collect(Collectors.groupingBy(dy -> dy.getLong("usergroup.id")));
        ArrayList scopeModelList = Lists.newArrayListWithExpectedSize((int)scopes.length);
        for (DynamicObject scope : scopes) {
            long adminGroupId = scope.getLong("admingroup.id");
            String adminGroupNumber = scope.getString("admingroup.number");
            String adminGroupName = scope.getString("admingroup.name");
            boolean isModifiable = scope.getBoolean("ismodifiable");
            List<DynamicObject> dynamicObjectList = collect.get(adminGroupId);
            if (dynamicObjectList != null) {
                List userIds = dynamicObjectList.stream().map(dynamicObject -> dynamicObject.getLong("user.id")).collect(Collectors.toList());
                scopeModelList.add(new ScopeModel(adminGroupId, adminGroupNumber, adminGroupName, isModifiable, "1", userIds));
                continue;
            }
            scopeModelList.add(new ScopeModel(adminGroupId, adminGroupNumber, adminGroupName, isModifiable, "1", new ArrayList()));
        }
        roleInfoLogModel.setScopeModelList((List)scopeModelList);
    }

    private static void setScopeList(RoleInfoLogModel roleInfoLogModel, DynamicObject[] scopes) {
        List userAdminReIds = Arrays.stream(scopes).map(dynamicObject -> dynamicObject.getLong("admingroup.id")).collect(Collectors.toList());
        DynamicObject[] userAdminReDys = PERM_USER_ADMIN_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("usergroup", "in", userAdminReIds)});
        Map<Long, List<DynamicObject>> collect = Arrays.stream(userAdminReDys).collect(Collectors.groupingBy(dy -> dy.getLong("usergroup.id")));
        ArrayList scopeModelList = Lists.newArrayListWithExpectedSize((int)scopes.length);
        for (DynamicObject scope : scopes) {
            long adminGroupId = scope.getLong("admingroup.id");
            String adminGroupNumber = scope.getString("admingroup.number");
            String adminGroupName = scope.getString("admingroup.name");
            List<DynamicObject> dynamicObjectList = collect.get(adminGroupId);
            if (dynamicObjectList != null) {
                List userIds = dynamicObjectList.stream().map(dynamicObject -> dynamicObject.getLong("user.id")).collect(Collectors.toList());
                scopeModelList.add(new ScopeModel(adminGroupId, adminGroupNumber, adminGroupName, true, "2", userIds));
                continue;
            }
            scopeModelList.add(new ScopeModel(adminGroupId, adminGroupNumber, adminGroupName, true, "2", new ArrayList()));
        }
        roleInfoLogModel.setScopeModelList((List)scopeModelList);
    }

    private static void handleDataRange(RoleInfoLogModel roleInfoLogModel, String roleId, DynamicObject[] roleDimDys) {
        DynamicObject[] roleBuDys = ROLE_BU_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        DynamicObject[] roleDimGrpDys = ROLE_DIMENSION_GRP_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        ArrayList dataRangeLogModelList = Lists.newArrayListWithExpectedSize((int)roleBuDys.length);
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)roleBuDys.length);
        for (DynamicObject roleBuDy : roleBuDys) {
            long hrBuCaFuncId = roleBuDy.getLong("hrbucafunc");
            long orgId = roleBuDy.getLong("org.id");
            String orgName = roleBuDy.getString("org.name");
            boolean containsSub = roleBuDy.getBoolean("containssub");
            orgList.add(new OrgModel(Long.valueOf(orgId), Long.valueOf(hrBuCaFuncId), orgName, containsSub));
        }
        ArrayList dimGrpLogModelList = Lists.newArrayListWithExpectedSize((int)roleDimDys.length);
        for (DynamicObject roleDimGrpDy : roleDimGrpDys) {
            long id = roleDimGrpDy.getLong("id");
            long buCaFuncId = roleDimGrpDy.getLong("bucafunc.id");
            DynamicObjectCollection entry = roleDimGrpDy.getDynamicObjectCollection("entry");
            ArrayList dimLogModelList = Lists.newArrayListWithExpectedSize((int)roleDimDys.length);
            for (DynamicObject dynamicObject : entry) {
                long dimensionId = dynamicObject.getLong("dimension.id");
                String dimensionNumber = dynamicObject.getString("dimension.number");
                String dimensionName = dynamicObject.getString("dimension.name");
                long structProjectId = dynamicObject.getLong("structproject.id");
                String structProjectName = dynamicObject.getString("structproject.name");
                boolean adminContainsSub = dynamicObject.getBoolean("admincontainssub");
                boolean containsSub = dynamicObject.getBoolean("containssub");
                String dimVal = dynamicObject.getString("dimval");
                boolean isAll = dynamicObject.getBoolean("isall");
                String valType = dynamicObject.getString("valtype");
                long dynaCondId = dynamicObject.getLong("dynacond.id");
                dimLogModelList.add(new DimLogModel(dimensionNumber, dimensionName, dimensionId, structProjectId, structProjectName, containsSub, adminContainsSub, dimVal, isAll, valType, Long.valueOf(dynaCondId)));
            }
            dimGrpLogModelList.add(new DimGrpLogModel(Long.valueOf(id), Long.valueOf(buCaFuncId), (List)dimLogModelList));
        }
        Map<Long, List<OrgModel>> orgGrpModel = orgList.stream().collect(Collectors.groupingBy(OrgModel::getBuCaFuncId));
        Map<Long, List<DimGrpLogModel>> dimGrpLogModel = dimGrpLogModelList.stream().collect(Collectors.groupingBy(DimGrpLogModel::getBuCaFuncId));
        orgGrpModel.forEach((buId, orgModels) -> dataRangeLogModelList.add(new DataRangeLogModel(buId, orgModels, (List)dimGrpLogModel.get(buId))));
        roleInfoLogModel.setDataRangeLogModelList((List)dataRangeLogModelList);
        DynamicObject[] roleDataRuleDys = ROLE_DATA_RULE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        ArrayList dataRuleModelList = Lists.newArrayListWithExpectedSize((int)roleBuDys.length);
        ArrayList bdDataRuleModelList = Lists.newArrayListWithExpectedSize((int)roleBuDys.length);
        for (DynamicObject roleDataRuleDy : roleDataRuleDys) {
            String appId = roleDataRuleDy.getString("app");
            String entityId = roleDataRuleDy.getString("entitytype");
            DynamicObjectCollection entry = roleDataRuleDy.getDynamicObjectCollection("roledataruleentry");
            for (DynamicObject dynamicObject : entry) {
                String permItemId = dynamicObject.getString("permitem.id");
                long dataRuleId = dynamicObject.getLong("datarule.id");
                dataRuleModelList.add(new DataRuleModel(appId, entityId, permItemId, dataRuleId));
            }
            DynamicObjectCollection bdEntry = roleDataRuleDy.getDynamicObjectCollection("hrcs_rolebdruleentry");
            Map<String, String> entityFieldMap = RolePermLogServiceHelper.getEntityFieldMap(entityId);
            for (DynamicObject dynamicObject : bdEntry) {
                String propKey = dynamicObject.getString("propkey");
                long bdDataRuleId = dynamicObject.getLong("bddatarule.id");
                bdDataRuleModelList.add(new BDDataRuleModel(appId, entityId, propKey, entityFieldMap.get(propKey), bdDataRuleId));
            }
        }
        roleInfoLogModel.setDataRuleModelList((List)dataRuleModelList);
        roleInfoLogModel.setBdDataRuleModelList((List)bdDataRuleModelList);
    }

    private static void handleBaseInfo(RoleInfoLogModel roleInfoLogModel, String roleId) {
        DynamicObject sysPermRole = SYS_ROLE_HELPER.loadSingle((Object)roleId);
        DynamicObject permRole = PERM_ROLE_HELPER.loadSingle((Object)roleId);
        roleInfoLogModel.setRoleNumber(sysPermRole.getString("number"));
        roleInfoLogModel.setRoleName(sysPermRole.getString("name"));
        roleInfoLogModel.setRoleType(sysPermRole.getString("roletype"));
        roleInfoLogModel.setRoleRemark(sysPermRole.getString("remark"));
        roleInfoLogModel.setRoleModifier(sysPermRole.getString("modifier.name"));
        roleInfoLogModel.setRoleModifyTime(sysPermRole.getString("modifytime"));
        roleInfoLogModel.setUseScope(permRole.getString("usescope"));
        roleInfoLogModel.setRoleCBisIntersection(permRole.getString("isintersection"));
        roleInfoLogModel.setRoleGroupId(permRole.getString("rolegrp.id"));
        roleInfoLogModel.setRoleGroupName(permRole.getString("rolegrp.name"));
        roleInfoLogModel.setCreateAdminGrpId(Long.valueOf(permRole.getLong("createadmingrp.id")));
        roleInfoLogModel.setCreateAdminGrpName(permRole.getString("createadmingrp.name"));
        roleInfoLogModel.setRoleProperty(permRole.getString("property"));
        String useScopeStr = RolePermLogServiceHelper.getComboItemTittle("usescope", roleInfoLogModel.getUseScope());
        roleInfoLogModel.setUseScopeStr(useScopeStr);
        String roleType = roleInfoLogModel.getRoleType();
        if (HRStringUtils.isNotEmpty((String)roleType)) {
            String[] split = roleType.split(",");
            ArrayList ids = Lists.newArrayListWithCapacity((int)split.length);
            for (String s : split) {
                if (!HRStringUtils.isNotEmpty((String)s)) continue;
                ids.add(Long.parseLong(s));
            }
            DynamicObject[] dynamicObjects = USER_TYPE_HELPER.loadDynamicObjectArray(ids.toArray());
            List collect = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toList());
            roleInfoLogModel.setRoleType(String.join((CharSequence)",", collect));
        }
        String intersectionStr = RolePermLogServiceHelper.getComboItemTittle("rolecbisintersection", roleInfoLogModel.getRoleCBisIntersection());
        roleInfoLogModel.setRoleCBisIntersectionStr(intersectionStr);
        String propertyStr = RolePermLogServiceHelper.getComboItemTittle("roleproperty", roleInfoLogModel.getRoleProperty());
        roleInfoLogModel.setRolePropertyStr(propertyStr);
        ArrayList fieldModelList = Lists.newArrayListWithExpectedSize((int)10);
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801", (String)"RolePermLogServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "rolenumber", roleInfoLogModel.getRoleNumber()));
        FieldModel fieldModel = new FieldModel(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"RolePermLogServiceHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "rolename", roleInfoLogModel.getRoleName());
        List enabledLang = new InteServiceImpl().getEnabledLang();
        fieldModel.setMulValueList(RolePermLogServiceHelper.getMulValues(enabledLang, (OrmLocaleValue)sysPermRole.getLocaleString("name")));
        fieldModelList.add(fieldModel);
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u89d2\u8272\u7c7b\u578b", (String)"RolePermLogServiceHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "roletype", roleInfoLogModel.getRoleType()));
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u89d2\u8272\u7ec4", (String)"RolePermLogServiceHelper_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "rolegroup", roleInfoLogModel.getRoleGroupName()));
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u89d2\u8272\u6210\u5458\u8303\u56f4\u5c5e\u6027", (String)"RolePermLogServiceHelper_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "roleproperty", propertyStr));
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u53d7\u89d2\u8272\u8303\u56f4\u9650\u5236", (String)"RolePermLogServiceHelper_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "rolecbisintersection", intersectionStr));
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4", (String)"RolePermLogServiceHelper_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "createadmingrp", roleInfoLogModel.getCreateAdminGrpName()));
        fieldModelList.add(new FieldModel(ResManager.loadKDString((String)"\u516c\u5f00\u72b6\u6001", (String)"RolePermLogServiceHelper_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "usescope", useScopeStr));
        FieldModel fieldModelMark = new FieldModel(ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"RolePermLogServiceHelper_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]), "roleremark", roleInfoLogModel.getRoleRemark());
        fieldModelMark.setMulValueList(RolePermLogServiceHelper.getMulValues(enabledLang, (OrmLocaleValue)sysPermRole.getLocaleString("remark")));
        fieldModelList.add(fieldModelMark);
        roleInfoLogModel.setFieldModelList((List)fieldModelList);
    }

    private static List<MulValue> getMulValues(List<EnabledLang> enabledLang, OrmLocaleValue value) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)value.size());
        for (EnabledLang lang : enabledLang) {
            list.add(new MulValue(lang.getNumber(), lang.getName(), value.get((Object)lang.getNumber()) == null ? "" : value.get((Object)lang.getNumber())));
        }
        return list;
    }

    private static String getComboItemTittle(String fieldName, String value) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hrcs_modifyrole");
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getAllFields().get(fieldName);
        List comboItems = ((ComboProp)property).getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            if (!HRStringUtils.equals((String)comboItem.getValue(), (String)value)) continue;
            return comboItem.getName().getLocaleValue();
        }
        return "";
    }

    public static Map<String, String> getEntityFieldMap(String entityNum) {
        HashMap fieldMap;
        block4: {
            block3: {
                if (HRStringUtils.isEmpty((String)entityNum)) {
                    LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.getEntityFieldMap.fail");
                    return Maps.newHashMapWithExpectedSize((int)0);
                }
                LOGGER.info("kd.hr.hrcs.bussiness.servicehelper.perm.log.RolePermLogServiceHelper.getEntityFieldMap\uff1a{}", (Object)entityNum);
                boolean isDynamicFormType = EntityCtrlServiceHelper.checkModelType(entityNum);
                fieldMap = Maps.newHashMapWithExpectedSize((int)16);
                if (!isDynamicFormType) break block3;
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
                DynamicObject entity = serviceHelper.queryOne("entryentity.propkey,entryentity.propname", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNum)});
                if (ObjectUtils.isEmpty((Object)entity)) break block4;
                DynamicObjectCollection collection = entity.getDynamicObjectCollection("entryentity");
                for (DynamicObject row : collection) {
                    String propKey = row.getString("propkey");
                    String propName = row.getString("propname");
                    fieldMap.put(propKey, propName);
                }
                break block4;
            }
            ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            HashMap formViewCustomParam = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList<String> noDBProps = new ArrayList<String>(10);
            List<Map<String, String>> propertyMapInEntity = customQuery.parsePropertySub((IDataEntityType)mainEntityType, null, formViewCustomParam, "1=1", noDBProps);
            for (Map<String, String> propMap : propertyMapInEntity) {
                String fieldId = propMap.get("field_id");
                String fieldName = propMap.get("field_name");
                fieldMap.put(fieldId, fieldName);
            }
        }
        return fieldMap;
    }
}

