/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.preview;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeBean;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeService;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public abstract class AbstractTreeNodeService
implements TreeNodeService {
    private final Log LOGGER = LogFactory.getLog(this.getClass());

    protected abstract AuthorizedOrgResultWithSub getHasPermAdminOrgWithSub(IFormView var1);

    protected abstract String getStructEntityNumber(String var1);

    protected abstract String getStructLongNumber(String var1, Long var2);

    protected abstract List<QFilter> getBaseFilter(IFormView var1);

    protected abstract String getPrimaryKey();

    protected abstract String getSelectFields();

    protected abstract String getOrderBy();

    protected abstract String getSeparator();

    @Override
    public List<TreeNodeBean> getHasAdminPermTreeNodeList(IFormView formView, Long parentId, List<Long> otClassifies, Long relyOnStruct, Set<String> structLongNumbers, boolean isCustomProjectStruct, QFilter extendQFilter, boolean showCompanyName) {
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        List<TreeNodeBean> firstLevelList = this.getFirstLevelData(formView, parentId, otClassifies, structLongNumbers, extendQFilter);
        List<Long> firstLevelIdList = firstLevelList.stream().map(TreeNodeBean::getId).collect(Collectors.toList());
        AuthorizedOrgResultWithSub permOrgResult = this.getHasPermAdminOrgWithSub(formView);
        List orgsWithSub = permOrgResult.getHasPermOrgsWithSub();
        List<TreeNodeBean> secondLevelList = this.getSecondLevelData(formView, firstLevelIdList, null);
        boolean hasAll = permOrgResult.isHasAllOrgPerm() ? true : this.hasAllCurrentNodePerm(entityNumber, parentId, orgsWithSub);
        this.LOGGER.info("Got admin perm tree node param values with hasAll:[{}], firstLevelList:[{}], secondLevelList:[{}], orgsWithSub:[{}].", new Object[]{hasAll, firstLevelList.size(), secondLevelList.size(), orgsWithSub});
        if (hasAll) {
            return this.getFirstLevelWithAllPerm(firstLevelList, secondLevelList);
        }
        return this.getFirstLevelWithoutAllPerm(firstLevelList, secondLevelList, orgsWithSub);
    }

    @Override
    public Map<Long, List<Pair<Long, String>>> getNodeAllParents(IFormView formView, List<Long> nodeIds, List<Long> struct, Long relyOnStruct, boolean isCustomProjectStruct) {
        String primaryKey = this.getPrimaryKey();
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        String structEntityNumber = this.getStructEntityNumber(entityNumber);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityNumber);
        List<QFilter> qFilters = this.getBaseFilter(formView);
        qFilters.add(new QFilter(primaryKey, "in", nodeIds));
        HashSet structLongNumberList = new HashSet(16);
        HashSet leafStructLongNumberList = new HashSet(16);
        Arrays.stream(serviceHelper.query("longnumber", HRPermCommonUtil.listToQFilters(qFilters))).forEach(item -> {
            String structLongNumber = item.getString("longnumber");
            leafStructLongNumberList.add(structLongNumber);
            while (HRStringUtils.isNotEmpty((String)structLongNumber)) {
                structLongNumberList.add(structLongNumber);
                int tempIndex = structLongNumber.lastIndexOf(this.getSeparator());
                if (-1 == tempIndex) break;
                structLongNumber = structLongNumber.substring(0, tempIndex);
            }
        });
        structLongNumberList.removeAll(leafStructLongNumberList);
        List<QFilter> commonParentFilters = this.getBaseFilter(formView);
        commonParentFilters.add(new QFilter("longnumber", "in", structLongNumberList));
        List commonParent = Arrays.stream(serviceHelper.query(primaryKey + ",longnumber", HRPermCommonUtil.listToQFilters(commonParentFilters))).map(it -> Pair.of((Object)it.getLong(primaryKey), (Object)it.getString("longnumber"))).sorted(Comparator.comparingInt(it -> ((String)it.getRight()).length())).collect(Collectors.toList());
        List<QFilter> parentFilters = this.getBaseFilter(formView);
        parentFilters.add(new QFilter("longnumber", "in", leafStructLongNumberList));
        return Arrays.stream(serviceHelper.query(primaryKey + ",longnumber", HRPermCommonUtil.listToQFilters(parentFilters))).collect(Collectors.toMap(item -> item.getLong(primaryKey), item -> {
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.addAll(commonParent);
            list.add(list.size(), Pair.of((Object)item.getLong(primaryKey), (Object)item.getString("longnumber")));
            return list;
        }, (oldValue, newValue) -> oldValue));
    }

    private List<TreeNodeBean> getFirstLevelData(IFormView formView, Long parentId, List<Long> otClassifies, Set<String> structLongNumbers, QFilter extendQFilter) {
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        String structEntityNumber = this.getStructEntityNumber(entityNumber);
        String selectFields = this.getSelectFields();
        List<QFilter> baseQFilterList = this.getBaseFilter(formView);
        baseQFilterList.add(new QFilter("parent", "=", (Object)parentId));
        if (otClassifies.size() == 1 && otClassifies.get(0) == 0L) {
            return new ArrayList<TreeNodeBean>();
        }
        if (null != structLongNumbers && !structLongNumbers.isEmpty()) {
            baseQFilterList.add(new QFilter("longnumber", "in", structLongNumbers));
        }
        if (null != extendQFilter) {
            baseQFilterList.add(extendQFilter);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityNumber);
        DynamicObjectCollection firstLevelCollection = serviceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList), this.getOrderBy());
        return firstLevelCollection.stream().filter(dyno -> 0L != dyno.getLong("id")).map(dyno -> {
            String name = this.getDisabledName(dyno.getString("name"), dyno.getString("enable"));
            TreeNodeBean nodeBean = new TreeNodeBean();
            nodeBean.setId(dyno.getLong("id"));
            nodeBean.setName(name);
            nodeBean.setNumber(dyno.getString("number"));
            nodeBean.setStructNumber(dyno.getString("structnumber"));
            nodeBean.setStructLongNumber(dyno.getString("longnumber"));
            nodeBean.setCurrentClassify(1010L);
            return nodeBean;
        }).collect(Collectors.toList());
    }

    private List<TreeNodeBean> getSecondLevelData(IFormView formView, List<Long> firstLevelIdList, QFilter extendQFilter) {
        String entityNumber = (String)formView.getFormShowParameter().getCustomParam("entityNumber");
        String structEntityNumber = this.getStructEntityNumber(entityNumber);
        List<QFilter> baseQFilterList = this.getBaseFilter(formView);
        baseQFilterList.add(new QFilter("parent", "in", firstLevelIdList));
        baseQFilterList.add(extendQFilter);
        String selectFields = this.getSelectFields();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityNumber);
        DynamicObjectCollection secondLevelColl = serviceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList));
        return secondLevelColl.stream().map(dyno -> {
            TreeNodeBean nodeBean = new TreeNodeBean();
            nodeBean.setId(dyno.getLong("id"));
            nodeBean.setParentId(dyno.getLong("parentid"));
            nodeBean.setStructLongNumber(dyno.getString("longnumber"));
            nodeBean.setCurrentClassify(1010L);
            return nodeBean;
        }).collect(Collectors.toList());
    }

    private boolean hasAllCurrentNodePerm(String entityNumber, Long parentId, List<OrgSubInfo> orgsWithSub) {
        String structLongNumber = this.getStructLongNumber(entityNumber, parentId);
        for (OrgSubInfo orgSubInfo : orgsWithSub) {
            if (HRStringUtils.isEmpty((String)orgSubInfo.getLongStructNumber()) || !orgSubInfo.isContainsSub() || !structLongNumber.startsWith(orgSubInfo.getLongStructNumber())) continue;
            return true;
        }
        return false;
    }

    private List<TreeNodeBean> getFirstLevelWithAllPerm(List<TreeNodeBean> firstLevelList, List<TreeNodeBean> secondLevelList) {
        Set parentIdSet = secondLevelList.stream().map(TreeNodeBean::getParentId).collect(Collectors.toSet());
        for (TreeNodeBean orgBean : firstLevelList) {
            orgBean.setLeaf(!parentIdSet.contains(orgBean.getId()));
            orgBean.setHasPerm(true);
        }
        return firstLevelList;
    }

    private List<TreeNodeBean> getFirstLevelWithoutAllPerm(List<TreeNodeBean> firstLevelList, List<TreeNodeBean> secondLevelList, List<OrgSubInfo> orgsWithSub) {
        Set<String> hasPermAllParentStructNumber = AbstractTreeNodeService.getAllParentStructNumber(orgsWithSub);
        Set parentIdSet = secondLevelList.stream().map(TreeNodeBean::getParentId).collect(Collectors.toSet());
        Set hasPermOrgIds = orgsWithSub.stream().map(OrgSubInfo::getOrgId).collect(Collectors.toSet());
        this.LOGGER.info("Got all parent struct number: [{}], hasPermOrgIds:[{}].", hasPermAllParentStructNumber, hasPermOrgIds);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (TreeNodeBean orgBean : firstLevelList) {
            if (!hasPermAllParentStructNumber.contains(orgBean.getStructNumber())) continue;
            result.add(orgBean);
            orgBean.setHasPerm(hasPermOrgIds.contains(orgBean.getId()));
            orgBean.setLeaf(!parentIdSet.contains(orgBean.getId()));
        }
        return result;
    }

    private static Set<String> getAllParentStructNumber(List<OrgSubInfo> orgsWithSub) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgSubInfo orgSubInfo : orgsWithSub) {
            result.addAll(AbstractTreeNodeService.splitLongNumber(orgSubInfo.getLongStructNumber()));
        }
        return result;
    }

    private static Set<String> splitLongNumber(String longNumber) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)longNumber)) {
            return result;
        }
        String[] structNumberArr = longNumber.split("!");
        Collections.addAll(result, structNumberArr);
        return result;
    }

    public String getDisabledName(String oriName, String enable) {
        String disabledPrefix = ResManager.loadKDString((String)"\uff08\u7981\u7528\uff09", (String)"PermOTLazyTreeCommonHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String name = oriName;
        if ("0".equals(enable)) {
            name = name + disabledPrefix;
        }
        return name;
    }
}

