/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.privacy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PrivacySigningServiceHelper {
    private static final String ENTITY_PRIVACY_STATEMENT = "privacystatement";

    public static Map<String, Object> getPrivacySigningList(Map<String, Object> paramMap) {
        Set lanIdList;
        String errMsg = PrivacySigningServiceHelper.validate(paramMap, '0');
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            return PrivacySigningServiceHelper.getResponseMap(errMsg, null);
        }
        String userId = (String)paramMap.get("user");
        Long userTypeId = (Long)paramMap.get("userType");
        Map busGroupMap = (Map)paramMap.get("group");
        Boolean isSystem = (Boolean)paramMap.get("system");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_PRIVACY_STATEMENT);
        Set busIdList = busGroupMap.keySet();
        DynamicObject[] results = serviceHelper.query("id,version,content_tag,name,form,locale", new QFilter[]{new QFilter("form.id", "in", busIdList), new QFilter("locale.id", "in", lanIdList = busGroupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())), new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("status", "=", (Object)"C")});
        if (results == null || results.length < 1) {
            String msg = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9690\u79c1\u58f0\u660e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u662f\u5426\u5df2\u914d\u7f6e\u9690\u79c1\u58f0\u660e\u3002", (String)"PrivacySigningServiceHelper_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            return PrivacySigningServiceHelper.getResponseMap(msg, null);
        }
        Map<String, List<DynamicObject>> privacyVersions = Stream.of(results).filter(result -> ((Set)busGroupMap.get(result.getString("form.id"))).contains(result.getLong("locale.id"))).collect(Collectors.groupingBy(result -> result.getString("form.id") + result.getLong("locale.id")));
        ArrayList filteredList = Lists.newArrayListWithExpectedSize((int)privacyVersions.size());
        privacyVersions.forEach((key, value) -> {
            value.sort((x1, x2) -> {
                double x1V = Double.parseDouble(x1.getString("version").substring(1));
                double x2V = Double.parseDouble(x2.getString("version").substring(1));
                return Double.compare(x2V, x1V);
            });
            filteredList.add(value.get(0));
        });
        Set<Long> privacyIdSet = filteredList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] privacySignings = PrivacySigningServiceHelper.getPrivacySignings(isSystem, userId, userTypeId, privacyIdSet);
        Map<Long, DynamicObject> privacySigningMap = Arrays.stream(privacySignings).collect(Collectors.toMap(privacySigning -> privacySigning.getLong("privacystmt.id"), privacySigning -> privacySigning));
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)filteredList.size());
        filteredList.forEach(filteredResult -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)filteredList.size());
            long id = filteredResult.getLong("id");
            map.put("id", id);
            String newVersion = filteredResult.getString("version");
            if (privacySigningMap.get(id) != null) {
                DynamicObject newVersionDyn = (DynamicObject)privacySigningMap.get(id);
                map.put("version", newVersion);
                map.put("isAgree", newVersionDyn.get("isagree"));
                map.put("modifyTime", newVersionDyn.getDate("modifytime"));
            }
            map.put("name", filteredResult.getString("name"));
            map.put("content", filteredResult.getString("content_tag"));
            map.put("form", filteredResult.getString("form.id"));
            map.put("locale", filteredResult.getString("locale.id"));
            dataList.add(map);
        });
        return PrivacySigningServiceHelper.getResponseMap(errMsg, dataList);
    }

    public static Map<String, Object> signPrivacy(List<Map<String, Object>> paramMapList) {
        for (Map<String, Object> paramMap : paramMapList) {
            String errMsg = PrivacySigningServiceHelper.validate(paramMap, '1');
            if (StringUtils.isEmpty((CharSequence)errMsg)) continue;
            return PrivacySigningServiceHelper.getResponseMap(errMsg, null);
        }
        DynamicObjectCollection systemCollection = new DynamicObjectCollection();
        DynamicObjectCollection noSystemCollection = new DynamicObjectCollection();
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)paramMapList.size());
        for (Map<String, Object> map : paramMapList) {
            if (map.get("id") == null) continue;
            idSet.add((Long)map.get("id"));
        }
        HRBaseServiceHelper privacyServiceHelper = new HRBaseServiceHelper(ENTITY_PRIVACY_STATEMENT);
        DynamicObject[] results = privacyServiceHelper.query("id,version,content_tag,name,form,locale", new QFilter[]{new QFilter("id", "in", (Object)idSet)});
        Map<Long, DynamicObject> resultMap = Stream.of(results).collect(Collectors.toMap(result -> result.getLong("id"), result -> result));
        for (Map<String, Object> paramMap : paramMapList) {
            DynamicObject dynamicObject;
            HRBaseServiceHelper serviceHelper;
            Date modifyTime = (Date)paramMap.get("modifyTime");
            Long id = (Long)paramMap.get("id");
            String client = (String)paramMap.get("client");
            Long country = (Long)paramMap.get("country");
            Boolean isSystem = (Boolean)paramMap.get("system");
            String userId = (String)paramMap.get("user");
            Long userTypeId = (Long)paramMap.get("userType");
            DynamicObject privacy = resultMap.get(id);
            if (privacy == null) continue;
            if (isSystem.booleanValue()) {
                serviceHelper = new HRBaseServiceHelper("userprivacystmt");
                dynamicObject = serviceHelper.generateEmptyDynamicObject();
                systemCollection.add((Object)dynamicObject);
                dynamicObject.set("user", (Object)Long.valueOf(userId));
            } else {
                serviceHelper = new HRBaseServiceHelper("hrcs_privacysigning");
                dynamicObject = serviceHelper.generateEmptyDynamicObject();
                dynamicObject.set("user", (Object)userId);
                dynamicObject.set("usertype", (Object)userTypeId);
                dynamicObject.set("version", (Object)privacy.getString("version"));
                dynamicObject.set("form", (Object)privacy.getString("form.id"));
                dynamicObject.set("locale", (Object)privacy.getLong("locale.id"));
                dynamicObject.set("client", (Object)client);
                dynamicObject.set("country", (Object)country);
                noSystemCollection.add((Object)dynamicObject);
            }
            dynamicObject.set("privacystmt", (Object)id);
            dynamicObject.set("isagree", (Object)"1");
            dynamicObject.set("modifytime", (Object)modifyTime);
        }
        String errMsg = PrivacySigningServiceHelper.validateDuplicate(systemCollection, noSystemCollection);
        if (StringUtils.isEmpty((CharSequence)errMsg)) {
            HRBaseServiceHelper sysServiceHelper = new HRBaseServiceHelper("userprivacystmt");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_privacysigning");
            sysServiceHelper.save(systemCollection);
            serviceHelper.save(noSystemCollection);
        }
        return PrivacySigningServiceHelper.getResponseMap(errMsg, null);
    }

    public static Map<String, Object> getNewVersionPrivacy(Map<String, Object> paramMap) {
        String errMsg = PrivacySigningServiceHelper.validate(paramMap, '0');
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            return PrivacySigningServiceHelper.getResponseMap(errMsg, null);
        }
        Boolean isSystem = (Boolean)paramMap.get("system");
        Long userTypeId = (Long)paramMap.get("userType");
        String userId = (String)paramMap.get("user");
        Map busGroupMap = (Map)paramMap.get("group");
        HashSet lanIdList = Sets.newHashSetWithExpectedSize((int)busGroupMap.size());
        Set<String> busIdList = busGroupMap.keySet();
        busGroupMap.forEach((key, value) -> lanIdList.addAll(value));
        DynamicObject[] results = PrivacySigningServiceHelper.getVersionsPrivacy(isSystem, userId, userTypeId, busIdList, lanIdList);
        Map<String, List<DynamicObject>> groupMap = Stream.of(results).filter(result -> {
            if (isSystem.booleanValue()) {
                return ((Set)busGroupMap.get(result.getString("privacystmt.form.id"))).contains(result.getLong("privacystmt.locale.id"));
            }
            return ((Set)busGroupMap.get(result.getString("form.id"))).contains(result.getLong("locale.id"));
        }).collect(Collectors.groupingBy(privacySigning -> privacySigning.getString("form.id") + privacySigning.getLong("locale.id")));
        HashMap filteredMap = Maps.newHashMapWithExpectedSize((int)results.length);
        groupMap.forEach((key, value) -> {
            value.sort((x1, x2) -> {
                String version2;
                String version1;
                if (isSystem.booleanValue()) {
                    version1 = x1.getString("privacystmt.version").substring(1);
                    version2 = x2.getString("privacystmt.version").substring(1);
                } else {
                    version1 = x1.getString("version").substring(1);
                    version2 = x2.getString("version").substring(1);
                }
                return Double.compare(Double.parseDouble(version2), Double.parseDouble(version1));
            });
            DynamicObject newestVersion = (DynamicObject)value.get(0);
            filteredMap.put(newestVersion.getLong("privacystmt.id"), newestVersion);
        });
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)filteredMap.size());
        if (!CollectionUtils.isEmpty((Map)filteredMap)) {
            Set privacyIdSet = filteredMap.keySet();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(ENTITY_PRIVACY_STATEMENT);
            DynamicObject[] privacyResults = serviceHelper.query("id,version,content_tag,name,form,locale", new QFilter[]{new QFilter("id", "in", privacyIdSet)});
            Map<Long, DynamicObject> privacyMap = Arrays.stream(privacyResults).collect(Collectors.toMap(privacy -> privacy.getLong("id"), privacy -> privacy));
            filteredMap.forEach((key, value) -> {
                DynamicObject privacy = (DynamicObject)privacyMap.get(key);
                if (privacy != null) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)filteredMap.size());
                    map.put("content", privacy.getString("content_tag"));
                    map.put("id", key);
                    if (isSystem.booleanValue()) {
                        map.put("version", privacy.getString("version"));
                    } else {
                        map.put("version", value.getString("version"));
                    }
                    map.put("name", privacy.getString("name"));
                    map.put("isAgree", value.get("isagree"));
                    map.put("modifyTime", value.getDate("modifytime"));
                    map.put("form", privacy.getString("form.id"));
                    map.put("locale", privacy.getString("locale.id"));
                    dataList.add(map);
                }
            });
        }
        return PrivacySigningServiceHelper.getResponseMap(errMsg, dataList);
    }

    private static String validate(Map<String, Object> paramMap, char type) {
        String errMsg = PrivacySigningServiceHelper.validateType(paramMap);
        if (errMsg.length() == 0) {
            errMsg = PrivacySigningServiceHelper.validateNull(paramMap, type);
        }
        return errMsg;
    }

    private static String validateNull(Map<String, Object> paramMap, char type) {
        Boolean isSystem = (Boolean)paramMap.get("system");
        String userId = (String)paramMap.get("user");
        Long userTypeId = (Long)paramMap.get("userType");
        Map busGroupMap = (Map)paramMap.get("group");
        Date modifyTime = (Date)paramMap.get("modifyTime");
        Long id = (Long)paramMap.get("id");
        StringBuilder stringBuilder = new StringBuilder();
        if (isSystem == null) {
            stringBuilder.append("system ");
        } else if (!isSystem.booleanValue() && userTypeId == null) {
            stringBuilder.append("userType ");
        }
        if (StringUtils.isEmpty((CharSequence)userId)) {
            stringBuilder.append("user ");
        }
        switch (type) {
            case '0': {
                if (!CollectionUtils.isEmpty((Map)busGroupMap)) break;
                stringBuilder.append("group ");
                break;
            }
            case '1': {
                if (id == null) {
                    stringBuilder.append("id ");
                }
                if (modifyTime != null) break;
                stringBuilder.append("modifytime ");
                break;
            }
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append("can't be empty!");
        }
        return stringBuilder.toString();
    }

    private static String validateType(Map<String, Object> paramMap) {
        Object isSystem = paramMap.get("system");
        Object user = paramMap.get("user");
        Object userType = paramMap.get("userType");
        Object map = paramMap.get("group");
        Object modifyTime = paramMap.get("modifyTime");
        Object id = paramMap.get("id");
        StringBuilder stringBuilder = new StringBuilder();
        if (isSystem != null && !(isSystem instanceof Boolean)) {
            stringBuilder.append("system ");
        }
        if (user != null && !(user instanceof String)) {
            stringBuilder.append("user ");
        }
        if (userType != null && !(userType instanceof Long)) {
            stringBuilder.append("userType ");
        }
        if (map != null) {
            if (map instanceof Map) {
                Map busGroupMap = (Map)map;
                block0: for (Map.Entry next : busGroupMap.entrySet()) {
                    if (!(next.getKey() instanceof String)) {
                        stringBuilder.append("group ");
                        break;
                    }
                    Set values = (Set)next.getValue();
                    for (Object locale : values) {
                        if (locale instanceof Long) continue;
                        stringBuilder.append("group ");
                        continue block0;
                    }
                }
            } else {
                stringBuilder.append("group ");
            }
        }
        if (modifyTime != null && !(modifyTime instanceof Date)) {
            stringBuilder.append("modifytime ");
        }
        if (id != null && !(id instanceof Long)) {
            stringBuilder.append("id ");
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append("args type error!");
        }
        return stringBuilder.toString();
    }

    private static String validateDuplicate(DynamicObjectCollection systemCollection, DynamicObjectCollection noSystemCollection) {
        List<Object> userIdList;
        List<Object> privacyIdList;
        if (!systemCollection.isEmpty()) {
            HRBaseServiceHelper sysServiceHelper = new HRBaseServiceHelper("userprivacystmt");
            privacyIdList = systemCollection.stream().map(sysDyn -> sysDyn.getLong("privacystmt")).collect(Collectors.toList());
            userIdList = systemCollection.stream().map(sysDyn -> sysDyn.getLong("user")).collect(Collectors.toList());
            DynamicObject[] results = sysServiceHelper.query("id,privacystmt,user", new QFilter[]{new QFilter("privacystmt.id", "in", (Object)privacyIdList), new QFilter("user.id", "in", (Object)userIdList)});
            Map<String, Long> privacyMap = systemCollection.stream().collect(Collectors.toMap(sysDyn -> sysDyn.getLong("privacystmt") + "." + sysDyn.getLong("user"), sysDyn -> sysDyn.getLong("user")));
            for (DynamicObject result : results) {
                Long userId = privacyMap.get(result.getLong("privacystmt.id") + "." + result.getLong("user.id"));
                if (userId == null) continue;
                return ResManager.loadKDString((String)"\u5f53\u524d\u58f0\u660e\u5df2\u7ecf\u7b7e\u7f72", (String)"PrivacySigningServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            }
        }
        if (!noSystemCollection.isEmpty()) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_privacysigning");
            privacyIdList = Lists.newArrayListWithExpectedSize((int)noSystemCollection.size());
            userIdList = Lists.newArrayListWithExpectedSize((int)noSystemCollection.size());
            ArrayList userTypeIdList = Lists.newArrayListWithExpectedSize((int)noSystemCollection.size());
            noSystemCollection.forEach(noSys -> {
                privacyIdList.add(noSys.getLong("privacystmt"));
                userIdList.add(noSys.getString("user"));
                userTypeIdList.add(noSys.getLong("usertype"));
            });
            DynamicObject[] results = serviceHelper.query("id,privacystmt,user,usertype", new QFilter[]{new QFilter("privacystmt.id", "in", (Object)privacyIdList), new QFilter("user", "in", (Object)userIdList), new QFilter("usertype.id", "in", (Object)userTypeIdList)});
            Map<String, DynamicObject> privacyMap = noSystemCollection.stream().collect(Collectors.toMap(dyn -> dyn.getLong("privacystmt") + "." + dyn.getString("user") + "." + dyn.getLong("usertype"), dyn -> dyn));
            for (DynamicObject result : results) {
                DynamicObject dyn2 = privacyMap.get(result.getLong("privacystmt.id") + "." + result.getString("user") + "." + result.getLong("usertype.id"));
                if (dyn2 == null) continue;
                return ResManager.loadKDString((String)"\u5f53\u524d\u58f0\u660e\u5df2\u7ecf\u7b7e\u7f72", (String)"PrivacySigningServiceHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private static DynamicObject[] getPrivacySignings(boolean isSystem, String userId, Long userTypeId, Set<Long> privacyIdSet) {
        DynamicObject[] privacySignings;
        if (isSystem) {
            HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("userprivacystmt");
            privacySignings = hrServiceHelper.query("id,privacystmt,privacystmt.version,isagree,modifytime", new QFilter[]{new QFilter("user.id", "=", (Object)Long.valueOf(userId)), new QFilter("privacystmt.id", "in", privacyIdSet), new QFilter("isagree", "=", (Object)Character.valueOf('1'))});
        } else {
            HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("hrcs_privacysigning");
            privacySignings = hrServiceHelper.query("id,privacystmt,version,isagree,modifytime", new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("usertype.id", "=", (Object)userTypeId), new QFilter("privacystmt.id", "in", privacyIdSet), new QFilter("isagree", "=", (Object)"1")});
        }
        return privacySignings;
    }

    private static DynamicObject[] getVersionsPrivacy(boolean isSystem, String userId, Long userTypeId, Set<String> busIdList, Set<Long> lanIdList) {
        DynamicObject[] results;
        if (isSystem) {
            HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("userprivacystmt");
            results = hrServiceHelper.query("id,privacystmt,privacystmt.version,privacystmt.form,privacystmt.locale,isagree,modifytime", new QFilter[]{new QFilter("privacystmt.form.id", "in", busIdList), new QFilter("privacystmt.locale.id", "in", lanIdList), new QFilter("user.id", "=", (Object)Long.valueOf(userId)), new QFilter("isagree", "=", (Object)Character.valueOf('1'))});
        } else {
            HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("hrcs_privacysigning");
            results = hrServiceHelper.query("id,privacystmt,version,isagree,modifytime,form,locale", new QFilter[]{new QFilter("form.id", "in", busIdList), new QFilter("locale.id", "in", lanIdList), new QFilter("user", "=", (Object)userId), new QFilter("usertype.id", "=", (Object)userTypeId), new QFilter("isagree", "=", (Object)"1")});
        }
        return results;
    }

    private static Map<String, Object> getResponseMap(String errMsg, List<Map<String, Object>> data) {
        HashMap responseMap = Maps.newHashMapWithExpectedSize((int)16);
        responseMap.put("responseCode", errMsg.length() == 0 ? "200" : "500");
        responseMap.put("responseDesc", errMsg.length() == 0 ? "success" : "fail");
        responseMap.put("errMessage", errMsg);
        responseMap.put("data", data);
        return responseMap;
    }
}

