/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.strategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.common.strategy.InitStrategyOrgModel;
import org.apache.commons.lang3.tuple.Pair;

public class InitStrategyServiceHelper {
    private static final Log LOG = LogFactory.getLog(InitStrategyServiceHelper.class);

    public static Map<Long, DynamicObject> getExistsStrategy(String entityNumber) {
        HRBaseServiceHelper strategyHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] strategys = strategyHelper.loadDynamicObjectArray(new QFilter[0]);
        return Arrays.stream(strategys).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), dy -> dy, (k1, k2) -> k1));
    }

    public static DynamicObject[] getAdminStruct(Collection<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        QFilter adminOrgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter orgStructFilter = new QFilter("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        return serviceHelper.queryOriginalArray("adminorg.id,structlongnumber", new QFilter[]{adminOrgFilter, currentFilter, orgStructFilter});
    }

    public static Map<Long, DynamicObject> getAdminOrgDetails(Collection<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter adminOrgFilter = new QFilter("id", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] details = serviceHelper.queryOriginalArray("id,bsed,enable", new QFilter[]{adminOrgFilter, currentFilter});
        return Arrays.stream(details).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
    }

    public static Map<Long, String> getAdminStruct2Map(Collection<Long> orgIds) {
        DynamicObject[] adminStruct = InitStrategyServiceHelper.getAdminStruct(orgIds);
        return Arrays.stream(adminStruct).collect(Collectors.toMap(struct -> struct.getLong("adminorg.id"), struct -> struct.getString("structlongnumber"), (k1, k2) -> k1));
    }

    public static List<InitStrategyOrgModel> getInitModel(Collection<Long> orgIds, Map<Long, DynamicObject> hrOrgId2Dy) {
        LOG.info("InitStrategyServiceHelper.getInitModel_orgIds size:{}", (Object)orgIds.size());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)orgIds.size());
        Map<Long, String> adminStruct2Map = InitStrategyServiceHelper.getAdminStruct2Map(orgIds);
        if (orgIds.size() != adminStruct2Map.size()) {
            Sets.SetView difference = Sets.difference(new HashSet<Long>(orgIds), adminStruct2Map.keySet());
            orgIds.removeAll((Collection<?>)difference);
            LOG.error("getInitModel() exist adminOrg don't have struct info, orgIds:{}", (Object)difference);
        }
        DynamicObject rootHROrg = HRBUExtServiceHelper.getRootHROrg();
        HashSet withOutLongNumber = Sets.newHashSetWithExpectedSize((int)16);
        orgIds.forEach(id -> {
            long parent = ((DynamicObject)hrOrgId2Dy.get(id)).getLong("parent");
            InitStrategyOrgModel model = new InitStrategyOrgModel(id.longValue(), (String)adminStruct2Map.get(id), parent);
            if (parent != 0L) {
                model.setParentId(parent);
            } else {
                model.setParentId(rootHROrg.getLong("id"));
            }
            if (HRStringUtils.isEmpty((String)((String)adminStruct2Map.get(id)))) {
                withOutLongNumber.add(id);
            } else {
                result.add(model);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)withOutLongNumber)) {
            LOG.error("getInitModel() org:{} structLongNumber is empty.", (Object)withOutLongNumber);
        }
        return result;
    }

    public static DynamicObject[] getAllStrategyType() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_strategy");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return helper.query("id,bussinessfield,strategytype", new QFilter[]{enableFilter});
    }

    public static DynamicObject[] getAllBusinessTypeReal(Long orgType, Long ... bussinessId) {
        LOG.info("InitStrategyServiceHelper-getAllBusinessTypeReal,orgType:{}", (Object)orgType);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_bussinesstype");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isAllFieldFilter = new QFilter("isallfield", "=", (Object)"0");
        QFilter orgTypeFilter = new QFilter("bussinessobject.orgtype.id", "=", (Object)orgType);
        if (bussinessId.length > 0) {
            LOG.info("InitStrategyServiceHelper-getAllBusinessTypeReal,bussinessId:{}", (Object)bussinessId[0]);
            orgTypeFilter.and("bussinessobject.id", "=", (Object)bussinessId[0]);
        }
        return helper.query("id,name,number,bussinesstype,bussinessobject.id", new QFilter[]{enableFilter, isAllFieldFilter, orgTypeFilter});
    }

    public static Map<Long, Map<Long, DynamicObject>> getParentStrategy(Collection<Long> projectTeamIds, String entityNumber, String fieldKey) {
        LOG.info("InitStrategyServiceHelper-getParentStrategy,projectTeamIds:{},entityNumber:{},fieldKey:{}", new Object[]{projectTeamIds, entityNumber, fieldKey});
        HRBaseServiceHelper serviceHelper = "hrcs_empstrategy".equals(entityNumber) ? new HRBaseServiceHelper("hrcs_empstrategy") : ("hrcs_orgstrategy".equals(entityNumber) ? new HRBaseServiceHelper("hrcs_orgstrategy") : ("hrcs_projempstrategy".equals(entityNumber) ? new HRBaseServiceHelper("hrcs_projempstrategy") : new HRBaseServiceHelper("hrcs_projorgstrategy")));
        QFilter qFilter = new QFilter("orgteam", "in", projectTeamIds);
        DynamicObject[] result = serviceHelper.query("orgteam,entryentity.bussinessfield,entryentity.entryhrbu,entryentity.entryinheritedorg", new QFilter[]{qFilter});
        return Arrays.stream(result).collect(Collectors.toMap(struct -> struct.getLong("orgteam.id"), struct -> struct.getDynamicObjectCollection("entryentity").stream().filter(dy -> Objects.nonNull(dy.getDynamicObject(fieldKey))).collect(Collectors.toMap(row -> row.getLong("bussinessfield.bussinesstype.id"), row -> row.getDynamicObject(fieldKey), (k1, k2) -> k2))));
    }

    public static List<DynamicObject> getEnableAdminOrg() {
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("haos_adminorghr");
        QFilter qFilter = InitStrategyServiceHelper.getHisDataFilter();
        InitStrategyServiceHelper.setDataFilter(qFilter);
        return Arrays.asList(orgHelper.queryOriginalArray("id,number,parent,bsed,enable", new QFilter[]{qFilter}));
    }

    public static List<Long> getEnableProjectTeam() {
        HRBaseServiceHelper projTeamHelper = new HRBaseServiceHelper("haos_projectteamhr");
        QFilter qFilter = InitStrategyServiceHelper.getHisDataFilter();
        InitStrategyServiceHelper.setDataFilter(qFilter);
        return Arrays.stream(projTeamHelper.queryOriginalArray("id", new QFilter[]{qFilter})).map(obj -> obj.getLong("id")).collect(Collectors.toList());
    }

    private static void setDataFilter(QFilter qFilter) {
        qFilter.and("initstatus", "in", (Object)"2");
        ArrayList dstatus = Lists.newArrayListWithExpectedSize((int)16);
        dstatus.add("1");
        dstatus.add("2");
        qFilter.and("datastatus", "in", (Object)dstatus);
    }

    public static List<DynamicObject> getProjectTeamDynamicObject(List<Long> ids) {
        HRBaseServiceHelper projTeamHelper = new HRBaseServiceHelper("haos_projectteamhr");
        QFilter qFilter = InitStrategyServiceHelper.getHisDataFilter();
        qFilter.and("id", "in", ids);
        InitStrategyServiceHelper.setDataFilter(qFilter);
        return Arrays.asList(projTeamHelper.query("id,establishmentdate,belongadminorg.id,parentorg.otclassify,enable", new QFilter[]{qFilter}));
    }

    public static Map<Long, List<Long>> getHrBuByAdminOrg(Collection<Long> adminOrgIds, Long businessObjectId) {
        Set<Long> viewIds = HRBUExtServiceHelper.getVersionView(true);
        HRBaseServiceHelper orgStruteHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter idFilter = new QFilter("org.id", "in", adminOrgIds);
        QFilter viewFilter = new QFilter("view", "in", viewIds);
        DynamicObject[] orgStructureDys = orgStruteHelper.query("org,view", new QFilter[]{viewFilter, idFilter});
        QFilter filter = new QFilter("controlfuntype.id", "in", viewIds);
        DynamicObject[] businessFields = new HRBaseServiceHelper("hbss_bussinessfield").query("id,controlfuntype.id", new QFilter[]{filter});
        Map<Long, Long> businessTypeMap = Arrays.stream(businessFields).collect(Collectors.toMap(dy -> dy.getLong("controlfuntype.id"), dy2 -> dy2.getLong("id"), (x1, x2) -> x1));
        QFilter filter2 = new QFilter("bussinesstype.id", "in", businessTypeMap.values());
        filter2.and("bussinessobject.id", "=", (Object)businessObjectId);
        DynamicObject[] businessTypeTies = new HRBaseServiceHelper("hrcs_bussinesstype").query("id,bussinesstype.id", new QFilter[]{filter2});
        Map<Long, Long> businessTypeTiesMap = Arrays.stream(businessTypeTies).collect(Collectors.toMap(dy -> dy.getLong("bussinesstype.id"), dy2 -> dy2.getLong("id"), (x1, x2) -> x1));
        Map<Long, List<Long>> result = Arrays.stream(orgStructureDys).collect(Collectors.groupingBy(dy -> {
            if (dy.getLong("view.id") == ManageStrategyConstants.BU_VIEW_ID.longValue()) {
                return ManageStrategyConstants.BU_VIEW_ID;
            }
            return Optional.ofNullable(businessTypeTiesMap.get(businessTypeMap.get(dy.getLong("view.id")))).orElse(0L);
        }, Collectors.mapping(dy2 -> dy2.getLong("org.id"), Collectors.toList())));
        result.remove(0L);
        return result;
    }

    public static Pair<Set<Long>, Map<Long, Set<Long>>> compareStrategy(Map<Long, DynamicObject> existStrategys, Set<Long> existTypesReals) {
        HashMap lacks = Maps.newHashMapWithExpectedSize((int)16);
        HashSet completeOrgs = Sets.newHashSetWithExpectedSize((int)16);
        existStrategys.forEach((orgTeamId, strategy) -> {
            DynamicObjectCollection strategyEntry = strategy.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)strategyEntry)) {
                lacks.put(orgTeamId, existTypesReals);
            } else {
                Set businessTypes = strategyEntry.stream().map(dy -> dy.getLong("bussinessfield.id")).collect(Collectors.toSet());
                Sets.SetView difference = Sets.difference((Set)existTypesReals, businessTypes);
                if (!CollectionUtils.isEmpty((Collection)difference)) {
                    lacks.put(orgTeamId, difference);
                } else {
                    completeOrgs.add(orgTeamId);
                }
            }
        });
        LOG.info("compareStrategy() result---completeOrgs:[{}],lacks:[{}]", (Object)completeOrgs, (Object)lacks);
        return Pair.of((Object)completeOrgs, (Object)lacks);
    }

    public static void setCommonField(DynamicObject dynamicObject, Date date, Object enable) {
        dynamicObject.set("createtime", (Object)date);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)date);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("enable", enable);
        dynamicObject.set("status", (Object)"C");
    }

    public static QFilter getHisDataFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
    }

    public static <T> void notEmptyExecute(List<T> coll, Consumer<List<T>> consumer) {
        if (!CollectionUtils.isEmpty(coll)) {
            consumer.accept(coll);
        }
    }
}

