/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.strategy;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.StrategyLogServiceHelper;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.StrategyChangeServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.common.strategy.InitStrategyOrgModel;
import kd.hr.hrcs.common.strategy.ModifyStrategyModel;
import org.apache.commons.lang3.tuple.Pair;

public class StrategyApiServiceHelper {
    private static final Log LOG = LogFactory.getLog(StrategyApiServiceHelper.class);
    private static final int MAX_TIMES = 10;

    public static List<Map<String, Long>> getHrBuByBusinessType(Map<Long, Set<Long>> orgId2BusinessType, Long businessObjectId) {
        if (CollectionUtils.isEmpty(orgId2BusinessType)) {
            LOG.info("getHrBuByBusinessType() param is empty.");
            return Collections.emptyList();
        }
        LOG.info("getHrBuByBusinessType() param orgId2BusinessType:{},businessObjectId:{}", orgId2BusinessType, (Object)businessObjectId);
        String entityName = ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_EMP.equals(businessObjectId) ? "hrcs_empstrentry" : "hrcs_orgstrentry";
        HRBaseServiceHelper strategyEntryHelper = new HRBaseServiceHelper(entityName);
        QFilter paramFilter = null;
        for (Map.Entry<Long, Set<Long>> entry2 : orgId2BusinessType.entrySet()) {
            long adminOrgId = entry2.getKey();
            Set<Long> businessTypeIds = entry2.getValue();
            QFilter tempFilter = new QFilter("orgteam.id", "=", (Object)adminOrgId);
            tempFilter.and(new QFilter("bussinessfield.bussinesstype.id", "in", businessTypeIds));
            if (paramFilter == null) {
                paramFilter = tempFilter;
                continue;
            }
            paramFilter.or(tempFilter);
        }
        Object[] strategyEntry = strategyEntryHelper.queryOriginalArray("orgteam.id,bussinessfield.bussinesstype.id,hrbu.id", new QFilter[]{paramFilter});
        if (ObjectUtils.isEmpty((Object[])strategyEntry)) {
            LOG.info("getHrBuByBusinessType() result is null");
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)orgId2BusinessType.size());
        Arrays.stream(strategyEntry).forEach(entry -> {
            LinkedHashMap tempMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
            tempMap.put("adminOrgId", entry.getLong("orgteam.id"));
            tempMap.put("businessTypeId", entry.getLong("bussinessfield.bussinesstype.id"));
            tempMap.put("hrBuId", entry.getLong("hrbu.id"));
            result.add(tempMap);
        });
        LOG.info("getHrBuByBusinessType() result:{}", (Object)result);
        return result;
    }

    public static Map<Long, Set<Long>> judgeStrategyExist4HrBu(Map<Long, Set<Long>> hrBuAndBusinessTypes) {
        LOG.info("judgeStrategyExist4HrBu() param:{}", hrBuAndBusinessTypes);
        if (CollectionUtils.isEmpty(hrBuAndBusinessTypes)) {
            return null;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)hrBuAndBusinessTypes.size());
        HashMap unExist4Org = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] orgStrategyEntry = StrategyApiServiceHelper.queryStrategyEntry("hrcs_orgstrentry", hrBuAndBusinessTypes.keySet(), hrBuAndBusinessTypes.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        Map existOrgHrBu2BusinessType = Arrays.stream(orgStrategyEntry).collect(Collectors.groupingBy(entry -> entry.getLong("hrbu.id"), Collectors.mapping(entry -> entry.getLong("bussinessfield.bussinesstype.id"), Collectors.toSet())));
        LOG.info("judgeStrategyExist4HrBu() existOrgHrBu2BusinessType:{}", existOrgHrBu2BusinessType);
        hrBuAndBusinessTypes.forEach((hrBu, types) -> {
            Set existTypes = (Set)existOrgHrBu2BusinessType.get(hrBu);
            if (!CollectionUtils.isEmpty((Collection)existTypes)) {
                Sets.SetView intersection = Sets.intersection((Set)existTypes, (Set)types);
                if (!CollectionUtils.isEmpty((Collection)intersection)) {
                    result.put(hrBu, intersection);
                } else {
                    result.put(hrBu, null);
                    unExist4Org.put(hrBu, types);
                }
            } else {
                unExist4Org.put(hrBu, types);
            }
        });
        if (CollectionUtils.isEmpty((Map)unExist4Org)) {
            return result;
        }
        StrategyApiServiceHelper.judgeEmpStrategy(hrBuAndBusinessTypes, unExist4Org, result);
        return result;
    }

    private static void judgeEmpStrategy(Map<Long, Set<Long>> hrBuAndBusinessTypes, Map<Long, Set<Long>> unExist4Org, Map<Long, Set<Long>> result) {
        LOG.info("judgeEmpStrategy() unExist4Org:{}", unExist4Org);
        DynamicObject[] empStrategyEntry = StrategyApiServiceHelper.queryStrategyEntry("hrcs_empstrentry", unExist4Org.keySet(), unExist4Org.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        Map existEmpHrBu2BusinessType = Arrays.stream(empStrategyEntry).collect(Collectors.groupingBy(entry -> entry.getLong("hrbu.id"), Collectors.mapping(entry -> entry.getLong("bussinessfield.bussinesstype.id"), Collectors.toSet())));
        LOG.info("judgeEmpStrategy() existEmpHrBu2BusinessType:{}", existEmpHrBu2BusinessType);
        hrBuAndBusinessTypes.forEach((hrBu, types) -> {
            Sets.SetView intersection;
            Set existTypes = (Set)existEmpHrBu2BusinessType.get(hrBu);
            if (result.get(hrBu) == null && !CollectionUtils.isEmpty((Collection)existTypes) && !CollectionUtils.isEmpty((Collection)(intersection = Sets.intersection((Set)existTypes, (Set)types)))) {
                result.put((Long)hrBu, (Set<Long>)intersection);
            }
        });
    }

    private static DynamicObject[] queryStrategyEntry(String entityName, Set<Long> hrBu, Set<Long> businessTypes) {
        HRBaseServiceHelper strategyEntryHelper = new HRBaseServiceHelper(entityName);
        return strategyEntryHelper.queryOriginalArray("hrbu.id,bussinessfield.bussinesstype.id", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("hrbu", "in", hrBu), new QFilter("bussinessfield.bussinesstype.id", "in", businessTypes)});
    }

    public static HRMServiceResult batchModifyStrategyByOrg(List<Map<String, Object>> params) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(params)) {
            result.setMessage("StrategyApiServiceHelper.batchModifyStrategyByOrg() params is empty.");
            LOG.info(result.getMessage());
            return result;
        }
        LOG.info("StrategyApiServiceHelper.batchModifyStrategyByOrg(),params:{}", params);
        ArrayList models = Lists.newArrayListWithExpectedSize((int)params.size());
        HashSet currentOrgTeamIds = Sets.newHashSetWithExpectedSize((int)params.size());
        HashSet parentIds = Sets.newHashSetWithExpectedSize((int)params.size());
        params.forEach(param -> {
            ModifyStrategyModel model = new ModifyStrategyModel(param);
            models.add(model);
            currentOrgTeamIds.add(model.getId());
            if (model.isParentChange()) {
                parentIds.add(model.getParentId());
            }
        });
        StrategyApiServiceHelper.checkParam(models, result);
        if (!result.isSuccess()) {
            LOG.info(result.getMessage());
            return result;
        }
        Map<Long, List<InitStrategyOrgModel>> org2Subs = StrategyApiServiceHelper.getSubOrgIdIncludeGrand(currentOrgTeamIds);
        HashSet allOrgTeamIds = Sets.newHashSetWithExpectedSize((int)16);
        allOrgTeamIds.addAll(currentOrgTeamIds);
        allOrgTeamIds.addAll(parentIds);
        allOrgTeamIds.addAll(StrategyApiServiceHelper.collectOrgTeamIds(org2Subs));
        LOG.info("StrategyApiServiceHelper.batchModifyStrategyByOrg(),allOrgTeamIds:{}", (Object)allOrgTeamIds);
        Map<String, Map<Long, DynamicObject>> existsStrategies = StrategyApiServiceHelper.getStrategies(allOrgTeamIds);
        HashMap bussinessfieldOrgListMap2 = Maps.newHashMapWithExpectedSize((int)16);
        HashBasedTable empChangedHROrg = HashBasedTable.create();
        HashBasedTable orgChangedHROrg = HashBasedTable.create();
        HashMap orgToBeModify = Maps.newHashMapWithExpectedSize((int)16);
        HashMap empToBeModify = Maps.newHashMapWithExpectedSize((int)16);
        try {
            models.forEach(arg_0 -> StrategyApiServiceHelper.lambda$batchModifyStrategyByOrg$8(orgToBeModify, org2Subs, existsStrategies, allOrgTeamIds, (Table)orgChangedHROrg, empToBeModify, (Table)empChangedHROrg, arg_0));
            StrategyApiServiceHelper.updateInherited(orgToBeModify, "org", (Table<Long, Long, Long>)orgChangedHROrg);
            StrategyApiServiceHelper.updateInherited(empToBeModify, "emp", (Table<Long, Long, Long>)empChangedHROrg);
            String selectProperties = "entryentity,bussinessfield,entrydefstrategy,entryhrbu,entryinheritedorg,entryeffdt";
            DynamicObject[] tempEmpStrategies = new HRBaseServiceHelper("hrcs_empstrategy").query(selectProperties, new QFilter[]{new QFilter("orgteam", "in", empToBeModify.keySet())});
            DynamicObject[] tempOrgStrategies = new HRBaseServiceHelper("hrcs_orgstrategy").query(selectProperties, new QFilter[]{new QFilter("orgteam", "in", orgToBeModify.keySet())});
            if (!CollectionUtils.isEmpty(orgToBeModify.values())) {
                new HRBaseServiceHelper("hrcs_orgstrategy").save(orgToBeModify.values().toArray(new DynamicObject[0]));
                ThreadPools.executeOnce((String)"StrategyApiServiceHelper.batchModifyStrategyByOrg.writeModifyLog.org", () -> StrategyLogServiceHelper.writeModifyLog(orgToBeModify, tempOrgStrategies));
                ThreadPools.executeOnce((String)"StrategyApiServiceHelper.batchModifyStrategyByOrg.publishMsg.org", () -> StrategyChangeServiceHelper.publishMsg("org", orgToBeModify, tempOrgStrategies));
            }
            if (!CollectionUtils.isEmpty(empToBeModify.values())) {
                new HRBaseServiceHelper("hrcs_empstrategy").save(empToBeModify.values().toArray(new DynamicObject[0]));
                ThreadPools.executeOnce((String)"StrategyApiServiceHelper.batchModifyStrategyByOrg.writeModifyLog.emp", () -> StrategyLogServiceHelper.writeModifyLog(empToBeModify, tempEmpStrategies));
                ThreadPools.executeOnce((String)"StrategyApiServiceHelper.batchModifyStrategyByOrg.publishMsg.emp", () -> StrategyChangeServiceHelper.publishMsg("emp", empToBeModify, tempEmpStrategies));
            }
            LOG.info("StrategyServiceHelper--sysnSubOrgStrategy(),bussinessfieldOrgListMap2:{}", (Object)bussinessfieldOrgListMap2.size());
            StrategyServiceHelper.handleProjChildStrategyEntities("emp", (Table<Long, Long, Long>)empChangedHROrg);
            StrategyServiceHelper.handleProjChildStrategyEntities("emp", (Table<Long, Long, Long>)orgChangedHROrg);
        }
        catch (Exception exception) {
            result.setSuccess(false);
            result.setMessage(exception.getMessage());
            LOG.error("StrategyApiServiceHelper.batchModifyStrategyByOrg():", (Throwable)exception);
        }
        return result;
    }

    private static void checkParam(List<ModifyStrategyModel> models, HRMServiceResult result) {
        for (ModifyStrategyModel model : models) {
            if (model.isParentChange() && (model.getParentId() == null || model.getParentId() == 0L)) {
                result.setSuccess(false);
                result.setMessage("batchModifyStrategyByOrg() checkParam is fail. parentChange but parentOrgTeamId is null.");
                return;
            }
            if (model.isOrgTypeChange()) {
                if (model.getOrgTypeId() == null || model.getOrgTypeId() == 0L) {
                    result.setSuccess(false);
                    result.setMessage("batchModifyStrategyByOrg() checkParam is fail. orgTypeChange but orgTypeId is null.");
                    return;
                }
                if (model.getOldOrgTypeId() == null || model.getOldOrgTypeId() == 0L) {
                    result.setSuccess(false);
                    result.setMessage("batchModifyStrategyByOrg() checkParam is fail. orgTypeChange but oldOrgTypeId is null.");
                    return;
                }
            }
            if (model.isParentChange() || model.isOrgTypeChange()) continue;
            result.setSuccess(false);
            result.setMessage("batchModifyStrategyByOrg() checkParam is fail. not parentChange and not orgTypeChange.");
            return;
        }
    }

    private static void doSetStrategy(Map<Long, DynamicObject> toBeModify, List<InitStrategyOrgModel> childrenOrgModelList, Map<Long, DynamicObject> existsStrategies, Set<Long> allOrgTeamIds, ModifyStrategyModel param, String strategyType, Table<Long, Long, Long> changedHROrg) {
        DynamicObject currentStrategy = existsStrategies.get(param.getId());
        if (param.isParentChange()) {
            DynamicObject parentStrategy = toBeModify.getOrDefault(param.getParentId(), existsStrategies.get(param.getParentId()));
            StrategyApiServiceHelper.doUpdateStrategy(currentStrategy, parentStrategy, toBeModify, strategyType, "0", changedHROrg);
        }
        if (param.isOrgTypeChange()) {
            boolean group = false;
            boolean company = false;
            if (ManageStrategyConstants.ID_ORGTYPE_GROUP.equals(param.getOldOrgTypeId()) || ManageStrategyConstants.ID_ORGTYPE_GROUP.equals(param.getOrgTypeId())) {
                group = true;
            }
            if (ManageStrategyConstants.ID_ORGTYPE_COMPANY.equals(param.getOldOrgTypeId()) || ManageStrategyConstants.ID_ORGTYPE_COMPANY.equals(param.getOrgTypeId())) {
                company = true;
            }
            Pair<Long, Long> newGroupAndCompany = StrategyApiServiceHelper.getNewGroupAndCompany(param, group, company);
            Long newGroupId = (Long)newGroupAndCompany.getLeft();
            Long newCompanyId = (Long)newGroupAndCompany.getRight();
            StrategyApiServiceHelper.supplyGroupAndCompany(existsStrategies, allOrgTeamIds, newGroupId, newCompanyId, strategyType);
            LOG.info("StrategyApiServiceHelper-after supplyGroupAndCompany ,existsStrategies:{}", existsStrategies.keySet());
            if (!param.isParentChange() && (group || company)) {
                Long parentId = currentStrategy.getLong("orgteam.parent.id");
                LOG.info("StrategyApiServiceHelper-parentId:{}", (Object)parentId);
                StrategyApiServiceHelper.addOrgToExistsStrategies(existsStrategies, strategyType, Sets.newHashSet((Object[])new Long[]{parentId}));
                DynamicObject parentStrategy = toBeModify.getOrDefault(parentId, existsStrategies.get(parentId));
                StrategyApiServiceHelper.doUpdateStrategy(currentStrategy, parentStrategy, toBeModify, strategyType, "0", changedHROrg);
                StrategyApiServiceHelper.handleSubs(existsStrategies, childrenOrgModelList, toBeModify, strategyType, changedHROrg);
            }
        }
        if (param.isParentChange()) {
            LOG.info("StrategyApiServiceHelper-doSetStrategy(),toBeModify:{},childrenOrgModelList:{},strategyType:{}", new Object[]{toBeModify.keySet(), childrenOrgModelList, strategyType});
            StrategyApiServiceHelper.handleSubs(existsStrategies, childrenOrgModelList, toBeModify, strategyType, changedHROrg);
        }
    }

    private static void updateInherited(Map<Long, DynamicObject> toBeModify, String businessObjectType, Table<Long, Long, Long> changedHROrg) {
        HashSet handledIds = Sets.newHashSetWithExpectedSize((int)16);
        handledIds.addAll(toBeModify.keySet());
        StrategyApiServiceHelper.doGetAndSetInherited(toBeModify.keySet(), toBeModify, handledIds, businessObjectType, 0, changedHROrg);
    }

    private static void doGetAndSetInherited(Set<Long> inhIds, Map<Long, DynamicObject> toBeModify, Set<Long> handledIds, String businessObjectType, int time, Table<Long, Long, Long> changedHROrg) {
        QFilter entryInhFilter;
        if (CollectionUtils.isEmpty(inhIds)) {
            LOG.info("doGetAndSetInherited() time:{}", (Object)time);
            return;
        }
        if (time >= 10) {
            LOG.error("doGetAndSetInherited() time greater than ten.");
            return;
        }
        ++time;
        HRBaseServiceHelper serviceHelper = "org".equals(businessObjectType) ? new HRBaseServiceHelper("hrcs_orgstrategy") : new HRBaseServiceHelper("hrcs_empstrategy");
        Object[] inhStrategies = serviceHelper.loadDynamicObjectArray(new QFilter[]{entryInhFilter = new QFilter("entryentity.entryinheritedorg", "in", inhIds)});
        if (!ObjectUtils.isEmpty((Object[])inhStrategies)) {
            LOG.info("updateInherited() inhStrategies size:{}", (Object)inhStrategies.length);
            Map orgTeam2Strategies = Arrays.stream(inhStrategies).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), Function.identity(), (x1, x2) -> x1));
            Set<Long> inhOrgTeamIds = orgTeam2Strategies.keySet();
            inhOrgTeamIds.removeAll(handledIds);
            if (CollectionUtils.isEmpty(inhOrgTeamIds)) {
                LOG.info("doGetAndSetInherited() inhOrgTeamIds removeAll is null.");
                return;
            }
            handledIds.addAll(inhOrgTeamIds);
            for (Map.Entry entry : orgTeam2Strategies.entrySet()) {
                StrategyApiServiceHelper.doUpdateStrategy((DynamicObject)entry.getValue(), toBeModify, changedHROrg);
            }
            StrategyApiServiceHelper.doGetAndSetInherited(orgTeam2Strategies.keySet(), toBeModify, handledIds, businessObjectType, time, changedHROrg);
        }
    }

    private static void handleSubs(Map<Long, DynamicObject> existsStrategies, List<InitStrategyOrgModel> subOrgIdIncludeGrand, Map<Long, DynamicObject> toBeModify, String strategyType, Table<Long, Long, Long> changedHROrg) {
        if (CollectionUtils.isEmpty(subOrgIdIncludeGrand)) {
            return;
        }
        subOrgIdIncludeGrand.stream().forEachOrdered(sub -> {
            DynamicObject currentStrategy = (DynamicObject)existsStrategies.get(sub.getId());
            StrategyApiServiceHelper.doUpdateStrategy(currentStrategy, (DynamicObject)toBeModify.get(sub.getParentId()), toBeModify, strategyType, "1", changedHROrg);
        });
    }

    private static void doUpdateStrategy(DynamicObject currentStrategy, DynamicObject parentStrategy, Map<Long, DynamicObject> toBeModify, String strategyType, String changeType, Table<Long, Long, Long> changedHROrg) {
        Long parentOrgId;
        if (Objects.isNull(currentStrategy)) {
            LOG.error("doUpdateStrategy() currentStrategy is null");
            return;
        }
        if (Objects.isNull(parentStrategy)) {
            LOG.error("doUpdateStrategy() currentStrategyOrg:{} parentStrategy is null.", (Object)currentStrategy.getLong("orgteam.id"));
            if (OrgServiceUtil.getAdminRootOrgId() == currentStrategy.getLong("orgteam.id")) {
                currentStrategy.set("effdt", (Object)new Date());
                currentStrategy.set("changetype", (Object)changeType);
                toBeModify.put(currentStrategy.getLong("orgteam.id"), currentStrategy);
            }
            return;
        }
        LOG.info("StrategyApiServiceHelper--doUpdateStrategy(),currentStrategy:{},parentStrategy:{},strategyType:{}", new Object[]{currentStrategy.getLong("id"), parentStrategy.getLong("id"), strategyType});
        String defStrategyType = currentStrategy.getString("defstrategytype.strategytype");
        DynamicObject inhStrategy = null;
        if ("0".equals(defStrategyType) || StringUtils.isBlank((CharSequence)defStrategyType)) {
            inhStrategy = parentStrategy;
            StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, inhStrategy, changeType);
        } else if ("1".equals(defStrategyType)) {
            parentOrgId = (Long)((DynamicObject)parentStrategy.get("orgteam")).getPkValue();
            DynamicObject groupOrgDy = StrategyServiceHelper.getCompanyByAdminOrgId(parentOrgId, true);
            if (groupOrgDy == null) {
                StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, null, changeType);
            } else if (groupOrgDy.getLong("id") == parentOrgId.longValue()) {
                inhStrategy = parentStrategy;
                StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, inhStrategy, changeType);
            } else {
                inhStrategy = StrategyApiServiceHelper.getParentStrategy(strategyType, groupOrgDy.getLong("id"));
                StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, inhStrategy, changeType);
            }
        } else if ("2".equals(defStrategyType)) {
            parentOrgId = (Long)((DynamicObject)parentStrategy.get("orgteam")).getPkValue();
            DynamicObject companyOrgDy = StrategyServiceHelper.getOnlyCompanyByAdminOrgId(parentOrgId, true);
            if (companyOrgDy == null) {
                StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, null, changeType);
            } else if (companyOrgDy.getLong("id") == parentOrgId.longValue()) {
                inhStrategy = parentStrategy;
                StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, inhStrategy, changeType);
            } else {
                inhStrategy = StrategyApiServiceHelper.getParentStrategy(strategyType, companyOrgDy.getLong("id"));
                StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, inhStrategy, changeType);
            }
        } else if ("5".equals(defStrategyType)) {
            inhStrategy = toBeModify.get(currentStrategy.getLong("inheritedorg.id"));
        } else {
            StrategyApiServiceHelper.setCurrentStrategy(currentStrategy, inhStrategy, changeType);
        }
        DynamicObjectCollection currentEntries = currentStrategy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : currentEntries) {
            Long parentOrgId2;
            String entryStrategyType = entry.getString("entrydefstrategy.strategytype");
            DynamicObject inhStrategyTemp = null;
            if ("1".equals(entryStrategyType)) {
                if (defStrategyType.equals(entryStrategyType)) {
                    inhStrategyTemp = inhStrategy;
                } else {
                    parentOrgId2 = (Long)((DynamicObject)parentStrategy.get("orgteam")).getPkValue();
                    DynamicObject groupOrg = StrategyServiceHelper.getCompanyByAdminOrgId(parentOrgId2, true);
                    if (groupOrg != null) {
                        inhStrategyTemp = StrategyApiServiceHelper.getParentStrategy(strategyType, (Long)groupOrg.getPkValue());
                    }
                }
            } else if ("2".equals(entryStrategyType)) {
                if (defStrategyType.equals(entryStrategyType)) {
                    inhStrategyTemp = inhStrategy;
                } else {
                    parentOrgId2 = (Long)((DynamicObject)parentStrategy.get("orgteam")).getPkValue();
                    DynamicObject companyOrg = StrategyServiceHelper.getOnlyCompanyByAdminOrgId(parentOrgId2, true);
                    if (companyOrg != null) {
                        inhStrategyTemp = StrategyApiServiceHelper.getParentStrategy(strategyType, (Long)companyOrg.getPkValue());
                    }
                }
            } else {
                inhStrategyTemp = "0".equals(entryStrategyType) ? parentStrategy : inhStrategy;
            }
            if (inhStrategyTemp == null) {
                StrategyApiServiceHelper.setCurrentStrategyEntry(entry, null, changeType, changedHROrg);
                continue;
            }
            StrategyApiServiceHelper.setCurrentStrategyEntry(entry, StrategyApiServiceHelper.getEntryMap(inhStrategyTemp).get(entry.getLong("bussinessfield.id")), changeType, changedHROrg);
        }
        if (HRStringUtils.isEmpty((String)currentStrategy.getString("changetype"))) {
            currentStrategy.set("changetype", (Object)changeType);
        }
        toBeModify.put(currentStrategy.getLong("orgteam.id"), currentStrategy);
    }

    private static DynamicObject getParentStrategy(String strategyType, Long pkValue) {
        return "org".equals(strategyType) ? StrategyServiceHelper.getOrgStrategyByOrg(pkValue) : StrategyServiceHelper.getEmpStrategyByOrg(pkValue);
    }

    private static void doUpdateStrategy(DynamicObject currentStrategy, Map<Long, DynamicObject> toBeModify, Table<Long, Long, Long> changedHROrg) {
        DynamicObject inhStrategy = toBeModify.get(currentStrategy.getLong("inheritedorg.id"));
        if (Objects.isNull(inhStrategy)) {
            LOG.error("doUpdateStrategy2Inh() inhStrategy is null.");
            return;
        }
        boolean flag = false;
        currentStrategy.set("effdt", (Object)new Date());
        currentStrategy.set("changetype", (Object)"1");
        DynamicObjectCollection currentEntries = currentStrategy.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> parentEntries = StrategyApiServiceHelper.getEntryMap(inhStrategy);
        for (DynamicObject entry : currentEntries) {
            String entryStrategyType = entry.getString("entrydefstrategy.strategytype");
            if (!"5".equals(entryStrategyType)) continue;
            long entryOrg = entry.getLong("entryinheritedorg.id");
            if ("5".equals(entryStrategyType) && entryOrg != inhStrategy.getLong("orgteam.id")) continue;
            DynamicObject parentEntry = parentEntries.get(entry.getLong("bussinessfield.id"));
            StrategyApiServiceHelper.setCurrentStrategyEntry(entry, parentEntry, "1", changedHROrg);
            entry.set("entrysourceorg", (Object)entry.getDynamicObject("entryinheritedorg"));
            flag = true;
        }
        if (flag) {
            toBeModify.put(currentStrategy.getLong("orgteam.id"), currentStrategy);
        }
    }

    private static void setCurrentStrategy(DynamicObject currentStrategy, DynamicObject inhStrategy, String changeType) {
        currentStrategy.set("effdt", (Object)new Date());
        currentStrategy.set("changetype", (Object)changeType);
        String strategyType = currentStrategy.getString("defstrategytype.strategytype");
        if (!("3".equals(strategyType) || "5".equals(strategyType) || "4".equals(strategyType))) {
            currentStrategy.set("sourceorg", inhStrategy == null ? null : inhStrategy.get("sourceorg"));
            currentStrategy.set("inheritedorg", inhStrategy == null ? null : inhStrategy.get("orgteam"));
            currentStrategy.set("hrbu", inhStrategy == null ? null : inhStrategy.get("hrbu"));
        }
    }

    private static void setCurrentStrategyEntry(DynamicObject entry, DynamicObject inhEntry, String changeType, Table<Long, Long, Long> changedHROrg) {
        if (null == inhEntry) {
            LOG.warn("StrategyApiServiceHelper--setCurrentStrategyEntry()--inhEntry is null,strategyId:{},changeType:{}", (Object)entry.getLong("id"), (Object)changeType);
        }
        entry.set("entryeffdt", (Object)new Date());
        entry.set("entrychangetype", (Object)changeType);
        String strategyType = entry.getString("entrydefstrategy.strategytype");
        if (!("3".equals(strategyType) || "4".equals(strategyType) || "5".equals(strategyType))) {
            entry.set("entryinheritedorg", inhEntry == null ? null : inhEntry.get("entryorgteam"));
            entry.set("entrysourceorg", inhEntry == null ? null : inhEntry.get("entrysourceorg"));
            StrategyApiServiceHelper.isHRBuChanged(entry, inhEntry, changedHROrg);
            entry.set("entryhrbu", inhEntry == null ? null : inhEntry.get("entryhrbu"));
        }
        if ("5".equals(strategyType) && inhEntry != null && inhEntry.getLong("entryorgteam.id") == entry.getLong("entryinheritedorg.id")) {
            entry.set("entrysourceorg", inhEntry.get("entrysourceorg"));
            StrategyApiServiceHelper.isHRBuChanged(entry, inhEntry, changedHROrg);
            entry.set("entryhrbu", inhEntry.get("entryhrbu"));
        }
    }

    private static void isHRBuChanged(DynamicObject entry, DynamicObject inhEntry, Table<Long, Long, Long> changedHROrg) {
        if (inhEntry == null) {
            changedHROrg.put((Object)entry.getLong("entryorgteam.id"), (Object)entry.getLong("bussinessfield.bussinesstype.id"), (Object)0L);
        } else if (entry.getLong("entryhrbu.id") != inhEntry.getLong("entryhrbu.id")) {
            changedHROrg.put((Object)entry.getLong("entryorgteam.id"), (Object)entry.getLong("bussinessfield.bussinesstype.id"), (Object)inhEntry.getLong("entryhrbu.id"));
        }
    }

    private static void supplyGroupAndCompany(Map<Long, DynamicObject> existsStrategies, Set<Long> allOrgTeamIds, long newGroupId, long newCompanyId, String strategyType) {
        HashSet groupAndComId = Sets.newHashSetWithExpectedSize((int)2);
        if (newGroupId != 0L && !allOrgTeamIds.contains(newGroupId)) {
            groupAndComId.add(newGroupId);
        }
        if (newCompanyId != 0L && !allOrgTeamIds.contains(newCompanyId)) {
            groupAndComId.add(newCompanyId);
        }
        StrategyApiServiceHelper.addOrgToExistsStrategies(existsStrategies, strategyType, groupAndComId);
    }

    private static void addOrgToExistsStrategies(Map<Long, DynamicObject> existsStrategies, String strategyType, Set<Long> orgIds) {
        if (!CollectionUtils.isEmpty(orgIds)) {
            DynamicObject[] strategies = "org".equals(strategyType) ? StrategyServiceHelper.loadOrgStrategyByOrgTeamIdList(orgIds) : StrategyServiceHelper.loadEmpStrategyByOrgTeamIdList(orgIds);
            existsStrategies.putAll(Arrays.stream(strategies).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), Function.identity())));
        }
    }

    private static Map<Long, DynamicObject> getEntryMap(DynamicObject strategy) {
        DynamicObjectCollection entries = strategy.getDynamicObjectCollection("entryentity");
        return entries.stream().collect(Collectors.toMap(dy -> dy.getLong("bussinessfield.id"), Function.identity()));
    }

    private static Map<Long, List<InitStrategyOrgModel>> getSubOrgIdIncludeGrand(Set<Long> orgIds) {
        QFilter orgIdFilter = new QFilter("adminorg.id", "in", orgIds);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        currentVersionFilter.and("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        Object[] orgStructs = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").query("adminorg.id,structlongnumber", new QFilter[]{orgIdFilter, currentVersionFilter});
        if (ObjectUtils.isEmpty((Object[])orgStructs)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        QFilter longNumberFilter = null;
        for (Object orgStruct : orgStructs) {
            String longNumber = orgStruct.getString("structlongnumber");
            QFilter tempFilter = new QFilter("structlongnumber", "like", (Object)(longNumber + "!" + "%"));
            if (longNumberFilter == null) {
                longNumberFilter = tempFilter;
                continue;
            }
            longNumberFilter.or(tempFilter);
        }
        QFilter[] filters = new QFilter[]{longNumberFilter, currentVersionFilter};
        String select = "adminorg.id,adminorg,parentorg,structlongnumber";
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminorgstruct").queryColl(select, filters, null);
        Map<Long, List<InitStrategyOrgModel>> result = StrategyApiServiceHelper.getAdminOrg((DynamicObject[])orgStructs, dyColl, "adminorg", "parentorg");
        LOG.info("getSubOrgIdIncludeGrand() result:{}", result);
        return result;
    }

    public static Map<Long, List<InitStrategyOrgModel>> getAdminOrg(DynamicObject[] orgStructs, DynamicObjectCollection dyColl, String orgTeamkey, String parentKey) {
        Map<Long, String> orgId2LongNumber = Arrays.stream(orgStructs).collect(Collectors.toMap(dy -> dy.getLong(orgTeamkey + ".id"), dy -> dy.getString("structlongnumber"), (x1, x2) -> x1));
        HashMap result = Maps.newHashMapWithExpectedSize((int)dyColl.size());
        orgId2LongNumber.forEach((orgId, longNumber) -> {
            ArrayList subs = Lists.newArrayListWithExpectedSize((int)16);
            for (DynamicObject object : dyColl) {
                if (orgId.equals(object.getLong(orgTeamkey)) || !object.getString("structlongnumber").contains((CharSequence)longNumber)) continue;
                InitStrategyOrgModel model = new InitStrategyOrgModel(object.getLong(orgTeamkey), object.getString("structlongnumber"), object.getLong(parentKey));
                subs.add(model);
            }
            result.put(orgId, subs.stream().sorted(Comparator.comparing(InitStrategyOrgModel::getLevel)).collect(Collectors.toList()));
        });
        return result;
    }

    private static Set<Long> collectOrgTeamIds(Map<Long, List<InitStrategyOrgModel>> org2Subs) {
        return org2Subs.values().stream().flatMap(Collection::stream).map(InitStrategyOrgModel::getId).collect(Collectors.toSet());
    }

    private static Map<String, Map<Long, DynamicObject>> getStrategies(Set<Long> allOrgTeamIds) {
        HashMap business2Strategies = Maps.newHashMapWithExpectedSize((int)2);
        DynamicObject[] orgStrategies = StrategyServiceHelper.loadOrgStrategyByOrgTeamIdList(allOrgTeamIds);
        business2Strategies.put("org", Arrays.stream(orgStrategies).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), Function.identity(), (x1, x2) -> x1)));
        DynamicObject[] empStrategies = StrategyServiceHelper.loadEmpStrategyByOrgTeamIdList(allOrgTeamIds);
        business2Strategies.put("emp", Arrays.stream(empStrategies).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), Function.identity(), (x1, x2) -> x1)));
        return business2Strategies;
    }

    private static Pair<Long, Long> getNewGroupAndCompany(ModifyStrategyModel param, boolean group, boolean company) {
        long newGroupId = 0L;
        long newCompanyId = 0L;
        if (group) {
            if (ManageStrategyConstants.ID_ORGTYPE_GROUP.equals(param.getOrgTypeId())) {
                newGroupId = param.getId();
            } else {
                DynamicObject newGroup = StrategyServiceHelper.getCompanyByAdminOrgId(param.getId(), true);
                if (Objects.isNull(newGroup)) {
                    LOG.warn("StrategyApiServiceHelper.getNewGroupAndCompany() get new group is null,ModifyStrategyModel:{}", (Object)param);
                } else {
                    newGroupId = newGroup.getLong("id");
                }
            }
        }
        if (company) {
            if (ManageStrategyConstants.ID_ORGTYPE_COMPANY.equals(param.getOrgTypeId())) {
                newCompanyId = param.getId();
            } else {
                DynamicObject newCompany = StrategyServiceHelper.getOnlyCompanyByAdminOrgId(param.getId(), true);
                if (Objects.isNull(newCompany)) {
                    LOG.warn("StrategyApiServiceHelper.getNewGroupAndCompany() get new company is null,ModifyStrategyModel:{}", (Object)param);
                } else {
                    newCompanyId = newCompany.getLong("id");
                }
            }
        }
        return Pair.of((Object)newGroupId, (Object)newCompanyId);
    }

    public static HRMServiceResult getResult() {
        HRMServiceResult result = new HRMServiceResult();
        result.setSuccess(true);
        result.setMessage("success");
        result.setReturnCode("");
        return result;
    }

    private static /* synthetic */ void lambda$batchModifyStrategyByOrg$8(Map orgToBeModify, Map org2Subs, Map existsStrategies, Set allOrgTeamIds, Table orgChangedHROrg, Map empToBeModify, Table empChangedHROrg, ModifyStrategyModel model) {
        StrategyApiServiceHelper.doSetStrategy(orgToBeModify, (List)org2Subs.get(model.getId()), (Map)existsStrategies.get("org"), allOrgTeamIds, model, "org", (Table<Long, Long, Long>)orgChangedHROrg);
        StrategyApiServiceHelper.doSetStrategy(empToBeModify, (List)org2Subs.get(model.getId()), (Map)existsStrategies.get("emp"), allOrgTeamIds, model, "emp", (Table<Long, Long, Long>)empChangedHROrg);
    }
}

