/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.strategy;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.mservice.HRMSendMsgResult;
import kd.hr.hrcs.bussiness.md.StrategyChangeInfo;

public class StrategyChangeServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(StrategyChangeServiceHelper.class);
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSS");

    public static void publishMsg(String type, Map<Long, DynamicObject> toBeModify, DynamicObject[] oldStrategies) {
        HashMap<Long, List<StrategyChangeInfo>> changeInfoListMap = new HashMap<Long, List<StrategyChangeInfo>>(oldStrategies.length);
        Map idToDy = Arrays.stream(oldStrategies).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        for (Map.Entry<Long, DynamicObject> entry : toBeModify.entrySet()) {
            Long orgTeamId = entry.getKey();
            DynamicObject newStrategy = entry.getValue();
            DynamicObject oldStrategy = (DynamicObject)idToDy.get(newStrategy.getLong("id"));
            DynamicObjectCollection newStrategyEntryEntities = newStrategy.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection oldStrategyEntryEntities = oldStrategy.getDynamicObjectCollection("entryentity");
            Map<Long, List<DynamicObject>> newStrategyEntriesMap = newStrategyEntryEntities.stream().collect(Collectors.groupingBy(dy -> dy.getLong("bussinessfield.bussinesstype.id")));
            for (DynamicObject oldStrategyEntry : oldStrategyEntryEntities) {
                long bussinessFieldId = oldStrategyEntry.getLong("bussinessfield.bussinesstype.id");
                List<DynamicObject> newStrategyEntry = newStrategyEntriesMap.get(bussinessFieldId);
                if (oldStrategyEntry.getLong("entryhrbu.id") == newStrategyEntry.get(0).getLong("entryhrbu.id")) continue;
                List list = changeInfoListMap.getOrDefault(bussinessFieldId, new ArrayList());
                list.add(new StrategyChangeInfo(type, orgTeamId, bussinessFieldId, oldStrategyEntry.getLong("entryhrbu.id"), newStrategyEntry.get(0).getLong("entryhrbu.id")));
                changeInfoListMap.put(bussinessFieldId, list);
            }
        }
        StrategyChangeServiceHelper.batchPublishMsg(changeInfoListMap);
    }

    public static void publishMsg(Long bussinessField, List<StrategyChangeInfo> changeInfoList) {
        HashMap<Long, List<StrategyChangeInfo>> changeInfoListMap = new HashMap<Long, List<StrategyChangeInfo>>(changeInfoList.size());
        changeInfoListMap.put(bussinessField, changeInfoList);
        StrategyChangeServiceHelper.batchPublishMsg(changeInfoListMap);
    }

    public static void batchPublishMsg(Map<Long, List<StrategyChangeInfo>> changeInfoList) {
        if (changeInfoList == null || changeInfoList.size() == 0) {
            return;
        }
        HashMap actionInfoCache = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList actionInfoList = Lists.newArrayListWithCapacity((int)16);
        AtomicInteger seq = new AtomicInteger(1);
        changeInfoList.forEach((key, value) -> {
            seq.set(1);
            List partition = Lists.partition((List)value, (int)1000);
            partition.forEach(list -> {
                Map<String, Object> actionInfoCacheOb = (Map<String, Object>)actionInfoCache.get(key);
                if (Objects.isNull(actionInfoCacheOb)) {
                    actionInfoCacheOb = StrategyChangeServiceHelper.addActionInfoList(key, list, seq.getAndIncrement());
                    actionInfoCache.put(key, actionInfoCacheOb);
                    actionInfoList.add(actionInfoCacheOb);
                } else {
                    HashMap<String, Object> actionInfoCacheTemp = new HashMap<String, Object>(actionInfoCacheOb);
                    actionInfoCacheTemp.put("msgNumber", "SC" + simpleDateFormat.format(System.currentTimeMillis()));
                    actionInfoCacheTemp.put("sendTime", new Date());
                    actionInfoCacheTemp.put("params", JSONObject.toJSONString((Object)list));
                    actionInfoCacheTemp.put("groupSeq", seq.getAndIncrement());
                    actionInfoList.add(actionInfoCacheTemp);
                }
            });
        });
        HRMSendMsgResult hrmSendMsgResult = HRProducerServiceHelper.publishAction((List)actionInfoList);
        LOGGER.info("StrategyChangeServiceHelper_publishMsg() msg:{}", (Object)actionInfoList);
        if (!hrmSendMsgResult.isSuccess()) {
            LOGGER.error("StrategyChangeServiceHelper_publishMsg() fail:{}", (Object)hrmSendMsgResult.getMessage());
        }
    }

    private static Map<String, Object> addActionInfoList(Long bussinessFieldId, List<StrategyChangeInfo> list, Integer seq) {
        HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)16);
        actionInfo.put("msgNumber", "SC" + simpleDateFormat.format(System.currentTimeMillis()));
        actionInfo.put("msgPubNo", StrategyChangeServiceHelper.getMsgPubNo(bussinessFieldId));
        actionInfo.put("msgTitle", "strategyChange");
        actionInfo.put("msgDesc", "strategyChange");
        actionInfo.put("msgTag", "managementStrategy");
        actionInfo.put("actionId", StrategyChangeServiceHelper.getActionId(bussinessFieldId));
        actionInfo.put("senderId", RequestContext.get().getCurrUserId());
        actionInfo.put("sendTime", new Date());
        actionInfo.put("groupNumber", bussinessFieldId.toString() + "-" + RequestContext.get().getTraceId());
        actionInfo.put("groupSeq", seq);
        actionInfo.put("params", JSONObject.toJSONString(list));
        return actionInfo;
    }

    private static String getMsgPubNo(Long bussinessField) {
        QFilter qFilter = new QFilter("publishbd.id", "=", (Object)bussinessField);
        qFilter.and("pubstatus", "=", (Object)"P");
        qFilter.and("action.id", "=", (Object)StrategyChangeServiceHelper.getActionId(bussinessField));
        DynamicObject dynamicObject = new HRBaseServiceHelper("hrcs_msgpublisher").queryOriginalOne("number", qFilter);
        if (dynamicObject != null) {
            return dynamicObject.getString("number");
        }
        return "";
    }

    private static Long getActionId(Long bussinessFieldId) {
        DynamicObject dynamicObject1;
        DynamicObject dynamicObject = new HRBaseServiceHelper("hbss_bussinessfield").queryOriginalOne("number", new QFilter("id", "=", (Object)bussinessFieldId));
        if (dynamicObject != null && (dynamicObject1 = new HRBaseServiceHelper("hbss_action").queryOriginalOne("id", new QFilter("number", "=", (Object)"A".concat(dynamicObject.getString("number"))))) != null) {
            return dynamicObject1.getLong("id");
        }
        return 0L;
    }
}

