/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.strategy.impl;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.InitStrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.impl.InitStrategyServiceImpl;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.common.strategy.InitStrategyOrgModel;
import kd.hr.hrcs.common.strategy.InitStrategySaveModel;
import org.apache.commons.lang3.tuple.Pair;

public class InitOrgStrategyServiceImpl
extends InitStrategyServiceImpl {
    private static final Log LOG = LogFactory.getLog(InitOrgStrategyServiceImpl.class);
    private static final HRBaseServiceHelper ORG_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_orgstrategy");

    @Override
    public Long getBusinessObjectId() {
        return ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG;
    }

    @Override
    public String getEntityNumber() {
        return "hrcs_orgstrategy";
    }

    @Override
    protected void handleStrategy(InitStrategySaveModel model) {
        if (model.getOrgTeamIds().size() > 10000) {
            this.processStrategyInNewThread(model, RequestContext.get().getTraceId());
            return;
        }
        LOG.info("start handleStrategy,orgSize:{}, entityNumber:{}", (Object)model.getOrgTeamIds().size(), (Object)"hrcs_orgstrategy");
        long startTime = System.currentTimeMillis();
        Pair<DynamicObjectCollection, DynamicObjectCollection> strategys = super.handleStrategy(model, "hrcs_orgstrategy");
        LOG.info("end handleStrategy, start addOrgStrategyHisByList,  strategys.getLeft().size():{},cost1:{}", (Object)((DynamicObjectCollection)strategys.getLeft()).size(), (Object)(System.currentTimeMillis() - startTime));
        InitStrategyServiceHelper.notEmptyExecute((List)strategys.getLeft(), this::addStrategyHisByList);
        LOG.info("end addOrgStrategyHisByList, start saveOrgStrategyHisByList,  strategys.getRight().size():{},cost2:{}", (Object)((DynamicObjectCollection)strategys.getRight()).size(), (Object)(System.currentTimeMillis() - startTime));
        InitStrategyServiceHelper.notEmptyExecute((List)strategys.getRight(), supply -> StrategyServiceHelper.saveOrgStrategyHisByList(supply.toArray(new DynamicObject[0]), "0"));
        LOG.info("finish handleStrategy method, total cost:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    protected void addStrategyHisByList(List<DynamicObject> list) {
        StrategyServiceHelper.addOrgStrategyHisByList(list.toArray(new DynamicObject[0]), "0");
    }

    private void processStrategyInNewThread(InitStrategySaveModel model, String oldTraceId) {
        ThreadPools.executeOnce((String)("handleStrategy_" + oldTraceId), () -> {
            TXHandle txHandle = TX.requiresNew();
            try {
                this.getPageCache().put("InitOrgStrategyService", "doing");
                LOG.info("start handleStrategy,orgSize:{}, entityNumber:{},put INIT_CACHE flag, oldTraceId:{} .", new Object[]{model.getOrgTeamIds().size(), "hrcs_orgstrategy", oldTraceId});
                long startTime = System.currentTimeMillis();
                Pair<DynamicObjectCollection, DynamicObjectCollection> strategys = super.handleStrategy(model, "hrcs_orgstrategy");
                LOG.info("end handleStrategy, start addOrgStrategyHisByList,  strategys.getLeft().size():{},cost1:{}, oldTraceId:{} .", new Object[]{((DynamicObjectCollection)strategys.getLeft()).size(), System.currentTimeMillis() - startTime, oldTraceId});
                this.processHisInThreshold((DynamicObjectCollection)strategys.getLeft());
                LOG.info("end addOrgStrategyHisByList, start saveOrgStrategyHisByList,  strategys.getRight().size():{},cost2:{}, oldTraceId:{} .", new Object[]{((DynamicObjectCollection)strategys.getRight()).size(), System.currentTimeMillis() - startTime, oldTraceId});
                InitStrategyServiceHelper.notEmptyExecute((List)strategys.getRight(), supply -> StrategyServiceHelper.saveOrgStrategyHisByList(supply.toArray(new DynamicObject[0]), "0"));
                LOG.info("finish handleStrategy method, total cost:{}, oldTraceId:{} .", (Object)(System.currentTimeMillis() - startTime), (Object)oldTraceId);
            }
            catch (Exception ex) {
                LOG.error(String.format(Locale.ROOT, "oldTraceId:%s, processStrategyInNewThread Exception: ", oldTraceId), (Throwable)ex);
                txHandle.markRollback();
            }
            finally {
                txHandle.close();
                this.getPageCache().remove("InitOrgStrategyService");
                LOG.info("remove INIT_ORG_CACHE_KEY_FLAG flag, oldTraceId:{} .", (Object)oldTraceId);
            }
        });
    }

    @Override
    protected DynamicObject genHrBuStrategyObject(InitStrategyOrgModel orgModel, InitStrategySaveModel saveModel, Date date, long id, String flag) {
        long orgId = orgModel.getId();
        DynamicObject strategy = this.getStrategyObject(flag, saveModel, orgModel.getId(), date, id, ORG_STRATEGY_HELPER);
        strategy.set("sourceorg", (Object)orgId);
        strategy.set("orgteam", (Object)orgId);
        strategy.set("defstrategytype", this.baseStrategys.get(this.fetchOrgKey2DefBu()));
        strategy.set("inheritedorg", (Object)orgId);
        strategy.set("hrbu", (Object)orgId);
        strategy.set("effdt", ((DynamicObject)saveModel.getAdminOrgDetails().get(orgId)).get("bsed"));
        Set reals = "news".equals(flag) ? (Set)this.businessTypeTies.get(ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG) : (Set)saveModel.getLacks().get(orgId);
        super.createEntryDynamicObject(strategy, reals, ORG_STRATEGY_HELPER, null, flag, saveModel.getBusinessType2HRBu());
        return strategy;
    }

    @Override
    protected DynamicObject genNotHrBuStrategyObject(InitStrategyOrgModel orgModel, InitStrategySaveModel saveModel, Date date, long id, String flag) {
        DynamicObject strategy = this.getStrategyObject(flag, saveModel, orgModel.getId(), date, id, ORG_STRATEGY_HELPER);
        long parentId = orgModel.getParentId();
        DynamicObject parentStrategy = (DynamicObject)this.alreadyStrategy.getOrDefault(parentId, saveModel.getExistStrategys().get(parentId));
        if (parentStrategy == null) {
            LOG.error("genNotHrBuStrategyObject() org's[{}] parentStrategy[{}] is null.", (Object)orgModel.getId(), (Object)orgModel.getParentId());
            return null;
        }
        strategy.set("orgteam", (Object)orgModel.getId());
        strategy.set("defstrategytype", this.baseStrategys.get(this.fetchOrgKey2SameParent()));
        strategy.set("inheritedorg", (Object)parentId);
        strategy.set("hrbu", parentStrategy.get("hrbu"));
        strategy.set("sourceorg", parentStrategy.get("sourceorg"));
        if (saveModel.getAdminOrgDetails().get(orgModel.getId()) == null) {
            LOG.error("genNotHrBuStrategyObject() orgModel id:{}", (Object)orgModel.getId());
        }
        strategy.set("effdt", ((DynamicObject)saveModel.getAdminOrgDetails().get(orgModel.getId())).get("bsed"));
        Set reals = "news".equals(flag) ? (Set)this.businessTypeTies.get(ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG) : (Set)saveModel.getLacks().get(orgModel.getId());
        super.createEntryDynamicObject(strategy, reals, ORG_STRATEGY_HELPER, parentStrategy, flag, saveModel.getBusinessType2HRBu());
        return strategy;
    }

    @Override
    protected String fetchDefEntryStrategyKey(Long businessType) {
        return "4#" + businessType + "#" + ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG;
    }

    @Override
    protected String fetchSpEntryStrategyKey(Long businessType) {
        return "0#" + businessType + "#" + ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG;
    }

    private String fetchOrgKey2DefBu() {
        return "4#" + ManageStrategyConstants.LONG_ALLFIELD_BUSSTYPE_ID_ORG + "#" + ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG;
    }

    private String fetchOrgKey2SameParent() {
        return "0#" + ManageStrategyConstants.LONG_ALLFIELD_BUSSTYPE_ID_ORG + "#" + ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG;
    }
}

