/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.strategy.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.InitStrategyService;
import kd.hr.hrcs.bussiness.strategy.InitStrategyServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public abstract class InitProjStrategyServiceImpl
implements InitStrategyService {
    private static final Log LOG = LogFactory.getLog(InitProjStrategyServiceImpl.class);
    protected IPageCache pageCache;

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    @Override
    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    @Override
    public void initStrategy() {
        List<Long> enableProjectTeam = InitStrategyServiceHelper.getEnableProjectTeam();
        LOG.info("begin to init strategy, enabled projectTeam size :{}", (Object)enableProjectTeam.size());
        if (enableProjectTeam.size() > 10000) {
            String oldTraceId = RequestContext.get().getTraceId();
            ThreadPools.executeOnce((String)("handleStrategy_" + oldTraceId), () -> {
                TXHandle txHandle = TX.requiresNew();
                try {
                    this.getPageCache().put(this.getEntityNumber(), "doing");
                    this.beginInitStrategy(enableProjectTeam);
                }
                catch (Exception ex) {
                    LOG.error(String.format(Locale.ROOT, "oldTraceId:%s, processStrategyInNewThread Exception: ", oldTraceId), (Throwable)ex);
                    txHandle.markRollback();
                }
                finally {
                    txHandle.close();
                    this.getPageCache().remove(this.getEntityNumber());
                    LOG.info("remove INIT_EMP_CACHE_KEY_FLAG flag, oldTraceId:{} .", (Object)oldTraceId);
                }
            });
        }
        this.beginInitStrategy(enableProjectTeam);
    }

    private void beginInitStrategy(List<Long> enableProjectTeam) {
        LOG.info("beginInitStrategy, enabled projectTeam size :{}", (Object)enableProjectTeam.size());
        Map<Long, DynamicObject> existStrategy = this.getExistStrategy();
        DynamicObject[] allBusinessTypeReals = InitStrategyServiceHelper.getAllBusinessTypeReal(ManageStrategyConstants.LONG_ORGTYPE_PROJECT, new Long[0]);
        Long businessObjectId = this.getBusinessObjectId();
        Set<Long> existTypesReals = Arrays.stream(allBusinessTypeReals).filter(dy -> businessObjectId.longValue() == dy.getLong("bussinessobject.id")).map(dy2 -> dy2.getLong("id")).collect(Collectors.toSet());
        Pair<Set<Long>, Map<Long, Set<Long>>> completeAndLacks = InitStrategyServiceHelper.compareStrategy(existStrategy, existTypesReals);
        Set intactIds = (Set)completeAndLacks.getLeft();
        Set modifyIds = ((Map)completeAndLacks.getRight()).keySet();
        ProjStrategyServiceHelper.addStrategyByProjectTeam(enableProjectTeam.stream().filter(modifyIds::contains).collect(Collectors.toList()), this.getEntityNumber(), false);
        ProjStrategyServiceHelper.addStrategyByProjectTeam(enableProjectTeam.stream().filter(id -> !modifyIds.contains(id) && !intactIds.contains(id)).collect(Collectors.toList()), this.getEntityNumber(), true);
    }

    protected Map<Long, DynamicObject> getExistStrategy() {
        return InitStrategyServiceHelper.getExistsStrategy(this.getEntityNumber());
    }
}

