/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.privacy.PrivacyMsgPushServiceHelper;

public class DuePersonNotifyTask
extends AbstractTask {
    private static int BATCH_SIZE = 100;
    private static final Log LOGGER = LogFactory.getLog(DuePersonNotifyTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Boolean isOpenPrivacySwitch;
        Map paramsMap;
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        if (requestContext != null && requestContext.getOrgId() != 0L) {
            orgId = requestContext.getOrgId();
        }
        if (!((paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(orgId)))) == null || (isOpenPrivacySwitch = (Boolean)paramsMap.get("privacydataswitch")) != null && isOpenPrivacySwitch.booleanValue())) {
            LOGGER.warn("privacy_data_switch_is_not_opened");
            return;
        }
        LOGGER.info("DuePersonNotifyTask_is_started");
        Map<String, String[]> queueMap = PrivacyMsgPushServiceHelper.getBusinessQueue();
        DynamicObject[] duePersons = PrivacyMsgPushServiceHelper.getDuePersonForNotify();
        String bizAppIdFlag = null;
        String dataSubjectTypeFlag = null;
        HashMap msg = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList personIds = Lists.newArrayListWithCapacity((int)16);
        int batch = 1;
        for (int i = 0; i < duePersons.length; ++i) {
            DynamicObject person = duePersons[i];
            if (!HRStringUtils.equals(bizAppIdFlag, (String)person.getString("bizappid.id")) || !HRStringUtils.equals(dataSubjectTypeFlag, (String)person.getString("datasubjecttype"))) {
                if (HRStringUtils.isNotEmpty(bizAppIdFlag)) {
                    this.pushMsg(bizAppIdFlag, queueMap, msg, batch);
                    batch = 1;
                }
                bizAppIdFlag = person.getString("bizappid.id");
                dataSubjectTypeFlag = person.getString("datasubjecttype");
                msg.clear();
                personIds.clear();
                msg.put("bizAppId", bizAppIdFlag);
                msg.put("dataSubjectIdType", dataSubjectTypeFlag);
                msg.put("dataSubjectIds", personIds);
            }
            personIds.add(person.getLong("datasubjectid"));
            if (personIds.size() != BATCH_SIZE) continue;
            this.pushMsg(bizAppIdFlag, queueMap, msg, batch);
            ++batch;
            personIds.clear();
            msg.put("dataSubjectIds", personIds);
        }
        if (personIds.size() > 0) {
            this.pushMsg(bizAppIdFlag, queueMap, msg, batch);
        }
    }

    private void pushMsg(String bizAppIdFlag, Map<String, String[]> queueMap, Map<String, Object> msg, int batch) {
        String[] queue = queueMap.get(bizAppIdFlag);
        if (queue == null) {
            LOGGER.warn(String.format("\u5e94\u7528 %s \u5bf9\u5e94\u7684\u961f\u5217\u672a\u914d\u7f6e\uff0c\u6d88\u606f\u672a\u63a8\u9001\u6210\u529f\uff01", bizAppIdFlag, Locale.ROOT));
            return;
        }
        msg.put("batchNumber", this.getMsgBatchNo(bizAppIdFlag, msg.get("dataSubjectIdType"), batch));
        try {
            HRProducerServiceHelper.publishDynamicQueue((String)queue[0], (String)queue[1], msg);
        }
        catch (Exception exception) {
            LOGGER.error(String.format("\u5e94\u7528 %s \u5bf9\u5e94\u7684\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff01", bizAppIdFlag, Locale.ROOT), (Throwable)exception);
        }
    }

    private String getMsgBatchNo(String bizApp, Object dataSubjectIdType, int batch) {
        return String.format("%s_%s_%s_%03d", bizApp, dataSubjectIdType, HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"), batch);
    }
}

