/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class HrClearDisabledScheduleTask
extends AbstractTask {
    private static final String HRCS_NEEDDELETETASKLOG = "hrcs_needdeletetasklog";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.deletePlanAndJob();
    }

    private void deletePlanAndJob() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_needdeletetask");
        QFilter[] qFilters = new QFilter[]{new QFilter("updatestatus", "=", (Object)"0")};
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(qFilters);
        if (dynamicObjects == null) {
            return;
        }
        HashMap scheduleDeleteJobMaps = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String scheduleId = dynamicObject.getString("schedule_id");
            Boolean deleteJob = dynamicObject.getBoolean("deletejob");
            scheduleDeleteJobMaps.put(scheduleId, deleteJob);
        }
        if (MapUtils.isEmpty((Map)scheduleDeleteJobMaps)) {
            return;
        }
        Set<String> canNotBeDeleteSet = this.canNotBeDelete(scheduleDeleteJobMaps.keySet());
        Set<String> canBeDeleteSet = scheduleDeleteJobMaps.keySet();
        if (CollectionUtils.isNotEmpty(canBeDeleteSet)) {
            canBeDeleteSet.removeAll(canNotBeDeleteSet);
        }
        if (CollectionUtils.isEmpty(canBeDeleteSet)) {
            if (CollectionUtils.isNotEmpty(canNotBeDeleteSet)) {
                this.updateStatus(serviceHelper, dynamicObjects, null, canNotBeDeleteSet);
            }
            return;
        }
        HRBaseServiceHelper scheduleHelper = new HRBaseServiceHelper("sch_schedule");
        DynamicObject[] dySchedules = this.queryScheduleInfo(scheduleHelper, canBeDeleteSet);
        if (dySchedules == null || dySchedules.length == 0) {
            if (CollectionUtils.isNotEmpty(canNotBeDeleteSet)) {
                this.updateStatus(serviceHelper, dynamicObjects, null, canNotBeDeleteSet);
            }
            return;
        }
        Map<String, DynamicObject> dyJobsMap = this.queryJobInfo(Arrays.stream(dySchedules).map(dy -> dy.getString("job_id")).collect(Collectors.toSet()));
        HashSet scheduleIdSet = Sets.newHashSetWithExpectedSize((int)dySchedules.length);
        HashSet jobIdSet = Sets.newHashSetWithExpectedSize((int)dySchedules.length);
        for (DynamicObject dynamicObject : dySchedules) {
            scheduleIdSet.add(dynamicObject.getString("id"));
            jobIdSet.add(dynamicObject.getString("job_id"));
        }
        ScheduleServiceHelper scheduleServiceHelper = new ScheduleServiceHelper();
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper(HRCS_NEEDDELETETASKLOG);
        ArrayList dyLogList = Lists.newArrayListWithExpectedSize((int)dySchedules.length);
        for (DynamicObject dynamicObject : dySchedules) {
            String jobId;
            if (dynamicObject == null) continue;
            String scheduleId = dynamicObject.getString("id");
            Boolean deleteJob = (Boolean)scheduleDeleteJobMaps.get(scheduleId);
            DynamicObject dyLog = logHelper.generateEmptyDynamicObject();
            if (deleteJob.booleanValue() && !this.hasRelateOtherSchedule(jobId = dynamicObject.getString("job_id"), scheduleHelper, scheduleIdSet)) {
                DynamicObject dyJob;
                if (dyJobsMap != null && (dyJob = dyJobsMap.get(jobId)) != null) {
                    dyLog.set("jobid", (Object)jobId);
                    dyLog.set("jobnumber", (Object)dyJob.getString("number"));
                    dyLog.set("jobname", (Object)dyJob.getString("name"));
                }
                ScheduleServiceHelper.deleteJob((String)jobId);
            }
            dyLog.set("scheduleid", (Object)scheduleId);
            dyLog.set("schedulenumber", (Object)dynamicObject.getString("number"));
            dyLog.set("schedulename", (Object)dynamicObject.getString("name"));
            dyLogList.add(dyLog);
            ScheduleServiceHelper.deletePlan((String)scheduleId);
        }
        if (CollectionUtils.isNotEmpty((Collection)dyLogList)) {
            logHelper.save(dyLogList.toArray(new DynamicObject[dyLogList.size()]));
        }
        this.updateStatus(serviceHelper, dynamicObjects, canBeDeleteSet, canNotBeDeleteSet);
    }

    private DynamicObject[] queryScheduleInfo(HRBaseServiceHelper scheduleHelper, Set<String> canBeDeleteSet) {
        DynamicObject[] dySchedules = scheduleHelper.query("id,name,number,job_id", new QFilter[]{new QFilter("id", "in", canBeDeleteSet), new QFilter("status", "=", (Object)"0")});
        return dySchedules;
    }

    private Map<String, DynamicObject> queryJobInfo(Set<String> canBeDeleteSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sch_job");
        DynamicObject[] dynamicObjects = serviceHelper.query("id,name,number", new QFilter[]{new QFilter("id", "in", canBeDeleteSet)});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy));
    }

    private boolean hasRelateOtherSchedule(String jobId, HRBaseServiceHelper scheduleHelper, Set<String> scheduleIdSet) {
        return scheduleHelper.isExists(new QFilter[]{new QFilter("job_id", "=", (Object)jobId), new QFilter("id", "not in", scheduleIdSet)});
    }

    private void updateStatus(HRBaseServiceHelper serviceHelper, DynamicObject[] dynamicObjects, Set<String> canBeDeleteSet, Set<String> canNotBeDeleteSet) {
        ArrayList needUpdateDyList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String id = dynamicObject.getString("schedule_id");
            if (canBeDeleteSet != null && canBeDeleteSet.contains(id)) {
                dynamicObject.set("updatestatus", (Object)"1");
                dynamicObject.set("errormsg", (Object)" ");
                needUpdateDyList.add(dynamicObject);
            }
            if (canNotBeDeleteSet == null || !canNotBeDeleteSet.contains(id)) continue;
            dynamicObject.set("errormsg", (Object)"Schedule must be disabled and task must be stopped at least 90 days ago.");
            needUpdateDyList.add(dynamicObject);
        }
        if (CollectionUtils.isNotEmpty((Collection)needUpdateDyList)) {
            serviceHelper.save(needUpdateDyList.toArray(new DynamicObject[needUpdateDyList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> canNotBeDelete(Set<String> scheduleIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sch_task");
        QFilter[] qFilters = new QFilter[]{new QFilter("schedule", "in", scheduleIdSet)};
        HashMap mapScheduleIdEndTime = null;
        DataSet dataSet = null;
        LocalDate today = LocalDate.now();
        LocalDate ninetyDaysAgo = today.minus(90L, ChronoUnit.DAYS);
        HashSet canNotBeDeleteSet = Sets.newHashSetWithExpectedSize((int)16);
        try {
            dataSet = serviceHelper.queryDataSet(HrClearDisabledScheduleTask.class.getName() + ".canBeDelete", "schedule_id,endtime", qFilters).groupBy(new String[]{"schedule_id"}).max("endtime").finish();
            while (dataSet.hasNext()) {
                Date endTime;
                LocalDate localDate;
                Row row = dataSet.next();
                if (mapScheduleIdEndTime == null) {
                    mapScheduleIdEndTime = Maps.newHashMapWithExpectedSize((int)scheduleIdSet.size());
                }
                if (!(localDate = (endTime = row.getDate("endtime")).toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).isAfter(ninetyDaysAgo)) continue;
                canNotBeDeleteSet.add(row.getString("schedule_id"));
            }
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
        }
        return canNotBeDeleteSet;
    }
}

