/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.MsgWarningServiceHelper;

public class MsgCenterRetryTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(MsgCenterRetryTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("MsgCenterRetryTask execute begin...");
        try {
            this.queryAllRetry();
        }
        catch (Exception ex) {
            logger.error("MsgCenterRetryTask_execute_error", (Throwable)ex);
        }
        logger.info("MsgCenterRetryTask execute end...");
    }

    private void queryAllRetry() {
        String sql = "select a.fid as id ,a.fretrytimes as retrytimes,a.fcreatetime as  createtime from t_hrcs_msgcenter a left join  t_hrcs_msgcenterentry b on a.fid=b.fid where b.frecstatus='B' and a.fretrytimes<3 order by  a.fcreatetime asc";
        DataSet ds = HRDBUtil.queryDataSet((String)"MsgCenterRetryTask.queryAllRetry", (DBRoute)DBRoute.of((String)"hmp"), (String)sql, null);
        ArrayList retryList = Lists.newArrayListWithExpectedSize((int)2000);
        while (ds.hasNext()) {
            if (retryList.size() < 2000) {
                Row row = ds.next();
                if (!this.checkRetryStrategy(row.getInteger("retrytimes"), row.getDate("createtime"))) continue;
                retryList.add(row.getLong("id"));
                continue;
            }
            if (retryList.size() != 2000) continue;
            this.retryMsgCenter(retryList);
            retryList = Lists.newArrayListWithExpectedSize((int)2000);
        }
        if (retryList.size() > 0) {
            this.retryMsgCenter(retryList);
        }
        ds.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryMsgCenter(List<Long> retrySubList) {
        DynamicObject[] msgCenterArr;
        HRBaseServiceHelper msgCenterHelper = new HRBaseServiceHelper("hrcs_msgcenter");
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        for (DynamicObject dynamicObject : msgCenterArr = msgCenterHelper.loadDynamicObjectArray(retrySubList.toArray())) {
            try {
                logger.info("MsgCenterRetryTask retryMsgs.NUMBER_is{})", (Object)dynamicObject.getString("number"));
                MsgCenterServiceHelper.retryMsgToBu(dynamicObject, msgCenterHelper, pubServiceHelper, subServiceHelper, null);
            }
            catch (Exception ex) {
                logger.error("{},bizConsumeMessage_retry_error", (Object)dynamicObject, (Object)ex);
            }
            finally {
                this.updateRetryTimes(msgCenterHelper, dynamicObject);
            }
        }
    }

    private void updateRetryTimes(HRBaseServiceHelper msgCenterHelper, DynamicObject dynamicObject) {
        try {
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("retrytimes", (Object)(dynamicObject.getInt("retrytimes") + 1));
            msgCenterHelper.saveOne(dynamicObject);
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject obj : entryEntity) {
                if (!"B".equalsIgnoreCase(String.valueOf(dynamicObject.get("recstatus")))) continue;
                MsgWarningServiceHelper.sendMsgWarning(dynamicObject, "rec", obj.getString("msgsubno"));
            }
        }
        catch (Exception ex) {
            logger.error("{},updateRetryTimes_error", (Object)dynamicObject, (Object)ex);
        }
    }

    private boolean checkRetryStrategy(int retryTimes, Date createTime) {
        long phaseTimes = HRDateTimeUtils.dateDiff((Date)createTime, (Date)new Date());
        return retryTimes == 0 && phaseTimes > 60000L || retryTimes == 1 && phaseTimes > 180000L || retryTimes == 2 && phaseTimes > 540000L;
    }
}

