/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermFileSyncServiceHelper;

public class SyncPermFilesTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SyncPermFilesTask.class);

    public void setTaskId(String id) {
        super.setTaskId(id);
        IHRAppCache appCache = HRAppCache.get((String)"hrcs");
        appCache.put("syncPermFilesTaskId", (Object)id);
    }

    public void stop() throws KDException {
        super.stop();
        IHRAppCache appCache = HRAppCache.get((String)"hrcs");
        appCache.put("syncPermFilesTaskId", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        IHRAppCache appCache = HRAppCache.get((String)"hrcs");
        int updTotalCount = 0;
        int newTotalCount = 0;
        int chkIsNotPassTotalCount = 0;
        int chkUserIdTotalCount = 0;
        int chkEnableTotalCount = 0;
        int chkRelSysUserTotalCount = 0;
        boolean isSuccess = true;
        String errorInfo = "";
        try {
            String desc = ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d...", (String)"SyncPermFilesTask_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
            this.feedbackProgress(0, desc, null);
            List labrelTypeclsList = (List)params.get("labrelTypeclsList");
            List labrelStatusclsList = (List)params.get("labrelStatusclsList");
            int totalCount = PermFileSyncServiceHelper.getErmanFilesCount(labrelTypeclsList, labrelStatusclsList);
            LOGGER.info("SyncPermFilesTask-totalCount:{}", (Object)totalCount);
            long id = 0L;
            int top = 1000;
            int microReqCount = totalCount / top;
            if (totalCount % top > 0) {
                ++microReqCount;
            }
            int resedueCount = totalCount;
            long startTime = System.currentTimeMillis();
            for (int reqSeq = 1; reqSeq <= microReqCount; ++reqSeq) {
                long reqStartTime = System.currentTimeMillis();
                DynamicObject[] ermanFiles = PermFileSyncServiceHelper.getErmanFiles(labrelTypeclsList, labrelStatusclsList, id, top);
                if (null == ermanFiles || ermanFiles.length == 0) {
                    this.feedbackProgress(Math.round(0.01f), desc, null);
                    break;
                }
                long reqEndTime = System.currentTimeMillis();
                LOGGER.info("SyncPermFilesTask-req-api:reqSeq={},reqTime(ms)={}", (Object)reqSeq, (Object)(reqEndTime - reqStartTime));
                long handleStartTime = System.currentTimeMillis();
                Map<String, Object> rspMap = PermFileSyncServiceHelper.genPermFiles(ermanFiles);
                long handleEndTime = System.currentTimeMillis();
                LOGGER.info("SyncPermFilesTask-handle-api:reqSeq={},handleTime(ms)={}", (Object)reqSeq, (Object)(handleEndTime - handleStartTime));
                this.recordHandleCountLog(reqSeq, rspMap);
                updTotalCount += ((Integer)rspMap.get("updCount")).intValue();
                newTotalCount += ((Integer)rspMap.get("newCount")).intValue();
                chkIsNotPassTotalCount += ((Integer)rspMap.get("chkIsNotPassCount")).intValue();
                chkUserIdTotalCount += ((Integer)rspMap.get("chkUserIdCount")).intValue();
                chkEnableTotalCount += ((Integer)rspMap.get("chkEnableCount")).intValue();
                chkRelSysUserTotalCount += ((Integer)rspMap.get("chkRelSysUserCount")).intValue();
                resedueCount = reqSeq == microReqCount ? 0 : (resedueCount -= top);
                if (ermanFiles.length < top) {
                    this.feedbackProgress(Math.round(0.01f), desc, null);
                    break;
                }
                this.feedbackProgress(Math.round((float)(totalCount - resedueCount) / (float)totalCount * 100.0f), desc, null);
                id = ermanFiles[ermanFiles.length - 1].getLong("id");
            }
            LOGGER.info("SyncPermFilesTask-genPermFiles-TotalCount(microReqCount={}):totalCount={},updTotalCount={},newTotalCount={},chkIsNotPassTotalCount={},chkUserIdTotalCount={},chkEnableTotalCount={},chkRelSysUserTotalCount={}", new Object[]{microReqCount, totalCount, updTotalCount, newTotalCount, chkIsNotPassTotalCount, chkUserIdTotalCount, chkEnableTotalCount, chkRelSysUserTotalCount});
            long endTime = System.currentTimeMillis();
            LOGGER.info("SyncPermFilesTask-execute-totalTime(ms):{}", (Object)(endTime - startTime));
        }
        catch (Exception exc) {
            isSuccess = false;
            errorInfo = SyncPermFilesTask.getStackTrace(exc);
            LOGGER.error("SyncPermFilesTask-execute-fail-errorInfo\uff1a", (Throwable)exc);
        }
        finally {
            this.buildRspResult(appCache, isSuccess, newTotalCount, updTotalCount, errorInfo);
        }
    }

    private void buildRspResult(IHRAppCache appCache, boolean isSuccess, int newCount, int updCount, String errorInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (isSuccess) {
            result.put("success", true);
        } else {
            result.put("success", false);
        }
        result.put("newCount", newCount);
        result.put("updCount", updCount);
        result.put("errorInfo", errorInfo);
        this.feedbackCustomdata(result);
        appCache.put("syncPermFilesTask" + RequestContext.get().getCurrUserId(), result);
        appCache.put("syncPermFilesTaskId", null);
    }

    private void recordHandleCountLog(int reqSeq, Map<String, Object> rspMap) {
        int updCount = (Integer)rspMap.get("updCount");
        int newCount = (Integer)rspMap.get("newCount");
        int chkIsNotPassCount = (Integer)rspMap.get("chkIsNotPassCount");
        int chkUserIdCount = (Integer)rspMap.get("chkUserIdCount");
        int chkEnableCount = (Integer)rspMap.get("chkEnableCount");
        int chkRelSysUserCount = (Integer)rspMap.get("chkRelSysUserCount");
        LOGGER.info("SyncPermFilesTask-genPermFiles-Count(reqSeq={}):updCount={},newCount={},chkIsNotPassCount={},chkUserIdCount={},chkEnableCount={},chkRelSysUserCount={}", new Object[]{reqSeq, updCount, newCount, chkIsNotPassCount, chkUserIdCount, chkEnableCount, chkRelSysUserCount});
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }
}

