/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.hr.hbp.common.util.HRStringUtils;

public class CompareUtils {
    public static boolean compareEquals(Object leftValue, Object rightValue) {
        boolean ruleFlag = false;
        if (leftValue instanceof Boolean) {
            ruleFlag = rightValue instanceof Boolean ? ((Boolean)leftValue).compareTo((Boolean)rightValue) == 0 : HRStringUtils.equals((String)((Boolean)leftValue != false ? "1" : "0"), (String)String.valueOf(rightValue));
        } else if (leftValue instanceof Integer || leftValue instanceof Long || leftValue instanceof BigDecimal) {
            ruleFlag = CompareUtils.transferBigDecimal(leftValue).compareTo(CompareUtils.transferBigDecimal(rightValue)) == 0;
        } else {
            String leftStr = leftValue instanceof LocaleString ? ((LocaleString)leftValue).getLocaleValue() : String.valueOf(leftValue);
            String rightStr = rightValue instanceof LocaleString ? ((LocaleString)rightValue).getLocaleValue() : String.valueOf(rightValue);
            ruleFlag = HRStringUtils.isNotEmpty((String)leftStr) && leftStr.compareTo(rightStr) == 0;
        }
        return ruleFlag;
    }

    public static boolean compareIn(Object leftValue, Object rightValue) {
        if (Objects.isNull(rightValue) || Objects.isNull(leftValue)) {
            return false;
        }
        if (leftValue instanceof Boolean) {
            String dataStr = (Boolean)leftValue != false ? "1" : "0";
            List filterList = (List)rightValue;
            return filterList.contains(dataStr);
        }
        List filterList = (List)rightValue;
        return filterList.contains(String.valueOf(leftValue));
    }

    public static boolean compareLike(Object leftValue, Object rightValue) {
        String dataStr = String.valueOf(leftValue);
        String filterStr = String.valueOf(rightValue);
        if (Objects.isNull(rightValue) || HRStringUtils.isEmpty((String)filterStr)) {
            return true;
        }
        if (Objects.isNull(leftValue) || HRStringUtils.isEmpty((String)dataStr)) {
            return false;
        }
        if (filterStr.startsWith("%") && filterStr.endsWith("%")) {
            return dataStr.contains(filterStr.replace("%", ""));
        }
        if (filterStr.startsWith("%")) {
            return dataStr.endsWith(filterStr.replace("%", ""));
        }
        if (filterStr.endsWith("%")) {
            return dataStr.startsWith(filterStr.replace("%", ""));
        }
        return false;
    }

    private static BigDecimal transferBigDecimal(Object dataValue) {
        BigDecimal result = new BigDecimal(0);
        if (dataValue instanceof Integer) {
            result = new BigDecimal((Integer)dataValue);
        } else if (dataValue instanceof Long) {
            result = new BigDecimal((Long)dataValue);
        } else if (dataValue instanceof BigDecimal) {
            result = (BigDecimal)dataValue;
        }
        return result;
    }

    public static boolean compareLessThan(Object leftValue, Object rightValue) {
        boolean ruleFlag = false;
        if (leftValue instanceof Date) {
            Date dateValue = (Date)leftValue;
            Date dateFilter = (Date)rightValue;
            ruleFlag = dateValue.before(dateFilter);
        } else if (leftValue instanceof Integer || leftValue instanceof Long || leftValue instanceof BigDecimal) {
            ruleFlag = CompareUtils.transferBigDecimal(leftValue).compareTo(CompareUtils.transferBigDecimal(rightValue)) < 0;
        } else if (leftValue instanceof Boolean) {
            ruleFlag = rightValue instanceof Boolean ? ((Boolean)leftValue).compareTo((Boolean)rightValue) == 0 : HRStringUtils.equals((String)((Boolean)leftValue != false ? "1" : "0"), (String)String.valueOf(rightValue));
        } else {
            String leftStr = leftValue instanceof LocaleString ? ((LocaleString)leftValue).getLocaleValue() : String.valueOf(leftValue);
            String rightStr = rightValue instanceof LocaleString ? ((LocaleString)rightValue).getLocaleValue() : String.valueOf(rightValue);
            ruleFlag = HRStringUtils.isNotEmpty((String)leftStr) && leftStr.compareTo(rightStr) < 0;
        }
        return ruleFlag;
    }

    public static boolean compareLargeThan(Object leftValue, Object rightValue) {
        boolean ruleFlag = false;
        if (leftValue instanceof Date) {
            Date dateValue = (Date)leftValue;
            Date dateFilter = (Date)rightValue;
            ruleFlag = dateValue.after(dateFilter);
        } else if (leftValue instanceof Integer || leftValue instanceof Long || leftValue instanceof BigDecimal) {
            ruleFlag = CompareUtils.transferBigDecimal(leftValue).compareTo(CompareUtils.transferBigDecimal(rightValue)) > 0;
        } else if (leftValue instanceof Boolean) {
            ruleFlag = rightValue instanceof Boolean ? ((Boolean)leftValue).compareTo((Boolean)rightValue) == 0 : HRStringUtils.equals((String)((Boolean)leftValue != false ? "1" : "0"), (String)String.valueOf(rightValue));
        } else {
            String leftStr = leftValue instanceof LocaleString ? ((LocaleString)leftValue).getLocaleValue() : String.valueOf(leftValue);
            String rightStr = rightValue instanceof LocaleString ? ((LocaleString)rightValue).getLocaleValue() : String.valueOf(rightValue);
            ruleFlag = HRStringUtils.isNotEmpty((String)leftStr) && leftStr.compareTo(rightStr) > 0;
        }
        return ruleFlag;
    }
}

