/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextAreaEdit;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.label.LabelService;
import kd.hr.hrcs.common.constants.label.LabelConstants;
import org.apache.commons.lang3.tuple.Pair;

public class GenFieldUtil
implements LabelConstants {
    public static FieldAp getFieldAp(DynamicProperty property, Map<String, String> baseEntityMap, int index) {
        FieldAp fieldAp = new FieldAp();
        String id = null;
        if (property instanceof BasedataProp || property instanceof MulBasedataProp) {
            String entityNum;
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                entityNum = basedataProp.getBaseEntityId();
            } else {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                entityNum = mulBasedataProp.getBaseEntityId();
            }
            id = "basedatafield" + index;
            MulBasedataField mulBasedataField = new MulBasedataField();
            mulBasedataField.setKey(id);
            mulBasedataField.setId(id);
            mulBasedataField.setBaseEntityId(entityNum);
            fieldAp.setField((Field)mulBasedataField);
            baseEntityMap.put(id, entityNum);
        } else if (property instanceof ComboProp || property instanceof BooleanProp) {
            ArrayList comboItemList;
            if (property instanceof BooleanProp) {
                comboItemList = Lists.newArrayListWithExpectedSize((int)2);
                ComboItem comboItem = new ComboItem();
                comboItem.setValue("1");
                comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"LabelObjectListPlugin_5", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
                comboItemList.add(comboItem);
                ComboItem comboItem2 = new ComboItem();
                comboItem2.setValue("0");
                comboItem2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"LabelObjectListPlugin_6", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0])));
                comboItemList.add(comboItem2);
            } else {
                ComboProp comboProp = (ComboProp)property;
                List valueMapItems = comboProp.getComboItems();
                comboItemList = Lists.newArrayListWithExpectedSize((int)valueMapItems.size());
                valueMapItems.forEach(valueMapItem -> {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setValue(valueMapItem.getValue());
                    comboItem.setCaption(valueMapItem.getName());
                    comboItemList.add(comboItem);
                });
            }
            id = "mulcombofield" + index;
            MulComboField mulComboField = new MulComboField();
            mulComboField.setKey(id);
            mulComboField.setId(id);
            mulComboField.setItems((List)comboItemList);
            fieldAp.setField((Field)mulComboField);
        } else if (property instanceof DateTimeProp) {
            id = "daterangefield" + index;
            DateRangeField dateRangeField = new DateRangeField();
            dateRangeField.setKey(id);
            dateRangeField.setId(id);
            dateRangeField.setStartDateFieldKey(id + "startdate");
            dateRangeField.setEndDateFieldKey(id + "enddate");
            fieldAp.setField((Field)dateRangeField);
        } else if (property instanceof TextProp) {
            id = "text" + index;
            TextAreaField textAreaField = new TextAreaField();
            textAreaField.setKey(id);
            textAreaField.setId(id);
            fieldAp.setField((Field)textAreaField);
        }
        fieldAp.setId(id);
        fieldAp.setKey(id);
        return fieldAp;
    }

    public static Pair<FieldAp, FieldAp> getNumberFieldAp(DynamicProperty property, int index) {
        Pair fieldPair = null;
        if (property instanceof IntegerProp) {
            String id = "integer" + index;
            IntegerField integerField = new IntegerField();
            integerField.setKey(id + "left");
            integerField.setId(integerField.getKey());
            FieldAp fieldAp = new FieldAp();
            fieldAp.setKey(integerField.getKey());
            fieldAp.setId(fieldAp.getKey());
            fieldAp.setField((Field)integerField);
            IntegerField integerField2 = new IntegerField();
            integerField2.setKey(id + "right");
            integerField2.setId(integerField2.getKey());
            FieldAp fieldAp2 = new FieldAp();
            fieldAp2.setKey(integerField2.getKey());
            fieldAp2.setField((Field)integerField2);
            fieldAp2.setId(fieldAp2.getKey());
            fieldPair = Pair.of((Object)fieldAp, (Object)fieldAp2);
        } else if (property instanceof DecimalProp) {
            String id = "decimal" + index;
            DecimalField integerField = new DecimalField();
            integerField.setKey(id + "left");
            integerField.setId(integerField.getKey());
            FieldAp fieldAp = new FieldAp();
            fieldAp.setKey(integerField.getKey());
            fieldAp.setId(fieldAp.getKey());
            fieldAp.setField((Field)integerField);
            DecimalField integerField2 = new DecimalField();
            integerField2.setKey(id + "right");
            integerField2.setId(integerField2.getKey());
            FieldAp fieldAp2 = new FieldAp();
            fieldAp2.setKey(integerField2.getKey());
            fieldAp2.setField((Field)integerField2);
            fieldAp2.setId(fieldAp2.getKey());
            fieldPair = Pair.of((Object)fieldAp, (Object)fieldAp2);
        }
        return fieldPair;
    }

    public static void onGetControl(OnGetControlArgs e, IFormView view) {
        if (e.getKey().contains("hasfilter")) {
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setView(view);
            e.setControl((Control)fieldEdit);
        } else if (e.getKey().contains("basedatafield")) {
            MulBasedataEdit mulBasedataEdit = new MulBasedataEdit();
            mulBasedataEdit.setKey(e.getKey());
            mulBasedataEdit.setView(view);
            e.setControl((Control)mulBasedataEdit);
        } else if (e.getKey().contains("mulcombofield")) {
            MulComboEdit mulComboEdit = new MulComboEdit();
            mulComboEdit.setKey(e.getKey());
            mulComboEdit.setView(view);
            e.setControl((Control)mulComboEdit);
        } else if (e.getKey().contains("daterangefield")) {
            if (!e.getKey().endsWith("startdate") && !e.getKey().endsWith("enddate")) {
                DateRangeEdit dateRangeEdit = new DateRangeEdit();
                dateRangeEdit.setStartDateFieldKey(e.getKey() + "startdate");
                dateRangeEdit.setEndDateFieldKey(e.getKey() + "enddate");
                dateRangeEdit.setKey(e.getKey());
                dateRangeEdit.setView(view);
                e.setControl((Control)dateRangeEdit);
            }
        } else if (e.getKey().contains("integer")) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(e.getKey());
            integerEdit.setView(view);
            e.setControl((Control)integerEdit);
        } else if (e.getKey().contains("decimal")) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(e.getKey());
            decimalEdit.setView(view);
            e.setControl((Control)decimalEdit);
        } else if (e.getKey().contains("text")) {
            TextAreaEdit textAreaEdit = new TextAreaEdit();
            textAreaEdit.setKey(e.getKey());
            textAreaEdit.setView(view);
            e.setControl((Control)textAreaEdit);
        }
    }

    public static List<DynamicProperty> getFieldPropertyList(String fieldKey, String propType, Map<String, String> baseEntityMap, boolean isDoubleDate) {
        ArrayList dynamicPropertyList = Lists.newArrayListWithExpectedSize((int)2);
        if (propType.contains("basedatafield")) {
            DynamicObjectType type = new DynamicObjectType(fieldKey);
            GenFieldUtil.registerProperties(type, baseEntityMap.get(fieldKey));
            MulBasedataProp mulBasedataProp = new MulBasedataProp(fieldKey, type);
            mulBasedataProp.setDbIgnore(true);
            mulBasedataProp.setBaseEntityId(baseEntityMap.get(fieldKey));
            dynamicPropertyList.add(mulBasedataProp);
        } else if (propType.contains("mulcombofield")) {
            MulComboProp mulComboProp = new MulComboProp();
            mulComboProp.setName(fieldKey);
            mulComboProp.setDbIgnore(true);
            dynamicPropertyList.add(mulComboProp);
        } else if (propType.contains("daterangefield")) {
            DateTimeProp dateTimeProp = new DateTimeProp();
            if (isDoubleDate) {
                dateTimeProp.setName(fieldKey + "startdate");
                dateTimeProp.setDbIgnore(true);
                dateTimeProp.setRegionType(1);
                DateTimeProp dateTimeProp2 = new DateTimeProp();
                dateTimeProp2.setName(fieldKey + "enddate");
                dateTimeProp2.setDbIgnore(true);
                dateTimeProp2.setRegionType(1);
                dynamicPropertyList.add(dateTimeProp);
                dynamicPropertyList.add(dateTimeProp2);
            } else {
                dateTimeProp.setName(fieldKey);
                dateTimeProp.setDbIgnore(true);
                dateTimeProp.setRegionType(1);
                dynamicPropertyList.add(dateTimeProp);
            }
        } else if (propType.contains("hasfilter")) {
            BooleanProp booleanProp = new BooleanProp();
            booleanProp.setName(fieldKey);
            booleanProp.setDbIgnore(true);
            dynamicPropertyList.add(booleanProp);
        } else if (propType.contains("integer")) {
            IntegerProp integerProp = new IntegerProp();
            integerProp.setName(fieldKey);
            integerProp.setDbIgnore(true);
            dynamicPropertyList.add(integerProp);
        } else if (propType.contains("decimal")) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(fieldKey);
            decimalProp.setDbIgnore(true);
            dynamicPropertyList.add(decimalProp);
        } else if (propType.contains("text")) {
            TextAreaProp textProp = new TextAreaProp();
            textProp.setName(fieldKey);
            textProp.setDbIgnore(true);
            dynamicPropertyList.add(textProp);
        }
        return dynamicPropertyList;
    }

    public static String getValue(String propKey, IFormView view) {
        String valueStr = null;
        if (propKey.contains("basedatafield")) {
            StringBuilder stringBuilder = new StringBuilder();
            DynamicObjectCollection value = (DynamicObjectCollection)view.getModel().getValue(propKey);
            for (DynamicObject dynamicObject : value) {
                stringBuilder.append(dynamicObject.get("fbasedataid.id")).append(',');
            }
            valueStr = stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : null;
        } else if (propKey.contains("mulcombofield")) {
            valueStr = (String)view.getModel().getValue(propKey);
        } else if (propKey.contains("daterangefield")) {
            String startDateKey = propKey + "startdate";
            String endDateKey = propKey + "enddate";
            Date startDate = (Date)view.getModel().getValue(startDateKey);
            Date endDate2 = (Date)view.getModel().getValue(endDateKey);
            if (startDate != null) {
                valueStr = HRDateTimeUtils.format((Date)startDate);
            }
            if (endDate2 != null) {
                String endDateStr = HRDateTimeUtils.format((Date)endDate2);
                valueStr = HRStringUtils.isEmpty((String)valueStr) ? endDateStr : valueStr + "," + endDateStr;
            }
        } else if (propKey.contains("integer") || propKey.contains("decimal")) {
            valueStr = String.valueOf(view.getModel().getValue(propKey));
        } else if (propKey.contains("text")) {
            valueStr = (String)view.getModel().getValue(propKey);
        }
        return valueStr;
    }

    public static QFilter getQFilter(String propKey, String fieldKey, IFormView view) {
        String value;
        QFilter qFilter = null;
        if (propKey.contains("basedatafield")) {
            DynamicObjectCollection value2 = (DynamicObjectCollection)view.getModel().getValue(propKey);
            ArrayList idList = Lists.newArrayListWithExpectedSize((int)value2.size());
            for (DynamicObject dynamicObject : value2) {
                idList.add(dynamicObject.get("fbasedataid.id"));
            }
            if (!idList.isEmpty()) {
                fieldKey = fieldKey.substring(0, fieldKey.lastIndexOf(".")) + ".id";
                qFilter = new QFilter(fieldKey, "in", (Object)idList);
            }
        } else if (propKey.contains("mulcombofield")) {
            String value3 = (String)view.getModel().getValue(propKey);
            if (!HRStringUtils.isEmpty((String)value3)) {
                String[] split = value3.split(",");
                ArrayList valueList = Lists.newArrayListWithExpectedSize((int)split.length);
                for (String str : split) {
                    if (HRStringUtils.isEmpty((String)str)) continue;
                    valueList.add(str);
                }
                if (!valueList.isEmpty()) {
                    qFilter = new QFilter(fieldKey, "in", (Object)valueList);
                }
            }
        } else if (propKey.contains("daterangefield")) {
            String startDateKey = propKey + "startdate";
            String endDateKey = propKey + "enddate";
            Date startDate = (Date)view.getModel().getValue(startDateKey);
            Date endDate = (Date)view.getModel().getValue(endDateKey);
            if (startDate != null) {
                qFilter = new QFilter(fieldKey, ">=", (Object)startDate);
            }
            if (endDate != null) {
                if (startDate != null) {
                    qFilter.and(fieldKey, "<=", (Object)endDate);
                } else {
                    qFilter = new QFilter(fieldKey, "<=", (Object)endDate);
                }
            }
        } else if (propKey.contains("integer") || propKey.contains("decimal")) {
            BigDecimal value4 = new BigDecimal(String.valueOf(view.getModel().getValue(propKey)));
            if (BigDecimal.ZERO.compareTo(value4) != 0) {
                qFilter = propKey.endsWith("left") ? new QFilter(fieldKey, ">=", (Object)value4) : new QFilter(fieldKey, "<=", (Object)value4);
            }
        } else if (propKey.contains("text") && !HRStringUtils.isEmpty((String)(value = (String)view.getModel().getValue(propKey)))) {
            qFilter = new QFilter(fieldKey, "like", (Object)("%" + view.getModel().getValue(propKey) + "%"));
        }
        return qFilter;
    }

    private static void registerProperties(DynamicObjectType type, String baseEntityId) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        baseProp.setBaseEntityId(dt.getName());
        baseProp.setName("fbasedataid");
        baseProp.setDisplayProp("name");
        baseProp.setEditSearchProp("name");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)dt);
        String key_ref = "fbasedataid_id";
        DynamicSimpleProperty refIdProp = baseProp.createRefIDProp();
        refIdProp.setName(key_ref);
        baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
        baseProp.setRefIdPropName(key_ref);
        type.registerComplexProperty((DynamicComplexProperty)baseProp);
        type.registerSimpleProperty(refIdProp);
    }

    public static DynamicProperty getBindEntityProperty(String fieldKey) {
        int index = fieldKey.indexOf(46);
        String entityNum = fieldKey.substring(0, index);
        int index2 = entityNum.indexOf(948);
        if (index2 != -1) {
            entityNum = entityNum.substring(0, index2);
        }
        String fieldPath = fieldKey.substring(index + 1);
        return LabelService.getFieldDynamicProperty(entityNum, fieldPath);
    }
}

