/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PermRoleUtil {
    private static final Log LOGGER = LogFactory.getLog(PermRoleUtil.class);

    public static Date formatStartDate(Date startDate) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("startDate before format:" + startDate.toString());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("startDate after format:" + calendar.getTime().toString());
        }
        return calendar.getTime();
    }

    public static Date formatEndDate(Date endDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean handleRoleLicense(String roleId, Map<String, List<String>> appEntity) {
        List userIDs = PermCommonUtil.getUserByRole((String)roleId);
        boolean result = false;
        if (userIDs != null && userIDs.size() > 0 && appEntity != null && appEntity.size() > 0) {
            Map resultMap = LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj((List)userIDs, appEntity);
            if (Objects.nonNull(resultMap) && resultMap.size() == 1) {
                result = (Boolean)resultMap.get("success");
            }
        } else {
            result = true;
        }
        return result;
    }

    public static boolean handleUserRoleLicense(List<Long> userIds, Map<String, List<String>> appEntity) {
        if (userIds == null || userIds.size() == 0) {
            return true;
        }
        Map resultMap = LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(userIds, appEntity);
        boolean result = false;
        if (Objects.nonNull(resultMap) && resultMap.size() == 1) {
            result = (Boolean)resultMap.get("success");
        }
        return result;
    }

    public static Set<Long> str2LongSet(Set<String> strSet) {
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(strSet)) {
            return resultSet;
        }
        for (String str : strSet) {
            if (!HRStringUtils.isNotEmpty((String)str)) continue;
            resultSet.add(Long.parseLong(str));
        }
        return resultSet;
    }

    public static Long str2LongWithDefValue(String str, Long def) {
        if (HRStringUtils.isEmpty((String)str)) {
            return def;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception ex) {
            LOGGER.error("parseLong error.", (Throwable)ex);
            return def;
        }
    }

    public static Long str2Long(String str) {
        return Long.parseLong(str);
    }

    public static Date dateIncreaseByMonth(Date startDate, int month) {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, month);
        return cal.getTime();
    }

    public static Date dateIncreaseByDay(Date startDate, int day) {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static <T> T[] convertArray(Class<T> targetType, Object[] arrayObjects) {
        if (targetType == null) {
            return arrayObjects;
        }
        if (arrayObjects == null) {
            return null;
        }
        Object[] targetArray = (Object[])Array.newInstance(targetType, arrayObjects.length);
        try {
            System.arraycopy(arrayObjects, 0, targetArray, 0, arrayObjects.length);
        }
        catch (ArrayStoreException ex) {
            LOGGER.error("convertArray error. ", (Throwable)ex);
        }
        return targetArray;
    }

    public static String date2LocalTime(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        String format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(localDateTime);
        return format;
    }
}

