/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.TaskServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.msg.info.ParticipantInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.hr.hbp.business.extpoint.activity.ActivityTask;
import kd.hr.hbp.business.extpoint.activity.IActivityTaskExtService;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityInsServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractActivityService {
    private static final String THEME = "actthemestr";
    private static final String APPLIER = "applier";
    private static final String ACTIVITY = "activity";
    private static final String BIND_BIZ_KEY = "bindbizkey";
    private static final String BIND_BIZ_NUM = "bindbiznum";
    private static final String HANDLERS = "handlers";
    private static final String WF_NODE_ID = "wfnode";
    private static final String WF_PROCESS_DEF_ID = "wfprocessdefinitionid";

    abstract Log getLogger();

    protected Long saveWFTask(Long actInsId, String bindBizKey, Object bindBillId, String bindBizNum) {
        DynamicObject activityIns = ActivityInsServiceHelper.getActivityInsById((String)"actthemestr,applier,activity,bindbizkey,bindbiznum,wfnode,wfprocessdefinitionid,actscheme,activity,handlers", (Long)actInsId);
        this.getLogger().info("Got activity instance: {} with id: {}, bindBizKey: {}.", new Object[]{activityIns, actInsId, bindBizKey});
        if (null == activityIns) {
            this.getLogger().info("Got empty activity instance with id: {}.", (Object)actInsId);
            return 0L;
        }
        long activitySchemeId = activityIns.getDynamicObject("actscheme").getLong("id");
        long activityId = activityIns.getDynamicObject(ACTIVITY).getLong("id");
        String wfNodeId = activityIns.getString(WF_NODE_ID);
        long wfProcessDefId = activityIns.getLong(WF_PROCESS_DEF_ID);
        this.getLogger().info("Got task info activitySchemeId: {}, activityId: {}, wfNodeId: {}, wfProcessDefId: {} with id: {}.", new Object[]{activitySchemeId, activityId, wfNodeId, wfProcessDefId, actInsId});
        TaskEntityInfo taskEntityInfo = new TaskEntityInfo();
        HRPluginProxy proxy = new HRPluginProxy(null, IActivityTaskExtService.class, "kd.hr.hbp.business.extpoint.activity.IActivityTaskExtService", null);
        if (null == proxy.getPluginList() || proxy.getPluginList().isEmpty()) {
            Map taskConfig = ActivityInsServiceHelper.getTaskConfig((Long)wfProcessDefId, (String)wfNodeId);
            String entityNumber = Optional.ofNullable(taskConfig).map(it -> (String)it.get("taskbill")).orElseGet(() -> activityIns.getString(BIND_BIZ_KEY));
            this.getLogger().info("Got task entity number: {}.", (Object)entityNumber);
            taskEntityInfo.setNumber("hrcs_activitymodel");
            taskEntityInfo.setName(activityIns.getDynamicObject(ACTIVITY).getLocaleString("name"));
            taskEntityInfo.setSubject((ILocaleString)new LocaleString(this.getWFTaskTheme(taskConfig, entityNumber, bindBillId)));
            taskEntityInfo.setDescription((ILocaleString)new LocaleString(""));
            taskEntityInfo.setEndType("all");
            taskEntityInfo.setCategory("innerentitytask");
            taskEntityInfo.setFormKey(entityNumber);
            taskEntityInfo.setMobileFormKey(entityNumber);
            taskEntityInfo.setDisplay(Boolean.TRUE.booleanValue());
            taskEntityInfo.setStarterId(Long.valueOf(activityIns.getDynamicObject(APPLIER).getLong("id")));
            taskEntityInfo.setBusinessKey(String.valueOf(bindBillId));
            taskEntityInfo.setBillNo(bindBizNum);
            taskEntityInfo.setEntityNumber(entityNumber);
            taskEntityInfo.setBillType(entityNumber);
            taskEntityInfo.setParticipantInfos(activityIns.getDynamicObjectCollection(HANDLERS).stream().map(handler -> new ParticipantInfo(handler.getDynamicObject("fbasedataid").getLong("id"), 0)).collect(Collectors.toList()));
        } else {
            ActivityTask activityTask = (ActivityTask)proxy.callReplace(p -> p.getActivityTask(activitySchemeId, activityId, actInsId.longValue(), bindBillId, new HashMap())).stream().findAny().orElseThrow(() -> new KDException("Can not get activity task from IActivityTaskExtService."));
            taskEntityInfo.setNumber("hrcs_activitymodel");
            taskEntityInfo.setEndType("pc");
            taskEntityInfo.setCategory("innerentitytask");
            taskEntityInfo.setDisplay(Boolean.TRUE.booleanValue());
            taskEntityInfo.setStarterId(Long.valueOf(activityIns.getDynamicObject(APPLIER).getLong("id")));
            taskEntityInfo.setParticipantInfos(activityIns.getDynamicObjectCollection(HANDLERS).stream().map(handler -> new ParticipantInfo(handler.getDynamicObject("fbasedataid").getLong("id"), 0)).collect(Collectors.toList()));
            taskEntityInfo.setName(activityTask.getName());
            taskEntityInfo.setSubject(activityTask.getSubject());
            taskEntityInfo.setDescription(activityTask.getDescription());
            taskEntityInfo.setBusinessKey(String.valueOf(bindBillId));
            taskEntityInfo.setBillNo(activityTask.getBillNo());
            taskEntityInfo.setEntityNumber(activityTask.getEntityNumber());
            taskEntityInfo.setBillType(activityTask.getEntityNumber());
        }
        TaskInfo taskInfo = MessageCenterServiceHelper.createBizTask((TaskEntityInfo)taskEntityInfo);
        Long taskId = Optional.ofNullable(taskInfo).map(TaskInfo::getId).orElse(-1L);
        this.getLogger().info("Got task:{}.", (Object)taskId);
        return taskId;
    }

    protected Long saveSSCTask(Object bindBillId, Long procDefId, Long wfProcInsId, Long wfTaskId, String currentNodeId) {
        Map taskConfig = ActivityInsServiceHelper.getTaskConfig((Long)procDefId, (String)currentNodeId);
        String cloudId = "ssc";
        String appId = "task";
        String serviceName = "ITaskService";
        String methodName = "createTask4HRActivity";
        HashMap params = new HashMap();
        params.put("entityNumber", taskConfig.get("sscbill"));
        params.put("billId", Long.parseLong(bindBillId.toString()));
        params.put("taskLevel", Integer.parseInt((String)taskConfig.get("tasklevel")));
        params.put("wfDefinitionId", procDefId);
        params.put("wfTaskId", String.valueOf(wfTaskId));
        Map map = new HashMap();
        try {
            map = (Map)HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params});
        }
        catch (Exception exception) {
            this.getLogger().error("Got failed message when create ssc task.", (Throwable)exception);
            throw exception;
        }
        if (!map.containsKey("taskId") && !HRStringUtils.equals((String)"true", (String)((String)map.get("success")))) {
            this.getLogger().info("Got failed message map [{}] when create ssc task.", map);
            throw new KDException((String)map.get("msg"));
        }
        this.getLogger().info("Got map: {}.", map);
        return (Long)map.get("taskId");
    }

    private String validate(Long wfProcInsId) {
        ManagementService workflowService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getManagementService();
        String validate = workflowService.validateApi(wfProcInsId, "suspend");
        return validate;
    }

    private String getWFTaskTheme(Map<String, String> taskConfig, String entityNumber, Object id) {
        String wfTaskTheme = "";
        this.getLogger().info("Got taskConfig: {} with params entityNumber: {}, id: {}.", taskConfig, id);
        if (null == taskConfig) {
            return wfTaskTheme;
        }
        String wfTaskThemeExpr = taskConfig.get("theme");
        DynamicObject item = null;
        try {
            item = new HRBaseServiceHelper(entityNumber).loadSingle(id);
        }
        catch (Exception exception) {
            this.getLogger().error("Got exception when find data with entityNumber: " + entityNumber + " , id: " + id + ".", (Throwable)exception);
        }
        if (null == item) {
            this.getLogger().info("Can not find data with entityNumber: {}, id: {}.", (Object)entityNumber, id);
            wfTaskTheme = wfTaskThemeExpr;
            return wfTaskTheme;
        }
        BusinessModelVariableScope scope = new BusinessModelVariableScope(item);
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        TaskServiceImpl taskService = new TaskServiceImpl(configuration);
        ((ServiceImpl)taskService).setCommandExecutor(configuration.getCommandExecutor());
        return taskService.contentParser(wfTaskThemeExpr, item, (VariableScope)scope, false);
    }

    protected Pair<String, Long> saveTask(Long actInsId, String bindBizKey, Object bindBillId, String bindBizNum) {
        Pair result = Pair.of((Object)"1", (Object)0L);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject activityIns = serviceHelper.queryOne("actscheme,activity,wfcurtaskid,wfprocessdefinitionid,wfprocessinsid,wfnode,taskswitch", (Object)actInsId);
        if (null == activityIns) {
            this.getLogger().info("Can not get activity instance with id: {}.", (Object)actInsId);
            return result;
        }
        String taskSwitch = activityIns.getString("taskswitch");
        if (HRStringUtils.equals((String)"2", (String)taskSwitch)) {
            Long taskId = this.saveWFTask(actInsId, bindBizKey, bindBillId, bindBizNum);
            result = Pair.of((Object)taskSwitch, (Object)taskId);
        } else if (HRStringUtils.equals((String)"3", (String)taskSwitch)) {
            Long taskId = this.saveSSCTask(bindBillId, activityIns.getLong(WF_PROCESS_DEF_ID), activityIns.getLong("wfprocessinsid"), activityIns.getLong("wfcurtaskid"), activityIns.getString(WF_NODE_ID));
            result = Pair.of((Object)taskSwitch, (Object)taskId);
        }
        return result;
    }
}

