/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.mservice.api.IHBSSEntityTransTestService;

public class HBSSEntityTransTestService
implements IHBSSEntityTransTestService {
    private static final int SUCCESS = 200;
    private static final int FAILURE = 300;
    private static final String RESPONSE_CODE = "responseCode";
    private static final String RESPONSE_DESC = "responseDesc";
    private static final String ERROR_MSG = "errorMsg";
    private static final String SEPARATOR = "$";
    private static final String ORDER_ENTITY_NUMBER = "hbss_order";

    public Map<String, Object> testExceptionData(Map<String, List<Object>> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<Object> idList = entry.getValue();
                if (!HRStringUtils.isNotEmpty((String)key) || !key.contains(SEPARATOR)) continue;
                String[] entityNumberAndType = key.split("\\$");
                String entityNumber = entityNumberAndType[0];
                String type = entityNumberAndType[1];
                if (HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)type)) continue;
                if (Objects.equal((Object)type, (Object)"insert")) {
                    for (Object id : idList) {
                        if (this.existId(id)) continue;
                        resultMap.put(RESPONSE_CODE, 300);
                        resultMap.put(ERROR_MSG, "id no exist!");
                        resultMap.put(RESPONSE_DESC, " maybe id");
                        return resultMap;
                    }
                    continue;
                }
                if (Objects.equal((Object)type, (Object)"update")) {
                    for (Object id : idList) {
                        System.out.println(id);
                    }
                    continue;
                }
                if (!Objects.equal((Object)type, (Object)"delete")) continue;
                System.out.print("success!");
            }
        }
        catch (Exception e) {
            resultMap.put(RESPONSE_CODE, 300);
            resultMap.put(ERROR_MSG, e.getMessage());
            return resultMap;
        }
        resultMap.put(RESPONSE_CODE, 200);
        resultMap.put(ERROR_MSG, null);
        return resultMap;
    }

    private boolean existId(Object id) {
        return false;
    }

    public Map<String, Object> processOrderDataBatch(Map<String, List<Object>> map) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
                String type;
                String[] entityNumberAndType;
                String entityNumber;
                String key = entry.getKey();
                List<Object> idList = entry.getValue();
                if (!HRStringUtils.isNotEmpty((String)key) || !key.contains(SEPARATOR) || !Objects.equal((Object)(entityNumber = (entityNumberAndType = key.split("\\$"))[0]), (Object)ORDER_ENTITY_NUMBER) || HRStringUtils.isEmpty((String)(type = entityNumberAndType[1]))) continue;
                if (Objects.equal((Object)type, (Object)"insert") || Objects.equal((Object)type, (Object)"update")) {
                    DynamicObject[] dys;
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    for (DynamicObject dy : dys = BusinessDataServiceHelper.load((Object[])idList.toArray(new Object[idList.size()]), (DynamicObjectType)dt)) {
                        DynamicObjectCollection dyDetailCollection = (DynamicObjectCollection)dy.get("orderdetail");
                        double total = 0.0;
                        for (DynamicObject dyDetail : dyDetailCollection) {
                            BigDecimal price = (BigDecimal)dyDetail.get("price");
                            BigDecimal productquantity = (BigDecimal)dyDetail.get("productquantity");
                            total += price.doubleValue() * productquantity.doubleValue();
                        }
                        Object orderPkValue = dy.getPkValue();
                        Date createtime = (Date)dy.get("createtime");
                        DynamicObject dynamicObjectDeliveryman = (DynamicObject)dy.get("deliveryman");
                        Object deliverymanPkValue = dynamicObjectDeliveryman.getPkValue();
                        this.UpdateRankingList(orderPkValue, deliverymanPkValue, createtime, total);
                    }
                    continue;
                }
                if (!Objects.equal((Object)type, (Object)"delete")) continue;
                this.deleteOrderUpdateRankingList(idList);
            }
        }
        catch (Exception e) {
            resultMap.put(RESPONSE_CODE, 300);
            resultMap.put(ERROR_MSG, e.getMessage());
            return resultMap;
        }
        resultMap.put(RESPONSE_CODE, 200);
        resultMap.put(ERROR_MSG, null);
        return resultMap;
    }

    private void UpdateRankingList(Object orderPkValue, Object deliverymanPkValue, Date createtime, double total) {
        System.out.println(orderPkValue.toString() + "|" + deliverymanPkValue + "|" + total);
    }

    private void deleteOrderUpdateRankingList(List<Object> idList) {
        System.out.println(idList.size());
    }
}

