/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityGroupInsServiceHelper;
import kd.hr.hrcs.mservice.api.IHRCSActivityGroupInsService;

public class HRCSActivityGroupInsService
implements IHRCSActivityGroupInsService {
    private static final Log LOG = LogFactory.getLog(HRCSActivityGroupInsService.class);
    private static final HRBaseServiceHelper ACTIVITY_SCHEME_HELPER = new HRBaseServiceHelper("hrcs_activityscheme");

    public List<Map<String, Object>> mateActivityGroup(Long sechemeId, DynamicObject data) {
        DynamicObject schemeObj = ACTIVITY_SCHEME_HELPER.queryOne((Object)sechemeId);
        DynamicObjectCollection groupEntrys = schemeObj.getDynamicObjectCollection("groupentry");
        LinkedHashMap<Long, String> conditions = new LinkedHashMap<Long, String>(groupEntrys.size());
        for (DynamicObject activityGroup : groupEntrys) {
            conditions.put(activityGroup.getLong("id"), activityGroup.getString("condition"));
        }
        Long groupEntryId = ActivityGroupInsServiceHelper.getInstance().mateActivityGroup(conditions, data);
        DynamicObjectCollection activityEntrys = null;
        for (DynamicObject activityGroup : groupEntrys) {
            if (!groupEntryId.equals(activityGroup.getLong("id"))) continue;
            activityEntrys = activityGroup.getDynamicObjectCollection("actgroupentity");
            break;
        }
        if (activityEntrys != null) {
            ArrayList<Map<String, Object>> activityGroupIns = new ArrayList<Map<String, Object>>(activityEntrys.size());
            for (DynamicObject activity : activityEntrys) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("activity", activity.get("groupactivity.id"));
                map.put("status", "1");
                map.put("activitytype", activity.get("activitytype"));
                activityGroupIns.add(map);
            }
            LOG.info("bizbill mateActivityGroup success : {}", (Object)groupEntryId);
            return activityGroupIns;
        }
        LOG.info("bizbill mateActivityGroup fail");
        return new ArrayList<Map<String, Object>>(0);
    }

    public Long generateActivityGroupIns(Long bizBillId, List<Map<String, Object>> activityGroupIns) {
        LOG.info("generateActivityGroupIns request : bizBillId : {},activityGroupIns : {}", (Object)bizBillId, activityGroupIns);
        DynamicObject dynamicObject = ActivityGroupInsServiceHelper.getInstance().queryActivityGroupInsById(bizBillId);
        dynamicObject = dynamicObject == null ? ActivityGroupInsServiceHelper.getInstance().saveActivityGroupIns(bizBillId, activityGroupIns) : ActivityGroupInsServiceHelper.getInstance().updateActivityGroupIns(bizBillId, activityGroupIns);
        Long activityGroupInsId = dynamicObject.getLong("id");
        LOG.info("generateActivityGroupIns response : activityGroupInsId : {}", (Object)activityGroupInsId);
        return activityGroupInsId;
    }

    public Long generateActivityGroupIns(Long bizBillId, Long sechemeId, DynamicObject data) {
        List<Map<String, Object>> activityGroupIns = this.mateActivityGroup(sechemeId, data);
        if (activityGroupIns == null || activityGroupIns.isEmpty()) {
            return 0L;
        }
        return this.generateActivityGroupIns(bizBillId, activityGroupIns);
    }

    public Long updateActivityGroupIns(Long bizBillId, List<Map<String, Object>> activityGroupIns) {
        LOG.info("updateActivityGroupIns request : bizBillId : {},activityGroupIns : {}", (Object)bizBillId, activityGroupIns);
        DynamicObject dynamicObject = ActivityGroupInsServiceHelper.getInstance().updateActivityGroupIns(bizBillId, activityGroupIns);
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    public int deleteActivityGroupInsById(Long bizBillId) {
        LOG.info("deleteActivityGroupInsById request : bizBillId : {}", (Object)bizBillId);
        return ActivityGroupInsServiceHelper.getInstance().deleteActivityGroupInsById(bizBillId);
    }

    public int deleteActivityGroupInsByIds(List<Long> bizBillIds) {
        LOG.info("deleteActivityGroupInsByIds request : bizBillIds : {}", bizBillIds);
        return ActivityGroupInsServiceHelper.getInstance().deleteActivityGroupInsByIds(bizBillIds);
    }

    public DynamicObject queryActivityGroupInsById(Long bizBillId) {
        return ActivityGroupInsServiceHelper.getInstance().queryActivityGroupInsById(bizBillId);
    }

    public DynamicObject[] queryActivityGroupInsByIds(List<Long> bizBillIds) {
        return ActivityGroupInsServiceHelper.getInstance().queryActivityGroupInsByIds(bizBillIds);
    }
}

