/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.mservice.HRCSActivityTargetService;
import kd.hr.hrcs.mservice.api.IHRCSActivityService;

public class HRCSActivityService
extends HRCSActivityTargetService
implements IHRCSActivityService {
    private static final Log LOGGER = LogFactory.getLog(HRCSActivityService.class);
    private static final HRCSActivityService INSTANCE = new HRCSActivityService();
    private static final String EXCEPTION_TYPE_NOTIFY = "2";
    private static final String EXCEPTION_TYPE_SEND_MQ = "2";
    private static final String EXCEPTION_TYPE_INVOKE_MP = "3";
    private static final String EXCEPTION_TYPE_INVOKE_WF = "4";
    private static final String EXCEPTION_TYPE_UPDATE_STATUS = "5";

    public static IHRCSActivityService getInstance() {
        return INSTANCE;
    }

    private DynamicObject saveException(Long userId, Long activityInsId, String exceptionStackMessage, boolean save) {
        LOGGER.info("OperationContext is {}", (Object)OperationContext.get());
        OperationContext operationContext = OperationContext.get();
        if (null != operationContext && HRStringUtils.equals((String)"hrcs_activity", (String)operationContext.getAppId())) {
            throw new RuntimeException();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityexception");
        DynamicObject exceptionItem = serviceHelper.generateEmptyDynamicObject();
        exceptionItem.set("creator", (Object)(null == userId ? Long.valueOf(RequestContext.get().getCurrUserId()) : userId));
        exceptionItem.set("createtime", (Object)new Date());
        exceptionItem.set("activityins", (Object)activityInsId);
        exceptionItem.set("exceptiontype", (Object)EXCEPTION_TYPE_INVOKE_MP);
        exceptionItem.set("exceptionstackmessage", (Object)exceptionStackMessage);
        exceptionItem.set("result", (Object)"0");
        if (save) {
            serviceHelper.saveOne(exceptionItem);
        }
        return exceptionItem;
    }

    private DynamicObject saveException(Long userId, Long activityInsId, String exceptionStackMessage, boolean save, String exceptionType) {
        LOGGER.info("OperationContext is {}", (Object)OperationContext.get());
        OperationContext operationContext = OperationContext.get();
        if (null != operationContext && HRStringUtils.equals((String)"hrcs_activity", (String)operationContext.getAppId())) {
            throw new RuntimeException();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityexception");
        DynamicObject exceptionItem = serviceHelper.generateEmptyDynamicObject();
        exceptionItem.set("creator", (Object)(null == userId ? Long.valueOf(RequestContext.get().getCurrUserId()) : userId));
        exceptionItem.set("createtime", (Object)new Date());
        exceptionItem.set("activityins", (Object)activityInsId);
        exceptionItem.set("exceptiontype", (Object)exceptionType);
        exceptionItem.set("exceptionstackmessage", (Object)exceptionStackMessage);
        exceptionItem.set("result", (Object)"0");
        if (save) {
            serviceHelper.saveOne(exceptionItem);
        }
        return exceptionItem;
    }

    private DynamicObject[] saveExceptions(List<DynamicObject> items) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityexception");
        DynamicObject[] save = (DynamicObject[])serviceHelper.save(items.toArray(new DynamicObject[0]));
        return save;
    }

    private String getExceptionStackMessage(Exception exception) {
        String traceId = RequestContext.get().getTraceId();
        String exceptionMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        return "TraceId: " + traceId + "\r\n" + exceptionMessage;
    }

    private DynamicObject[] processOperationResult(Long userId, OperationResult operationResult) {
        List<DynamicObject> items = operationResult.getAllErrorInfo().stream().map(it -> this.saveException(userId, (Long)it.getPkValue(), it.getErrorCode(), false)).collect(Collectors.toList());
        DynamicObject[] longs = this.saveExceptions(items);
        return longs;
    }

    private OperationResult processIfHasException(Supplier<OperationResult> supplier, Long userId, Long activityInsId) {
        try {
            OperationResult operationResult = supplier.get();
            this.processOperationResult(userId, operationResult);
            return operationResult;
        }
        catch (Exception exception) {
            if (null != activityInsId) {
                this.saveException(userId, activityInsId, this.getExceptionStackMessage(exception), true);
            }
            throw exception;
        }
    }

    private OperationResult processIfHasException1(Supplier<OperationResult> supplier, Long userId, Long activityInsId, Object[] param) {
        LOGGER.info("OperationContext is {}", (Object)OperationContext.get());
        try {
            OperationResult operationResult = supplier.get();
            DynamicObject[] longs = this.processOperationResult(userId, operationResult);
            this.saveActivityErrParam(param, longs);
            return operationResult;
        }
        catch (KDException exception) {
            LOGGER.info("OperationContext is {}", (Object)OperationContext.get());
            OperationContext operationContext = OperationContext.get();
            if (null != operationContext && HRStringUtils.equals((String)"hrcs_activity", (String)operationContext.getAppId())) {
                LOGGER.error("RuntimeException:", (Throwable)new RuntimeException("RuntimeException"));
            } else if ("2".equals(exception.getErrorCode().getCode())) {
                DynamicObject exceptionDy = this.saveException(userId, activityInsId, this.getExceptionStackMessage((Exception)((Object)exception)), true, "2");
                this.saveActivityErrParam(param, new DynamicObject[]{exceptionDy});
                LOGGER.error(ResManager.loadKDString((String)"\u53d1\u9001MQ\u5931\u8d25", (String)"HRCSActivityWorkflowService_6", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), (Throwable)exception);
            } else if (EXCEPTION_TYPE_INVOKE_WF.equals(exception.getErrorCode().getCode())) {
                DynamicObject exceptionDy = this.saveException(userId, activityInsId, this.getExceptionStackMessage((Exception)((Object)exception)), true, EXCEPTION_TYPE_INVOKE_WF);
                this.saveActivityErrParam(param, new DynamicObject[]{exceptionDy});
                LOGGER.error(ResManager.loadKDString((String)"\u4e2d\u53f0\u8c03\u7528\u5de5\u4f5c\u6d41\u5931\u8d25", (String)"HRCSActivityWorkflowService_10", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), (Throwable)exception);
            } else if (EXCEPTION_TYPE_UPDATE_STATUS.equals(exception.getErrorCode().getCode())) {
                DynamicObject exceptionDy = this.saveException(userId, activityInsId, this.getExceptionStackMessage((Exception)((Object)exception)), true, EXCEPTION_TYPE_UPDATE_STATUS);
                this.saveActivityErrParam(param, new DynamicObject[]{exceptionDy});
                LOGGER.error(ResManager.loadKDString((String)"\u4e2d\u53f0\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25", (String)"HRCSActivityWorkflowService_8", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), (Throwable)exception);
            } else if ("2".equals(exception.getErrorCode().getCode())) {
                DynamicObject exceptionDy = this.saveException(userId, activityInsId, this.getExceptionStackMessage((Exception)((Object)exception)), true, "2");
                this.saveActivityErrParam(param, new DynamicObject[]{exceptionDy});
                LOGGER.error(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u56de\u8c03\u4e2d\u53f0\u5931\u8d25", (String)"HRCSActivityWorkflowService_9", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), (Throwable)exception);
            } else {
                DynamicObject exceptionDy = this.saveException(userId, activityInsId, this.getExceptionStackMessage((Exception)((Object)exception)), true, EXCEPTION_TYPE_INVOKE_MP);
                this.saveActivityErrParam(param, new DynamicObject[]{exceptionDy});
                LOGGER.error(ResManager.loadKDString((String)"\u4e1a\u52a1\u65b9\u8c03\u7528HR\u4e1a\u52a1\u5e73\u53f0\u5931\u8d25\u3002", (String)"HRCSActivityWorkflowService_7", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), (Throwable)exception);
            }
        }
        catch (Exception exception) {
            DynamicObject exceptionDy = this.saveException(userId, activityInsId, this.getExceptionStackMessage(exception), true);
            this.saveActivityErrParam(param, new DynamicObject[]{exceptionDy});
            LOGGER.error("Exception:", (Throwable)exception);
        }
        LOGGER.info("processIfHasException1 false.");
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(Boolean.FALSE.booleanValue());
        return operationResult;
    }

    private void saveActivityErrParam(Object[] param, DynamicObject[] ids) {
        Arrays.stream(ids).forEach(id -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_activityerrparam");
            DynamicObject emptyDynamicObject = helper.generateEmptyDynamicObject();
            emptyDynamicObject.set("param", (Object)SerializationUtils.toJsonString((Object)param));
            emptyDynamicObject.set("exceptionid", (Object)id.getLong("id"));
            helper.saveOne(emptyDynamicObject);
        });
    }

    @Override
    public OperationResult transferTask(Long activityInsId, Long newHandlerId, String auditMessage) {
        Object[] params = new Object[]{"transferTask", activityInsId, newHandlerId, auditMessage};
        return this.processIfHasException1(() -> super.transferTask(activityInsId, newHandlerId, auditMessage), null, activityInsId, params);
    }

    @Override
    public OperationResult rejectTask(Long activityInsId, String auditMessage) {
        Object[] params = new Object[]{"rejectTask", activityInsId, auditMessage};
        return this.processIfHasException1(() -> super.rejectTask(activityInsId, auditMessage), null, activityInsId, params);
    }

    @Override
    public OperationResult rejectTask(Long activityInsId, Long userId, String auditMessage) {
        Object[] params = new Object[]{"rejectTask", activityInsId, userId, auditMessage};
        return this.processIfHasException1(() -> super.rejectTask(activityInsId, userId, auditMessage), userId, activityInsId, params);
    }

    @Override
    public OperationResult rejectTask(Long activityInsId, Long userId, String auditMessage, boolean rejectBackToNode) {
        Object[] params = new Object[]{"rejectTask", activityInsId, userId, auditMessage};
        return this.processIfHasException1(() -> super.rejectTask(activityInsId, userId, auditMessage, rejectBackToNode), userId, activityInsId, params);
    }

    @Override
    public OperationResult consentTask(Long activityInsId, String auditMessage) {
        Object[] params = new Object[]{"consentTask", activityInsId, auditMessage};
        return this.processIfHasException1(() -> super.consentTask(activityInsId, auditMessage), null, activityInsId, params);
    }

    @Override
    public OperationResult consentTask(Long activityInsId, Long userId, String auditMessage) {
        Object[] params = new Object[]{"consentTask", activityInsId, userId, auditMessage};
        return this.processIfHasException1(() -> super.consentTask(activityInsId, userId, auditMessage), userId, activityInsId, params);
    }

    @Override
    public OperationResult terminateTask(Long activityInsId, String auditMessage) {
        Object[] params = new Object[]{"terminateTask", activityInsId, auditMessage};
        return this.processIfHasException1(() -> super.terminateTask(activityInsId, auditMessage), null, activityInsId, params);
    }

    @Override
    public OperationResult terminateTask(Long activityInsId, Long userId, String auditMessage) {
        Object[] params = new Object[]{"terminateTask", activityInsId, userId, auditMessage};
        return this.processIfHasException1(() -> super.terminateTask(activityInsId, userId, auditMessage), userId, activityInsId, params);
    }

    @Override
    public OperationResult assignTask(Long activityInsId, List<Long> newHandlerId, String auditMessage) {
        Object[] params = new Object[]{"assignTask", activityInsId, newHandlerId, auditMessage};
        return this.processIfHasException1(() -> super.assignTask(activityInsId, newHandlerId, auditMessage), null, activityInsId, params);
    }

    @Override
    public void updateTaskBindBillInfo(Long taskId, Object bindBizBillId, String bindBizNum) {
        try {
            super.updateTaskBindBillInfo(taskId, bindBizBillId, bindBizNum);
        }
        catch (Exception exception) {
            DynamicObject dynamicObject = this.saveException(null, taskId, this.getExceptionStackMessage(exception), true);
            Object[] params = new Object[]{"updateTaskBindBillInfo", taskId, bindBizBillId, bindBizNum};
            this.saveActivityErrParam(params, new DynamicObject[]{dynamicObject});
            throw exception;
        }
    }

    @Override
    public OperationResult batchConsentTask(List<Long> taskIdList, String auditMessage) {
        Object[] params = new Object[]{"batchConsentTask", taskIdList, auditMessage};
        return this.processIfHasException1(() -> super.batchConsentTask(taskIdList, auditMessage), null, null, params);
    }

    @Override
    public OperationResult batchConsentTask(List<Long> taskIdList, Long userId, String auditMessage) {
        Object[] params = new Object[]{"batchConsentTask", taskIdList, userId, auditMessage};
        return this.processIfHasException1(() -> super.batchConsentTask(taskIdList, userId, auditMessage), userId, null, params);
    }

    @Override
    public OperationResult batchRejectTask(List<Long> taskIdList, String auditMessage) {
        Object[] params = new Object[]{"batchConsentTask", taskIdList, auditMessage};
        return this.processIfHasException1(() -> super.batchRejectTask(taskIdList, auditMessage), null, null, params);
    }

    @Override
    public OperationResult batchRejectTask(List<Long> taskIdList, Long userId, String auditMessage) {
        Object[] params = new Object[]{"batchConsentTask", taskIdList, userId, auditMessage};
        return this.processIfHasException1(() -> super.batchRejectTask(taskIdList, userId, auditMessage), userId, null, params);
    }

    @Override
    public OperationResult batchTerminateTask(List<Long> taskIdList, String auditMessage) {
        Object[] params = new Object[]{"batchConsentTask", taskIdList, auditMessage};
        return this.processIfHasException1(() -> super.batchTerminateTask(taskIdList, auditMessage), null, null, params);
    }

    @Override
    public OperationResult batchTerminateTask(List<Long> taskIdList, Long userId, String auditMessage) {
        Object[] params = new Object[]{"batchConsentTask", taskIdList, userId, auditMessage};
        return this.processIfHasException1(() -> super.batchTerminateTask(taskIdList, userId, auditMessage), userId, null, params);
    }

    @Override
    public OperationResult batchAssignTask(List<Long> taskIdList, List<Long> destHandlerIdList, String auditMessage) {
        Object[] params = new Object[]{"batchAssignTask", taskIdList, destHandlerIdList, auditMessage};
        return this.processIfHasException1(() -> super.batchAssignTask(taskIdList, destHandlerIdList, auditMessage), null, null, params);
    }

    @Override
    public OperationResult batchTransferTask(List<Long> taskIdList, Long destHandlerIdList, String auditMessage) {
        Object[] params = new Object[]{"batchTransferTask", taskIdList, destHandlerIdList, auditMessage};
        return this.processIfHasException1(() -> super.batchTransferTask(taskIdList, destHandlerIdList, auditMessage), null, null, params);
    }

    @Override
    public OperationResult batchRevocation(List<String> bizBillIds, Long userId) {
        Object[] params = new Object[]{"revocation", bizBillIds, userId};
        return this.processIfHasException1(() -> super.batchRevocation(bizBillIds, userId), userId, null, params);
    }

    @Override
    public OperationResult rejectToNode(Long taskId, Long userId, String auditMessage, String nextNodeId, boolean rejectBackToNode) {
        Object[] params = new Object[]{"rejectToInnerNode", taskId, userId, auditMessage, nextNodeId};
        return this.processIfHasException1(() -> super.rejectToNode(taskId, userId, auditMessage, nextNodeId, rejectBackToNode), userId, null, params);
    }

    @Override
    public DynamicObject beforeInvoke(HashMap<String, Object> param) {
        return super.beforeInvoke(param);
    }

    @Override
    public DynamicObject afterInvoke(HashMap<String, Object> param) {
        return super.afterInvoke(param);
    }

    @Override
    public Map<String, Object> sscNotify(Map<String, Object> paramMap) {
        return super.sscNotify(paramMap);
    }
}

