/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCustomParam;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityInsBatchOperateHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityInsOPRecServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityInsServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;
import kd.hr.hrcs.mservice.AbstractActivityService;
import kd.hr.hrcs.mservice.api.IHRCSActivityService;
import kd.hr.hrcs.mservice.enums.NotifyEventTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class HRCSActivityTargetService
extends AbstractActivityService
implements IHRCSActivityService {
    private static final Log LOGGER = LogFactory.getLog(HRCSActivityTargetService.class);
    private static final String ACTIVITY_TYPE = "HRActivity";
    private static final String SUCCESS = "success";
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_MSG = "errorMsg";
    private static final String DATA = "data";
    private static final String ERROR_CODE_WF_NOT_FOUND = "HRCSActivityTargetService_1";
    private static final String ERROR_CODE_SCHEME_NOT_FOUND = "HRCSActivityTargetService_2";
    private static final String ERROR_CODE_ACTIVITY_NOT_FOUND = "HRCSActivityTargetService_3";

    @Override
    Log getLogger() {
        return LOGGER;
    }

    public OperationResult generateActivityTask(Long bizBillCreatorId, String bizBillId, String bizNum, String bizKey, String bindBizBillId, String bindBizNum, String bindBizKey, String bindinglayoutid, Long wfProDefId, Long wfProInsId, Long wfCurTaskId, String activitySchemeNumber, String activitySchemeVersion, Long activityId, Long[] wfNodeParticipantIds) {
        LOGGER.info("Enter generateActivityTask.");
        return ActivityInsServiceHelper.generateActivityTask((String)"", (Long)bizBillCreatorId, (String)bizBillId, (String)bizNum, (String)bizKey, (String)bindBizBillId, (String)bindBizNum, (String)bindBizKey, (String)bindinglayoutid, (Long)wfProDefId, (Long)wfProInsId, (Long)wfCurTaskId, (String)activitySchemeNumber, (String)activitySchemeVersion, (Long)activityId, (Long[])wfNodeParticipantIds);
    }

    public OperationResult generateActivityTask(DynamicObject dyObj, Long[] wfNodeParticipantIds) {
        LOGGER.info("Enter generateActivityTask2.");
        Long bizBillCreatorId = dyObj.getLong("applier");
        String bizBillId = dyObj.getString("bizbillid");
        String bizNum = dyObj.getString("biznum");
        String bizKey = dyObj.getString("bizkey");
        Long wfProDefId = dyObj.getLong("wfprocessdefinitionid");
        Long wfProInsId = dyObj.getLong("wfprocessinsid");
        Long wfCurTaskId = dyObj.getLong("wfcurtaskid");
        String actSchemeNumber = dyObj.getString("schemenumber");
        Long activityId = dyObj.getLong("activity");
        String actSchemeVersion = dyObj.getString("schemeversion");
        String bindBizBillId = dyObj.getString("bindbizbillid");
        String bindBizNum = dyObj.getString("bindbiznum");
        String bindBizKey = dyObj.getString("bindbizkey");
        String bindinglayoutid = dyObj.getString("bindinglayoutid");
        return this.generateActivityTask(bizBillCreatorId, bizBillId, bizNum, bizKey, bindBizBillId, bindBizNum, bindBizKey, bindinglayoutid, wfProDefId, wfProInsId, wfCurTaskId, actSchemeNumber, actSchemeVersion, activityId, wfNodeParticipantIds);
    }

    public DynamicObjectCollection getActivityTasksByUser(Long userId) {
        LOGGER.info("Enter getActivityTasksByUser.");
        return ActivityInsServiceHelper.getActivityTasksByUser((Long)userId);
    }

    public DynamicObjectCollection getActivityTasks(String selectProperties, QFilter filters) {
        LOGGER.info("Enter getActivityTasks.");
        return ActivityInsServiceHelper.getActivityTasks((String)selectProperties, (QFilter)filters);
    }

    public DynamicObjectCollection getActivityTasks(String selectProperties, String bizKey, Long userID, boolean isQueryAll) {
        LOGGER.info("Enter getActivityTasks2.");
        return ActivityInsServiceHelper.getActivityTasks((String)selectProperties, (String)bizKey, (Long)userID, (boolean)isQueryAll);
    }

    public DynamicObjectCollection getActivityTasks(String selectProperties, String bizKey, String bindBizKey, Long userID, boolean isQueryAll) {
        LOGGER.info("Enter getActivityTasks3.");
        return ActivityInsServiceHelper.getActivityTasks((String)selectProperties, (String)bizKey, (String)bindBizKey, (Long)userID, (boolean)isQueryAll);
    }

    public DynamicObject getLatestActivityTask(Object bizBillId, Long activityId) {
        LOGGER.info("Enter getLatestActivityTask.");
        return ActivityInsServiceHelper.getLatestActivityTask((Object)bizBillId, (Long)activityId);
    }

    public OperationResult transferTask(Long activityInsId, Long newHandlerId, String auditMessage) {
        LOGGER.info("Enter transferTask.");
        return ActivityInsServiceHelper.transferTask((Long)activityInsId, (Long)newHandlerId, (String)auditMessage);
    }

    public OperationResult rejectTask(Long activityInsId, String auditMessage) {
        LOGGER.info("Enter rejectTask.");
        return ActivityInsServiceHelper.reject((Long)activityInsId, null, (String)auditMessage);
    }

    public OperationResult rejectTask(Long activityInsId, Long userId, String auditMessage) {
        LOGGER.info("Enter rejectTask.");
        return ActivityInsServiceHelper.reject((Long)activityInsId, (Long)userId, (String)auditMessage);
    }

    public OperationResult rejectTask(Long activityInsId, Long userId, String auditMessage, boolean rejectBackToNode) {
        LOGGER.info("Enter rejectTask.");
        return ActivityInsServiceHelper.reject((Long)activityInsId, (Long)userId, (String)auditMessage, (boolean)rejectBackToNode);
    }

    public OperationResult consentTask(Long activityInsId, String auditMessage) {
        LOGGER.info("Enter consentTask.");
        return ActivityInsServiceHelper.consent((Long)activityInsId, null, (String)auditMessage);
    }

    public OperationResult consentTask(Long activityInsId, Long userId, String auditMessage) {
        LOGGER.info("Enter consentTask.");
        return ActivityInsServiceHelper.consent((Long)activityInsId, (Long)userId, (String)auditMessage);
    }

    public OperationResult terminateTask(Long activityInsId, String auditMessage) {
        LOGGER.info("Enter terminateTask.");
        return ActivityInsServiceHelper.terminate((Long)activityInsId, null, (String)auditMessage);
    }

    public OperationResult terminateTask(Long activityInsId, Long userId, String auditMessage) {
        LOGGER.info("Enter terminateTask.");
        return ActivityInsServiceHelper.terminate((Long)activityInsId, (Long)userId, (String)auditMessage);
    }

    public boolean isCurrentHandler(Long activityInsId) {
        LOGGER.info("Enter isCurrentHandler.");
        if (activityInsId == null) {
            return false;
        }
        DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById((String)"handlers,taskstatus", (Long)activityInsId);
        if (taskInsInfo == null) {
            return false;
        }
        return ActivityInsServiceHelper.validateCanHandleByCurUser((DynamicObject)taskInsInfo);
    }

    public boolean isCurrentHandler(Long activityInsId, Long userId) {
        LOGGER.info("Enter isCurrentHandler2.");
        if (userId == null || activityInsId == null) {
            return false;
        }
        DynamicObject taskInsInfo = ActivityInsServiceHelper.getActivityInsById((String)"handlers,taskstatus", (Long)activityInsId);
        if (taskInsInfo == null) {
            return false;
        }
        DynamicObjectCollection handlerColl = taskInsInfo.getDynamicObjectCollection("handlers");
        for (DynamicObject dynamicObject : handlerColl) {
            Long dbHandlerId = (Long)((DynamicObject)dynamicObject.get("fbasedataid")).getPkValue();
            if (userId.compareTo(dbHandlerId) != 0) continue;
            return true;
        }
        return false;
    }

    public DynamicObject getActivitySchemeByNumberAndVersion(String selectProperties, String number, String version) {
        LOGGER.info("Enter getActivitySchemeByNumberAndVersion.");
        return ActivitySchemeServiceHelper.getByNumberAndVersion((String)selectProperties, (String)number, (String)version);
    }

    public DynamicObject getActivitySchemeByID(String selectProperties, Long schemeID) {
        LOGGER.info("Enter getActivitySchemeByID.");
        return ActivitySchemeServiceHelper.getByID((String)selectProperties, (Long)schemeID);
    }

    public DynamicObject getActivitySchemeByNumberAndVersion(String number, String version) {
        LOGGER.info("Enter getActivitySchemeByNumberAndVersion2.");
        return this.getActivitySchemeByNumberAndVersion("actschemeentry.activity", number, version);
    }

    public DynamicObject getLatestActivitySchemeByNumber(String selectProperties, String number) {
        LOGGER.info("Enter getLatestActivitySchemeByNumber.");
        return ActivitySchemeServiceHelper.getLatestByNumber((String)selectProperties, (String)number);
    }

    public DynamicObject getLatestActivitySchemeByNumber(String number) {
        LOGGER.info("Enter getLatestActivitySchemeByNumber2.");
        return this.getLatestActivitySchemeByNumber("actschemeentry.activity", number);
    }

    public List<DynamicObject> getActivitySchemeDomainParams(Long activitySchemeId, Long activityId) {
        LOGGER.info("Enter getActivitySchemeDomainParams.");
        return ActivitySchemeServiceHelper.getDomainParamByIdAndActivityId((Long)activitySchemeId, (Long)activityId);
    }

    public OperationResult assignTask(Long activityInsId, List<Long> newHandlerId, String auditMessage) {
        LOGGER.info("Enter assignTask.");
        return ActivityInsServiceHelper.assignTask((Long)activityInsId, newHandlerId, (String)auditMessage);
    }

    public void updateTaskBindBillInfo(Long taskId, Object bindBizBillId, String bindBizNum) {
        LOGGER.info("Enter updateTaskBindBillInfo.");
        Pair<String, Long> taskInfo = this.saveTask(taskId, null, bindBizBillId, bindBizNum);
        ActivityInsServiceHelper.updateTaskBindBillInfo((Long)taskId, null, (Object)bindBizBillId, (String)bindBizNum, (String)((String)taskInfo.getKey()), (Long)((Long)taskInfo.getValue()));
    }

    public DynamicObject getActivitySchemeByBindBizBillId(Object bindBizBillId) {
        LOGGER.info("Enter getActivitySchemeByBindBizBillId.");
        return ActivityInsServiceHelper.getActivitySchemeByBindBizBillId((Object)bindBizBillId);
    }

    public OperationResult batchConsentTask(List<Long> taskIdList, String auditMessage) {
        LOGGER.info("Enter batchConsentTask.");
        return ActivityInsBatchOperateHelper.batchConsentTask(taskIdList, null, (String)auditMessage);
    }

    public OperationResult batchConsentTask(List<Long> taskIdList, Long userId, String auditMessage) {
        LOGGER.info("Enter batchConsentTask.");
        return ActivityInsBatchOperateHelper.batchConsentTask(taskIdList, (Long)userId, (String)auditMessage);
    }

    public OperationResult batchRejectTask(List<Long> taskIdList, String auditMessage) {
        LOGGER.info("Enter batchRejectTask.");
        return ActivityInsBatchOperateHelper.batchRejectTask(taskIdList, null, (String)auditMessage);
    }

    public OperationResult batchRejectTask(List<Long> taskIdList, Long userId, String auditMessage) {
        LOGGER.info("Enter batchRejectTask.");
        return ActivityInsBatchOperateHelper.batchRejectTask(taskIdList, (Long)userId, (String)auditMessage);
    }

    public OperationResult batchTerminateTask(List<Long> taskIdList, String auditMessage) {
        LOGGER.info("Enter batchTerminateTask.");
        long start = System.currentTimeMillis();
        OperationResult result = ActivityInsBatchOperateHelper.batchTerminateTask(taskIdList, null, (String)auditMessage);
        long end = System.currentTimeMillis();
        LOGGER.info("batchTerminateTask task coast: {}.", (Object)(end - start));
        return result;
    }

    public OperationResult batchTerminateTask(List<Long> taskIdList, Long userId, String auditMessage) {
        LOGGER.info("Enter batchTerminateTask.");
        long start = System.currentTimeMillis();
        OperationResult result = ActivityInsBatchOperateHelper.batchTerminateTask(taskIdList, (Long)userId, (String)auditMessage);
        long end = System.currentTimeMillis();
        LOGGER.info("batchTerminateTask task coast: {}.", (Object)(end - start));
        return result;
    }

    public OperationResult batchAssignTask(List<Long> taskIdList, List<Long> destHandlerIdList, String auditMessage) {
        LOGGER.info("Enter batchAssignTask.");
        return ActivityInsBatchOperateHelper.batchAssignTask(taskIdList, destHandlerIdList, (String)auditMessage);
    }

    public OperationResult batchTransferTask(List<Long> taskIdList, Long destHandlerIdList, String auditMessage) {
        LOGGER.info("Enter batchTransferTask.");
        return ActivityInsBatchOperateHelper.batchTransferTask(taskIdList, (Long)destHandlerIdList, (String)auditMessage);
    }

    public Pair<String, String> getSchemeFromWorkflow(DynamicObject bill) {
        AtomicReference scheme = new AtomicReference();
        WFProcess process = WorkflowServiceHelper.getProcessInfo((DynamicObject)bill, (String)"submit");
        if (null != process) {
            LOGGER.info("Got process[name:[{}], entraBillName:[{}], entraBill:[{}], entraBillId:[{}], processType:[{}] ] from workflow.", new Object[]{process.getName(), process.getEntraBillName(), process.getEntraBill(), process.getEntraBillId(), process.getProcessType()});
            if (null != process) {
                process.getVariables().stream().filter(it -> {
                    LOGGER.info("Got process variable: [name:[{}], description:[{}], type:[{}], defaultValue:[{}]].", new Object[]{it.getName(), it.getDescription(), it.getType(), it.getDefaultValue()});
                    return it.getName().equalsIgnoreCase("hr_scheme");
                }).findFirst().ifPresent(it -> {
                    LOGGER.info("Got process default value: [{}].", (Object)it.getDefaultValue());
                    String[] schemeInfos = it.getDefaultValue().toString().split("\\$\\$");
                    scheme.set(Pair.of((Object)schemeInfos[0], (Object)schemeInfos[1]));
                });
            }
        } else {
            LOGGER.info("Can not find process by bill[{}].", bill.getPkValue());
        }
        return (Pair)scheme.get();
    }

    public DynamicObject getByNumberAndVersionAndActivityId(String selectProperties, String number, String version, Long activityId) {
        LOGGER.info("Enter getByNumberAndVersionAndActivityId.");
        return ActivitySchemeServiceHelper.getByNumberAndVersionAndActivityId((String)selectProperties, (String)number, (String)version, (Long)activityId);
    }

    public DynamicObjectCollection getActivityInsOPRecByInsId(Long actInsId) {
        LOGGER.info("Enter getActivityInsOPRecByInsId.");
        return ActivityInsOPRecServiceHelper.getActivityInsOPRecByInsId((Long)actInsId);
    }

    public DynamicObjectCollection getActivityInsOPRecColl(String selectProperties, QFilter filters, String orderBy, int top) {
        LOGGER.info("Enter getActivityInsOPRecColl.");
        return ActivityInsOPRecServiceHelper.getActivityInsOPRecColl((String)selectProperties, (QFilter)filters, (String)orderBy, (int)top);
    }

    public DynamicObject[] getActivityInsOPRecArr(String selectProperties, QFilter filters, String orderBy, int top) {
        LOGGER.info("Enter getActivityInsOPRecArr.");
        return ActivityInsOPRecServiceHelper.getActivityInsOPRecArr((String)selectProperties, (QFilter)filters, (String)orderBy, (int)top);
    }

    public List<Long> getActivityInsOPRecIdsByInsId(Long actInsId) {
        LOGGER.info("Enter getActivityInsOPRecIdsByInsId.");
        return ActivityInsOPRecServiceHelper.getActivityInsOPRecIdsByInsId((Long)actInsId);
    }

    public DynamicObject[] getActivityInsByBizBillId(String selectProperties, String bizBillId) {
        LOGGER.info("Enter getActivityInsByBizBillId.");
        return ActivityInsServiceHelper.getActivityInsByBizId((String)selectProperties, (String)bizBillId);
    }

    public DynamicObject getActivityInsById(String selectProperties, Long actId) {
        LOGGER.info("Enter getActivityInsByBizBillId.");
        return ActivityInsServiceHelper.getActivityInsById((String)selectProperties, (Long)actId);
    }

    public Integer getFlowParam(Long actInsId) {
        LOGGER.info("Enter getFlowParam.");
        return ActivityInsServiceHelper.getFlowParam((Long)actInsId);
    }

    public Map<String, Object> getActivitySchemeFromWorkflow(DynamicObject bill, String selectProperties) {
        if (null == selectProperties) {
            selectProperties = "id";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        WFProcess process = WorkflowServiceHelper.getProcessInfo((DynamicObject)bill, (String)"submit");
        List elements = WorkflowServiceHelper.getProcessElements((DynamicObject)bill, (String)"submit");
        if (null == process || null == elements || elements.isEmpty()) {
            map.put(SUCCESS, false);
            map.put(ERROR_CODE, ERROR_CODE_WF_NOT_FOUND);
            map.put(ERROR_MSG, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u5339\u914d\u5230\u5de5\u4f5c\u6d41\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\u5e76\u68c0\u67e5\u5176\u542f\u52a8\u6761\u4ef6\u3002", (String)ERROR_CODE_WF_NOT_FOUND, (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
            return map;
        }
        Set activityIds = elements.stream().filter(it -> it.getType().equals(ACTIVITY_TYPE)).map(it -> Long.parseLong(((WFCustomParam)((WFAuditTask)it).getCustomParams().get(0)).getId())).collect(Collectors.toSet());
        String finalSelectProperties = selectProperties;
        DynamicObject lastScheme = process.getVariables().stream().filter(it -> "hr_scheme".equalsIgnoreCase(it.getName()) && it.getDefaultValue().toString().split("\\$\\$").length == 2).findFirst().map(it -> {
            String scheme = it.getDefaultValue().toString();
            String schemeNumber = scheme.split("\\$\\$")[0];
            String schemeVersion = scheme.split("\\$\\$")[1];
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_activityscheme");
            DynamicObject activityScheme = helper.queryOne(finalSelectProperties + ", actschemeentry.activity", new QFilter[]{new QFilter("number", "=", (Object)schemeNumber), new QFilter("version", "=", (Object)schemeVersion)});
            if (null == activityScheme) {
                return null;
            }
            activityScheme.getDynamicObjectCollection("actschemeentry").removeIf(entry -> !activityIds.contains(entry.getLong("activity.id")));
            return activityScheme;
        }).orElse(null);
        if (null == lastScheme) {
            map.put(SUCCESS, false);
            map.put(ERROR_CODE, ERROR_CODE_SCHEME_NOT_FOUND);
            map.put(ERROR_MSG, String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u5de5\u4f5c\u6d41\u201c%1$s\u201d\u4e2d\uff0c\u672a\u914d\u7f6e\u6d3b\u52a8\u65b9\u6848\uff0c\u8bf7\u6309\u8def\u5f84\u68c0\u67e5\uff1a\u5de5\u4f5c\u6d41\u670d\u52a1>\u8bbe\u8ba1\u4e2d\u5fc3>%2$s>\u6d41\u7a0b\u53d8\u91cf\u3002", (String)ERROR_CODE_SCHEME_NOT_FOUND, (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), process.getName().getLocaleValue(), process.getName().getLocaleValue()));
        } else if (lastScheme.getDynamicObjectCollection("actschemeentry").size() == 0) {
            map.put(SUCCESS, false);
            map.put(ERROR_CODE, ERROR_CODE_ACTIVITY_NOT_FOUND);
            map.put(ERROR_MSG, String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u6d3b\u52a8\u65b9\u6848\u201c%1$s\u201d\u4e2d\uff0c\u672a\u914d\u7f6e\u6d3b\u52a8\uff0c\u8bf7\u6309\u8def\u5f84\u68c0\u67e5\uff1aHR\u901a\u7528\u670d\u52a1>\u6d3b\u52a8\u7f16\u6392>\u6d3b\u52a8\u65b9\u6848\u3002\u8be5\u5355\u636e\u672a\u5339\u914d\u5230\u5de5\u4f5c\u6d41\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\u5e76\u68c0\u67e5\u5176\u542f\u52a8\u6761\u4ef6\u3002", (String)ERROR_CODE_ACTIVITY_NOT_FOUND, (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), process.getName().getLocaleValue()));
        } else {
            map.put(SUCCESS, true);
            map.put(DATA, lastScheme);
        }
        return map;
    }

    public OperationResult batchRevocation(List<String> bizBillIds, Long userId) {
        LOGGER.info("Enter revocation.");
        return this.revocation(bizBillIds, userId);
    }

    public OperationResult rejectToNode(Long activityInsId, Long userId, String auditMessage, String nextNodeId, boolean rejectBackToNode) {
        LOGGER.info("Enter rejectTask.");
        return ActivityInsServiceHelper.rejectToNode((Long)activityInsId, (Long)userId, (String)auditMessage, (String)nextNodeId, (boolean)rejectBackToNode);
    }

    public DynamicObject beforeInvoke(HashMap<String, Object> param) {
        DynamicObject businessObject = (DynamicObject)param.get("businessObject");
        businessObject.set("billno", (Object)"111111");
        return businessObject;
    }

    public DynamicObject afterInvoke(HashMap<String, Object> param) {
        DynamicObject businessObject = (DynamicObject)param.get("businessObject");
        String billno = businessObject.getString("billno");
        businessObject.set("billno", (Object)(billno + "222222"));
        return businessObject;
    }

    public Map<String, Object> sscNotify(Map<String, Object> paramMap) {
        this.getLogger().info("Got ssc notify with params: {}.", paramMap);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUCCESS, "true");
        result.put(DATA, new HashMap());
        try {
            NotifyEventTypeEnum eventTypeEnum = NotifyEventTypeEnum.fromValue((String)paramMap.get("eventType"));
            this.getLogger().info("Got event type enum: {}.", (Object)eventTypeEnum);
            switch (eventTypeEnum) {
                case RECYCLE: {
                    this.getLogger().info("SSC notify: recycle.");
                    Long sscTaskId = (Long)paramMap.get("taskId");
                    Long activityInsId = ActivityInsServiceHelper.getActivityInsIdBySSCTaskId((Long)sscTaskId);
                    ActivityInsServiceHelper.revert((Long)activityInsId);
                    break;
                }
                case AUTO_DIS: 
                case MANUAL_DIS: 
                case MANUAL_GET: {
                    this.getLogger().info("SSC notify: assignTask.");
                    Long sscTaskId = (Long)paramMap.get("taskId");
                    ArrayList newHandlers = Lists.newArrayList((Object[])new Long[]{(Long)paramMap.get("personId")});
                    Long activityInsId = ActivityInsServiceHelper.getActivityInsIdBySSCTaskId((Long)sscTaskId);
                    if (null != activityInsId && 0L != activityInsId) {
                        OperationResult operationResult = this.assignTask(activityInsId, newHandlers, ResManager.loadKDString((String)"\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\u5206\u914d", (String)"HRCSActivityTargetService_4", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
                        this.getLogger().info("Got assign task result: {} from ssc.", (Object)operationResult);
                        if (!operationResult.isSuccess()) {
                            result.put(SUCCESS, "false");
                            result.put(ERROR_CODE, "processCode");
                            result.put("msg", operationResult.getAllErrorInfo().stream().filter(Objects::nonNull).map(OperateInfo::getMessage).collect(Collectors.joining(";")));
                        }
                        break;
                    }
                    this.getLogger().info("Got empty activity ins id with ssc task id: {}.", (Object)sscTaskId);
                    break;
                }
                default: {
                    this.getLogger().info("Ignore with eventType: {}.", (Object)eventTypeEnum);
                }
            }
        }
        catch (Exception exception) {
            this.getLogger().error("Got error.", (Throwable)exception);
            result.put(SUCCESS, "false");
            result.put(ERROR_CODE, "exceptionCode");
            result.put("msg", exception.getMessage());
        }
        return result;
    }

    private OperationResult revocation(List<String> bizBillIds, Long userId) {
        OperationResult result = new OperationResult();
        if (userId == null) {
            userId = RequestContext.get().getCurrUserId();
        }
        for (String bizBillId : bizBillIds) {
            ActivityInsServiceHelper.revocation((String)bizBillId, (Long)userId, (String)"", (OperationResult)result);
        }
        if (result.getAllErrorInfo().size() > 0) {
            result.setSuccess(false);
        } else {
            result.setSuccess(true);
        }
        return result;
    }
}

