/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCustomParam;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityGroupInsServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivitySchemeServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.ActivityCommonUtil;
import kd.hr.hrcs.common.model.activity.ActivityWfQueryData;
import kd.hr.hrcs.common.model.activity.ActivityWfRecord;
import kd.hr.hrcs.common.model.activity.NodeInfo;
import kd.hr.hrcs.common.model.activity.ProcessSelectParam;
import kd.hr.hrcs.common.model.activity.WFGroupDecisionTypeEnum;
import kd.hr.hrcs.mservice.HRCSActivityTargetService;
import kd.hr.hrcs.mservice.api.IHRCSActivityWfQueryService;
import org.apache.commons.collections.MapUtils;

public class HRCSActivityWfQueryService
implements IHRCSActivityWfQueryService {
    private static final Log LOG = LogFactory.getLog(HRCSActivityWfQueryService.class);
    private static final String SUCCESS = "success";
    private static final String ERROR_MSG = "errorMsg";
    private static final String DATA = "data";
    private static final String PARENTNODES = "parentNodes";
    private static final String NODETYPE = "nodeType";
    private static final String ROWNUM = "rowNum";
    private static final String STATUSINFO = "statusInfo";
    private static final String BILLID = "billId";
    private static final String STATUS = "status";
    private static final String ENDNONEEVENT = "EndNoneEvent";
    private static final String MERGENODE = "mergeNode";
    private static final String MESSAGE = "message";
    private static final String RESULT = "result";
    private static final String TIME = "time";
    private static final String INCLUSIVEGATEWAY = "InclusiveGateway";
    private static final String USERTASK = "UserTask";

    public Map<String, Object> queryRuntimeActivityNode(DynamicObject bill) {
        LOG.info("input param bill:{}", (Object)bill);
        ActivityWfQueryData activityWfQueryData = this.completRuntimeParamByWf(bill);
        HRCSActivityTargetService ihrcsActivityService = new HRCSActivityTargetService();
        Map fromWorkflow = ihrcsActivityService.getActivitySchemeFromWorkflow(bill, "id,actschemeentry.activity,actinfo.actbizobj,actinfo.sla");
        boolean isSuccess = (Boolean)fromWorkflow.get(SUCCESS);
        if (!isSuccess) {
            return fromWorkflow;
        }
        long activitySchemeId = ((DynamicObject)fromWorkflow.get(DATA)).getLong("id");
        List<ProcessSelectParam> schemeParamList = this.fetchActivitySchemeParam(activitySchemeId);
        List<ProcessSelectParam> schemeProcessSelectParams = this.setParamDataByWf(schemeParamList, activityWfQueryData.getActivityAuditData(), activityWfQueryData.getWfActivityIdMap());
        List<Map> processSelectParams = this.mergeActivity(activityWfQueryData.getProcessSelectParams(), schemeProcessSelectParams);
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put(SUCCESS, Boolean.TRUE);
        result.put(DATA, processSelectParams);
        LOG.info("this method result\uff1a{}", (Object)result);
        return result;
    }

    private List<Map> mergeActivity(List<ProcessSelectParam> processSelectParams, List<ProcessSelectParam> schemeParamList) {
        LinkedList returnList = Lists.newLinkedList();
        Map<Long, ProcessSelectParam> memo = processSelectParams.stream().collect(Collectors.toMap(ProcessSelectParam::getActivityId, param -> param, (key, val) -> val));
        try {
            if (HRCollUtil.isEmpty(processSelectParams)) {
                for (ProcessSelectParam param2 : schemeParamList) {
                    param2.setIsExampleExist("0");
                    returnList.add(this.beanToMap(param2));
                }
            } else {
                for (ProcessSelectParam processSelectParam : schemeParamList) {
                    long activityId = processSelectParam.getActivityId();
                    ProcessSelectParam runtimeParam = memo.get(activityId);
                    if (null != runtimeParam) {
                        returnList.add(this.beanToMap(runtimeParam));
                        continue;
                    }
                    processSelectParam.setIsExampleExist("0");
                    returnList.add(this.beanToMap(processSelectParam));
                }
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException ex) {
            throw new KDBizException("mergeActivity javabean turn to map err");
        }
        return returnList;
    }

    private ActivityWfQueryData completRuntimeParamByWf(DynamicObject bill) {
        List processElements = WorkflowServiceHelper.getProcessElements((DynamicObject)bill, (String)"submit");
        List<ProcessSelectParam> paramByActivityGroupIns = this.getParamByActivityGroupIns(bill);
        Map<String, List<ActivityWfRecord>> auditIdData = this.getWFlowNodeData(bill);
        LOG.info("workflow data:{}", auditIdData);
        LinkedHashMap wfActivityIdMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        if (HRCollUtil.isNotEmpty((Collection)processElements)) {
            this.getActivityFromWf((WFFlowElement)processElements.get(0), wfActivityIdMap, auditIdData, false);
        }
        List<ProcessSelectParam> processSelectParams = this.setParamDataByWf(paramByActivityGroupIns, auditIdData, wfActivityIdMap);
        ActivityWfQueryData data = new ActivityWfQueryData();
        data.setActivityAuditData(auditIdData);
        data.setWfActivityIdMap((Map)wfActivityIdMap);
        data.setProcessSelectParams(processSelectParams);
        return data;
    }

    private List<ProcessSelectParam> setParamDataByWf(List<ProcessSelectParam> paramByActivityGroupIns, Map<String, List<ActivityWfRecord>> auditIdData, Map<String, String> wfActivityIdMap) {
        boolean isWait = ActivityCommonUtil.isWaitSubmit(auditIdData);
        Map<Long, ProcessSelectParam> processSelectParamMap = paramByActivityGroupIns.stream().collect(Collectors.toMap(ProcessSelectParam::getActivityId, param -> param, (key, val) -> val));
        LinkedList result = Lists.newLinkedList();
        List<ActivityWfRecord> waitRunningList = auditIdData.get(WFGroupDecisionTypeEnum.WILL_RUNNING.getType());
        for (Map.Entry<String, String> entry : wfActivityIdMap.entrySet()) {
            String activityId = entry.getKey();
            String wfId = entry.getValue();
            ProcessSelectParam processSelectParam = processSelectParamMap.get(Long.parseLong(activityId));
            if (null == processSelectParam) continue;
            processSelectParam.setIsProcessNode("1");
            if (isWait) {
                processSelectParam.setIsInNodeAfter("1");
                processSelectParam.setActivityStatus("2");
                result.add(processSelectParam);
                continue;
            }
            String groupDecisionType = null;
            for (Map.Entry<String, List<ActivityWfRecord>> entry2 : auditIdData.entrySet()) {
                groupDecisionType = entry2.getKey();
                List<ActivityWfRecord> queryWfIds = entry2.getValue();
                if (!ActivityCommonUtil.activityRecordContainWfId(queryWfIds, (String)wfId)) continue;
                processSelectParam.setActivityStatus(WFGroupDecisionTypeEnum.getStatusByType((String)groupDecisionType));
                break;
            }
            if (ActivityCommonUtil.activityRecordContainWfId(waitRunningList, (String)wfId)) {
                processSelectParam.setIsInNodeAfter("1");
                if (HRStringUtils.isEmpty((String)processSelectParam.getActivityStatus())) {
                    processSelectParam.setActivityStatus("2");
                }
            } else {
                processSelectParam.setIsInNodeAfter("0");
            }
            result.add(processSelectParam);
        }
        for (Map.Entry<Object, String> entry : processSelectParamMap.entrySet()) {
            ProcessSelectParam value = (ProcessSelectParam)entry.getValue();
            String isProcessNode = value.getIsProcessNode();
            if (!HRStringUtils.isEmpty((String)isProcessNode)) continue;
            value.setIsProcessNode("0");
            result.add(value);
        }
        return result;
    }

    private Map<String, List<ActivityWfRecord>> getWFlowNodeData(DynamicObject bill) {
        long billId = bill.getLong("id");
        String businessKey = String.valueOf(billId);
        HashMap groupDecisionTypeMap = Maps.newHashMapWithExpectedSize((int)4);
        groupDecisionTypeMap.put(WFGroupDecisionTypeEnum.APPROVE.getType(), Lists.newArrayListWithExpectedSize((int)10));
        groupDecisionTypeMap.put(WFGroupDecisionTypeEnum.WAIT.getType(), Lists.newArrayListWithExpectedSize((int)10));
        groupDecisionTypeMap.put(WFGroupDecisionTypeEnum.REJECT.getType(), Lists.newArrayListWithExpectedSize((int)10));
        groupDecisionTypeMap.put(WFGroupDecisionTypeEnum.TERMINATE.getType(), Lists.newArrayListWithExpectedSize((int)10));
        groupDecisionTypeMap.put(WFGroupDecisionTypeEnum.WILL_RUNNING.getType(), Lists.newArrayListWithExpectedSize((int)10));
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)businessKey);
        for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
            String groupDecisionType = approvalRecord.getGroupDecisionType();
            List activityWfRecords = (List)groupDecisionTypeMap.get(groupDecisionType);
            List children = approvalRecord.getChildren();
            if (null == activityWfRecords || !HRCollUtil.isNotEmpty((Collection)children)) continue;
            IApprovalRecordItem approvalRecordItem = (IApprovalRecordItem)children.get(0);
            ActivityWfRecord activityWfRecord = new ActivityWfRecord();
            activityWfRecord.setActivityId(approvalRecordItem.getActivityId());
            activityWfRecord.setMessage(approvalRecordItem.getMessage());
            activityWfRecord.setResult(approvalRecordItem.getResult());
            activityWfRecord.setInFormatTime(approvalRecordItem.getFormatTime() == null ? 0L : approvalRecordItem.getFormatTime());
            activityWfRecords.add(activityWfRecord);
        }
        return groupDecisionTypeMap;
    }

    private List<ProcessSelectParam> fetchActivitySchemeParam(long activitySchemeId) {
        DynamicObject[] activitySchemeList = ActivitySchemeServiceHelper.getEntryByActivitySchemeIds((List)Lists.newArrayList((Object[])new Long[]{activitySchemeId}));
        LinkedList processSelectParams = Lists.newLinkedList();
        for (DynamicObject scheme : activitySchemeList) {
            DynamicObjectCollection schemeEntry = scheme.getDynamicObjectCollection("actschemeentry");
            for (DynamicObject entry : schemeEntry) {
                DynamicObject activity = entry.getDynamicObject("activity");
                ProcessSelectParam processSelectParam = this.genParamBySchemeEntry(activity);
                processSelectParams.add(processSelectParam);
            }
        }
        return processSelectParams;
    }

    private List<ProcessSelectParam> getParamByActivityGroupIns(DynamicObject bill) {
        long billId = (Long)bill.getPkValue();
        DynamicObject runTimeActivity = ActivityGroupInsServiceHelper.getInstance().queryActivityGroupInsById(Long.valueOf(billId));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        if (HRObjectUtils.isEmpty((Object)runTimeActivity)) {
            LOG.warn("billid={}\uff0cquery activityGroupIns is empty", (Object)billId);
            return result;
        }
        DynamicObjectCollection entryEntity = runTimeActivity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            ProcessSelectParam processSelectParam = this.genParamByRuntimeEntry(entry);
            result.add(processSelectParam);
        }
        return result;
    }

    private void getActivityFromWf(WFFlowElement startElement, Map<String, String> wfActivityIdMap, Map<String, List<ActivityWfRecord>> auditIdData, boolean isInNodeAfter) {
        WFFlowNode wfFlowNode = (WFFlowNode)startElement;
        List nextNodes = wfFlowNode.getNextNodes();
        ArrayList<Boolean> nextNodesIsInNodeAfter = new ArrayList<Boolean>(Collections.nCopies(nextNodes.size(), isInNodeAfter));
        int index = 0;
        if (HRCollUtil.isNotEmpty((Collection)nextNodes)) {
            for (WFFlowNode nextNode : nextNodes) {
                if (ActivityCommonUtil.isWaitSubmit(auditIdData)) {
                    nextNodesIsInNodeAfter.set(index, true);
                }
                String wfId = nextNode.getId();
                String type = nextNode.getType();
                if (HRStringUtils.equals((String)type, (String)"HRActivity")) {
                    List<ActivityWfRecord> waitRunning;
                    List customParams = nextNode.getCustomParams();
                    List<ActivityWfRecord> waitTypeIds = auditIdData.get(WFGroupDecisionTypeEnum.WAIT.getType());
                    if (ActivityCommonUtil.activityRecordContainWfId(waitTypeIds, (String)wfId)) {
                        nextNodesIsInNodeAfter.set(index, true);
                    }
                    if (((Boolean)nextNodesIsInNodeAfter.get(index)).booleanValue() && !ActivityCommonUtil.activityRecordContainWfId(waitTypeIds, (String)wfId) && !ActivityCommonUtil.activityRecordContainWfId(waitRunning = auditIdData.get(WFGroupDecisionTypeEnum.WILL_RUNNING.getType()), (String)wfId)) {
                        ActivityWfRecord activityWfRecord = new ActivityWfRecord(wfId);
                        waitRunning.add(activityWfRecord);
                    }
                    if (HRCollUtil.isNotEmpty((Collection)customParams)) {
                        WFCustomParam wfCustomParam = (WFCustomParam)customParams.get(0);
                        String activityId = wfCustomParam.getId();
                        wfActivityIdMap.remove(activityId);
                        wfActivityIdMap.put(activityId, wfId);
                    }
                }
                ++index;
            }
            index = 0;
            for (WFFlowNode nextNode : nextNodes) {
                this.getActivityFromWf((WFFlowElement)nextNode, wfActivityIdMap, auditIdData, (Boolean)nextNodesIsInNodeAfter.get(index));
                ++index;
            }
        }
    }

    private ProcessSelectParam genParamBySchemeEntry(DynamicObject activity) {
        ProcessSelectParam processSelectParam = new ProcessSelectParam();
        processSelectParam.setActivityId(activity.getLong("id"));
        processSelectParam.setActivityName(activity.getString("name"));
        processSelectParam.setIsMustNode("0");
        return processSelectParam;
    }

    private ProcessSelectParam genParamByRuntimeEntry(DynamicObject entry) {
        ProcessSelectParam processSelectParam = new ProcessSelectParam();
        DynamicObject activity = entry.getDynamicObject("activity");
        String status = entry.getString(STATUS);
        String activityType = entry.getString("activitytype");
        processSelectParam.setActivityId(activity.getLong("id"));
        processSelectParam.setDelStatus(status);
        processSelectParam.setIsMustNode(activityType);
        processSelectParam.setActivityName(activity.getString("name"));
        processSelectParam.setIsExampleExist("1");
        return processSelectParam;
    }

    private Map<String, Object> beanToMap(Object bean) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] pds;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            String name = pd.getName();
            Object value = pd.getReadMethod().invoke(bean, new Object[0]);
            map.put(name, value);
        }
        return map;
    }

    public List<WFFlowNode> queryWFFlowNodes(List<DynamicObject> bills) {
        if (HRCollUtil.isEmpty(bills)) {
            return null;
        }
        ArrayList wfFlowNodes = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject bill : bills) {
            long billId = bill.getLong("id");
            LOG.info("queryWFFlowNodes billId: {}", (Object)billId);
            List processElements = WorkflowServiceHelper.getProcessElements((DynamicObject)bill, (String)"submit");
            if (CollectionUtils.isEmpty((Collection)processElements) || processElements.get(0) == null) {
                LOG.info("getProcessElements result is null, bill: {}", (Object)bill);
                continue;
            }
            List<ProcessSelectParam> paramByActivityGroupIns = this.getParamByActivityGroupIns(bill);
            Map<String, List<ActivityWfRecord>> wFlowNodeData = this.getWFlowNodeData(bill);
            WFFlowNode flowNode = (WFFlowNode)processElements.get(0);
            Map<String, String> allWFNodes = this.getAllWFNodes(flowNode, null);
            List<String> needDeleteNodeIds = this.getNeedDeleteNodeIds(allWFNodes, paramByActivityGroupIns);
            LOG.info("needDeleteNodeIds result: {}", needDeleteNodeIds);
            this.deleteNodeByIdsBeforeTurn(flowNode, needDeleteNodeIds);
            this.setNodesStatus(flowNode, wFlowNodeData, billId);
            LOG.info("deleteNodeByIdsBeforeTurn and setNodesStatus result: {}", (Object)SerializationUtils.toJsonString((Object)flowNode));
            wfFlowNodes.add(flowNode);
        }
        return wfFlowNodes;
    }

    public String turnToPaintableData(WFFlowNode flowNodes) {
        this.setParentNodes(null, flowNodes);
        this.deleteNodeWithGateway(flowNodes);
        this.setMergeFlowNodes(flowNodes);
        this.addVirtuallyNode(flowNodes);
        ArrayList flowNodeList = Lists.newArrayListWithExpectedSize((int)10);
        if (flowNodes == null || flowNodes.getNextNodes().size() == 0) {
            return null;
        }
        int level = 0;
        this.getNextNodesInfo(flowNodes, flowNodeList, level);
        int nodesLength = flowNodeList.size();
        int cardEntityNum = this.getMaxRows(flowNodes);
        LOG.info("cardEntityNum: {},nodesLength: {}", (Object)cardEntityNum, (Object)nodesLength);
        ArrayList<List<NodeInfo>> nodeAllList = new ArrayList<List<NodeInfo>>(cardEntityNum);
        for (int i = 0; i < cardEntityNum; ++i) {
            NodeInfo nodeInfo = new NodeInfo(0);
            ArrayList<NodeInfo> nodeList = new ArrayList<NodeInfo>(Collections.nCopies(nodesLength, nodeInfo));
            nodeAllList.add(nodeList);
        }
        this.setNodesInfo(flowNodes, nodeAllList, flowNodes, level, 0, 0);
        String returnToShow = SerializationUtils.toJsonString(nodeAllList);
        LOG.info("nodeAllList returnToShow 20130924: {}", (Object)returnToShow);
        return returnToShow;
    }

    private Map<String, String> getAllWFNodes(WFFlowNode wfFlowNode, Map<String, String> nodeIdMap) {
        if (MapUtils.isEmpty(nodeIdMap)) {
            nodeIdMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        nodeIdMap.put(wfFlowNode.getId(), this.getActivityNodeId(wfFlowNode));
        if (CollectionUtils.isEmpty((Collection)wfFlowNode.getNextNodes())) {
            return null;
        }
        for (WFFlowNode childNode : wfFlowNode.getNextNodes()) {
            this.getAllWFNodes(childNode, nodeIdMap);
        }
        return nodeIdMap;
    }

    private String getActivityNodeId(WFFlowNode wfFlowNode) {
        if (CollectionUtils.isEmpty((Collection)wfFlowNode.getCustomParams())) {
            return null;
        }
        return ((WFCustomParam)wfFlowNode.getCustomParams().get(0)).getId();
    }

    private String getActivityNodeBillId(WFFlowNode wfFlowNode) {
        if (MapUtils.isEmpty((Map)wfFlowNode.getExtProps())) {
            return null;
        }
        List statusList = (List)wfFlowNode.getExtProps().get(STATUSINFO);
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            return null;
        }
        return (String)((Map)statusList.get(0)).get(BILLID);
    }

    private List<String> getNeedDeleteNodeIds(Map<String, String> nodeIdMap, List<ProcessSelectParam> paramByActivityGroupIns) {
        if (MapUtils.isEmpty(nodeIdMap) || CollectionUtils.isEmpty(paramByActivityGroupIns)) {
            LOG.info("nodeIdMap or paramByActivityGroupIns is empty");
            return null;
        }
        LOG.info("getNeedDeleteNodeIds paramByActivityGroupIns: {}", (Object)SerializationUtils.toJsonString(paramByActivityGroupIns));
        List activityIds = paramByActivityGroupIns.stream().filter(activity -> "1".equals(activity.getDelStatus())).map(processSelectParam -> String.valueOf(processSelectParam.getActivityId())).collect(Collectors.toList());
        ArrayList needDeleteNodeIds = Lists.newArrayListWithExpectedSize((int)10);
        nodeIdMap.forEach((key, value) -> {
            if (value != null) {
                if (!activityIds.contains(value)) {
                    needDeleteNodeIds.add(key);
                }
            } else {
                needDeleteNodeIds.add(key);
            }
        });
        return needDeleteNodeIds;
    }

    private void deleteNodeByIdsBeforeTurn(WFFlowNode flowElement, List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        for (String id : idList) {
            this.deleteNodeByIdBeforeTurn(flowElement, id);
        }
    }

    private List<WFFlowNode> deleteNodeByIdBeforeTurn(WFFlowNode flowElement, String id) {
        if (CollectionUtils.isEmpty((Collection)flowElement.getNextNodes())) {
            return null;
        }
        CopyOnWriteArrayList wfFlowNodes1 = new CopyOnWriteArrayList(flowElement.getNextNodes());
        for (WFFlowNode wfFlowNode : wfFlowNodes1) {
            List<WFFlowNode> wfFlowNodes = this.deleteNodeByIdBeforeTurn(wfFlowNode, id);
            if (CollectionUtils.isEmpty(wfFlowNodes)) continue;
            flowElement.getNextNodes().remove(wfFlowNode);
            for (WFFlowNode wfFlowNode1 : wfFlowNodes) {
                WFFlowNode copyFlowElement = this.getCopyFlowElement(wfFlowNode1, flowElement);
                if (copyFlowElement != null) continue;
                flowElement.getNextNodes().add(wfFlowNode1);
            }
        }
        if (flowElement.getId().equals(id) && !flowElement.getType().equals(INCLUSIVEGATEWAY)) {
            return flowElement.getNextNodes();
        }
        return null;
    }

    private void deleteNodeWithGateway(WFFlowNode flowNode) {
        if (ENDNONEEVENT.equals(flowNode.getType())) {
            return;
        }
        CopyOnWriteArrayList childNodes = new CopyOnWriteArrayList(flowNode.getNextNodes());
        for (WFFlowNode childNode : childNodes) {
            if (!USERTASK.equals(childNode.getType()) && !INCLUSIVEGATEWAY.equals(childNode.getType()) || INCLUSIVEGATEWAY.equals(childNode.getType()) && childNode.getNextNodes().size() > 1 && this.getParentNode(childNode).size() > 1) continue;
            flowNode.getNextNodes().remove(childNode);
            flowNode.getNextNodes().addAll(childNode.getNextNodes());
            for (WFFlowNode childNextNode : childNode.getNextNodes()) {
                this.getParentNode(childNextNode).add(flowNode);
                this.getParentNode(childNextNode).remove(childNode);
            }
        }
        for (WFFlowNode childNode : flowNode.getNextNodes()) {
            this.deleteNodeWithGateway(childNode);
        }
    }

    private WFFlowNode getCopyFlowElement(WFFlowNode wfFlowNode, WFFlowNode deepCopyFlowElement) {
        if (StringUtils.equals((CharSequence)wfFlowNode.getId(), (CharSequence)deepCopyFlowElement.getId())) {
            return deepCopyFlowElement;
        }
        for (WFFlowNode node : deepCopyFlowElement.getNextNodes()) {
            WFFlowNode copyFlowElement = this.getCopyFlowElement(wfFlowNode, node);
            if (copyFlowElement == null) continue;
            return copyFlowElement;
        }
        return null;
    }

    private void setNodesStatus(WFFlowNode flowNode, Map<String, List<ActivityWfRecord>> wFlowNodeData, long billId) {
        this.setNodeStatusInfo(flowNode, WFGroupDecisionTypeEnum.WILL_RUNNING.getStatus(), billId, null);
        wFlowNodeData.forEach((key, value) -> {
            ActivityWfRecord activityRecordByWfId = ActivityCommonUtil.getActivityRecordByWfId((List)value, (String)flowNode.getId());
            if (activityRecordByWfId != null) {
                this.setNodeStatusInfo(flowNode, WFGroupDecisionTypeEnum.getStatusByType((String)key), billId, activityRecordByWfId);
            }
        });
        if (CollectionUtils.isEmpty((Collection)flowNode.getNextNodes())) {
            return;
        }
        for (WFFlowNode wfFlowNode : flowNode.getNextNodes()) {
            this.setNodesStatus(wfFlowNode, wFlowNodeData, billId);
        }
    }

    private int getNodeType(WFFlowNode wfFlowNode) {
        if (wfFlowNode.getExtProps().get(NODETYPE) != null) {
            return (Integer)wfFlowNode.getExtProps().get(NODETYPE);
        }
        return 0;
    }

    private int getRowNum(WFFlowNode wfFlowNode) {
        if (wfFlowNode.getExtProps().get(ROWNUM) != null) {
            return (Integer)wfFlowNode.getExtProps().get(ROWNUM);
        }
        return 0;
    }

    private void setNodeStatusInfo(WFFlowNode wfFlowNode, String status, long billId, ActivityWfRecord activityRecordByWfId) {
        if (wfFlowNode.getExtProps().get(STATUSINFO) != null) {
            List nodeInfo = (List)wfFlowNode.getExtProps().get(STATUSINFO);
            this.saveNodeInfo(nodeInfo, billId, status, activityRecordByWfId);
        } else {
            ArrayList nodeInfo = Lists.newArrayListWithExpectedSize((int)16);
            Map<String, String> info = this.getNodeInfo(billId, status, activityRecordByWfId);
            nodeInfo.add(info);
            wfFlowNode.getExtProps().put(STATUSINFO, nodeInfo);
        }
    }

    private Map<String, String> getNodeInfo(long billId, String status, ActivityWfRecord activityRecordByWfId) {
        HashMap info = Maps.newHashMapWithExpectedSize((int)16);
        info.put(BILLID, String.valueOf(billId));
        info.put(STATUS, status);
        if (activityRecordByWfId != null) {
            info.put(MESSAGE, activityRecordByWfId.getMessage());
            info.put(RESULT, activityRecordByWfId.getResult());
            info.put(TIME, String.valueOf(activityRecordByWfId.getInFormatTime()));
        }
        return info;
    }

    private void saveNodeInfo(List<Map<String, String>> nodeInfo, long billId, String status, ActivityWfRecord activityRecordByWfId) {
        for (Map<String, String> tempNodeInfo : nodeInfo) {
            boolean canUpdate = activityRecordByWfId != null && String.valueOf(billId).equals(tempNodeInfo.get(BILLID)) && (StringUtils.isEmpty((CharSequence)tempNodeInfo.get(TIME)) || Long.parseLong(tempNodeInfo.get(TIME)) < activityRecordByWfId.getInFormatTime());
            boolean canReturnWithNotCanUpdate = String.valueOf(billId).equals(tempNodeInfo.get(BILLID));
            if (canUpdate) {
                tempNodeInfo.put(STATUS, status);
                tempNodeInfo.put(MESSAGE, activityRecordByWfId.getMessage());
                tempNodeInfo.put(RESULT, activityRecordByWfId.getResult());
                tempNodeInfo.put(TIME, String.valueOf(activityRecordByWfId.getInFormatTime()));
                return;
            }
            if (!canReturnWithNotCanUpdate) continue;
            return;
        }
        Map<String, String> info = this.getNodeInfo(billId, status, activityRecordByWfId);
        nodeInfo.add(info);
    }

    private List<Map<String, String>> getNodeStatusInfo(WFFlowNode wfFlowNode) {
        if (wfFlowNode.getExtProps().get(STATUSINFO) != null) {
            return (List)wfFlowNode.getExtProps().get(STATUSINFO);
        }
        return Lists.newArrayListWithExpectedSize((int)10);
    }

    private void setParentNodes(WFFlowNode parentLinkedFlowElement, WFFlowNode childLinkedFlowElement) {
        this.addParentNode(childLinkedFlowElement, parentLinkedFlowElement);
        for (WFFlowNode wfFlowNode : childLinkedFlowElement.getNextNodes()) {
            this.setParentNodes(childLinkedFlowElement, wfFlowNode);
        }
    }

    private void addParentNode(WFFlowNode wfFlowNode, WFFlowNode parentFlowNode) {
        if (wfFlowNode != null && parentFlowNode != null) {
            List parentList;
            if (wfFlowNode.getExtProps().get(PARENTNODES) == null) {
                ArrayList parentNodes = Lists.newArrayListWithExpectedSize((int)10);
                wfFlowNode.getExtProps().put(PARENTNODES, parentNodes);
            }
            if (!(parentList = (List)wfFlowNode.getExtProps().get(PARENTNODES)).contains(parentFlowNode)) {
                parentList.add(parentFlowNode);
            }
        }
    }

    private void addVirtuallyNode(WFFlowNode linkedFlowElement) {
        int currentLevel = 0;
        this.addDerectionNode(null, linkedFlowElement, linkedFlowElement, currentLevel);
        this.addHorizonNode(linkedFlowElement);
    }

    private void addDerectionNode(WFFlowNode parentFlowElement, WFFlowNode linkedFlowElement, WFFlowNode allFlowElement, int level) {
        if (linkedFlowElement.getExtProps().get(NODETYPE) != null && (Integer)linkedFlowElement.getExtProps().get(NODETYPE) > 0) {
            return;
        }
        int maxDepth = this.getMaxDepth(linkedFlowElement, allFlowElement);
        boolean addFlag = false;
        if (maxDepth - 1 > level) {
            addFlag = true;
            WFFlowNode tempParentlinkedFlowElement = parentFlowElement;
            for (int i = 0; i < maxDepth - level - 1; ++i) {
                int indexChild;
                WFFlowNode tempFlowElement = this.getNewWFFlowNode(13);
                if (maxDepth - level == 2) {
                    indexChild = tempParentlinkedFlowElement.getNextNodes().indexOf(linkedFlowElement);
                    tempParentlinkedFlowElement.getNextNodes().set(indexChild, tempFlowElement);
                    this.addParentNode(tempFlowElement, tempParentlinkedFlowElement);
                    tempFlowElement.getNextNodes().add(linkedFlowElement);
                    this.replaceParentNode(linkedFlowElement, parentFlowElement, tempFlowElement);
                } else if (i == 0) {
                    indexChild = tempParentlinkedFlowElement.getNextNodes().indexOf(linkedFlowElement);
                    tempParentlinkedFlowElement.getNextNodes().set(indexChild, tempFlowElement);
                    this.addParentNode(tempFlowElement, tempParentlinkedFlowElement);
                } else if (i == maxDepth - level - 2) {
                    tempParentlinkedFlowElement.getNextNodes().add(tempFlowElement);
                    this.addParentNode(tempFlowElement, tempParentlinkedFlowElement);
                    tempFlowElement.getNextNodes().add(linkedFlowElement);
                    this.replaceParentNode(linkedFlowElement, parentFlowElement, tempFlowElement);
                } else {
                    tempParentlinkedFlowElement.getNextNodes().add(tempFlowElement);
                    this.addParentNode(tempFlowElement, tempParentlinkedFlowElement);
                }
                tempParentlinkedFlowElement = tempFlowElement;
            }
        }
        if (addFlag) {
            this.addDerectionNode(null, allFlowElement, allFlowElement, 0);
        } else {
            for (WFFlowNode nextNode : linkedFlowElement.getNextNodes()) {
                this.addDerectionNode(linkedFlowElement, nextNode, allFlowElement, level + 1);
            }
        }
    }

    private void addHorizonNode(WFFlowNode linkedFlowElement) {
        if (linkedFlowElement.getNextNodes().size() > 1) {
            int allNum = 0;
            boolean isMerge = this.checkMergeCode(linkedFlowElement);
            for (WFFlowNode node : linkedFlowElement.getNextNodes()) {
                allNum += isMerge ? this.getMaxRowsWithFirstMergeNode(node) : this.getMaxRows(node);
                if (this.getNodeType(node) != 14) continue;
                return;
            }
            boolean needAddOneRow = allNum % 2 == 0;
            int childNum = linkedFlowElement.getNextNodes().size();
            int middleCurrent = childNum >> 1;
            List<List<WFFlowNode>> mergeGroup = this.getMergeGroup(linkedFlowElement);
            if (mergeGroup.size() == linkedFlowElement.getNextNodes().size() || mergeGroup.size() == 1) {
                this.addTempNodeWithNoMergeGroup(linkedFlowElement, middleCurrent, needAddOneRow, isMerge);
            } else {
                allNum = this.getMaxRows(linkedFlowElement);
                needAddOneRow = allNum % 2 == 0;
                int groupCount = 0;
                int needAddOneRowGroupCount = (mergeGroup.size() >> 1) - 1;
                int indexLastAdd = 0;
                for (List<WFFlowNode> sameGroupNodes : mergeGroup) {
                    int middle = sameGroupNodes.size() % 2 == 0 ? (sameGroupNodes.size() >> 1) - 1 : sameGroupNodes.size() >> 1;
                    int maxRows = 0;
                    int groupAllRows = 0;
                    for (WFFlowNode childGroup : sameGroupNodes) {
                        groupAllRows += this.getMaxRowsWithFirstMergeNode(childGroup);
                        maxRows = Math.max(maxRows, this.getMaxRows(sameGroupNodes.get(middle)));
                    }
                    if (groupAllRows > sameGroupNodes.size()) {
                        this.addMergeGroupNode(linkedFlowElement, sameGroupNodes, mergeGroup, groupCount);
                    }
                    if (maxRows > groupAllRows) {
                        int lastIndex = this.addTempNodeWithMaxRowLargeCurrentGroupRow(linkedFlowElement, sameGroupNodes, mergeGroup, groupCount, groupAllRows, needAddOneRowGroupCount, maxRows);
                        int n = indexLastAdd = lastIndex > 0 ? lastIndex : indexLastAdd;
                    }
                    if (needAddOneRow && needAddOneRowGroupCount == groupCount) {
                        if (indexLastAdd == 0) {
                            indexLastAdd = linkedFlowElement.getNextNodes().indexOf(sameGroupNodes.get(sameGroupNodes.size() - 1));
                            Set<WFFlowNode> mergeNode = this.getMergeNode(sameGroupNodes.get(sameGroupNodes.size() - 1));
                            int maxRowsWithEndNode = this.getMaxRowsWithEndNode(sameGroupNodes.get(sameGroupNodes.size() - 1), mergeNode.iterator().next());
                            indexLastAdd += maxRowsWithEndNode >> 1;
                        }
                        this.addTempNode(linkedFlowElement, indexLastAdd + 1);
                    }
                    ++groupCount;
                }
            }
        }
        for (WFFlowNode nextNode : linkedFlowElement.getNextNodes()) {
            this.addHorizonNode(nextNode);
        }
    }

    private int getMaxDepth(WFFlowNode wfFlowNode, WFFlowNode allFlowNode) {
        int temMaxDepth = 0;
        for (WFFlowNode wfFlowNode01 : allFlowNode.getNextNodes()) {
            int maxDepth = this.getMaxDepth(wfFlowNode, wfFlowNode01);
            if (maxDepth <= temMaxDepth) continue;
            temMaxDepth = maxDepth;
        }
        if (temMaxDepth > 0) {
            ++temMaxDepth;
        }
        if (ENDNONEEVENT.equals(wfFlowNode.getType()) || wfFlowNode.getNextNodes().size() == 0) {
            return 0;
        }
        if (wfFlowNode.equals(allFlowNode)) {
            return 1;
        }
        return temMaxDepth;
    }

    private void getNextNodesInfo(WFFlowNode wfFlowNode, List<Set<WFFlowNode>> flowNodes, int level) {
        Set<Object> nodeNames;
        if (ENDNONEEVENT.equals(wfFlowNode.getType())) {
            return;
        }
        if (flowNodes.size() < level + 1) {
            nodeNames = new LinkedHashSet(16);
            flowNodes.add(nodeNames);
        } else {
            nodeNames = flowNodes.get(level);
        }
        nodeNames.add(wfFlowNode);
        for (WFFlowNode node : wfFlowNode.getNextNodes()) {
            this.getNextNodesInfo(node, flowNodes, level + 1);
        }
    }

    private int getMaxRows(WFFlowNode wfFlowNode) {
        int rows;
        if (ENDNONEEVENT.equals(wfFlowNode.getType())) {
            return 0;
        }
        if (wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode((WFFlowNode)wfFlowNode.getNextNodes().get(0)).size() > 1) {
            int middle;
            List<WFFlowNode> parentNodes = this.getParentNode((WFFlowNode)wfFlowNode.getNextNodes().get(0));
            int n = middle = parentNodes.size() % 2 == 0 ? (parentNodes.size() >> 1) - 1 : parentNodes.size() >> 1;
            if (!parentNodes.get(middle).equals(wfFlowNode)) {
                if (this.getNodeType(wfFlowNode) > 0) {
                    return 0;
                }
                return 1;
            }
        } else if (this.getNodeType(wfFlowNode) > 0) {
            return 0;
        }
        int maxRow = wfFlowNode.getNextNodes().size() % 2 == 0 ? wfFlowNode.getNextNodes().size() + 1 : wfFlowNode.getNextNodes().size();
        int childMaxRow = 0;
        int childMaxRowWithMax = 0;
        for (WFFlowNode node : wfFlowNode.getNextNodes()) {
            int childNodeCount = this.getMaxRows(node);
            childMaxRow += childNodeCount;
            childMaxRowWithMax = Math.max(childMaxRowWithMax, childNodeCount);
        }
        boolean isMerge = this.checkMergeCode(wfFlowNode);
        if (isMerge && wfFlowNode.getNextNodes().size() > 1) {
            Set<WFFlowNode> mergeNode = this.getMergeNode(wfFlowNode);
            int rowWithEndNode = this.getMaxRowsWithEndNode(wfFlowNode, mergeNode.iterator().next());
            childMaxRow = Math.max(childMaxRowWithMax, rowWithEndNode);
        }
        List<List<WFFlowNode>> mergeGroup = this.getMergeGroup(wfFlowNode);
        if (wfFlowNode.getNextNodes().size() > 1 && mergeGroup.size() < this.getNextNodesWithoutAddNode(wfFlowNode).size() && mergeGroup.size() > 1) {
            int groupAllRows = 0;
            for (List<WFFlowNode> sameGroup : mergeGroup) {
                int tempRows = 0;
                int smallGroupAllRows = 0;
                for (WFFlowNode smallGroupNode : sameGroup) {
                    tempRows = Math.max(tempRows, this.getMaxRows(smallGroupNode));
                }
                for (WFFlowNode smallGroupNode : sameGroup) {
                    smallGroupAllRows += this.getMaxRowsWithFirstMergeNode(smallGroupNode);
                }
                int countRow = Math.max(tempRows, smallGroupAllRows);
                groupAllRows += countRow;
            }
            childMaxRow = groupAllRows;
        }
        return (rows = Math.max(childMaxRow, maxRow)) % 2 == 0 ? rows + 1 : rows;
    }

    private int getMaxRowsWithEndNode(WFFlowNode wfFlowNode, WFFlowNode endNode) {
        if (ENDNONEEVENT.equals(wfFlowNode.getType()) || this.getNodeType(wfFlowNode) > 0 || wfFlowNode.equals(endNode)) {
            return 0;
        }
        int maxRow = wfFlowNode.getNextNodes().size() % 2 == 0 ? wfFlowNode.getNextNodes().size() + 1 : wfFlowNode.getNextNodes().size();
        int childMaxRow = 0;
        for (WFFlowNode node : wfFlowNode.getNextNodes()) {
            childMaxRow += this.getMaxRowsWithEndNode(node, endNode);
        }
        int rows = Math.max(childMaxRow, maxRow);
        return rows % 2 == 0 ? rows + 1 : rows;
    }

    private int getMaxRowsWithFirstMergeNode(WFFlowNode wfFlowNode) {
        if (ENDNONEEVENT.equals(wfFlowNode.getType()) || this.getNodeType(wfFlowNode) > 0) {
            return 0;
        }
        if (wfFlowNode.getNextNodes().size() == 1 && this.getParentNode((WFFlowNode)wfFlowNode.getNextNodes().get(0)).size() > 1) {
            return 1;
        }
        int maxRow = wfFlowNode.getNextNodes().size() % 2 == 0 ? wfFlowNode.getNextNodes().size() + 1 : wfFlowNode.getNextNodes().size();
        int childMaxRow = 0;
        for (WFFlowNode node : wfFlowNode.getNextNodes()) {
            childMaxRow += this.getMaxRowsWithFirstMergeNode(node);
        }
        int rows = Math.max(childMaxRow, maxRow);
        return rows % 2 == 0 ? rows + 1 : rows;
    }

    private boolean checkMergeCode(WFFlowNode wfFlowNode) {
        if (wfFlowNode == null || wfFlowNode.getNextNodes().size() == 1) {
            return false;
        }
        Set<WFFlowNode> mergeNode = this.getMergeNode((WFFlowNode)wfFlowNode.getNextNodes().get(0));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(mergeNode)) {
            return false;
        }
        for (WFFlowNode node : wfFlowNode.getNextNodes()) {
            Set<WFFlowNode> tempNode;
            if (this.getNodeType(node) != 0 || !org.apache.commons.collections.CollectionUtils.isEmpty(tempNode = this.getMergeNode(node)) && org.apache.commons.collections.CollectionUtils.isEqualCollection(tempNode, mergeNode)) continue;
            return false;
        }
        return true;
    }

    private List<WFFlowNode> getParentNode(WFFlowNode wfFlowNode) {
        if (wfFlowNode.getExtProps().get(PARENTNODES) == null) {
            ArrayList parentNodes = Lists.newArrayListWithExpectedSize((int)10);
            wfFlowNode.getExtProps().put(PARENTNODES, parentNodes);
        }
        return (List)wfFlowNode.getExtProps().get(PARENTNODES);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setNodesInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, WFFlowNode parentFlowNode, int level, int childType, int parentRow) {
        if (ENDNONEEVENT.equals(wfFlowNode.getType())) {
            return;
        }
        LOG.info("setNodesInfo level:{}, childType:{}, parentRow:{}", new Object[]{level, childType, parentRow});
        int maxRows = this.getMaxRows(wfFlowNode);
        int brotherNodeRows = this.getBrotherNodeRows(wfFlowNode);
        int middleInt = maxRows >> 1;
        LOG.info("setNodesInfo maxRows:{}, brotherNodeRows:{}, middleInt:{}", new Object[]{maxRows, brotherNodeRows, middleInt});
        if (level == 0) {
            this.setBeginNodeInfo(wfFlowNode, nodeAllList, middleInt);
        } else {
            int parentNodesSize = this.getParentNode(wfFlowNode).size();
            if (parentNodesSize > 1) {
                if (!parentFlowNode.equals(this.getParentNode(wfFlowNode).get(parentNodesSize - 1))) return;
                int firstParentNum = this.getRowNum(this.getParentNode(wfFlowNode).get(0));
                middleInt = firstParentNum + (parentRow - firstParentNum >> 1);
                LOG.info("parentNodesSize morethan 1 middleInt:{}, firstParentNum:{}, parentRow:{}", new Object[]{middleInt, firstParentNum, parentRow});
                for (int i = firstParentNum; i <= parentRow; ++i) {
                    this.setMergeNodeInfo(wfFlowNode, nodeAllList, middleInt, i, level, parentRow, firstParentNum);
                }
            } else {
                int parentMaxRows;
                WFFlowNode parentFlowElement = this.getParentNode(wfFlowNode).get(0);
                boolean isMerge = this.checkMergeCode(parentFlowElement);
                List<List<WFFlowNode>> mergeGroup = this.getMergeGroup(parentFlowElement);
                if (isMerge) {
                    parentMaxRows = this.getMaxRowsWithFirstMergeNode(parentFlowElement);
                    maxRows = this.getMaxRowsWithFirstMergeNode((WFFlowNode)parentFlowElement.getNextNodes().get(0));
                } else if (parentFlowElement.getNextNodes().size() > 1 && mergeGroup.size() > 1 && mergeGroup.size() < this.getNextNodesWithoutAddNode(parentFlowElement).size()) {
                    parentMaxRows = this.getMaxRows(parentFlowElement);
                    maxRows = this.getFirstChildNodeMaxRowWithSameMergeGroups(parentFlowElement, mergeGroup);
                } else {
                    parentMaxRows = this.getMaxRows(parentFlowElement);
                    maxRows = this.getMaxRows((WFFlowNode)parentFlowElement.getNextNodes().get(0));
                }
                middleInt = parentRow - (parentMaxRows >> 1) + (maxRows >> 1) + brotherNodeRows;
                LOG.info("parentNodesSize equals 1 middleInt:{}, maxRows:{}, parentMaxRows:{}, parentRow:{}", new Object[]{middleInt, maxRows, parentMaxRows, parentRow});
                if (this.getNodeType(wfFlowNode) > 0) {
                    if (this.getNodeType(wfFlowNode) == 13) {
                        middleInt = parentRow;
                    }
                    NodeInfo nodeInfo = new NodeInfo(this.getNodeType(wfFlowNode));
                    nodeAllList.get(middleInt).set(level, nodeInfo);
                } else if (childType == 1) {
                    this.setUpNodeInfo(wfFlowNode, nodeAllList, middleInt, level);
                } else if (childType == 2) {
                    this.setDownNodeInfo(wfFlowNode, nodeAllList, middleInt, level);
                } else {
                    this.setMiddleNodeInfo(wfFlowNode, nodeAllList, middleInt, level);
                }
            }
        }
        this.setNextNodesInfo(wfFlowNode, nodeAllList, level, middleInt);
    }

    private void setNextNodesInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, int level, int middleInt) {
        wfFlowNode.getExtProps().put(ROWNUM, middleInt);
        for (int i = 0; i < wfFlowNode.getNextNodes().size(); ++i) {
            int middle;
            int n = middle = wfFlowNode.getNextNodes().size() % 2 == 0 ? (wfFlowNode.getNextNodes().size() >> 1) - 1 : wfFlowNode.getNextNodes().size() >> 1;
            if (wfFlowNode.getNextNodes().size() % 2 == 0) {
                if (i <= middle) {
                    this.setNodesInfo((WFFlowNode)wfFlowNode.getNextNodes().get(i), nodeAllList, wfFlowNode, level + 1, 1, middleInt);
                    continue;
                }
                this.setNodesInfo((WFFlowNode)wfFlowNode.getNextNodes().get(i), nodeAllList, wfFlowNode, level + 1, 2, middleInt);
                continue;
            }
            if (i < middle) {
                this.setNodesInfo((WFFlowNode)wfFlowNode.getNextNodes().get(i), nodeAllList, wfFlowNode, level + 1, 1, middleInt);
                continue;
            }
            if (i > middle) {
                this.setNodesInfo((WFFlowNode)wfFlowNode.getNextNodes().get(i), nodeAllList, wfFlowNode, level + 1, 2, middleInt);
                continue;
            }
            this.setNodesInfo((WFFlowNode)wfFlowNode.getNextNodes().get(i), nodeAllList, wfFlowNode, level + 1, 0, middleInt);
        }
    }

    private int getBrotherNodeRows(WFFlowNode flowNode) {
        int rows = 0;
        if (this.getParentNode(flowNode).size() == 0) {
            return 0;
        }
        for (WFFlowNode wfFlowNode : this.getParentNode(flowNode).get(0).getNextNodes()) {
            if (wfFlowNode.equals(flowNode)) {
                return rows;
            }
            ++rows;
        }
        return 0;
    }

    private void replaceParentNode(WFFlowNode wfFlowNode, WFFlowNode parentFlowNode, WFFlowNode replaceNode) {
        if (wfFlowNode != null) {
            List parentList;
            int indexParent;
            if (wfFlowNode.getExtProps().get(PARENTNODES) == null) {
                ArrayList parentNodes = Lists.newArrayListWithExpectedSize((int)10);
                wfFlowNode.getExtProps().put(PARENTNODES, parentNodes);
            }
            if ((indexParent = (parentList = (List)wfFlowNode.getExtProps().get(PARENTNODES)).indexOf(parentFlowNode)) > -1) {
                parentList.set(indexParent, replaceNode);
            }
        }
    }

    private void setNodeInfoProperties(WFFlowNode wfFlowNode, NodeInfo nodeInfo) {
        if (wfFlowNode == null) {
            return;
        }
        if (wfFlowNode.getName() != null) {
            nodeInfo.setName(wfFlowNode.getName().getLocaleValue());
        }
        nodeInfo.setNodeId(wfFlowNode.getId());
        if (!CollectionUtils.isEmpty((Collection)wfFlowNode.getCustomParams())) {
            nodeInfo.setId(((WFCustomParam)wfFlowNode.getCustomParams().get(0)).getId());
        }
        nodeInfo.setNodeInfo(this.getNodeStatusInfo(wfFlowNode));
        nodeInfo.setExtProps(wfFlowNode.getExtProps());
    }

    private WFFlowNode getNewWFFlowNode(int nodeType) {
        WFFlowNode tempFlowElement = new WFFlowNode();
        tempFlowElement.setName(LocaleString.fromMap((Map)ImmutableMap.of((Object)Lang.zh_CN.toString(), (Object)"temp")));
        tempFlowElement.setId(UUID.randomUUID().toString());
        tempFlowElement.getExtProps().put(NODETYPE, nodeType);
        return tempFlowElement;
    }

    private void setBeginNodeInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, int middleInt) {
        NodeInfo nodeInfo = wfFlowNode.getNextNodes().size() > 1 ? new NodeInfo(18) : new NodeInfo(16);
        this.setNodeInfoProperties(wfFlowNode, nodeInfo);
        nodeAllList.get(middleInt).set(0, nodeInfo);
    }

    private void setMergeNodeInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, int middleInt, int index, int level, int parentRow, int firstParentNum) {
        NodeInfo nodeInfo = index == middleInt ? (index == firstParentNum && wfFlowNode.getNextNodes().size() == 1 && ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(25) : (index == firstParentNum && wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(10) : (index == firstParentNum && wfFlowNode.getNextNodes().size() != 1 ? new NodeInfo(8) : (wfFlowNode.getNextNodes().size() == 1 && ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(19) : (wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(21) : new NodeInfo(4)))))) : (index == firstParentNum ? new NodeInfo(24) : (index == parentRow ? new NodeInfo(15) : new NodeInfo(14)));
        this.setNodeInfoProperties(wfFlowNode, nodeInfo);
        nodeAllList.get(index).set(level, nodeInfo);
    }

    private void setUpNodeInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, int middleInt, int level) {
        NodeInfo nodeInfo = new NodeInfo(0);
        if (wfFlowNode.getNextNodes().size() == 1) {
            nodeInfo = ((WFFlowNode)this.getParentNode(wfFlowNode).get(0).getNextNodes().get(0)).equals(wfFlowNode) ? (ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(25) : new NodeInfo(10)) : (ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(19) : new NodeInfo(21));
        } else if (wfFlowNode.getNextNodes().size() > 1) {
            nodeInfo = ((WFFlowNode)this.getParentNode(wfFlowNode).get(0).getNextNodes().get(0)).equals(wfFlowNode) ? new NodeInfo(8) : new NodeInfo(4);
        } else if (this.getNodeType(wfFlowNode) > 0) {
            nodeInfo = new NodeInfo(this.getNodeType(wfFlowNode));
        }
        this.setNodeInfoProperties(wfFlowNode, nodeInfo);
        nodeAllList.get(middleInt).set(level, nodeInfo);
    }

    private void setDownNodeInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, int middleInt, int level) {
        NodeInfo nodeInfo = new NodeInfo(0);
        if (wfFlowNode.getNextNodes().size() == 1) {
            nodeInfo = ((WFFlowNode)this.getParentNode(wfFlowNode).get(0).getNextNodes().get(this.getParentNode(wfFlowNode).get(0).getNextNodes().size() - 1)).equals(wfFlowNode) ? (ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(26) : new NodeInfo(9)) : (ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) ? new NodeInfo(19) : new NodeInfo(21));
        } else if (wfFlowNode.getNextNodes().size() > 1) {
            nodeInfo = ((WFFlowNode)this.getParentNode(wfFlowNode).get(0).getNextNodes().get(this.getParentNode(wfFlowNode).get(0).getNextNodes().size() - 1)).equals(wfFlowNode) ? new NodeInfo(7) : new NodeInfo(4);
        } else if (this.getNodeType(wfFlowNode) > 0) {
            nodeInfo = new NodeInfo(this.getNodeType(wfFlowNode));
        }
        this.setNodeInfoProperties(wfFlowNode, nodeInfo);
        nodeAllList.get(middleInt).set(level, nodeInfo);
    }

    private void setMiddleNodeInfo(WFFlowNode wfFlowNode, List<List<NodeInfo>> nodeAllList, int parentRow, int level) {
        NodeInfo nodeInfo = new NodeInfo(0);
        if (wfFlowNode.getNextNodes().size() > 1 && this.getParentNode(wfFlowNode).size() == 1 && this.getParentNode(wfFlowNode).get(0).getNextNodes().size() > 1) {
            nodeInfo = new NodeInfo(4);
        } else if (wfFlowNode.getNextNodes().size() > 1 && this.getParentNode(wfFlowNode).size() == 1) {
            nodeInfo = new NodeInfo(20);
        } else if (wfFlowNode.getNextNodes().size() > 1 && this.getParentNode(wfFlowNode).size() > 1) {
            nodeInfo = new NodeInfo(4);
        } else if (wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode(wfFlowNode).size() == 1 && this.getParentNode(wfFlowNode).get(0).getNextNodes().size() > 1) {
            nodeInfo = new NodeInfo(21);
        } else if (wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode(wfFlowNode).size() == 1) {
            nodeInfo = new NodeInfo(1);
        } else if (wfFlowNode.getNextNodes().size() == 1 && ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode(wfFlowNode).size() == 1 && this.getParentNode(wfFlowNode).get(0).getNextNodes().size() > 1) {
            nodeInfo = new NodeInfo(19);
        } else if (wfFlowNode.getNextNodes().size() == 1 && ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode(wfFlowNode).size() == 1) {
            nodeInfo = new NodeInfo(17);
        } else if (wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode(wfFlowNode).size() > 1) {
            nodeInfo = new NodeInfo(21);
        } else if (wfFlowNode.getNextNodes().size() == 1 && ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode(wfFlowNode).size() > 1) {
            nodeInfo = new NodeInfo(19);
        }
        this.setNodeInfoProperties(wfFlowNode, nodeInfo);
        nodeAllList.get(parentRow).set(level, nodeInfo);
    }

    private void setMergeFlowNodes(WFFlowNode wfFlowNode) {
        if (ENDNONEEVENT.equals(wfFlowNode.getType())) {
            return;
        }
        if (wfFlowNode.getNextNodes().size() == 1 && !ENDNONEEVENT.equals(((WFFlowNode)wfFlowNode.getNextNodes().get(0)).getType()) && this.getParentNode((WFFlowNode)wfFlowNode.getNextNodes().get(0)).size() > 1) {
            this.setMergeNode(wfFlowNode, (WFFlowNode)wfFlowNode.getNextNodes().get(0));
        }
        for (WFFlowNode childNode : wfFlowNode.getNextNodes()) {
            this.setMergeFlowNodes(childNode);
            this.getMergeNode(wfFlowNode).addAll(this.getMergeNode(childNode));
        }
    }

    private Set<WFFlowNode> getMergeNode(WFFlowNode wfFlowNode) {
        if (wfFlowNode.getExtProps().get(MERGENODE) == null) {
            wfFlowNode.getExtProps().remove(MERGENODE);
            wfFlowNode.getExtProps().put(MERGENODE, new LinkedHashSet(16));
        }
        return (Set)wfFlowNode.getExtProps().get(MERGENODE);
    }

    private void setMergeNode(WFFlowNode wfFlowNode, WFFlowNode mergeNode) {
        if (wfFlowNode.getExtProps().get(MERGENODE) == null) {
            wfFlowNode.getExtProps().remove(MERGENODE);
            wfFlowNode.getExtProps().put(MERGENODE, new LinkedHashSet(16));
        }
        ((Set)wfFlowNode.getExtProps().get(MERGENODE)).add(mergeNode);
    }

    private List<List<WFFlowNode>> getMergeGroup(WFFlowNode wfFlowNode) {
        ArrayList mergeGroup = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList sameGroup = Lists.newArrayListWithExpectedSize((int)10);
        WFFlowNode tempNode = null;
        for (WFFlowNode childNode : wfFlowNode.getNextNodes()) {
            boolean notSameGroup;
            if (this.getNodeType(childNode) != 0) continue;
            boolean bl = notSameGroup = tempNode != null && !org.apache.commons.collections.CollectionUtils.isEqualCollection(this.getMergeNode(childNode), this.getMergeNode(tempNode)) && !this.getMergeNode(tempNode).containsAll(this.getMergeNode(childNode)) && !this.getMergeNode(childNode).containsAll(this.getMergeNode(tempNode));
            if ((this.getMergeNode(childNode) == null || CollectionUtils.isEmpty(this.getMergeNode(childNode))) && !CollectionUtils.isEmpty((Collection)sameGroup)) {
                notSameGroup = true;
            }
            if (notSameGroup) {
                mergeGroup.add(sameGroup);
                sameGroup = Lists.newArrayListWithExpectedSize((int)10);
            }
            sameGroup.add(childNode);
            tempNode = childNode;
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)sameGroup)) {
            mergeGroup.add(sameGroup);
        }
        return mergeGroup;
    }

    private List<WFFlowNode> getNextNodesWithoutAddNode(WFFlowNode wfFlowNode) {
        ArrayList childNodes = Lists.newArrayListWithExpectedSize((int)10);
        List nextNodes = wfFlowNode.getNextNodes();
        for (WFFlowNode nextNode : nextNodes) {
            if (this.getNodeType(nextNode) != 0) continue;
            childNodes.add(nextNode);
        }
        return childNodes;
    }

    private void addTempNode(WFFlowNode linkedFlowElement, int count) {
        WFFlowNode tempFlowElement = new WFFlowNode();
        tempFlowElement.setName(LocaleString.fromMap((Map)ImmutableMap.of((Object)Lang.zh_CN.toString(), (Object)"temp")));
        tempFlowElement.setId(UUID.randomUUID().toString());
        tempFlowElement.getExtProps().put(NODETYPE, 14);
        linkedFlowElement.getNextNodes().add(count, tempFlowElement);
        this.addParentNode(tempFlowElement, linkedFlowElement);
    }

    private void addMergeGroupNode(WFFlowNode linkedFlowElement, List<WFFlowNode> sameGroupNodes, List<List<WFFlowNode>> mergeGroup, int groupCount) {
        if (groupCount == 0) {
            int sameGroupCount = 0;
            for (WFFlowNode childGroupNode : sameGroupNodes) {
                this.firstSameGroupAddNode(linkedFlowElement, childGroupNode, sameGroupCount);
                ++sameGroupCount;
            }
        } else if (groupCount == mergeGroup.size() - 1) {
            int sameGroupCount = 0;
            for (WFFlowNode childGroupNode : sameGroupNodes) {
                int indexChild = linkedFlowElement.getNextNodes().indexOf(childGroupNode);
                int childRow = this.getMaxRowsWithFirstMergeNode(childGroupNode);
                int needAddRows = childRow - 1 >> 1;
                if (childRow > 1) {
                    int i;
                    for (i = 0; i < needAddRows; ++i) {
                        this.addTempNode(linkedFlowElement, indexChild + i);
                    }
                    if (sameGroupCount != sameGroupNodes.size() - 1) {
                        indexChild = linkedFlowElement.getNextNodes().indexOf(childGroupNode);
                        for (i = 0; i < needAddRows; ++i) {
                            this.addTempNode(linkedFlowElement, indexChild + i + 1);
                        }
                    }
                }
                ++sameGroupCount;
            }
        } else {
            for (WFFlowNode childGroupNode : sameGroupNodes) {
                int i;
                int indexChild = linkedFlowElement.getNextNodes().indexOf(childGroupNode);
                int childRow = this.getMaxRowsWithFirstMergeNode(childGroupNode);
                int needAddRows = childRow - 1 >> 1;
                if (childRow <= 1) continue;
                for (i = 0; i < needAddRows; ++i) {
                    this.addTempNode(linkedFlowElement, indexChild + i);
                }
                indexChild = linkedFlowElement.getNextNodes().indexOf(childGroupNode);
                for (i = 0; i < needAddRows; ++i) {
                    this.addTempNode(linkedFlowElement, indexChild + i + 1);
                }
            }
        }
    }

    private void firstSameGroupAddNode(WFFlowNode linkedFlowElement, WFFlowNode childGroupNode, int sameGroupCount) {
        int indexChild = linkedFlowElement.getNextNodes().indexOf(childGroupNode);
        int childRow = this.getMaxRowsWithFirstMergeNode(childGroupNode);
        int needAddRows = childRow - 1 >> 1;
        if (childRow > 1) {
            int i;
            if (sameGroupCount > 0) {
                for (i = 0; i < needAddRows; ++i) {
                    this.addTempNode(linkedFlowElement, indexChild + i);
                }
                indexChild = linkedFlowElement.getNextNodes().indexOf(childGroupNode);
            }
            for (i = 0; i < needAddRows; ++i) {
                this.addTempNode(linkedFlowElement, indexChild + i + 1);
            }
        }
    }

    private int getFirstChildNodeMaxRowWithSameMergeGroups(WFFlowNode parentFlowElement, List<List<WFFlowNode>> mergeGroup) {
        int tempRows = 0;
        int smallGroupAllRows = 0;
        for (WFFlowNode smallGroupNode : mergeGroup.get(0)) {
            tempRows = Math.max(tempRows, this.getMaxRows(smallGroupNode));
        }
        for (WFFlowNode smallGroupNode : mergeGroup.get(0)) {
            smallGroupAllRows += this.getMaxRowsWithFirstMergeNode(smallGroupNode);
        }
        tempRows = Math.max(tempRows, smallGroupAllRows);
        boolean isMaxRowFromSelf = false;
        if (tempRows == smallGroupAllRows) {
            int mergeNodeMaxRows;
            isMaxRowFromSelf = true;
            Set<WFFlowNode> mergeNode = this.getMergeNode(mergeGroup.get(0).get(0));
            int n = mergeNodeMaxRows = CollectionUtils.isEmpty(mergeNode) ? 0 : this.getMaxRows(mergeNode.iterator().next());
            if (tempRows == mergeNodeMaxRows) {
                isMaxRowFromSelf = false;
            }
        }
        tempRows = tempRows % 2 == 0 ? tempRows + 1 : tempRows;
        int maxRows = tempRows - smallGroupAllRows;
        int maxRowsWithFirstMergeNode = this.getMaxRowsWithFirstMergeNode((WFFlowNode)parentFlowElement.getNextNodes().get(0));
        maxRows += maxRowsWithFirstMergeNode > 1 ? maxRowsWithFirstMergeNode : 0;
        if (!isMaxRowFromSelf) {
            maxRows = maxRows % 2 == 0 ? maxRows : maxRows + 1;
        }
        return maxRows;
    }

    private int addTempNodeWithMaxRowLargeCurrentGroupRow(WFFlowNode linkedFlowElement, List<WFFlowNode> sameGroupNodes, List<List<WFFlowNode>> mergeGroup, int groupCount, int groupAllRows, int needAddOneRowGroupCount, int maxRows) {
        int indexLastAdd = -1;
        int addedGroupAllRows = groupAllRows;
        int downAddNodeNums = maxRows - addedGroupAllRows >> 1;
        int upAddNodeNums = maxRows - addedGroupAllRows - downAddNodeNums;
        WFFlowNode firstNode = sameGroupNodes.get(0);
        WFFlowNode lastNode = sameGroupNodes.get(sameGroupNodes.size() - 1);
        int indexFirst = linkedFlowElement.getNextNodes().indexOf(firstNode);
        int indexLast = linkedFlowElement.getNextNodes().indexOf(lastNode);
        if (groupCount == 0) {
            for (int i = 0; i < downAddNodeNums; ++i) {
                this.addTempNode(linkedFlowElement, indexLast + i + 1);
                if (needAddOneRowGroupCount != groupCount) continue;
                indexLastAdd = indexLast + i + 1;
            }
        } else if (groupCount == mergeGroup.size() - 1) {
            for (int i = 0; i < upAddNodeNums; ++i) {
                this.addTempNode(linkedFlowElement, indexFirst + i);
                indexLastAdd = indexFirst + i;
            }
        } else {
            int i;
            for (i = 0; i < upAddNodeNums; ++i) {
                this.addTempNode(linkedFlowElement, indexFirst + i);
            }
            indexLast = linkedFlowElement.getNextNodes().indexOf(lastNode);
            for (i = 0; i < downAddNodeNums; ++i) {
                this.addTempNode(linkedFlowElement, indexLast + i + 1);
                if (needAddOneRowGroupCount != groupCount) continue;
                indexLastAdd = indexLast + i + 1;
            }
        }
        return indexLastAdd;
    }

    private void addTempNodeWithNoMergeGroup(WFFlowNode linkedFlowElement, int middleCurrent, boolean needAddOneRow, boolean isMerge) {
        int count = 0;
        int copyListCount = 0;
        CopyOnWriteArrayList copyOnWriteFlowNodes = new CopyOnWriteArrayList(linkedFlowElement.getNextNodes());
        for (WFFlowNode nextNode : copyOnWriteFlowNodes) {
            int maxRows;
            int middle;
            if (copyListCount == middleCurrent && needAddOneRow) {
                this.addTempNode(linkedFlowElement, count);
                ++count;
            }
            if ((middle = (maxRows = isMerge ? this.getMaxRowsWithFirstMergeNode(nextNode) : this.getMaxRows(nextNode)) + 1 >> 1) > 1) {
                int i;
                if (copyListCount == 0) {
                    for (i = 0; i < middle - 1; ++i) {
                        this.addTempNode(linkedFlowElement, count + 1);
                        ++count;
                    }
                } else if (copyListCount == copyOnWriteFlowNodes.size() - 1) {
                    for (i = 0; i < middle - 1; ++i) {
                        this.addTempNode(linkedFlowElement, count);
                        ++count;
                    }
                } else {
                    for (i = 0; i < maxRows; ++i) {
                        if (i < middle - 1) {
                            this.addTempNode(linkedFlowElement, count);
                            ++count;
                            continue;
                        }
                        if (i <= middle - 1) continue;
                        this.addTempNode(linkedFlowElement, count + 1);
                        ++count;
                    }
                }
            }
            ++count;
            ++copyListCount;
        }
    }
}

