/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.DynamicObjectJsonSerializer;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.activity.exception.ActivityErrorCode;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityNodeLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.ActivityWorkflowServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.WorkflowStatusEventServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.activity.util.WorkflowEventEnum;
import kd.hr.hrcs.mservice.api.IHRCSActivityWorkflowService;

public class HRCSActivityWorkflowService
implements IHRCSActivityWorkflowService {
    private static final Log LOGGER = LogFactory.getLog(HRCSActivityWorkflowService.class);
    private static final String SCHEME_SPLIT_STR = "\\$\\$";
    private static final String BINDINGLAYOUTID = "bindinglayoutid";
    private static final String CLOUDID = "hrmp";
    private static final String APPID = "hrcs";
    private static final String SERVICENAME = "IHRCSActivityService";
    private static final String HRCS_MSERVICE = "hrmp-hrcs-mservice";
    private static final String META_NUMBER_HRCS_ACTIVITY_CLIENT_CONF = "hrcs_activityclientconf";

    public OperationResult notify(String nodeId, String bizBillId, String bizEntityNumber, Long startUserId, String schemeVerStr, List<Long> approverList, Long wfProDefId, Long wfCurTaskId, Long wfProInsId, Object customParams) {
        OperationResult operationResult;
        LOGGER.info("RequestContext: {}.", Optional.ofNullable(RequestContext.get()).map(RequestContext::getLang).orElse(null));
        LOGGER.info("HRCSActivityWorkflowService : Got mq env value: [{}]", (Object)System.getProperty("mqConfigFiles.config"));
        LOGGER.info("HRCSActivityWorkflowService \uff1acoming in notify hrcs HRCSActivityWorkflowService [{}]", (Object)bizBillId);
        String[] info = schemeVerStr.split(SCHEME_SPLIT_STR);
        if (info.length != 2) {
            throw new KDBizException(ActivityErrorCode.schemeStrError((String)schemeVerStr), new Object[0]);
        }
        DynamicObject bizBillInfo = BusinessDataServiceHelper.loadSingle((Object)bizBillId, (String)bizEntityNumber, (String)"id,number,billno,creator,creator.id");
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)bizEntityNumber);
        String bizBillNumber = HRCSActivityWorkflowService.extractBillNum(bizBillInfo, bizEntityNumber, bizBillId, mainType);
        Long creatorId = HRCSActivityWorkflowService.extractCreatorId(bizBillInfo, mainType, startUserId);
        Long activityId = this.extractActId(customParams);
        LOGGER.info("Got activity scheme info: number[{}], version[{}], activity id[{}].", new Object[]{info[0], info[1], activityId});
        DynamicObject schemeInfo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)CLOUDID, (String)APPID, (String)SERVICENAME, (String)"getByNumberAndVersionAndActivityId", (Object[])new Object[]{"actschemeentry.actbizobj,actschemeentry.bindinglayoutid,actschemeentry.tasktheme,actschemeentry.activity", info[0], info[1], activityId});
        if (schemeInfo == null || ((Long)schemeInfo.getPkValue()).compareTo(0L) == 0) {
            throw new KDBizException(ActivityErrorCode.schemeNotFoundError((String)schemeVerStr), new Object[0]);
        }
        String schemeVer = info[1];
        String schemeNum = info[0];
        DynamicObject actInfo = (DynamicObject)((DynamicObject)schemeInfo.getDynamicObjectCollection("actschemeentry").get(0)).getDynamicObjectCollection("actinfo").get(0);
        String bindBizKey = HRCSActivityWorkflowService.getBizKey(actInfo.getDynamicObject("actbizobj"));
        String bindLayoutId = actInfo.getString(BINDINGLAYOUTID);
        QFilter wfProcessInsFilter = new QFilter("wfprocessinsid", "=", (Object)wfProInsId);
        QFilter wfCurrentNodeFilter = new QFilter("wfnode", "=", (Object)nodeId);
        QFilter abandonFilter = new QFilter("isabandon", "=", (Object)"0");
        QFilter taskStatusFilter = new QFilter("taskstatus", "not in", Arrays.asList("40", "30", "50"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject activityIns = serviceHelper.queryOne("id,wfcurtaskid,taskstatus", new QFilter[]{wfProcessInsFilter, wfCurrentNodeFilter, abandonFilter, taskStatusFilter});
        DynamicObject businessDynamicObject = null;
        if (null != activityIns) {
            activityIns.set("wfcurtaskid", (Object)wfCurTaskId);
            serviceHelper.updateOne(activityIns);
            operationResult = new OperationResult();
            operationResult.setSuccess(true);
            operationResult.setSuccessPkIds(Collections.singletonList(activityIns.get("id")));
        } else {
            try {
                businessDynamicObject = ActivityWorkflowServiceHelper.invokePlugin((String)bizBillId, (Long)activityId, (String)schemeVer, (String)schemeNum, (String)"0", null);
            }
            catch (Exception exception) {
                LOGGER.error("invokePlugin before error bizBillId={}\uff0cactivityId={}\uff0cschemeVer={}\uff0cschemeNum={}", new Object[]{bizBillId, activityId, schemeVer, schemeNum});
            }
            operationResult = ActivityWorkflowServiceHelper.notify((String)nodeId, (String)bizBillId, (String)bizEntityNumber, (String)bizBillNumber, (Long)creatorId, (Long)activityId, (String)schemeVer, (String)schemeNum, (String)bindBizKey, (String)bindLayoutId, approverList, (Long)wfProDefId, (Long)wfCurTaskId, (Long)wfProInsId);
        }
        if (operationResult.isSuccess()) {
            try {
                businessDynamicObject = ActivityWorkflowServiceHelper.generateMappingDynaminObject((Long)activityId, (String)schemeVer, (String)schemeNum, (String)bizBillId, (DynamicObject)businessDynamicObject);
                businessDynamicObject.set("bizbillid", (Object)bizBillId);
                businessDynamicObject.set("bizbillnumber", (Object)bizEntityNumber);
                businessDynamicObject.set("billstatus", (Object)"A");
                businessDynamicObject = ActivityWorkflowServiceHelper.invokePlugin((String)bizBillId, (Long)activityId, (String)schemeVer, (String)schemeNum, (String)"1", (DynamicObject)businessDynamicObject);
            }
            catch (Exception exception) {
                LOGGER.error("invokePlugin after error bizBillId={}\uff0cactivityId={}\uff0cschemeVer={}\uff0cschemeNum={}", new Object[]{bizBillId, activityId, schemeVer, schemeNum});
            }
        } else {
            LOGGER.error("Save activity instance failed with activity id [{}]", (Object)activityId);
            ErrorCode errorCode = new ErrorCode("hrmp.hrcs.saveActivityInstanceFailure", ResManager.loadKDString((String)"\u4fdd\u5b58\u6d3b\u52a8\u5b9e\u4f8b\u5931\u8d25\u3002", (String)"HRCSActivityWorkflowService_3", (String)HRCS_MSERVICE, (Object[])new Object[0]));
            throw new KDBizException(errorCode, new Object[0]);
        }
        this.notifyBizClient(nodeId, wfProInsId, activityId, bizBillId, bizEntityNumber, schemeNum, schemeVer, bindBizKey, (Long)operationResult.getSuccessPkIds().get(0), businessDynamicObject);
        LOGGER.info("HRCSActivityWorkflowService : finish HRCSActivityWorkflowService go out");
        return operationResult;
    }

    private static String getBizKey(DynamicObject actBizObjInfo) {
        if (actBizObjInfo == null) {
            return "";
        }
        Object entityId = actBizObjInfo.getPkValue();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)entityId, (String)"bos_entityobject", (String)"id");
        return dynObj == null ? "" : dynObj.getString("id");
    }

    private static String extractBillNum(DynamicObject bizBillInfo, String bizEntityNumber, String bizBillId, MainEntityType mainType) {
        String bizBillNumber = bizEntityNumber + "." + bizBillId;
        if (mainType != null) {
            Map bizFieldsMap = mainType.getAllFields();
            if (bizFieldsMap.containsKey("number")) {
                bizBillNumber = bizBillInfo.getString("number");
            } else if (bizFieldsMap.containsKey("billno")) {
                bizBillNumber = bizBillInfo.getString("billno");
            }
        }
        return bizBillNumber;
    }

    private static Long extractCreatorId(DynamicObject bizBillInfo, MainEntityType mainType, Long startUserId) {
        Map bizFieldsMap;
        Long bizBillCreatorId = startUserId;
        if (mainType != null && (bizFieldsMap = mainType.getAllFields()).containsKey("creator")) {
            bizBillCreatorId = bizBillInfo.getLong("creator.id");
        }
        return bizBillCreatorId;
    }

    private Long extractActId(Object customParams) {
        LOGGER.info("HRCSActivityWorkflowService extractActId : coming into extractActId! ");
        List customParamList = (List)customParams;
        if (null == customParamList || customParamList.size() == 0) {
            throw new KDBizException(ActivityErrorCode.actIdInDesignerisWrong(), new Object[0]);
        }
        Iterator iteParam = customParamList.iterator();
        String activityId = null;
        StringBuilder str = new StringBuilder("extractActId now:");
        LOGGER.info("HRCSActivityWorkflowService extractActId : extractActId now ! element size is " + customParamList.size());
        while (iteParam.hasNext()) {
            CustomParam wfparam = (CustomParam)iteParam.next();
            str.append(wfparam.getId()).append(" isbuiltin :").append(wfparam.isBuiltIn()).append(" name :").append(wfparam.getName()).append(" value ").append(wfparam.getValue());
            if (wfparam.isBuiltIn()) {
                activityId = wfparam.getId();
                str.append("HRCSActivityWorkflowService extractActId : extractID final is : ").append(activityId);
                break;
            }
            LOGGER.info(str.toString());
        }
        if (StringUtils.isEmpty(activityId)) {
            throw new KDBizException(ActivityErrorCode.activityIDCanNotBeNullError(), new Object[0]);
        }
        return Long.valueOf(activityId);
    }

    private void notifyBizClient(String wfNodeId, Long wfProInsId, Long activityId, String bizBillId, String bizEntityNumber, String schemeNum, String schemeVer, String bindBizKey, Long instanceId, DynamicObject businessDynamicObject) {
        DynamicObject coll = (DynamicObject)DispatchServiceHelper.invokeBizService((String)CLOUDID, (String)APPID, (String)SERVICENAME, (String)"getByNumberAndVersionAndActivityId", (Object[])new Object[]{"actschemeentry.bindinglayoutid, actschemeentry.actbizobj, actschemeentry.sla", schemeNum, schemeVer, activityId});
        DynamicObject actSchemeEntry = (DynamicObject)coll.getDynamicObjectCollection("actschemeentry").get(0);
        DynamicObject actInfo = (DynamicObject)actSchemeEntry.getDynamicObjectCollection("actinfo").get(0);
        int sla = actInfo.getInt("sla");
        String taskSwitch = new HRBaseServiceHelper("hrcs_activityins").queryOne("taskswitch", (Object)instanceId).getString("taskswitch");
        this.notifyBizClientByMQ(wfNodeId, wfProInsId, schemeNum, schemeVer, String.valueOf(activityId), String.valueOf(instanceId), taskSwitch, bizBillId, bizEntityNumber, bindBizKey, sla, businessDynamicObject);
    }

    private void notifyBizClientByMQ(String wfNodeId, Long wfProInsId, final String activitySchemeNumber, final String activitySchemeVersion, final String activityId, final String instanceId, final String taskSwitch, final String bizBillId, final String bizEntityNumber, final String bindBizKey, final int sla, final DynamicObject businessDynamicObject) {
        DynamicObject[] items;
        LOGGER.info("Start Notify biz client with activitySchemeNumber: [{}], activitySchemeVersion: [{}], activityId: [{}], instanceId: [{}], bizBillId: [{}], bizEntityNumber: [{}], bindBizKey: [{}]", new Object[]{activitySchemeNumber, activitySchemeVersion, activityId, instanceId, bizBillId, bizEntityNumber, bindBizKey});
        LOGGER.info("Current mq config files: [{}]", (Object)System.getProperty("mqConfigFiles.config"));
        DynamicObject item = null;
        boolean next = true;
        if (HRStringUtils.isNotEmpty((String)bindBizKey) && (items = BusinessDataServiceHelper.load((String)META_NUMBER_HRCS_ACTIVITY_CLIENT_CONF, (String)"cloud,queuename", (QFilter[])new QFilter[]{new QFilter("bizobj.number", "=", (Object)bindBizKey)})).length > 0) {
            item = items[0];
            next = false;
        }
        if (next) {
            items = BusinessDataServiceHelper.load((String)META_NUMBER_HRCS_ACTIVITY_CLIENT_CONF, (String)"cloud,queuename", (QFilter[])new QFilter[]{new QFilter("bizobj.number", "=", (Object)bizEntityNumber)});
            if (items.length <= 0) {
                throw new KDException(new ErrorCode("2", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u914d\u7f6eMQ\u3002", (String)"HRCSActivityWorkflowService_11", (String)HRCS_MSERVICE, (Object[])new Object[0])), new Object[]{instanceId});
            }
            item = items[0];
        }
        final Set influencedInstanceIds = Arrays.stream(new HRBaseServiceHelper("hrcs_activityins").query("id", new QFilter[]{new QFilter("wfnode", "=", (Object)wfNodeId), new QFilter("wfprocessinsid", "=", (Object)wfProInsId)})).map(it -> it.getLong("id")).collect(Collectors.toSet());
        if (null == item) {
            throw new KDException(new ErrorCode("2", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u914d\u7f6eMQ\u3002", (String)"HRCSActivityWorkflowService_11", (String)HRCS_MSERVICE, (Object[])new Object[0])), new Object[]{instanceId});
        }
        String region = item.getDynamicObject("cloud").getString("number").toLowerCase(Locale.ROOT);
        String queue = item.getString("queuename").toLowerCase(Locale.ROOT);
        HashMap<String, Object> map = new HashMap<String, Object>(7){
            private static final long serialVersionUID = -6829290333851710375L;
            {
                super(x0);
                this.put("activitySchemeNumber", activitySchemeNumber);
                this.put("activitySchemeVersion", activitySchemeVersion);
                this.put("activityId", activityId);
                this.put("instanceId", instanceId);
                this.put("bizBillId", bizBillId);
                this.put("taskSwitch", taskSwitch);
                this.put("bizBillKey", bizEntityNumber);
                this.put("bindBizKey", bindBizKey);
                this.put("sla", sla);
                this.put("influencedInstanceIds", influencedInstanceIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
                try {
                    this.put("businessDynamicObject", DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)businessDynamicObject));
                    this.put("formid", businessDynamicObject.getDataEntityType().getName());
                }
                catch (Exception exception) {
                    LOGGER.error((Throwable)exception);
                }
            }
        };
        try {
            HRProducerServiceHelper.publishDynamicQueue((String)region, (String)queue, (Object)map);
        }
        catch (Exception exception) {
            throw new KDException((Throwable)exception, new ErrorCode("2", ResManager.loadKDString((String)"\u53d1\u9001MQ\u5931\u8d25", (String)"HRCSActivityWorkflowService_6", (String)HRCS_MSERVICE, (Object[])new Object[0])), new Object[]{instanceId});
        }
        LOGGER.info("Finish Notify biz client with activitySchemeNumber: [{}], activitySchemeVersion: [{}], activityId: [{}], instanceId: [{}], bizBillId: [{}], bizEntityNumber: [{}], bindBizKey: [{}],businessDynamicObject: [{}]", new Object[]{activitySchemeNumber, activitySchemeVersion, activityId, instanceId, bizBillId, bizEntityNumber, bindBizKey, businessDynamicObject});
    }

    public OperationResult notifyForErrorSuspend(Long processDefId, Long processInsId, String currentNodeId, Long creatorId, String entityNumber, String billId, String billNo, String activityScheme, Long activityId, List<Long> approverList, String exceptionMessage) {
        LOGGER.info("Got params. ProcessDefId: {}, processInsId: {}, currentNodeId: {}, entityNumber: {}, billId: {}, billNo: {}, activityScheme: {}, activityId: {}, exceptionMessage: {}.", new Object[]{processDefId, processInsId, currentNodeId, entityNumber, billId, billNo, activityScheme, activityId, exceptionMessage});
        String[] info = activityScheme.split(SCHEME_SPLIT_STR);
        DynamicObject activitySchemeItem = (DynamicObject)DispatchServiceHelper.invokeBizService((String)CLOUDID, (String)APPID, (String)SERVICENAME, (String)"getByNumberAndVersionAndActivityId", (Object[])new Object[]{"actschemeentry.actbizobj,actschemeentry.bindinglayoutid,actschemeentry.tasktheme,actschemeentry.activity", info[0], info[1], activityId});
        DynamicObject actInfo = (DynamicObject)((DynamicObject)activitySchemeItem.getDynamicObjectCollection("actschemeentry").get(0)).getDynamicObjectCollection("actinfo").get(0);
        String bindBizKey = HRCSActivityWorkflowService.getBizKey(actInfo.getDynamicObject("actbizobj"));
        String bindLayoutId = actInfo.getString(BINDINGLAYOUTID);
        QFilter wfProcessInsFilter = new QFilter("wfprocessinsid", "=", (Object)processInsId);
        QFilter wfCurrentNodeFilter = new QFilter("wfnode", "=", (Object)currentNodeId);
        QFilter abandonFilter = new QFilter("isabandon", "=", (Object)"0");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject activityIns = serviceHelper.queryOriginalOne("id,applier.id", new QFilter[]{wfProcessInsFilter, wfCurrentNodeFilter, abandonFilter});
        OperationResult operationResult = new OperationResult();
        try (TXHandle txHandle = TX.required();){
            try {
                if (null != activityIns) {
                    operationResult.setSuccess(true);
                    operationResult.setSuccessPkIds((List)Lists.newArrayList((Object[])new Object[]{activityIns.getLong("id")}));
                    creatorId = activityIns.getLong("applier.id");
                } else {
                    operationResult = ActivityWorkflowServiceHelper.notify((String)currentNodeId, (String)billId, (String)entityNumber, (String)billNo, (Long)creatorId, (Long)activityId, (String)info[1], (String)info[0], (String)bindBizKey, (String)bindLayoutId, approverList, (Long)processDefId, (Long)0L, (Long)processInsId);
                }
                if (operationResult.isSuccess()) {
                    DynamicObject newActivityIns = serviceHelper.queryOne(operationResult.getSuccessPkIds().get(0));
                    ActivityNodeLogServiceHelper.save((String)newActivityIns.getString("taskstatus"), (String)"60", (String)WorkflowEventEnum.ERROR_SUSPEND.name(), (Long)creatorId, (Long)processInsId, (String)currentNodeId);
                    newActivityIns.set("taskstatus", (Object)"60");
                    serviceHelper.updateOne(newActivityIns);
                    this.saveException(creatorId, (Long)operationResult.getSuccessPkIds().get(0), exceptionMessage);
                    WorkflowStatusEventServiceHelper.notifyClient((String)entityNumber, (WorkflowEventEnum)WorkflowEventEnum.ERROR_SUSPEND, operationResult.getSuccessPkIds().stream().map(it -> (Long)it).collect(Collectors.toSet()));
                } else {
                    String activityInsErrorMessage = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).reduce((acc, item) -> acc + "\r\n" + item).orElse("nothing");
                    LOGGER.error("Save activity instance error: {}.", (Object)activityInsErrorMessage);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
            txHandle.commit();
        }
        return operationResult;
    }

    public OperationResult notifyForTerminate(Long processInsId, String billId, String entityNumber, Long creatorId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject[] activityInsList = serviceHelper.query("id,taskstatus,wfprocessinsid,wfprocessdefinitionid,bizbillid,wfnode", new QFilter[]{new QFilter("wfprocessinsid", "=", (Object)processInsId), new QFilter("bizbillid", "=", (Object)billId), new QFilter("taskstatus", "in", Arrays.asList("10", "20"))});
        OperationResult operationResult = new OperationResult();
        try (TXHandle txHandle = TX.required();){
            try {
                ArrayList activityInsIds = new ArrayList(activityInsList.length);
                ArrayList nodeLogs = new ArrayList(activityInsList.length);
                HRBaseServiceHelper nodeLogServiceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
                DynamicObject[] items = (DynamicObject[])Arrays.stream(activityInsList).peek(it -> {
                    activityInsIds.add(it.getLong("id"));
                    ActivityNodeLogServiceHelper.constructNodeLog((List)nodeLogs, (HRBaseServiceHelper)nodeLogServiceHelper, (DynamicObject)it, (String)"50", (WorkflowEventEnum)WorkflowEventEnum.ABORT, (Long)creatorId, (Long)processInsId, (String)it.getString("wfnode"));
                    it.set("taskstatus", (Object)"50");
                }).toArray(DynamicObject[]::new);
                serviceHelper.update(items);
                ActivityNodeLogServiceHelper.batchSave((DynamicObject[])nodeLogs.toArray(new DynamicObject[0]));
                operationResult.setSuccessPkIds(activityInsIds);
                WorkflowStatusEventServiceHelper.notifyClient((String)entityNumber, (WorkflowEventEnum)WorkflowEventEnum.ABORT, operationResult.getSuccessPkIds().stream().map(it -> (Long)it).collect(Collectors.toSet()));
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
            txHandle.commit();
        }
        operationResult.setSuccess(true);
        return operationResult;
    }

    public OperationResult notifyForDisagreeAndTerminate(Long processInsId, String billId, String entityNumber, Long creatorId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject[] activityInsList = serviceHelper.query("id,taskstatus,wfprocessinsid,wfprocessdefinitionid,bizbillid,wfnode", new QFilter[]{new QFilter("wfprocessinsid", "=", (Object)processInsId), new QFilter("bizbillid", "=", (Object)billId), new QFilter("taskstatus", "in", Arrays.asList("10", "20"))});
        OperationResult operationResult = new OperationResult();
        try (TXHandle txHandle = TX.required();){
            try {
                ArrayList activityInsIds = new ArrayList(activityInsList.length);
                ArrayList nodeLogs = new ArrayList(activityInsList.length);
                HRBaseServiceHelper nodeLogServiceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
                DynamicObject[] items = (DynamicObject[])Arrays.stream(activityInsList).peek(it -> {
                    activityInsIds.add(it.getLong("id"));
                    ActivityNodeLogServiceHelper.constructNodeLog((List)nodeLogs, (HRBaseServiceHelper)nodeLogServiceHelper, (DynamicObject)it, (String)"50", (WorkflowEventEnum)WorkflowEventEnum.DISAGREE_AND_ABORT, (Long)creatorId, (Long)processInsId, (String)it.getString("wfnode"));
                    it.set("taskstatus", (Object)"50");
                }).toArray(DynamicObject[]::new);
                serviceHelper.update(items);
                ActivityNodeLogServiceHelper.batchSave((DynamicObject[])nodeLogs.toArray(new DynamicObject[0]));
                operationResult.setSuccessPkIds(activityInsIds);
                WorkflowStatusEventServiceHelper.notifyClient((String)entityNumber, (WorkflowEventEnum)WorkflowEventEnum.DISAGREE_AND_ABORT, operationResult.getSuccessPkIds().stream().map(it -> (Long)it).collect(Collectors.toSet()));
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
            txHandle.commit();
        }
        operationResult.setSuccess(true);
        return operationResult;
    }

    public OperationResult notifyForErrorActivate(Long processInsId, String billId, String entityNumber, Long creatorId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject[] activityInsList = serviceHelper.query("id,taskstatus,wfprocessinsid,wfprocessdefinitionid,bizbillid,handlers,wfnode", new QFilter[]{new QFilter("wfprocessinsid", "=", (Object)processInsId), new QFilter("bizbillid", "=", (Object)billId), new QFilter("taskstatus", "=", (Object)"60")});
        OperationResult operationResult = new OperationResult();
        try (TXHandle txHandle = TX.required();){
            try {
                ArrayList activityInsIds = new ArrayList(activityInsList.length);
                ArrayList nodeLogs = new ArrayList(activityInsList.length);
                HRBaseServiceHelper nodeLogServiceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
                DynamicObject[] items = (DynamicObject[])Arrays.stream(activityInsList).peek(it -> {
                    activityInsIds.add(it.getLong("id"));
                    String afterStatus = it.getDynamicObjectCollection("handlers").size() > 0 ? "20" : "10";
                    ActivityNodeLogServiceHelper.constructNodeLog((List)nodeLogs, (HRBaseServiceHelper)nodeLogServiceHelper, (DynamicObject)it, (String)afterStatus, (WorkflowEventEnum)WorkflowEventEnum.ERROR_ACTIVATE, (Long)creatorId, (Long)processInsId, (String)it.getString("wfnode"));
                    it.set("taskstatus", (Object)afterStatus);
                }).toArray(DynamicObject[]::new);
                serviceHelper.update(items);
                HRBaseServiceHelper actExceptionServiceHelper = new HRBaseServiceHelper("hrcs_activityexception");
                actExceptionServiceHelper.deleteByFilter(new QFilter[]{new QFilter("activityins", "in", activityInsIds)});
                ActivityNodeLogServiceHelper.batchSave((DynamicObject[])nodeLogs.toArray(new DynamicObject[0]));
                operationResult.setSuccessPkIds(activityInsIds);
                WorkflowStatusEventServiceHelper.notifyClient((String)entityNumber, (WorkflowEventEnum)WorkflowEventEnum.ERROR_ACTIVATE, operationResult.getSuccessPkIds().stream().map(it -> (Long)it).collect(Collectors.toSet()));
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
            txHandle.commit();
        }
        operationResult.setSuccess(true);
        return operationResult;
    }

    public OperationResult notifyForManualActivate(Long processInsId, String billId, String entityNumber, Long creatorId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject[] activityInsList = serviceHelper.query("id,taskstatus,wfprocessinsid,wfprocessdefinitionid,bizbillid,handlers,wfnode", new QFilter[]{new QFilter("wfprocessinsid", "=", (Object)processInsId), new QFilter("bizbillid", "=", (Object)billId), new QFilter("taskstatus", "=", (Object)"60")});
        OperationResult operationResult = new OperationResult();
        try (TXHandle txHandle = TX.required();){
            try {
                ArrayList activityInsIds = new ArrayList(activityInsList.length);
                ArrayList nodeLogs = new ArrayList(activityInsList.length);
                HRBaseServiceHelper nodeLogServiceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
                DynamicObject[] items = (DynamicObject[])Arrays.stream(activityInsList).peek(it -> {
                    activityInsIds.add(it.getLong("id"));
                    String afterStatus = it.getDynamicObjectCollection("handlers").size() > 0 ? "20" : "10";
                    ActivityNodeLogServiceHelper.constructNodeLog((List)nodeLogs, (HRBaseServiceHelper)nodeLogServiceHelper, (DynamicObject)it, (String)afterStatus, (WorkflowEventEnum)WorkflowEventEnum.MAN_ACTIVATE, (Long)creatorId, (Long)processInsId, (String)it.getString("wfnode"));
                    it.set("taskstatus", (Object)afterStatus);
                }).toArray(DynamicObject[]::new);
                serviceHelper.update(items);
                ActivityNodeLogServiceHelper.batchSave((DynamicObject[])nodeLogs.toArray(new DynamicObject[0]));
                operationResult.setSuccessPkIds(activityInsIds);
                WorkflowStatusEventServiceHelper.notifyClient((String)entityNumber, (WorkflowEventEnum)WorkflowEventEnum.MAN_ACTIVATE, operationResult.getSuccessPkIds().stream().map(it -> (Long)it).collect(Collectors.toSet()));
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
            txHandle.commit();
        }
        operationResult.setSuccess(true);
        return operationResult;
    }

    public OperationResult notifyForManualSuspend(Long processInsId, String billId, String entityNumber, Long creatorId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject[] activityInsList = serviceHelper.query("id,taskstatus,wfprocessinsid,wfprocessdefinitionid,bizbillid,handlers,wfnode", new QFilter[]{new QFilter("wfprocessinsid", "=", (Object)processInsId), new QFilter("bizbillid", "=", (Object)billId), new QFilter("taskstatus", "in", Arrays.asList("10", "20"))});
        OperationResult operationResult = new OperationResult();
        try (TXHandle txHandle = TX.required();){
            try {
                ArrayList activityInsIds = new ArrayList(activityInsList.length);
                ArrayList nodeLogs = new ArrayList(activityInsList.length);
                HRBaseServiceHelper nodeLogServiceHelper = new HRBaseServiceHelper("hrcs_activitynodelog");
                DynamicObject[] items = (DynamicObject[])Arrays.stream(activityInsList).peek(it -> {
                    activityInsIds.add(it.getLong("id"));
                    ActivityNodeLogServiceHelper.constructNodeLog((List)nodeLogs, (HRBaseServiceHelper)nodeLogServiceHelper, (DynamicObject)it, (String)"60", (WorkflowEventEnum)WorkflowEventEnum.MAN_SUSPEND, (Long)creatorId, (Long)processInsId, (String)it.getString("wfnode"));
                    it.set("taskstatus", (Object)"60");
                }).toArray(DynamicObject[]::new);
                serviceHelper.update(items);
                ActivityNodeLogServiceHelper.batchSave((DynamicObject[])nodeLogs.toArray(new DynamicObject[0]));
                operationResult.setSuccessPkIds(activityInsIds);
                WorkflowStatusEventServiceHelper.notifyClient((String)entityNumber, (WorkflowEventEnum)WorkflowEventEnum.MAN_SUSPEND, operationResult.getSuccessPkIds().stream().map(it -> (Long)it).collect(Collectors.toSet()));
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw exception;
            }
            txHandle.commit();
        }
        operationResult.setSuccess(true);
        return operationResult;
    }

    private void saveException(Long creatorId, Long activityInsId, String exceptionMessage) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_activityexception");
        DynamicObject item = serviceHelper.generateEmptyDynamicObject();
        item.set("activityins", (Object)activityInsId);
        item.set("creator", (Object)creatorId);
        item.set("exceptiontype", (Object)"2");
        item.set("createtime", (Object)new Date());
        item.set("result", (Object)"0");
        item.set("exceptionstackmessage", (Object)exceptionMessage);
        serviceHelper.saveOne(item);
    }

    public Boolean isActivityBillEntityNumber(String entityNumber) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return Boolean.FALSE;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(META_NUMBER_HRCS_ACTIVITY_CLIENT_CONF);
        QFilter entityNumberFilter = new QFilter("bizobj.number", "=", (Object)entityNumber);
        return helper.isExists(entityNumberFilter);
    }
}

