/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.calendar.WorkingPlanServiceHelper;
import kd.hr.hrcs.mservice.api.IHRCSCalendarService;

public class HRCSCalendarService
implements IHRCSCalendarService {
    public Map<String, Object> getCalendarData(Long wpId, Date rangeStart, Date rangeEnd) {
        return WorkingPlanServiceHelper.getCalendarData((Long)wpId, (Date)rangeStart, (Date)rangeEnd);
    }

    public DynamicObject[] getService() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_serviceregister");
        return serviceHelper.query("id,number,name,cloud,app,service,method,param", new QFilter[0]);
    }

    public Map<String, List<Map<String, String>>> test(Date rangeStart, Date rangeEnd, Map<String, Object> paramMap) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)100);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_caltest");
        DynamicObject[] results = serviceHelper.query("id,starttime,endtime,name,addressorlink,description,datefield", new QFilter[]{new QFilter("datefield", ">=", (Object)rangeStart), new QFilter("datefield", "<=", (Object)rangeEnd)});
        Map<String, List<DynamicObject>> dateFieldMap = Stream.of(results).collect(Collectors.groupingBy(result -> HRDateTimeUtils.formatDate((Date)result.getDate("datefield"))));
        dateFieldMap.forEach((key, value) -> {
            ArrayList dayTodoList = Lists.newArrayListWithExpectedSize((int)3);
            value.forEach(toDoDyn -> {
                HashMap toDo = Maps.newHashMapWithExpectedSize((int)5);
                int startTime = toDoDyn.getInt("starttime");
                int endTime = toDoDyn.getInt("endtime");
                toDo.put("id", Long.toString(toDoDyn.getLong("id")));
                toDo.put("startTime", String.valueOf(startTime));
                toDo.put("endTime", String.valueOf(endTime));
                toDo.put("name", toDoDyn.getString("name"));
                toDo.put("addressOrLink", toDoDyn.getString("addressorlink"));
                toDo.put("description", toDoDyn.getString("description"));
                dayTodoList.add(toDo);
            });
            dataMap.put(key, dayTodoList);
        });
        return dataMap;
    }

    public Map<String, String> getCalendarDataWithDay(Long wpId, Date rangeStart, Date rangeEnd) {
        return WorkingPlanServiceHelper.getCalendarDataWithDay((Long)wpId, (Date)rangeStart, (Date)rangeEnd);
    }
}

