/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.check.MatchDataRuleByScriptService;
import kd.hr.hrcs.bussiness.service.perm.check.MultiBdCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.PermCheckService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.HREntityIgnorePermServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.cache.HRFieldPermServiceHelperWithCache;
import kd.hr.hrcs.bussiness.service.perm.check.helper.DynamicFormHelper;
import kd.hr.hrcs.bussiness.service.perm.check.helper.EntityPropParser;
import kd.hr.hrcs.bussiness.service.perm.check.helper.HRDataPermServiceHelper;
import kd.hr.hrcs.bussiness.util.PermCheckUtil;
import kd.hr.hrcs.common.util.LoggerStrUtil;
import kd.hr.hrcs.mservice.api.IHRCSDataPermissionService;

public class HRCSDataPermissionService
implements IHRCSDataPermissionService {
    private static final Log LOGGER = LogFactory.getLog(HRCSDataPermissionService.class);

    public Map<Object, Boolean> matchDataRule(long userId, String appId, String entityNumber, String permItemId, QFilter[] qFilters, Map<String, Object> customParam) {
        long start = System.currentTimeMillis();
        customParam = PermCheckUtil.trimInvalidParam((Map)customParam);
        customParam.put("permMserviceCallerKey", "sys");
        customParam.put("permMserviceSourceKey", "list");
        PermCheckService.convertCustomParamStructProjectType((Map)customParam);
        LOGGER.info("HRDataPermService matchDataRule entry parameter,userId:{},appId:{},entityNumber:{},permItemId:{},qFilters:{},customParam:{}", new Object[]{userId, appId, entityNumber, permItemId, Arrays.toString(qFilters), customParam});
        if (PermCheckService.isCustomParamHasAll((Map)customParam)) {
            LOGGER.info("HRDataPermService matchDataRule result dataPermHasAll is true,return null");
            return null;
        }
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
        if (HRStringUtils.equals((String)"47156aff000000ac", (String)permItemId)) {
            return null;
        }
        HashMap matchResult = Maps.newHashMapWithExpectedSize((int)16);
        if (ArrayUtils.isEmpty((Object[])qFilters)) {
            LOGGER.info("HRDataPermService matchDataRule result qFilters is null,return null");
            return null;
        }
        List idList = HRDataPermServiceHelper.paramQFilterToList((QFilter)qFilters[0]);
        for (Object id : idList) {
            matchResult.put(id, Boolean.TRUE);
        }
        if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityDataRuleWithCache((String)entityNumber)) {
            LOGGER.info("HRDataPermService matchDataRule, ignore entity:{},appId:{}", (Object)entityNumber, (Object)appId);
            return matchResult;
        }
        QFilter dataRule = this.getDataRule(userId, appId, entityNumber, permItemId, customParam);
        if (Objects.isNull(dataRule)) {
            LOGGER.info("HRDataPermService matchDataRule,getDataRule is null");
            return matchResult;
        }
        List pkValueList = HRDataPermServiceHelper.queryUserDataRulePKValues((List)idList, (String)entityNumber, (QFilter)dataRule);
        for (Map.Entry entry : matchResult.entrySet()) {
            if (pkValueList.contains(entry.getKey().toString())) continue;
            entry.setValue(Boolean.FALSE);
        }
        List existedIdList = HRDataPermServiceHelper.queryExistedDataId((List)idList, (String)entityNumber);
        for (Map.Entry entry : matchResult.entrySet()) {
            if (existedIdList.contains(entry.getKey().toString())) continue;
            entry.setValue(Boolean.TRUE);
        }
        LOGGER.info("HRDataPermService matchDataRule result,cost_mills:{},return:{},pkValueList:{}", new Object[]{System.currentTimeMillis() - start, matchResult, pkValueList});
        return matchResult;
    }

    public String getDataRuleScript(Long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam) {
        try {
            long start = System.currentTimeMillis();
            customParam = PermCheckUtil.trimInvalidParam(customParam);
            customParam.put("permMserviceCallerKey", "sys");
            customParam.put("permMserviceSourceKey", "list");
            PermCheckService.convertCustomParamStructProjectType((Map)customParam);
            LOGGER.info("HRDataPermService getDataRuleScript entry parameter,userId:{},appId:{},entityNumber:{},permItemId:{},customParam:{}", new Object[]{userId, appId, entityNum, permItemId, customParam});
            if (PermCheckService.isCustomParamHasAll((Map)customParam)) {
                LOGGER.info("HRDataPermService getDataRuleScript result dataPermHasAll is true,return null");
                return null;
            }
            appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
            customParam.put("permMserviceIsFromScript", "true");
            String resultScript = MatchDataRuleByScriptService.getDataRuleScript((Long)userId, (String)appId, (String)entityNum, (String)permItemId, (Map)customParam);
            LOGGER.info("HRDataPermService getDataRuleScript result,cost_mills:{}, return:{}", (Object)(System.currentTimeMillis() - start), (Object)resultScript);
            return resultScript;
        }
        catch (Exception ex) {
            LOGGER.error("HRDataPermService getDataRuleScript_error.", (Throwable)ex);
            throw new KDException(BosErrorCode.systemError, ex.getMessage(), (Throwable)ex);
        }
    }

    public QFilter getDataRuleWithoutDim(long userId, String appId, String entityNumber, String permItemId, List<Long> dimObjIds, Map<String, Object> customParam) {
        LOGGER.info("HRDataPermService getDataRuleWithoutDim entry parameter,userId:{},appId:{},entityNumber:{},permItemId:{},dimObjIds:{},customParam:{}", new Object[]{userId, appId, entityNumber, permItemId, dimObjIds, customParam});
        return this.getDataRule(userId, appId, entityNumber, permItemId, customParam);
    }

    public QFilter getDataRuleWithoutDim(long userId, String appId, String entityNumber, String permItemId, Map<String, Object> customParam) {
        LOGGER.info("HRDataPermService getDataRuleWithoutDim entry parameter,userId:{},appId:{},entityNumber:{},permItemId:{},customParam:{}", new Object[]{userId, appId, entityNumber, permItemId, customParam});
        return this.getDataRule(userId, appId, entityNumber, permItemId, customParam);
    }

    public QFilter getDataRule(long userId, String appId, String entityNumber, String permItemId, Map<String, Object> customParam) {
        try {
            long start = System.currentTimeMillis();
            customParam = PermCheckUtil.trimInvalidParam(customParam);
            customParam.put("permMserviceCallerKey", "sys");
            customParam.put("permMserviceSourceKey", "list");
            PermCheckService.convertCustomParamStructProjectType((Map)customParam);
            LOGGER.info("HRDataPermService getDataRule entry parameter check, userId:{},appId:{},entityNumber:{},permItemId:{},customParam:{}", new Object[]{userId, appId, entityNumber, permItemId, customParam});
            appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
            if (PermCheckService.isCustomParamHasAll((Map)customParam)) {
                LOGGER.info("HRDataPermService getDataRule result dataPermHasAll is true,return null");
                return null;
            }
            if (customParam.get("isLookUp") != null && ((Boolean)customParam.get("isLookUp")).booleanValue()) {
                LOGGER.info("HRDataPermService getDataRule isLookUp is true,return null");
                return null;
            }
            if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityDataRuleWithCache((String)entityNumber)) {
                LOGGER.info("HRDataPermService getDataRule ignore entity:{},appId:{}", (Object)entityNumber, (Object)appId);
                return null;
            }
            QFilter resultQFilter = PermCheckService.assembleUserPermQFilter((Long)userId, (String)appId, (String)entityNumber, (String)permItemId, (Map)customParam);
            LOGGER.info("HRDataPermService getDataRule result,cost_mills:{},return:{},=========== userId:{},appId:{},entityNumber:{},permItemId:{}", new Object[]{System.currentTimeMillis() - start, LoggerStrUtil.qFilterToString((QFilter)resultQFilter), userId, appId, entityNumber, permItemId});
            return resultQFilter;
        }
        catch (Exception ex) {
            LOGGER.error("HRDataPermService assembleUserPermQFilter_error.", (Throwable)ex);
            throw new KDException(BosErrorCode.systemError, ex.getMessage(), (Throwable)ex);
        }
    }

    public QFilter getDataRuleForBdProp(long userId, String appId, String parentEntityNumber, String propFullKey, String permItemId, Map<String, Object> customParam) {
        long start = System.currentTimeMillis();
        if (HRStringUtils.isEmpty((String)propFullKey)) {
            LOGGER.info("HRDataPermService getDataRuleForBdProp entry parameter,propFullKey is null, userId:{},appId:{},parentEntityNumber:{},permItemId:{},propFullKey:{},customParam:{}", new Object[]{userId, appId, parentEntityNumber, permItemId, propFullKey, customParam});
            return null;
        }
        customParam = PermCheckUtil.trimInvalidParam(customParam);
        customParam.put("permMserviceCallerKey", "sys");
        PermCheckService.convertCustomParamStructProjectType((Map)customParam);
        String dealedPropFullKey = EntityPropParser.trimMultiBasedata((String)propFullKey);
        dealedPropFullKey = EntityPropParser.trimLastNameAndNumberProperty((String)dealedPropFullKey);
        String dataRuleKey = EntityPropParser.getDataRuleFieldKey((String)parentEntityNumber, (String)dealedPropFullKey);
        LOGGER.info("HRDataPermService getDataRuleForBdProp entry parameter,userId:{},appId:{},parentEntityNumber:{},permItemId:{},propFullKey:{},dealedPropFullKey:{},dataRuleKey:{},customParam:{}", new Object[]{userId, appId, parentEntityNumber, permItemId, propFullKey, dealedPropFullKey, dataRuleKey, customParam});
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
        if (PermCheckService.isCustomParamHasAll((Map)customParam)) {
            LOGGER.info("HRDataPermService getDataRuleForBdProp result dataPermHasAll is true,return null");
            return null;
        }
        if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityDataRuleWithCache((String)parentEntityNumber)) {
            LOGGER.info("HRDataPermService getDataRuleForBdProp result ignore entity:{},appId:{}", (Object)parentEntityNumber, (Object)appId);
            return null;
        }
        String propEntityNumber = EntityPropParser.getPropF7EntityNumber((String)parentEntityNumber, (String)dataRuleKey);
        if (HRStringUtils.isEmpty((String)propEntityNumber)) {
            propEntityNumber = DynamicFormHelper.getPropTypeFromDynamicForm((String)parentEntityNumber, (String)dataRuleKey);
        }
        if (HRStringUtils.isEmpty((String)propEntityNumber)) {
            propEntityNumber = parentEntityNumber;
        }
        LOGGER.info("HRDataPermService getDataRuleForBdProp targetEntityNumber={}", (Object)propEntityNumber);
        customParam.put("permMserviceSourceKey", "f7");
        customParam.put("propEntityNumberKey", propEntityNumber);
        QFilter qFilter = PermCheckService.assembleUserPermFilter4BdProp((Long)userId, (String)appId, (String)parentEntityNumber, (String)propEntityNumber, (String)dataRuleKey, (String)dealedPropFullKey, (String)permItemId, (Map)customParam);
        LOGGER.info("HRDataPermService getDataRuleForBdProp result,cost_mills:{},propFullKey:{},return:{}", new Object[]{System.currentTimeMillis() - start, propFullKey, LoggerStrUtil.qFilterToString((QFilter)qFilter)});
        return qFilter;
    }

    public QFilter getDataRuleForBdProp(long userId, String appId, String parentEntityNumber, String propFullKey, String permItemId, List<Long> dimObjIds, Map<String, Object> customParam) {
        return this.getDataRuleForBdProp(userId, appId, parentEntityNumber, propFullKey, permItemId, customParam);
    }

    public FieldControlRules getFieldControlRules(long userId, String appId, String entityNum, Map<String, Object> customParam) {
        long start = System.currentTimeMillis();
        customParam = PermCheckUtil.trimInvalidParam(customParam);
        customParam.put("permMserviceCallerKey", "sys");
        PermCheckService.convertCustomParamStructProjectType((Map)customParam);
        LOGGER.info("HRDataPermService getFieldControlRules entry parameter, userId:{},appId:{},entityNumber:{},customParam:{}", new Object[]{userId, appId, entityNum, customParam});
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
        if (PermCheckService.isCustomParamHasAll((Map)customParam)) {
            LOGGER.info("HRDataPermService getFieldControlRules result dataPermHasAll is true,return null");
            return null;
        }
        if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityFieldPermWithCache((String)entityNum)) {
            LOGGER.info("HRDataPermService getFieldControlRules ignore entity:{},appId:{}", (Object)entityNum, (Object)appId);
            return null;
        }
        FieldControlRules fieldControlRules = HRFieldPermServiceHelperWithCache.getFieldControlRulesWithCache((long)userId, (String)appId, (String)entityNum);
        LOGGER.info("HRDataPermService getFieldControlRules result,cost_mills:{},return:{}", (Object)(System.currentTimeMillis() - start), (Object)SerializationUtils.toJsonString((Object)fieldControlRules));
        return fieldControlRules;
    }

    public FieldControlRule getFieldControlRule(long userId, long orgId, String appId, String entityNum, Map<String, Object> customParam) {
        long start = System.currentTimeMillis();
        customParam = PermCheckUtil.trimInvalidParam(customParam);
        customParam.put("permMserviceCallerKey", "sys");
        PermCheckService.convertCustomParamStructProjectType((Map)customParam);
        LOGGER.info("HRDataPermService getFieldControlRule entry parameter, userId:{},appId:{},entityNumber:{},orgId:{},customParam:{}", new Object[]{userId, appId, entityNum, orgId, customParam});
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
        if (PermCheckService.isCustomParamHasAll((Map)customParam)) {
            LOGGER.info("HRDataPermService getFieldControlRule result dataPermHasAll is true,return null");
            return null;
        }
        if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityFieldPermWithCache((String)entityNum)) {
            LOGGER.info("HRDataPermService getFieldControlRule result ignore entity:{},appId:{}", (Object)entityNum, (Object)appId);
            return null;
        }
        FieldControlRule fieldControlRule = HRFieldPermServiceHelperWithCache.getFieldControlRuleWithCache((String)appId, (String)entityNum, (Long)userId, (Long)orgId);
        LOGGER.info("HRDataPermService getFieldControlRule result,cost_mills:{},return:{}", (Object)(System.currentTimeMillis() - start), (Object)SerializationUtils.toJsonString((Object)fieldControlRule));
        return fieldControlRule;
    }

    public FieldControlRule getFieldRulesSum(long userId, String appId, String entityNum) {
        long start = System.currentTimeMillis();
        LOGGER.info("HRDataPermService getFieldRulesSum entry parameter,userId:{},appId:{},entityNumber:{}", new Object[]{userId, appId, entityNum});
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
        if (HREntityIgnorePermServiceHelperWithCache.isIgnoreEntityFieldPermWithCache((String)entityNum)) {
            LOGGER.info("HRDataPermService getFieldRulesSum result ignore entity:{},appId:{}", (Object)entityNum, (Object)appId);
            return null;
        }
        FieldControlRule fieldControlRule = HRFieldPermServiceHelperWithCache.getFieldRulesWithoutMainOrgWithCache((long)userId, (String)appId, (String)entityNum);
        LOGGER.info("HRDataPermService getFieldRulesSum result,cost_mills:{},return:{}", (Object)(System.currentTimeMillis() - start), (Object)SerializationUtils.toJsonString((Object)fieldControlRule));
        return fieldControlRule;
    }

    public Set<String> getMulBdPropKeysByHasSetDataRule(long userId, String appId, String entityNum, Map<String, Object> customParam) {
        long start = System.currentTimeMillis();
        customParam = PermCheckUtil.trimInvalidParam(customParam);
        customParam.put("permMserviceCallerKey", "sys");
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
        LOGGER.info("HRDataPermService getMulBdPropKeysByHasSetDataRule entry parameter, userId:{},appId:{},entityNumber:{},customParam:{}", new Object[]{userId, appId, entityNum, customParam});
        Set multiBdProps = MultiBdCheckService.getMulBdPropKeysByHasSetDataRule((long)userId, (String)appId, (String)entityNum, (Map)customParam);
        LOGGER.info("HRDataPermService getMulBdPropKeysByHasSetDataRule result,cost_mills:{},return:{}", (Object)(System.currentTimeMillis() - start), (Object)multiBdProps);
        return multiBdProps;
    }
}

