/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ContractSubjectService;
import kd.hr.hrcs.bussiness.service.econtract.EContractSignApiService;
import kd.hr.hrcs.bussiness.service.econtract.UserAuthApiService;
import kd.hr.hrcs.bussiness.service.esign.ESignConfigService;
import kd.hr.hrcs.bussiness.service.esign.util.ESignSPMgrUtil;
import kd.hr.hrcs.bussiness.util.ParamsUtil;
import kd.hr.hrcs.mservice.HRCSESignService;
import kd.hr.hrcs.mservice.api.IHRCSEContractService;

public class HRCSEContractService
implements IHRCSEContractService {
    private static final Log LOGGER = LogFactory.getLog(HRCSEContractService.class);

    public SignRespParam toSign(SignReqParam signReqParam) {
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            this.printLog("toSign", signReqParam);
            ParamsUtil.setSignReqParam((SignReqParam)signReqParam);
            LOGGER.info("signReqParam nameMd5Val={}", (Object)signReqParam.getNameMd5Val());
            EContractSignApiService service = new EContractSignApiService(signReqParam.getFiorg());
            return service.upLoadContract(signReqParam);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.toSign(signReqParam);
    }

    public SignRespParam getHandSignUrl(String contractNo, SignReqParam signReqParam) {
        LOGGER.info("getHandSignUrl contractNo={}", (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            this.printLog("getHandSignUrl", signReqParam);
            ParamsUtil.setSignReqParam((SignReqParam)signReqParam);
            LOGGER.info("signReqParam nameMd5Val={}", (Object)signReqParam.getNameMd5Val());
            EContractSignApiService service = new EContractSignApiService(signReqParam.getFiorg());
            return service.repeatToHandSign(contractNo, signReqParam);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.getHandSignUrl(contractNo, signReqParam);
    }

    public SignRespParam sign(Long fiorg, Long templateTypeId, String contractNo) {
        LOGGER.info("sign fiorg={};tempId={};contractNo={}", new Object[]{fiorg, templateTypeId, contractNo});
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(fiorg);
            return signService.companySign(fiorg, contractNo, null, templateTypeId);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.sign(fiorg, templateTypeId, contractNo);
    }

    public SignRespParam signNew(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("signNew fiorg={};lowentitiyid={};tempId={};contractNo={}", new Object[]{signReqParam.getFiorg(), signReqParam.getLawEntityId(), signReqParam.getTemplateTypeId(), contractNo});
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(signReqParam.getFiorg());
            return signService.companySign(signReqParam.getFiorg(), contractNo, signReqParam.getTemplateId(), signReqParam.getTemplateTypeId());
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.signNew(signReqParam, contractNo);
    }

    public SignRespParam getPrevAndDown(Long fiorg, String contractNo) {
        LOGGER.info("getPrevAndDown fiorg={};contractNo={}", (Object)fiorg, (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(fiorg);
            return signService.contPrevOrDld(contractNo);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.getPrevAndDown(fiorg, contractNo);
    }

    public SignRespParam getPrevAndDownNew(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("getPrevAndDownNew fiorg={};lowentitiyid={};contractNo={}", new Object[]{signReqParam.getFiorg(), signReqParam.getLawEntityId(), contractNo});
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(signReqParam.getFiorg());
            return signService.contPrevOrDld(contractNo);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.getPrevAndDownNew(signReqParam, contractNo);
    }

    public boolean cancel(Long fiorg, String contractNo) {
        LOGGER.info("cancel fiorg={};contractNo={}", (Object)fiorg, (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(fiorg);
            return signService.cancel(contractNo);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.cancel(fiorg, contractNo);
    }

    public boolean cancelNew(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("cancelNew fiorg={};lowentitiyid={};contractNo={}", new Object[]{signReqParam.getFiorg(), signReqParam.getLawEntityId(), contractNo});
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(signReqParam.getFiorg());
            return signService.cancel(contractNo);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.cancelNew(signReqParam, contractNo);
    }

    @Deprecated
    public boolean authStatus(SignReqParam signReqParam) {
        this.printLog("authStatus", signReqParam);
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            ParamsUtil.setSignReqParam((SignReqParam)signReqParam);
            LOGGER.info("signReqParam nameMd5Val={}", (Object)signReqParam.getNameMd5Val());
            UserAuthApiService apiService = new UserAuthApiService(signReqParam.getFiorg());
            return apiService.queryAuthResult(signReqParam);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.authStatus(signReqParam);
    }

    public String getAuthStatus(SignReqParam signReqParam) {
        this.printLog("getAuthStatus", signReqParam);
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            ParamsUtil.setSignReqParam((SignReqParam)signReqParam);
            LOGGER.info("signReqParam nameMd5Val={}", (Object)signReqParam.getNameMd5Val());
            UserAuthApiService apiService = new UserAuthApiService(signReqParam.getFiorg());
            return apiService.getAuthResult(signReqParam);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.getAuthStatus(signReqParam);
    }

    public boolean signStatus(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("signStatus contractNo={}", (Object)contractNo);
        this.printLog("signStatus", signReqParam);
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            ParamsUtil.setSignReqParam((SignReqParam)signReqParam);
            LOGGER.info("signReqParam nameMd5Val={}", (Object)signReqParam.getNameMd5Val());
            EContractSignApiService signService = new EContractSignApiService(signReqParam.getFiorg());
            return signService.querySignStatus(contractNo, signReqParam);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.signStatus(signReqParam, contractNo);
    }

    public boolean contractSignStatus(Long fiorg, String contractNo) {
        LOGGER.info("contractSignStatus fiorg={};contractNo={}", (Object)fiorg, (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(fiorg);
            return signService.querySignStatus(contractNo);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.contractSignStatus(fiorg, contractNo);
    }

    public boolean contractSignStatusNew(SignReqParam signReqParam, String contractNo) {
        LOGGER.info("contractSignStatusNew fiorg={};lowentitiyid={};contractNo={}", new Object[]{signReqParam.getFiorg(), signReqParam.getLawEntityId(), contractNo});
        ESignConfigService configService = new ESignConfigService();
        if (configService.isKDCloudContractNo(contractNo)) {
            EContractSignApiService signService = new EContractSignApiService(signReqParam.getFiorg());
            return signService.querySignStatus(contractNo);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.contractSignStatusNew(signReqParam, contractNo);
    }

    public boolean contSubjectExists(Long fiorg) {
        LOGGER.info("contSubjectExists fiorg={}", (Object)fiorg);
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            return ContractSubjectService.fiorgExists((Long)fiorg);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.contSubjectExists(fiorg);
    }

    public boolean contSubjectExistsNew(SignReqParam signReqParam) {
        LOGGER.info("contSubjectExistsNew fiorg={};lowentitiyid={}", (Object)signReqParam.getFiorg(), (Object)signReqParam.getLawEntityId());
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            return ContractSubjectService.fiorgExists((Long)signReqParam.getFiorg());
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.contSubjectExistsNew(signReqParam);
    }

    public boolean isUploadSignature(Long fiorg) {
        LOGGER.info("isUploadSignature fiorg={}", (Object)fiorg);
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            return ContractSubjectService.isUploadSignature((Long)fiorg);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.isUploadSignature(fiorg);
    }

    public boolean isUploadSignatureNew(SignReqParam signReqParam) {
        LOGGER.info("isUploadSignatureNew fiorg={};lowentitiyid={}", (Object)signReqParam.getFiorg(), (Object)signReqParam.getLawEntityId());
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            return ContractSubjectService.isUploadSignature((Long)signReqParam.getFiorg());
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.isUploadSignatureNew(signReqParam);
    }

    private void printLog(String msg, SignReqParam signReqParam) {
        String reqMsg = JSON.toJSONString((Object)signReqParam);
        reqMsg = reqMsg.replace(signReqParam.getName(), "").replace(signReqParam.getIdentity(), "").replace(signReqParam.getMobile(), "");
        LOGGER.info("{} signReqParam={}", (Object)msg, (Object)reqMsg);
    }

    public SignRespParam abolish(String preContractNo, SignReqParam signReqParam) {
        LOGGER.info("abolish fiorg={};lowentitiyid={};preContractNo={}", new Object[]{signReqParam.getFiorg(), signReqParam.getLawEntityId(), preContractNo});
        ESignConfigService configService = new ESignConfigService();
        if (!configService.isKDCloudContractNo(preContractNo)) {
            HRCSESignService signService = new HRCSESignService();
            return signService.abolish(preContractNo, signReqParam);
        }
        return super.abolish(preContractNo, signReqParam);
    }

    public boolean isKDCloudSign(String contractNo) {
        LOGGER.info("isKDCloudSign contractNo={};", (Object)contractNo);
        ESignConfigService configService = new ESignConfigService();
        if (HRStringUtils.isEmpty((String)contractNo)) {
            return ESignSPMgrUtil.onlineSPIsFddCloud();
        }
        return configService.isKDCloudContractNo(contractNo);
    }

    public boolean isSupportMergeSign() {
        return !ESignSPMgrUtil.onlineSPIsFddCloud();
    }

    public SignRespParam getBatchSignUrl(Map<String, Object> params) {
        if (ESignSPMgrUtil.onlineSPIsFddCloud()) {
            return super.getBatchSignUrl(params);
        }
        HRCSESignService signService = new HRCSESignService();
        return signService.getBatchSignUrl(params);
    }
}

